/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Button;
import com.codename1.ui.ComboBox;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.animations.CommonTransitions;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.GridLayout;
import com.codename1.ui.list.DefaultListModel;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Calendar
extends Container
implements ActionSource {
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] DAYS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] LABELS = new String[]{"Su", "M", "Tu", "W", "Th", "F", "Sa"};
    private boolean twoDigitMode;
    private ComboBox month;
    private ComboBox year;
    private MonthView mv;
    private Label dateLabel;
    private final EventDispatcher dispatcher = new EventDispatcher();
    private final EventDispatcher dataChangedListeners = new EventDispatcher();
    private final EventDispatcher monthChangedListeners = new EventDispatcher();
    private final long[] dates = new long[42];
    private boolean changesSelectedDateEnabled = true;
    private TimeZone tmz;
    private long SELECTED_DAY = -1L;
    private final Collection<Date> selectedDays = new ArrayList<Date>();
    private boolean multipleSelectionEnabled = false;
    private String selectedDaysUIID = "CalendarMultipleDay";
    private final Map<String, Collection<Date>> highlightGroup = new HashMap<String, Collection<Date>>();
    private final ArrayList<ActionListener> dayListeners = new ArrayList();

    public Calendar(long time) {
        this(time, TimeZone.getDefault());
    }

    public Calendar() {
        this(System.currentTimeMillis());
    }

    public Calendar(long time, TimeZone tmz) {
        this(time, TimeZone.getDefault(), null, null);
    }

    public Calendar(Image leftArrowImage, Image rightArrowImage) {
        this(System.currentTimeMillis(), TimeZone.getDefault(), leftArrowImage, rightArrowImage);
    }

    public Calendar(long time, TimeZone tmz, Image leftArrowImage, Image rightArrowImage) {
        super(new BorderLayout());
        Image rightArrow;
        this.tmz = tmz;
        this.setUIID("Calendar");
        this.mv = new MonthView(time);
        Image leftArrow = leftArrowImage != null ? leftArrowImage : UIManager.getInstance().getThemeImageConstant("calendarLeftImage");
        Image image = rightArrow = rightArrowImage != null ? rightArrowImage : UIManager.getInstance().getThemeImageConstant("calendarRightImage");
        if (leftArrow != null && rightArrow != null) {
            final Button left = new Button(leftArrow, "CalendarLeft");
            Button right = new Button(rightArrow, "CalendarRight");
            ActionListener progress = new ActionListener(){
                private boolean lock = false;

                public void actionPerformed(ActionEvent evt) {
                    boolean tran;
                    if (this.lock) {
                        return;
                    }
                    this.lock = true;
                    int month = Calendar.this.mv.getMonth();
                    int year = Calendar.this.mv.getYear();
                    if (evt.getSource() == left) {
                        if (--month < 0) {
                            month = 11;
                            --year;
                        }
                    } else if (++month > 11) {
                        month = 0;
                        ++year;
                    }
                    if (tran = UIManager.getInstance().isThemeConstant("calTransitionBool", true)) {
                        CommonTransitions cm = UIManager.getInstance().isThemeConstant("calTransitionVertBool", false) ? CommonTransitions.createSlide(1, evt.getSource() == left, 300) : CommonTransitions.createSlide(0, evt.getSource() == left, 300);
                        MonthView newMv = new MonthView(((Calendar)Calendar.this).mv.currentDay);
                        newMv.setMonth(year, month);
                        Calendar.this.replaceAndWait(Calendar.this.mv, newMv, cm);
                        Calendar.this.mv = newMv;
                        newMv.fireActionEvent();
                    } else {
                        Calendar.this.mv.setMonth(year, month);
                        Calendar.this.componentChanged();
                    }
                    Calendar.this.dateLabel.setText(Calendar.this.getLocalizedMonth(month) + " " + year);
                    this.lock = false;
                }
            };
            left.addActionListener(progress);
            right.addActionListener(progress);
            Container dateCnt = new Container(new BorderLayout());
            dateCnt.setUIID("CalendarDate");
            this.dateLabel = new Label();
            this.dateLabel.setUIID("CalendarDateLabel");
            this.dateLabel.setText(this.getLocalizedMonth(this.mv.getMonth()) + " " + this.mv.getYear());
            dateCnt.addComponent("Center", (Component)this.dateLabel);
            dateCnt.addComponent("East", (Component)right);
            dateCnt.addComponent("West", (Component)left);
            this.addComponent("North", (Component)dateCnt);
        } else {
            this.month = new ComboBox();
            this.year = new ComboBox();
            Vector<String> months = new Vector<String>();
            for (int i = 0; i < MONTHS.length; ++i) {
                months.addElement(this.getLocalizedMonth(i));
            }
            DefaultListModel monthsModel = new DefaultListModel(months);
            int selected = months.indexOf(this.getLocalizedMonth(this.mv.getMonth()));
            this.month.setModel(monthsModel);
            this.month.setSelectedIndex(selected);
            this.month.addActionListener((ActionListener)this.mv);
            java.util.Calendar cal = java.util.Calendar.getInstance(tmz);
            cal.setTime(new Date(time));
            this.month.getStyle().setBgTransparency(0);
            int y = cal.get(1);
            Vector<String> years = new Vector<String>();
            for (int i = 2100; i >= 1900; --i) {
                years.addElement("" + i);
            }
            DefaultListModel yearModel = new DefaultListModel(years);
            selected = years.indexOf("" + y);
            this.year.setModel(yearModel);
            this.year.setSelectedIndex(selected);
            this.year.getStyle().setBgTransparency(0);
            this.year.addActionListener((ActionListener)this.mv);
            Container cnt = new Container(new BoxLayout(1));
            cnt.setRTL(false);
            Container dateCnt = new Container(new BoxLayout(1));
            dateCnt.setUIID("CalendarDate");
            dateCnt.addComponent(this.month);
            dateCnt.addComponent(this.year);
            cnt.addComponent(dateCnt);
            Container upper = new Container(new FlowLayout(4));
            upper.addComponent(cnt);
            this.addComponent("North", (Component)upper);
        }
        this.addComponent("Center", (Component)this.mv);
    }

    public long getSelectedDay() {
        return this.mv.getSelectedDay();
    }

    private String getLocalizedMonth(int i) {
        String o;
        Map<String, String> t = this.getUIManager().getBundle();
        String text = MONTHS[i];
        if (t != null && (o = t.get("Calendar." + text)) != null) {
            text = o;
        }
        return text;
    }

    void componentChanged() {
        java.util.Calendar cal = java.util.Calendar.getInstance(this.tmz);
        cal.set(1, this.mv.getYear());
        cal.set(2, this.mv.getMonth());
        cal.set(5, this.mv.getDayOfMonth());
        if (this.month != null) {
            this.month.getParent().revalidate();
        }
    }

    public Date getDate() {
        return new Date(this.mv.getSelectedDay());
    }

    public void setDate(Date d) {
        this.mv.setSelectedDay(d.getTime());
        this.mv.setCurrentDay(this.SELECTED_DAY, true);
        this.componentChanged();
    }

    public void setYearRange(int minYear, int maxYear) {
        if (minYear > maxYear) {
            throw new IllegalArgumentException("Max year should be bigger than or equal to min year!");
        }
        if (this.year != null) {
            Object previouslySelectedYear = this.year.getSelectedItem();
            Vector<String> years = new Vector<String>();
            for (int i = maxYear; i >= minYear; --i) {
                years.addElement("" + i);
            }
            DefaultListModel yearModel = new DefaultListModel(years);
            this.year.setModel(yearModel);
            if (years.contains(previouslySelectedYear)) {
                this.year.setSelectedItem(previouslySelectedYear);
            }
        }
    }

    public void setSelectedDate(Date d) {
        this.mv.setSelectedDay(d.getTime());
        this.mv.setCurrentDay(this.SELECTED_DAY, true);
        this.componentChanged();
    }

    public Date getCurrentDate() {
        return new Date(this.mv.getCurrentDay());
    }

    public void setCurrentDate(Date d) {
        this.mv.setCurrentDay(d.getTime(), true);
        this.componentChanged();
    }

    public TimeZone getTimeZone() {
        return this.tmz;
    }

    public void setTimeZone(TimeZone tmz) {
        this.tmz = tmz;
    }

    public Style getMonthViewSelectedStyle() {
        return this.mv.getSelectedStyle();
    }

    public void setMonthViewSelectedStyle(Style s) {
        this.mv.setSelectedStyle(s);
    }

    public Style getMonthViewUnSelectedStyle() {
        return this.mv.getUnselectedStyle();
    }

    public void setMonthViewUnSelectedStyle(Style s) {
        this.mv.setUnselectedStyle(s);
    }

    public void addActionListener(ActionListener l) {
        this.mv.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.mv.removeActionListener(l);
    }

    public void addMonthChangedListener(ActionListener l) {
        this.mv.addMonthChangedListener(l);
    }

    public void removeMonthChangedListener(ActionListener l) {
        this.mv.removeMonthChangedListener(l);
    }

    public void addDayActionListener(ActionListener l) {
        this.mv.addDayActionListener(l);
    }

    public void removeDayActionListener(ActionListener l) {
        this.mv.removeDayActionListener(l);
    }

    public void addDataChangedListener(DataChangedListener l) {
        this.mv.addDataChangedListener(l);
    }

    public void removeDataChangedListener(DataChangedListener l) {
        this.mv.removeDataChangedListener(l);
    }

    public void addDataChangeListener(DataChangedListener l) {
        this.mv.addDataChangedListener(l);
    }

    public void removeDataChangeListener(DataChangedListener l) {
        this.mv.removeDataChangedListener(l);
    }

    public boolean isChangesSelectedDateEnabled() {
        return this.changesSelectedDateEnabled;
    }

    public void setChangesSelectedDateEnabled(boolean changesSelectedDateEnabled) {
        this.changesSelectedDateEnabled = changesSelectedDateEnabled;
    }

    protected Button createDay() {
        Button day = new Button("", "CalendarDay");
        day.setAlignment(4);
        day.setEndsWith3Points(false);
        day.setTickerEnabled(false);
        return day;
    }

    protected Label createDayTitle(int day) {
        String value = this.getUIManager().localize("Calendar." + DAYS[day], LABELS[day]);
        Label dayh = new Label(value, "CalendarTitle");
        dayh.setEndsWith3Points(false);
        dayh.setTickerEnabled(false);
        return dayh;
    }

    protected void updateButtonDayDate(Component dayButton, int year, int currentMonth, int day) {
        if (dayButton instanceof Button) {
            this.updateButtonDayDate((Button)dayButton, currentMonth, day);
        }
    }

    protected void updateButtonDayDate(Component dayButton, int currentMonth, int day) {
        if (dayButton instanceof Button) {
            this.updateButtonDayDate((Button)dayButton, currentMonth, day);
        }
    }

    protected void updateButtonDayDate(Button dayButton, int year, int currentMonth, int day) {
        this.updateButtonDayDate(dayButton, currentMonth, day);
    }

    protected void updateButtonDayDate(Button dayButton, int currentMonth, int day) {
        if (this.twoDigitMode) {
            if (day < 10) {
                dayButton.setText("0" + day);
            } else {
                dayButton.setText("" + day);
            }
        } else if (day < 10) {
            dayButton.setText(" " + day + " ");
        } else {
            dayButton.setText("" + day);
        }
    }

    public boolean isTwoDigitMode() {
        return this.twoDigitMode;
    }

    public void setTwoDigitMode(boolean twoDigitMode) {
        this.twoDigitMode = twoDigitMode;
    }

    public Collection<Date> getSelectedDays() {
        return this.selectedDays;
    }

    public void setSelectedDays(Collection<Date> selectedDays) {
        for (Date selectedDay : selectedDays) {
            java.util.Calendar cal = java.util.Calendar.getInstance(this.tmz);
            cal.setTime(selectedDay);
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.selectedDays.add(cal.getTime());
        }
        this.selectedDaysUIID = "CalendarMultipleDay";
        this.mv.setCurrentDay(this.SELECTED_DAY, true);
        this.componentChanged();
    }

    public void setSelectedDays(Collection<Date> selectedDays, String uiid) {
        for (Date selectedDay : selectedDays) {
            java.util.Calendar cal = java.util.Calendar.getInstance(this.tmz);
            cal.setTime(selectedDay);
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.selectedDays.add(cal.getTime());
        }
        this.selectedDaysUIID = uiid;
        this.mv.setCurrentDay(this.SELECTED_DAY, true);
        this.componentChanged();
    }

    public String getSelectedDaysUIID() {
        return this.selectedDaysUIID;
    }

    public void setSelectedDaysUIID(String uiid) {
        this.selectedDaysUIID = uiid;
    }

    public void highlightDate(Date date, String uiid) {
        java.util.Calendar cal = java.util.Calendar.getInstance(this.tmz);
        cal.setTime(date);
        cal.set(10, 1);
        cal.set(11, 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (!this.highlightGroup.isEmpty()) {
            Collection<Date> datesArray = new ArrayList<Date>();
            if (this.highlightGroup.containsKey(uiid)) {
                datesArray = this.highlightGroup.get(uiid);
            }
            datesArray.add(cal.getTime());
            this.highlightGroup.put(uiid, datesArray);
        } else {
            ArrayList<Date> datesArray = new ArrayList<Date>();
            datesArray.add(cal.getTime());
            this.highlightGroup.put(uiid, datesArray);
        }
        this.mv.setCurrentDay(this.SELECTED_DAY, true);
        this.componentChanged();
    }

    public void highlightDates(Collection<Date> dates, String uiid) {
        for (Date selectedDay : dates) {
            Collection<Date> datesArray;
            java.util.Calendar cal = java.util.Calendar.getInstance(this.tmz);
            cal.setTime(selectedDay);
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (!this.highlightGroup.isEmpty()) {
                datesArray = new ArrayList<Date>();
                if (this.highlightGroup.containsKey(uiid)) {
                    datesArray = this.highlightGroup.get(uiid);
                }
                datesArray.add(cal.getTime());
                this.highlightGroup.put(uiid, datesArray);
                continue;
            }
            datesArray = new ArrayList();
            datesArray.add(cal.getTime());
            this.highlightGroup.put(uiid, datesArray);
        }
        this.mv.setCurrentDay(this.SELECTED_DAY, true);
        this.componentChanged();
    }

    public void unHighlightDates(Collection<Date> dates) {
        if (!this.highlightGroup.isEmpty()) {
            for (Date selectedDay : dates) {
                java.util.Calendar cal = java.util.Calendar.getInstance(this.tmz);
                cal.setTime(selectedDay);
                cal.set(10, 1);
                cal.set(11, 1);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                Iterator<Map.Entry<String, Collection<Date>>> it = this.highlightGroup.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Collection<Date>> entry = it.next();
                    if (!entry.getValue().contains(cal.getTime())) continue;
                    entry.getValue().remove(cal.getTime());
                    if (!entry.getValue().isEmpty()) continue;
                    it.remove();
                }
            }
            this.mv.setCurrentDay(this.SELECTED_DAY, true);
            this.componentChanged();
        }
    }

    public void unHighlightDate(Date date) {
        if (!this.highlightGroup.isEmpty()) {
            java.util.Calendar cal = java.util.Calendar.getInstance(this.tmz);
            cal.setTime(date);
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Iterator<Map.Entry<String, Collection<Date>>> it = this.highlightGroup.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Collection<Date>> entry = it.next();
                if (!entry.getValue().contains(cal.getTime())) continue;
                entry.getValue().remove(cal.getTime());
                if (!entry.getValue().isEmpty()) continue;
                it.remove();
            }
            this.mv.setCurrentDay(this.SELECTED_DAY, true);
            this.componentChanged();
        }
    }

    public boolean isMultipleSelectionEnabled() {
        return this.multipleSelectionEnabled;
    }

    public void setMultipleSelectionEnabled(boolean multipleSelectionEnabled) {
        this.multipleSelectionEnabled = multipleSelectionEnabled;
    }

    protected Component createDayComponent() {
        return this.createDay();
    }

    protected void bindDayListener(Component cmp, ActionListener l) {
        if (cmp instanceof Button) {
            ((Button)cmp).addActionListener(l);
        }
    }

    private void unBindDayListener(Component cmp, ActionListener l) {
        if (cmp instanceof Button) {
            ((Button)cmp).removeActionListener(l);
        }
    }

    protected void setDayText(Component cmp, String text) {
        if (cmp instanceof Button) {
            ((Button)cmp).setText(text);
        }
    }

    protected String getDayText(Component cmp) {
        if (cmp instanceof Button) {
            return ((Button)cmp).getText();
        }
        return null;
    }

    protected void setDayUIID(Component cmp, String uiid) {
        cmp.setUIID(uiid);
    }

    protected void setDayEnabled(Component cmp, boolean enable) {
        cmp.setEnabled(enable);
    }

    class MonthView
    extends Container
    implements ActionListener {
        private final Component[] components;
        private final Container titles;
        private final Container days;
        long currentDay;
        private Component selected;

        public MonthView(long time) {
            int iter;
            super(new BoxLayout(2));
            this.components = new Component[42];
            this.setUIID("MonthView");
            this.titles = new Container(new GridLayout(1, 7));
            this.days = new Container(new GridLayout(6, 7));
            this.addComponent(this.titles);
            this.addComponent(this.days);
            if (UIManager.getInstance().isThemeConstant("calTitleDayStyleBool", false)) {
                this.titles.setUIID("CalendarTitleArea");
                this.days.setUIID("CalendarDayArea");
            }
            for (iter = 0; iter < DAYS.length; ++iter) {
                this.titles.addComponent(Calendar.this.createDayTitle(iter));
            }
            for (iter = 0; iter < this.components.length; ++iter) {
                this.components[iter] = Calendar.this.createDayComponent();
                this.days.add(this.components[iter]);
                if (iter <= 7) {
                    this.components[iter].setNextFocusUp(Calendar.this.year);
                }
                Calendar.this.bindDayListener(this.components[iter], this);
                for (ActionListener dayListener : Calendar.this.dayListeners) {
                    Calendar.this.bindDayListener(this.components[iter], dayListener);
                }
            }
            this.setCurrentDay(time);
        }

        public long getCurrentDay() {
            return this.currentDay;
        }

        public void setCurrentDay(long day) {
            this.setCurrentDay(day, false);
        }

        private void setCurrentDay(long day, boolean force) {
            this.repaint();
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTime(new Date(this.currentDay));
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            int yearOld = cal.get(1);
            int monthOld = cal.get(2);
            int dayOld = cal.get(5);
            Date dateObject = new Date(day);
            cal.setTime(dateObject);
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            int yearNew = cal.get(1);
            int monthNew = cal.get(2);
            int dayNew = cal.get(5);
            if (Calendar.this.month != null) {
                Calendar.this.year.setSelectedItem("" + yearNew);
                Calendar.this.month.setSelectedIndex(monthNew);
            } else if (Calendar.this.dateLabel != null) {
                Calendar.this.dateLabel.setText(Calendar.this.getLocalizedMonth(monthNew) + " " + yearNew);
            }
            if (yearNew != yearOld || monthNew != monthOld || dayNew != dayOld || force) {
                int j;
                this.currentDay = cal.getTime().getTime();
                if (Calendar.this.SELECTED_DAY == -1L) {
                    Calendar.this.SELECTED_DAY = this.currentDay;
                }
                int month = cal.get(2);
                cal.set(5, 1);
                long startDate = cal.getTime().getTime();
                int dow = cal.get(7);
                cal.setTime(new Date(cal.getTime().getTime()));
                cal.add(5, -1);
                int lastDay = cal.get(5);
                int i = 0;
                if (dow > 1) {
                    while (dow > 1) {
                        cal.add(5, -1);
                        dow = cal.get(7);
                    }
                    int previousMonthSunday = cal.get(5);
                    while (i <= lastDay - previousMonthSunday) {
                        Calendar.this.setDayUIID(this.components[i], "CalendarDay");
                        Calendar.this.setDayEnabled(this.components[i], false);
                        Calendar.this.setDayText(this.components[i], "" + (previousMonthSunday + i));
                        ++i;
                    }
                }
                cal.set(2, (month + 1) % 12);
                while (cal.get(2) != month) {
                    cal.add(5, -1);
                }
                lastDay = cal.get(5);
                for (j = i; j < this.components.length && j - i + 1 <= lastDay; ++j) {
                    Calendar.this.setDayEnabled(this.components[j], true);
                    ((Calendar)Calendar.this).dates[j] = startDate;
                    if (Calendar.this.dates[j] == Calendar.this.SELECTED_DAY) {
                        Calendar.this.setDayUIID(this.components[j], "CalendarSelectedDay");
                        this.selected = this.components[j];
                    } else {
                        Calendar.this.setDayUIID(this.components[j], "CalendarDay");
                    }
                    for (Map.Entry entry : Calendar.this.highlightGroup.entrySet()) {
                        if (!((Collection)entry.getValue()).contains(new Date(Calendar.this.dates[j]))) continue;
                        Calendar.this.setDayUIID(this.components[j], (String)entry.getKey());
                    }
                    if (Calendar.this.multipleSelectionEnabled && Calendar.this.selectedDays.contains(new Date(Calendar.this.dates[j]))) {
                        Calendar.this.setDayUIID(this.components[j], Calendar.this.selectedDaysUIID);
                    }
                    Calendar.this.updateButtonDayDate(this.components[j], yearNew, month, j - i + 1);
                    cal.setTime(new Date(startDate));
                    cal.add(5, 1);
                    startDate = cal.getTime().getTime();
                }
                int d = 1;
                while (j < this.components.length) {
                    Calendar.this.setDayUIID(this.components[j], "CalendarDay");
                    Calendar.this.setDayEnabled(this.components[j], false);
                    Calendar.this.setDayText(this.components[j], "" + d++);
                    ++j;
                }
            }
        }

        public int getDayOfMonth() {
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTime(new Date(this.currentDay));
            return cal.get(5);
        }

        public int getMonth() {
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTime(new Date(this.currentDay));
            return cal.get(2);
        }

        public void incrementMonth() {
            int month = this.getMonth();
            int year = this.getYear();
            if (++month > 11) {
                month = 0;
                ++year;
            }
            this.setMonth(year, month);
        }

        private long getSelectedDay() {
            return Calendar.this.SELECTED_DAY;
        }

        public void setSelectedDay(long selectedDay) {
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTime(new Date(selectedDay));
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Calendar.this.SELECTED_DAY = cal.getTime().getTime();
        }

        private void setMonth(int year, int month) {
            this.fireMonthChangedEvent();
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTimeZone(TimeZone.getDefault());
            cal.set(2, month);
            cal.set(5, 1);
            cal.set(1, year);
            while (cal.get(2) != month) {
                cal.add(5, -1);
            }
            this.setCurrentDay(cal.getTime().getTime());
        }

        public void decrementMonth() {
            int month = this.getMonth();
            int year = this.getYear();
            if (--month < 0) {
                month = 11;
                --year;
            }
            this.setMonth(year, month);
        }

        public int getYear() {
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTime(new Date(this.currentDay));
            return cal.get(1);
        }

        public void addActionListener(ActionListener l) {
            Calendar.this.dispatcher.addListener(l);
        }

        public void removeActionListener(ActionListener l) {
            Calendar.this.dispatcher.removeListener(l);
        }

        public void addMonthChangedListener(ActionListener l) {
            Calendar.this.monthChangedListeners.addListener(l);
        }

        public void removeMonthChangedListener(ActionListener l) {
            Calendar.this.monthChangedListeners.removeListener(l);
        }

        public void addDayActionListener(ActionListener l) {
            Calendar.this.dayListeners.add(l);
            for (Component cmp : this.components) {
                Calendar.this.bindDayListener(cmp, l);
            }
        }

        public void removeDayActionListener(ActionListener l) {
            Calendar.this.dayListeners.remove(l);
            for (Component cmp : this.components) {
                Calendar.this.unBindDayListener(cmp, l);
            }
        }

        public void addDataChangedListener(DataChangedListener l) {
            Calendar.this.dataChangedListeners.addListener(l);
        }

        public void removeDataChangedListener(DataChangedListener l) {
            Calendar.this.dataChangedListeners.removeListener(l);
        }

        protected void fireActionEvent() {
            Calendar.this.componentChanged();
            super.fireActionEvent();
            Calendar.this.dispatcher.fireActionEvent(new ActionEvent((Object)Calendar.this, ActionEvent.Type.Calendar));
        }

        protected void fireMonthChangedEvent() {
            Calendar.this.monthChangedListeners.fireActionEvent(new ActionEvent((Object)Calendar.this, ActionEvent.Type.Calendar));
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src instanceof ComboBox) {
                this.setMonth(Integer.parseInt((String)Calendar.this.year.getSelectedItem()), Calendar.this.month.getSelectedIndex());
                Calendar.this.componentChanged();
                return;
            }
            if (Calendar.this.changesSelectedDateEnabled) {
                for (int iter = 0; iter < this.components.length; ++iter) {
                    boolean isContained = false;
                    if (this.components[iter] instanceof Container) {
                        isContained = ((Container)this.components[iter]).contains((Component)src);
                    }
                    if (src != this.components[iter] && !isContained) continue;
                    if (Calendar.this.multipleSelectionEnabled) {
                        if (Calendar.this.selectedDays.contains(new Date(Calendar.this.dates[iter]))) {
                            if (Calendar.this.SELECTED_DAY == Calendar.this.dates[iter]) {
                                Calendar.this.setDayUIID(this.components[iter], "CalendarSelectedDay");
                            } else {
                                Calendar.this.setDayUIID(this.components[iter], "CalendarDay");
                            }
                            if (!Calendar.this.highlightGroup.isEmpty()) {
                                for (Map.Entry entry : Calendar.this.highlightGroup.entrySet()) {
                                    if (!((Collection)entry.getValue()).contains(new Date(Calendar.this.dates[iter]))) continue;
                                    Calendar.this.setDayUIID(this.components[iter], (String)entry.getKey());
                                    break;
                                }
                            }
                            Calendar.this.selectedDays.remove(new Date(Calendar.this.dates[iter]));
                        } else {
                            Calendar.this.setDayUIID(this.components[iter], Calendar.this.selectedDaysUIID);
                            Calendar.this.selectedDays.add(new Date(Calendar.this.dates[iter]));
                        }
                    } else {
                        if (this.selected != null) {
                            Calendar.this.setDayUIID(this.selected, "CalendarDay");
                            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
                            cal.setTime(new Date(this.currentDay));
                            cal.set(5, Integer.parseInt(Calendar.this.getDayText(this.selected).trim()));
                            cal.set(10, 1);
                            cal.set(11, 1);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            if (!Calendar.this.highlightGroup.isEmpty()) {
                                for (Map.Entry entry : Calendar.this.highlightGroup.entrySet()) {
                                    if (!((Collection)entry.getValue()).contains(cal.getTime())) continue;
                                    Calendar.this.setDayUIID(this.selected, (String)entry.getKey());
                                    break;
                                }
                            }
                        }
                        Calendar.this.setDayUIID(this.components[iter], "CalendarSelectedDay");
                        Calendar.this.SELECTED_DAY = Calendar.this.dates[iter];
                        this.selected = this.components[iter];
                    }
                    this.fireActionEvent();
                    if (!this.getComponentForm().isSingleFocusMode()) {
                        this.setHandlesInput(false);
                    }
                    this.revalidate();
                    return;
                }
            }
        }
    }
}

