/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.cloud.BindTarget;
import com.codename1.ui.Button;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.plaf.DefaultLookAndFeel;
import com.codename1.ui.plaf.LookAndFeel;
import com.codename1.ui.util.EventDispatcher;

public class CheckBox
extends Button {
    private boolean selected = false;
    private boolean oppositeSide;
    private EventDispatcher bindListeners = null;
    private EventDispatcher changeListeners;

    public CheckBox(String text) {
        this(text, (Image)null);
    }

    public CheckBox() {
        this("");
    }

    public CheckBox(Image icon) {
        this("", icon);
    }

    public CheckBox(String text, Image icon) {
        super(text, icon);
        this.setUIID("CheckBox");
        this.updateSide();
    }

    public static CheckBox createToggle(String text, Image icon) {
        CheckBox cb = new CheckBox(text, icon);
        cb.setToggle(true);
        return cb;
    }

    public static CheckBox createToggle(String text) {
        CheckBox cb = new CheckBox(text, null);
        cb.setToggle(true);
        return cb;
    }

    public static CheckBox createToggle(Image icon) {
        CheckBox cb = new CheckBox("", icon);
        cb.setToggle(true);
        return cb;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        boolean changed = selected != this.selected;
        this.selected = selected;
        if (changed) {
            this.fireChangeEvent();
        }
        this.repaint();
    }

    public void released(int x, int y) {
        this.setSelected(!this.isSelected());
        super.released(x, y);
    }

    protected void fireActionEvent(int x, int y) {
        super.fireActionEvent(x, y);
        if (this.bindListeners != null) {
            if (this.isSelected()) {
                this.bindListeners.fireBindTargetChange(this, "selected", Boolean.FALSE, Boolean.TRUE);
            } else {
                this.bindListeners.fireBindTargetChange(this, "selected", Boolean.TRUE, Boolean.FALSE);
            }
        }
    }

    public void paint(Graphics g) {
        if (this.isToggle()) {
            this.getUIManager().getLookAndFeel().drawButton(g, this);
        } else {
            this.getUIManager().getLookAndFeel().drawCheckBox(g, this);
        }
    }

    protected Dimension calcPreferredSize() {
        return this.getUIManager().getLookAndFeel().getCheckBoxPreferredSize(this);
    }

    protected String paramString() {
        return super.paramString() + ", selected = " + this.selected;
    }

    void initComponentImpl() {
        super.initComponentImpl();
    }

    private void updateSide() {
        Boolean v = this.getUIManager().isThemeConstant("checkBoxOppositeSideBool");
        if (v != null) {
            this.oppositeSide = v;
        }
    }

    public void refreshTheme(boolean merge) {
        super.refreshTheme(merge);
        this.updateSide();
    }

    int getAvaliableSpaceForText() {
        Image[] rButtonImages;
        if (this.isToggle()) {
            return super.getAvaliableSpaceForText();
        }
        LookAndFeel l = this.getUIManager().getLookAndFeel();
        if (l instanceof DefaultLookAndFeel && (rButtonImages = ((DefaultLookAndFeel)l).getCheckBoxImages()) != null) {
            int index = this.isSelected() ? 1 : 0;
            return super.getAvaliableSpaceForText() - rButtonImages[index].getWidth();
        }
        return super.getAvaliableSpaceForText() - (this.getHeight() + this.getGap());
    }

    public boolean isOppositeSide() {
        return this.oppositeSide;
    }

    public void setOppositeSide(boolean oppositeSide) {
        this.oppositeSide = oppositeSide;
    }

    public String[] getBindablePropertyNames() {
        return new String[]{"selected"};
    }

    public Class[] getBindablePropertyTypes() {
        return new Class[]{Boolean.class};
    }

    public void bindProperty(String prop, BindTarget target) {
        if (prop.equals("selected")) {
            if (this.bindListeners == null) {
                this.bindListeners = new EventDispatcher();
            }
            this.bindListeners.addListener(target);
            return;
        }
        super.bindProperty(prop, target);
    }

    public void unbindProperty(String prop, BindTarget target) {
        if (prop.equals("selected")) {
            if (this.bindListeners == null) {
                return;
            }
            this.bindListeners.removeListener(target);
            if (!this.bindListeners.hasListeners()) {
                this.bindListeners = null;
            }
            return;
        }
        super.unbindProperty(prop, target);
    }

    public Object getBoundPropertyValue(String prop) {
        if (prop.equals("selected")) {
            if (this.isSelected()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return super.getBoundPropertyValue(prop);
    }

    public void setBoundPropertyValue(String prop, Object value) {
        if (prop.equals("selected")) {
            this.setSelected(value != null && (Boolean)value != false);
            return;
        }
        super.setBoundPropertyValue(prop, value);
    }

    public void addChangeListener(ActionListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new EventDispatcher();
        }
        this.changeListeners.addListener(l);
    }

    public void removeChangeListeners(ActionListener l) {
        if (this.changeListeners != null) {
            this.changeListeners.removeListener(l);
        }
    }

    private void fireChangeEvent() {
        if (this.changeListeners != null) {
            ActionEvent evt = new ActionEvent((Object)this, ActionEvent.Type.Change);
            this.changeListeners.fireActionEvent(evt);
        }
    }
}

