/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.List;
import com.codename1.ui.animations.CommonTransitions;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.list.DefaultListCellRenderer;
import com.codename1.ui.list.DefaultListModel;
import com.codename1.ui.list.ListCellRenderer;
import com.codename1.ui.list.ListModel;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBox<T>
extends List<T>
implements ActionSource {
    private static boolean defaultActAsSpinnerDialog;
    private static boolean defaultIncludeSelectCancel;
    private Image comboBoxImage;
    private boolean actAsSpinnerDialog = defaultActAsSpinnerDialog;
    private boolean includeSelectCancel = defaultIncludeSelectCancel;
    private boolean showingPopupDialog;

    public ComboBox(Vector<T> items) {
        this((ListModel<T>)new DefaultListModel<T>(items));
    }

    public ComboBox(Object ... items) {
        this((ListModel<Object>)new DefaultListModel<Object>(items));
    }

    public ComboBox() {
        this((ListModel<T>)new DefaultListModel());
    }

    public ComboBox(ListModel<T> model) {
        super(model);
        Component c;
        super.setUIID("ComboBox");
        ((DefaultListCellRenderer)super.getRenderer()).setShowNumbers(false);
        this.setInputOnFocus(false);
        this.setIsScrollVisible(false);
        this.setFixedSelection(1);
        ListCellRenderer r = this.getRenderer();
        if (r instanceof Component) {
            c = (Component)((Object)this.getRenderer());
            c.setUIID("ComboBoxItem");
        }
        if ((c = this.getRenderer().getListFocusComponent(this)) != null) {
            c.setUIID("ComboBoxFocus");
        }
        if (UIManager.getInstance().isThemeConstant("comboBoxUseMaterialArrowDropDownBool", false)) {
            Style comboImageStyle = new Style(this.getStyle());
            comboImageStyle.setBgTransparency(0);
            this.setComboBoxImage(FontImage.createMaterial('\ue5c5', comboImageStyle));
        }
    }

    public static boolean isDefaultActAsSpinnerDialog() {
        return defaultActAsSpinnerDialog;
    }

    public static void setDefaultActAsSpinnerDialog(boolean aDefaultActAsSpinnerDialog) {
        defaultActAsSpinnerDialog = aDefaultActAsSpinnerDialog;
    }

    public static boolean isDefaultIncludeSelectCancel() {
        return defaultIncludeSelectCancel;
    }

    public static void setDefaultIncludeSelectCancel(boolean aDefaultIncludeSelectCancel) {
        defaultIncludeSelectCancel = aDefaultIncludeSelectCancel;
    }

    public Image getComboBoxImage() {
        return this.comboBoxImage;
    }

    public void setComboBoxImage(Image comboBoxImage) {
        this.comboBoxImage = comboBoxImage;
    }

    @Override
    public void setUIID(String uiid) {
        Component c;
        super.setUIID(uiid);
        ListCellRenderer r = this.getRenderer();
        if (r instanceof Component) {
            c = (Component)((Object)this.getRenderer());
            c.setUIID(uiid + "Item");
        }
        if ((c = this.getRenderer().getListFocusComponent(this)) != null) {
            c.setUIID(uiid + "Focus");
        }
        if (UIManager.getInstance().isThemeConstant("comboBoxUseMaterialArrowDropDownBool", false)) {
            Style comboImageStyle = new Style(this.getStyle());
            comboImageStyle.setBgTransparency(0);
            this.setComboBoxImage(FontImage.createMaterial('\ue5c5', comboImageStyle));
        }
    }

    @Override
    public int getBaseline(int width, int height) {
        Component selected = this.getRenderingPrototype() != null ? this.getRenderer().getListCellRendererComponent(this, this.getRenderingPrototype(), 0, true) : (this.getModel().getSize() > 0 ? this.getRenderer().getListCellRendererComponent(this, this.getModel().getItemAt(0), 0, true) : this.getRenderer().getListCellRendererComponent(this, "XXXXXXXXXXX", 0, true));
        return this.getHeight() - this.getStyle().getPaddingBottom() - selected.getStyle().getPaddingBottom();
    }

    @Override
    protected void laidOut() {
    }

    @Override
    public Rectangle getSelectedRect() {
        return new Rectangle(this.getAbsoluteX(), this.getAbsoluteY(), this.getBounds().getSize());
    }

    @Override
    protected Rectangle getVisibleBounds() {
        return this.getBounds();
    }

    @Override
    public void setSelectedIndex(int selection) {
        super.setSelectedIndex(selection, false);
    }

    @Override
    public void setSelectedIndex(int selection, boolean scroll) {
        super.setSelectedIndex(selection, false);
    }

    @Override
    public void pointerHover(int[] x, int[] y) {
    }

    @Override
    public void pointerHoverReleased(int[] x, int[] y) {
    }

    protected Dialog createPopupDialog(List<T> l) {
        Dialog popupDialog = new Dialog(this.getUIID() + "Popup", this.getUIID() + "PopupTitle"){

            void sizeChangedInternal(int w, int h) {
                if (this.getWidth() == w && this.getHeight() != h) {
                    Form frm = this.getPreviousForm();
                    if (frm != null) {
                        frm.sizeChangedInternal(w, h);
                    }
                    this.setSize(new Dimension(w, h));
                    this.repaint();
                } else {
                    this.dispose();
                }
            }
        };
        popupDialog.setScrollable(false);
        popupDialog.getContentPane().setAlwaysTensile(false);
        popupDialog.setAlwaysTensile(false);
        popupDialog.getContentPane().setUIID("PopupContentPane");
        popupDialog.setDisposeWhenPointerOutOfBounds(true);
        popupDialog.setTransitionInAnimator(CommonTransitions.createEmpty());
        popupDialog.setTransitionOutAnimator(CommonTransitions.createEmpty());
        popupDialog.setLayout(new BorderLayout());
        popupDialog.addComponent("Center", l);
        return popupDialog;
    }

    public boolean isShowingPopupDialog() {
        return this.showingPopupDialog;
    }

    protected Command showPopupDialog(Dialog popupDialog, List l) {
        if (this.getUIManager().isThemeConstant("popupTitleBool", false) && this.getLabelForComponent() != null) {
            popupDialog.setTitle(this.getLabelForComponent().getText());
        }
        if (this.includeSelectCancel) {
            popupDialog.setBackCommand(popupDialog.getMenuBar().getCancelMenuItem());
            if (Display.getInstance().isTouchScreenDevice()) {
                if (this.getUIManager().isThemeConstant("popupCancelBodyBool", false)) {
                    popupDialog.placeButtonCommands(new Command[]{popupDialog.getMenuBar().getCancelMenuItem()});
                }
            } else if (Display.getInstance().isThirdSoftButton()) {
                popupDialog.addCommand(popupDialog.getMenuBar().getSelectMenuItem());
                popupDialog.addCommand(popupDialog.getMenuBar().getCancelMenuItem());
            } else {
                popupDialog.addCommand(popupDialog.getMenuBar().getCancelMenuItem());
                popupDialog.addCommand(popupDialog.getMenuBar().getSelectMenuItem());
            }
        }
        if (this.actAsSpinnerDialog) {
            l.setFixedSelection(12);
            l.setUIID("Spinner");
            l.spinnerOverlay = this.getUIManager().getComponentStyle("SpinnerOverlay");
            l.spinnerOverlay.setMargin(0, 0, 0, 0);
            l.setAlwaysTensile(false);
            l.installDefaultPainter(l.spinnerOverlay);
            popupDialog.setDialogUIID("Container");
            popupDialog.setUIID("Container");
            popupDialog.getTitleComponent().setUIID("Container");
            popupDialog.setTransitionInAnimator(CommonTransitions.createSlide(1, true, 200));
            popupDialog.setTransitionOutAnimator(CommonTransitions.createSlide(1, false, 200));
            this.showingPopupDialog = true;
            Command out = popupDialog.show(Display.getInstance().getDisplayHeight() - popupDialog.getDialogComponent().getPreferredH(), 0, 0, 0, true, true);
            this.showingPopupDialog = false;
            return out;
        }
        if (this.getUIManager().isThemeConstant("centeredPopupBool", false)) {
            this.showingPopupDialog = true;
            Command out = popupDialog.showPacked("Center", true);
            this.showingPopupDialog = false;
            return out;
        }
        Form parentForm = this.getComponentForm();
        int listW = Math.max(this.getWidth(), l.getPreferredW());
        listW = Math.min(listW + l.getSideGap(), parentForm.getContentPane().getWidth());
        Container content = popupDialog.getDialogComponent();
        Style contentStyle = content.getStyle();
        int listH = content.getPreferredH() + contentStyle.getVerticalMargins();
        Container title = popupDialog.getTitleArea();
        listH += title.getPreferredH() + title.getStyle().getVerticalMargins();
        int bottom = 0;
        int top = this.getAbsoluteY();
        int formHeight = parentForm.getHeight();
        if (parentForm.getSoftButtonCount() > 1) {
            Container c = parentForm.getSoftButton(0).getParent();
            formHeight -= c.getHeight();
            Style s = c.getStyle();
            formHeight -= s.getVerticalMargins();
        }
        if (listH < formHeight) {
            if (top > formHeight / 2) {
                bottom = formHeight - top;
                top -= listH;
            } else {
                bottom = formHeight - (top += this.getHeight()) - listH;
            }
        } else {
            top = 0;
        }
        int left = this.getAbsoluteX();
        int right = parentForm.getWidth() - left - listW;
        if (right < 0) {
            left += right;
            right = 0;
        }
        popupDialog.setBackCommand(popupDialog.getMenuBar().getCancelMenuItem());
        this.showingPopupDialog = true;
        Command out = popupDialog.show(Math.max(top, 0), Math.max(bottom, 0), Math.max(left, 0), Math.max(right, 0), false, true);
        this.showingPopupDialog = false;
        return out;
    }

    @Override
    protected void fireClicked() {
        List<T> l = this.createPopupList();
        l.dispatcher = this.dispatcher;
        l.eventSource = this;
        l.disposeDialogOnSelection = true;
        Form parentForm = this.getComponentForm();
        int tint = parentForm.getTintColor();
        parentForm.setTintColor(0);
        Dialog popupDialog = this.createPopupDialog(l);
        int originalSel = this.getSelectedIndex();
        Form.comboLock = this.includeSelectCancel;
        float rr = Dialog.getDefaultBlurBackgroundRadius();
        Dialog.setDefaultBlurBackgroundRadius(-1.0f);
        Command result = this.showPopupDialog(popupDialog, l);
        Dialog.setDefaultBlurBackgroundRadius(rr);
        Form.comboLock = false;
        parentForm.setTintColor(tint);
        if (result == popupDialog.getMenuBar().getCancelMenuItem() || popupDialog.wasDisposedDueToOutOfBoundsTouch() || popupDialog.wasDisposedDueToRotation()) {
            this.setSelectedIndex(originalSel);
        }
    }

    protected List<T> createPopupList() {
        List l = new List(this.getModel());
        l.setCommandList(this.isCommandList());
        l.setSmoothScrolling(this.isSmoothScrolling());
        l.setFixedSelection(this.getFixedSelection());
        l.setListCellRenderer(this.getRenderer());
        l.setItemGap(this.getItemGap());
        l.setUIID("ComboBoxList");
        if (this.getUIManager().isThemeConstant("otherPopupRendererBool", false)) {
            DefaultListCellRenderer renderer = new DefaultListCellRenderer();
            renderer.setUIID("PopupItem");
            renderer.getListFocusComponent(l).setUIID("PopupFocus");
            l.setListCellRenderer(renderer);
        }
        return l;
    }

    @Override
    public void keyReleased(int keyCode) {
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (gameAction == 8) {
            this.fireClicked();
            return;
        }
        super.keyPressed(keyCode);
    }

    @Override
    void selectElement(int selectedIndex) {
    }

    @Override
    public void pointerPressed(int x, int y) {
    }

    @Override
    public void pointerDragged(int x, int y) {
    }

    @Override
    public void pointerReleased(int x, int y) {
        if (this.isEnabled() && !Display.impl.isScrollWheeling()) {
            this.fireClicked();
        }
    }

    @Override
    public void paint(Graphics g) {
        this.getUIManager().getLookAndFeel().drawComboBox(g, this);
    }

    @Override
    protected Dimension calcPreferredSize() {
        return this.getUIManager().getLookAndFeel().getComboBoxPreferredSize(this);
    }

    @Override
    public int getOrientation() {
        return 2;
    }

    public boolean isIncludeSelectCancel() {
        return this.includeSelectCancel;
    }

    public void setIncludeSelectCancel(boolean includeSelectCancel) {
        this.includeSelectCancel = includeSelectCancel;
    }

    public boolean isActAsSpinnerDialog() {
        return this.actAsSpinnerDialog;
    }

    public void setActAsSpinnerDialog(boolean actAsSpinnerDialog) {
        this.actAsSpinnerDialog = actAsSpinnerDialog;
    }

    static {
        defaultIncludeSelectCancel = true;
    }
}

