/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.plaf.Style;

public abstract class DynamicImage
extends Image {
    private int w = 250;
    private int h = 250;
    private Style style;

    public DynamicImage() {
        super(null);
    }

    public DynamicImage(int w, int h) {
        super(null);
        this.w = w;
        this.h = h;
    }

    public static void setIcon(final Label lbl, final DynamicImage img) {
        DynamicImage wrapper = new DynamicImage(){

            protected void drawImageImpl(Graphics g, Object nativeGraphics, int x, int y, int w, int h) {
                img.setStyle(lbl.getStyle());
                img.drawImageImpl(g, nativeGraphics, x, y, w, h);
            }
        };
        wrapper.w = img.w;
        wrapper.h = img.h;
        lbl.setIcon(wrapper);
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style s) {
        this.style = s == null ? null : new Style(s);
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void scale(int width, int height) {
        this.w = width;
        this.h = height;
    }

    public Image fill(int width, int height) {
        try {
            DynamicImage img = (DynamicImage)this.getClass().newInstance();
            img.w = width;
            img.h = height;
            img.setStyle(this.style);
            return img;
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public Image applyMask(Object mask) {
        return this.fill(this.w, this.h);
    }

    public boolean requiresDrawImage() {
        return true;
    }

    protected abstract void drawImageImpl(Graphics var1, Object var2, int var3, int var4, int var5, int var6);

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y) {
        this.drawImageImpl(g, nativeGraphics, x, y, this.w, this.h);
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y, int w, int h) {
        this.drawImageImpl(g, nativeGraphics, x, y, w, h);
    }
}

