/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.ui.Display;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.RGBImage;
import com.codename1.ui.util.ImageIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EncodedImage
extends Image {
    private byte[][] imageData;
    private int[] dpis;
    private int lastTestedDPI = -1;
    private int width = -1;
    private int height = -1;
    private boolean opaqueChecked = false;
    private boolean opaque = false;
    private Object cache;
    private Image hardCache;
    private int locked;

    private EncodedImage(byte[][] imageData) {
        super(null);
        this.imageData = imageData;
    }

    protected EncodedImage(int width, int height) {
        super(null);
        this.width = width;
        this.height = height;
    }

    public static EncodedImage createMulti(int[] dpis, byte[][] data) {
        EncodedImage e = new EncodedImage(data);
        e.dpis = dpis;
        return e;
    }

    public static EncodedImage createFromImage(Image i, boolean jpeg) {
        if (i instanceof EncodedImage) {
            return (EncodedImage)i;
        }
        ImageIO io = ImageIO.getImageIO();
        if (io != null) {
            String format = jpeg ? (!io.isFormatSupported("jpeg") ? "png" : "jpeg") : (!io.isFormatSupported("png") ? "jpeg" : "png");
            try {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                io.save(i, bo, format, 0.9f);
                EncodedImage enc = EncodedImage.create(bo.toByteArray());
                Util.cleanup(bo);
                enc.width = i.getWidth();
                enc.height = i.getHeight();
                if (format == "jpeg") {
                    enc.opaque = true;
                    enc.opaqueChecked = true;
                }
                enc.cache = Display.getInstance().createSoftWeakRef(i);
                return enc;
            }
            catch (IOException err) {
                Log.e(err);
            }
        }
        return null;
    }

    public static Image createFromRGB(int[] argb, int width, int height, boolean jpeg) {
        Image i = Image.createImage(argb, width, height);
        ImageIO io = ImageIO.getImageIO();
        if (io != null) {
            String format;
            if (jpeg) {
                if (!io.isFormatSupported("jpeg")) {
                    return i;
                }
                format = "jpeg";
            } else {
                if (!io.isFormatSupported("png")) {
                    return i;
                }
                format = "png";
            }
            try {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                io.save(i, bo, format, 0.9f);
                EncodedImage enc = EncodedImage.create(bo.toByteArray());
                Util.cleanup(bo);
                enc.width = width;
                enc.height = height;
                if (jpeg) {
                    enc.opaque = true;
                    enc.opaqueChecked = true;
                }
                enc.cache = Display.getInstance().createSoftWeakRef(i);
                return enc;
            }
            catch (IOException err) {
                Log.e(err);
            }
        }
        return i;
    }

    public static EncodedImage create(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        return new EncodedImage(new byte[][]{data});
    }

    public static EncodedImage create(byte[] data, int width, int height, boolean opacity) {
        if (data == null) {
            throw new NullPointerException();
        }
        EncodedImage e = new EncodedImage(new byte[][]{data});
        e.width = width;
        e.height = height;
        e.opaque = opacity;
        e.opaqueChecked = true;
        return e;
    }

    public static EncodedImage create(InputStream i) throws IOException {
        byte[] buffer = Util.readInputStream(i);
        if (buffer.length > 200000) {
            System.out.println("Warning: loading large images using EncodedImage.create(InputStream) might lead to memory issues, try using EncodedImage.create(InputStream, int)");
        }
        return new EncodedImage(new byte[][]{buffer});
    }

    public static EncodedImage create(InputStream i, int size) throws IOException {
        byte[] buffer = new byte[size];
        Util.readFully(i, buffer);
        return new EncodedImage(new byte[][]{buffer});
    }

    public static EncodedImage create(String i) throws IOException {
        return EncodedImage.create(Display.getInstance().getResourceAsStream(EncodedImage.class, i));
    }

    protected void resetCache() {
        this.cache = null;
        this.hardCache = null;
    }

    public byte[] getImageData() {
        if (this.imageData.length == 1) {
            return this.imageData[0];
        }
        int dpi = Display.getInstance().getDeviceDensity();
        int bestFitOffset = 0;
        int bestFitDPI = 0;
        int dlen = this.dpis.length;
        for (int iter = 0; iter < dlen; ++iter) {
            int currentDPI = this.dpis[iter];
            if (dpi == currentDPI) {
                bestFitOffset = iter;
                break;
            }
            if (bestFitDPI == dpi || dpi < currentDPI || currentDPI < bestFitDPI) continue;
            bestFitDPI = currentDPI;
            bestFitOffset = iter;
        }
        this.lastTestedDPI = dpi;
        return this.imageData[bestFitOffset];
    }

    public Object getImage() {
        return this.getInternalImpl().getImage();
    }

    private Image getInternalImpl() {
        if (this.imageData != null && this.imageData.length > 1 && this.lastTestedDPI != Display.getInstance().getDeviceDensity()) {
            this.hardCache = null;
            this.cache = null;
            this.width = -1;
            this.height = -1;
        }
        if (this.hardCache != null) {
            return this.hardCache;
        }
        Image i = this.getInternal();
        if (this.locked > 0) {
            this.hardCache = i;
        }
        return i;
    }

    protected Image getInternal() {
        Image i;
        if (this.cache != null && (i = (Image)Display.getInstance().extractHardRef(this.cache)) != null) {
            return i;
        }
        try {
            byte[] b = this.getImageData();
            i = Image.createImage(b, 0, b.length);
            if (this.opaqueChecked) {
                i.setOpaque(this.opaque);
            }
            CodenameOneImplementation impl = Display.impl;
            impl.setImageName(i.getImage(), this.getImageName());
        }
        catch (Exception err) {
            Log.e(err);
            i = Image.createImage(5, 5);
        }
        this.cache = Display.getInstance().createSoftWeakRef(i);
        return i;
    }

    public boolean isLocked() {
        return this.locked > 0;
    }

    public void asyncLock(Image internal) {
        if (this.locked <= 0) {
            this.locked = 1;
            if (this.cache != null) {
                this.hardCache = (Image)Display.getInstance().extractHardRef(this.cache);
                if (this.hardCache != null) {
                    return;
                }
            }
            this.hardCache = internal;
            Display.getInstance().scheduleBackgroundTask(new Runnable(){

                public void run() {
                    try {
                        byte[] b = EncodedImage.this.getImageData();
                        final Image i = Image.createImage(b, 0, b.length);
                        if (EncodedImage.this.opaqueChecked) {
                            i.setOpaque(EncodedImage.this.opaque);
                        }
                        CodenameOneImplementation impl = Display.impl;
                        impl.setImageName(i.getImage(), EncodedImage.this.getImageName());
                        Display.getInstance().callSerially(new Runnable(){

                            public void run() {
                                if (EncodedImage.this.locked > 0) {
                                    EncodedImage.this.hardCache = i;
                                }
                                EncodedImage.this.cache = Display.getInstance().createSoftWeakRef(i);
                                Display.getInstance().getCurrent().repaint();
                                EncodedImage.this.width = i.getWidth();
                                EncodedImage.this.height = i.getHeight();
                            }
                        });
                    }
                    catch (Exception err) {
                        Log.e(err);
                    }
                }
            });
        }
    }

    public void lock() {
        if (this.locked < 1) {
            this.locked = 1;
            if (this.cache != null) {
                this.hardCache = (Image)Display.getInstance().extractHardRef(this.cache);
            }
        } else {
            ++this.locked;
        }
    }

    public void unlock() {
        --this.locked;
        if (this.locked < 1) {
            if (this.hardCache != null) {
                if (this.cache == null || Display.getInstance().extractHardRef(this.cache) == null) {
                    this.cache = Display.getInstance().createSoftWeakRef(this.hardCache);
                }
                this.hardCache = null;
            }
            this.locked = 0;
        }
    }

    public Image subImage(int x, int y, int width, int height, boolean processAlpha) {
        return this.getInternalImpl().subImage(x, y, width, height, processAlpha);
    }

    public Image rotate(int degrees) {
        return this.getInternalImpl().rotate(degrees);
    }

    public Image modifyAlpha(byte alpha) {
        return this.getInternalImpl().modifyAlpha(alpha);
    }

    public Image modifyAlpha(byte alpha, int removeColor) {
        return this.getInternalImpl().modifyAlpha(alpha, removeColor);
    }

    public Graphics getGraphics() {
        return null;
    }

    public int getWidth() {
        if (this.width > -1) {
            return this.width;
        }
        this.width = this.getInternalImpl().getWidth();
        return this.width;
    }

    public int getHeight() {
        if (this.height > -1) {
            return this.height;
        }
        this.height = this.getInternalImpl().getHeight();
        return this.height;
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y) {
        Display.impl.drawingEncodedImage(this);
        Image internal = this.getInternalImpl();
        if (this.width > -1 && this.height > -1 && (internal.getWidth() != this.width || internal.getHeight() != this.height)) {
            internal.drawImage(g, nativeGraphics, x, y, this.width, this.height);
        } else {
            internal.drawImage(g, nativeGraphics, x, y);
        }
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y, int w, int h) {
        Display.impl.drawingEncodedImage(this);
        this.getInternalImpl().drawImage(g, nativeGraphics, x, y, w, h);
    }

    void getRGB(int[] rgbData, int offset, int x, int y, int width, int height) {
        this.getInternalImpl().getRGB(rgbData, offset, x, y, width, height);
    }

    public void toRGB(RGBImage image, int destX, int destY, int x, int y, int width, int height) {
        this.getInternalImpl().toRGB(image, destX, destY, x, y, width, height);
    }

    public Image scaledWidth(int width) {
        return this.getInternalImpl().scaledWidth(width);
    }

    public Image scaledHeight(int height) {
        return this.getInternalImpl().scaledHeight(height);
    }

    public Image scaledSmallerRatio(int width, int height) {
        return this.getInternalImpl().scaledSmallerRatio(width, height);
    }

    public EncodedImage scaledEncoded(int width, int height) {
        float ratio;
        if (width == this.getWidth() && height == this.getHeight()) {
            return this;
        }
        if (width < 0) {
            ratio = (float)height / (float)this.getHeight();
            width = Math.max(1, (int)((float)this.getWidth() * ratio));
        } else if (height < 0) {
            ratio = (float)width / (float)this.getWidth();
            height = Math.max(1, (int)((float)this.getHeight() * ratio));
        }
        try {
            ImageIO io = ImageIO.getImageIO();
            if (io != null) {
                String format = "png";
                if ((this.isOpaque() || !io.isFormatSupported("png")) && io.isFormatSupported("jpeg")) {
                    format = "jpeg";
                }
                if (io.isFormatSupported(format)) {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    io.save(new ByteArrayInputStream(this.getImageData()), (OutputStream)bo, format, width, height, 0.9f);
                    EncodedImage img = EncodedImage.create(bo.toByteArray());
                    Util.cleanup(bo);
                    img.opaque = this.opaque;
                    img.opaqueChecked = this.opaqueChecked;
                    if (width > -1 && height > -1) {
                        img.width = width;
                        img.height = height;
                    }
                    return img;
                }
            }
        }
        catch (IOException err) {
            Log.e(err);
        }
        return null;
    }

    public Image scaled(int width, int height) {
        if (Display.getInstance().getProperty("encodedImageScaling", "true").equals("true") && ImageIO.getImageIO() != null && ImageIO.getImageIO().isFormatSupported("png")) {
            return this.scaledEncoded(width, height);
        }
        return this.getInternalImpl().scaled(width, height);
    }

    public void scale(int width, int height) {
        this.getInternalImpl().scale(width, height);
    }

    public boolean isAnimation() {
        return false;
    }

    public boolean isOpaque() {
        if (this.opaqueChecked) {
            return this.opaque;
        }
        this.opaque = this.getInternalImpl().isOpaque();
        return this.opaque;
    }
}

