/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Component;
import com.codename1.ui.Image;

public abstract class ImageFactory {
    private static final String KEY = "$$IMAGE_FACTORY$$";
    private static ImageFactory defaultFactory = new ImageFactory(){

        public Image createImage(int w, int h, int bgColor) {
            return Image.createImage(w, h, bgColor);
        }
    };

    public static ImageFactory getImageFactory(Component cmp) {
        if (cmp == null) {
            return defaultFactory;
        }
        ImageFactory f = (ImageFactory)cmp.getClientProperty(KEY);
        if (f == null) {
            return ImageFactory.getImageFactory(cmp.getParent());
        }
        return f;
    }

    public static ImageFactory setImageFactory(Component cmp, ImageFactory f) {
        if (cmp != null) {
            ImageFactory old = (ImageFactory)cmp.getClientProperty(KEY);
            cmp.putClientProperty(KEY, f);
            return old;
        }
        ImageFactory old = defaultFactory;
        defaultFactory = f;
        return old;
    }

    public static Image createImage(Component context, int w, int h, int bgColor) {
        return ImageFactory.getImageFactory(context).createImage(w, h, bgColor);
    }

    public abstract Image createImage(int var1, int var2, int var3);
}

