/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Button;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Label;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextHolder;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.plaf.Border;
import java.util.ArrayList;

public abstract class InputComponent
extends Container {
    static Boolean guiBuilderMode;
    private static boolean multiLineErrorMessage;
    private final Button lbl = new Button("", "Label"){

        protected boolean shouldRenderComponentSelection() {
            return true;
        }
    };
    private final Label descriptionMessage = new Label("", "DescriptionLabel");
    Button action;
    private Boolean onTopMode;
    private final TextHolder errorMessageImpl = this.createErrorLabel();
    private boolean actionAsButton;

    protected InputComponent() {
        if (guiBuilderMode == null) {
            guiBuilderMode = Display.getInstance().getProperty("GUIBuilderDesignMode", null) != null;
        }
    }

    private static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }

    private static int max(int a, int b, int c, int d) {
        return Math.max(Math.max(Math.max(a, b), c), d);
    }

    public static void group(Component ... cmps) {
        ArrayList<Component> al = new ArrayList<Component>();
        for (Component c : cmps) {
            if (c instanceof InputComponent) {
                InputComponent t = (InputComponent)c;
                if (t.isOnTopMode()) continue;
                al.add(t.lbl);
                t.lbl.setPreferredSize(null);
                continue;
            }
            al.add(c);
        }
        Component[] cc = new Component[al.size()];
        al.toArray(cc);
        Component.setSameWidth(cc);
    }

    public static boolean isMultiLineErrorMessage() {
        return multiLineErrorMessage;
    }

    public static void setMultiLineErrorMessage(boolean aMultiLineErrorMessage) {
        multiLineErrorMessage = aMultiLineErrorMessage;
    }

    protected void initInput() {
        if (this.getEditor() != null) {
            this.setUIID("TextComponent");
            this.getEditor().setLabelForComponent(this.lbl);
            this.lbl.setFocusable(false);
            String tuid = this.getUIManager().getThemeConstant("textComponentFieldUIID", null);
            if (tuid != null) {
                this.getEditor().setUIID(tuid);
            }
            this.refreshForGuiBuilder();
        }
    }

    Label getLabel() {
        return this.lbl;
    }

    protected TextHolder createErrorLabel() {
        if (multiLineErrorMessage && this.isOnTopMode()) {
            TextArea errorLabel = new TextArea(){

                protected Dimension calcPreferredSize() {
                    if (this.getText() == null || this.getText().length() == 0) {
                        return new Dimension();
                    }
                    return super.calcPreferredSize();
                }
            };
            errorLabel.setRows(1);
            errorLabel.setActAsLabel(true);
            errorLabel.setGrowByContent(true);
            errorLabel.setFocusable(false);
            errorLabel.setEditable(false);
            errorLabel.setUIID("ErrorLabel");
            return errorLabel;
        }
        return new Label("", "ErrorLabel");
    }

    Component getErrorMessage() {
        return (Component)((Object)this.errorMessageImpl);
    }

    Label getDescriptionMessage() {
        return this.descriptionMessage;
    }

    protected Dimension calcPreferredSize() {
        if (this.getComponentCount() == 0) {
            if (this.isOnTopMode()) {
                this.lbl.setUIID("FloatingHint");
                int w = InputComponent.max(this.getEditor().getOuterPreferredW(), this.lbl.getOuterPreferredW(), this.getErrorMessage().getOuterPreferredW(), this.descriptionMessage.getOuterPreferredW());
                int h = this.getEditor().getOuterPreferredH() + this.lbl.getOuterPreferredH() + Math.max(this.getErrorMessage().getOuterPreferredH(), this.descriptionMessage.getOuterPreferredH());
                return new Dimension(w + this.getStyle().getHorizontalPadding(), h + this.getStyle().getVerticalPadding());
            }
            return new Dimension(Math.max(this.getEditor().getOuterPreferredW() + this.lbl.getOuterPreferredW(), this.getErrorMessage().getOuterPreferredW()) + this.getStyle().getHorizontalPadding(), this.getErrorMessage().getOuterPreferredH() + Math.max(this.getEditor().getOuterPreferredH(), this.lbl.getOuterPreferredH()) + this.getStyle().getVerticalPadding());
        }
        return super.calcPreferredSize();
    }

    private void addEditorAction() {
        if (this.action != null) {
            if (this.actionAsButton) {
                this.add((Object)"Center", BorderLayout.centerEastWest(this.getEditor(), this.action, null));
            } else {
                this.add((Object)"Center", LayeredLayout.encloseIn(this.getEditor(), FlowLayout.encloseRightMiddle(this.action)));
            }
        } else {
            this.add((Object)"Center", this.getEditor());
        }
    }

    void constructUI() {
        if (this.getComponentCount() == 0) {
            if (this.isOnTopMode()) {
                this.lbl.setUIID("FloatingHint");
                this.setLayout(new BorderLayout());
                this.add((Object)"North", this.lbl);
                this.addEditorAction();
                this.add((Object)"South", LayeredLayout.encloseIn(this.getErrorMessage(), this.descriptionMessage));
            } else {
                this.setLayout(new BorderLayout());
                this.addEditorAction();
                this.add((Object)"West", this.lbl);
                this.add((Object)"South", this.getErrorMessage());
            }
        }
    }

    public abstract Component getEditor();

    void refreshForGuiBuilder() {
        if (guiBuilderMode.booleanValue()) {
            this.removeAll();
            this.getEditor().remove();
            if (this.action != null) {
                this.action.remove();
            }
            this.lbl.remove();
            this.descriptionMessage.remove();
            this.getErrorMessage().remove();
            this.constructUI();
        }
    }

    public InputComponent onTopMode(boolean onTopMode) {
        this.onTopMode = onTopMode;
        this.refreshForGuiBuilder();
        return this;
    }

    void initComponentImpl() {
        this.constructUI();
        super.initComponentImpl();
    }

    public boolean isOnTopMode() {
        if (this.onTopMode != null) {
            return this.onTopMode;
        }
        return this.getUIManager().isThemeConstant("textComponentOnTopBool", false);
    }

    public InputComponent errorMessage(String errorMessage) {
        String col = this.getUIManager().getThemeConstant("textComponentErrorColor", null);
        boolean line = this.getUIManager().isThemeConstant("textComponentErrorLineBorderBool", true);
        if (errorMessage == null || errorMessage.length() == 0) {
            if (this.errorMessageImpl.getText().length() == 0) {
                return this;
            }
            this.errorMessageImpl.setText("");
            if (col != null) {
                this.lbl.setUIID(this.lbl.getUIID());
                this.getEditor().setUIID(this.getEditor().getUIID());
            }
            this.descriptionMessage.setVisible(true);
        } else {
            this.descriptionMessage.setVisible(false);
            this.errorMessageImpl.setText(errorMessage);
            if (col != null) {
                int val = Integer.parseInt(col, 16);
                this.lbl.getAllStyles().setFgColor(val);
                if (line) {
                    Border b = Border.createUnderlineBorder(2, val);
                    this.getEditor().getAllStyles().setBorder(b);
                }
            }
        }
        this.refreshForGuiBuilder();
        return this;
    }

    public InputComponent descriptionMessage(String descriptionMessage) {
        if (descriptionMessage == null || descriptionMessage.length() == 0) {
            if (this.descriptionMessage.getText().length() == 0) {
                return this;
            }
            this.descriptionMessage.setText("");
        } else {
            this.descriptionMessage.setText(descriptionMessage);
        }
        this.refreshForGuiBuilder();
        return this;
    }

    public InputComponent label(String text) {
        this.lbl.setText(text);
        this.refreshForGuiBuilder();
        return this;
    }

    private void initAction() {
        if (this.action == null) {
            this.action = new Button("", "InputComponentAction");
        }
    }

    public InputComponent actionUIID(String uiid) {
        this.initAction();
        this.action.setUIID(uiid);
        return this;
    }

    public String getActionUIID() {
        this.initAction();
        return this.action.getUIID();
    }

    public InputComponent actionAsButton(boolean asButton) {
        this.initAction();
        this.actionAsButton = asButton;
        return this;
    }

    public boolean isActionAsButton() {
        return this.actionAsButton;
    }

    public InputComponent actionText(String text) {
        this.initAction();
        this.action.setText(text);
        return this;
    }

    public String getActionText() {
        this.initAction();
        return this.action.getText();
    }

    public InputComponent action(char icon) {
        this.initAction();
        this.action.setMaterialIcon(icon);
        this.refreshForGuiBuilder();
        return this;
    }

    public InputComponent actionClick(ActionListener c) {
        this.initAction();
        this.action.addActionListener(c);
        this.refreshForGuiBuilder();
        return this;
    }

    public Button getAction() {
        this.initAction();
        return this.action;
    }

    public Object getPropertyValue(String name) {
        if (name.equals("label")) {
            return this.lbl.getText();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("label")) {
            this.label((String)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }
}

