/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Command;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Label;
import com.codename1.ui.TextField;
import com.codename1.ui.Toolbar;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.plaf.UIManager;

class SearchBar
extends Toolbar {
    private final TextField search;
    private final Toolbar parent;
    private final float iconSize;

    public SearchBar(Toolbar parent, float iconSize) {
        this.parent = parent;
        this.iconSize = iconSize;
        this.search = new TextField();
        this.search.putClientProperty("searchField", Boolean.TRUE);
        this.search.setUIID("TextFieldSearch");
        FontImage img = iconSize > 0.0f ? FontImage.createMaterial('\ue8b6', UIManager.getInstance().getComponentStyle("TextHintSearch"), iconSize) : FontImage.createMaterial('\ue8b6', UIManager.getInstance().getComponentStyle("TextHintSearch"));
        String s = this.getUIManager().localize("m.search", "Search");
        Label hint = new Label(s, img);
        hint.setUIID("TextHintSearch");
        this.search.setHint(s);
        this.search.setHintLabelImpl(hint);
        this.search.addDataChangedListener(new DataChangedListener(){

            public void dataChanged(int type, int index) {
                SearchBar.this.onSearch(SearchBar.this.search.getText());
            }
        });
        this.setUIID("ToolbarSearch");
        if (parent.getComponentForm() == Display.INSTANCE.getCurrent()) {
            this.search.startEditingAsync();
        } else if (parent.getComponentForm() != null) {
            parent.getComponentForm().setEditOnShow(this.search);
        }
    }

    void initSearchBar() {
        this.setTitleComponent(this.search);
        this.setBackCommand(new Command(""){

            public void actionPerformed(ActionEvent evt) {
                SearchBar.this.search.stopEditing();
                Display.getInstance().callSerially(new Runnable(){

                    public void run() {
                        SearchBar.this.onSearch("");
                        final Form f = (Form)SearchBar.this.getParent();
                        f.getAnimationManager().flushAnimation(new Runnable(){

                            public void run() {
                                f.removeComponentFromForm(SearchBar.this);
                                f.setToolbar(SearchBar.this.parent);
                                SearchBar.this.parent.setHidden(false);
                                f.animateLayout(100);
                            }
                        });
                    }
                });
            }
        }, Toolbar.BackCommandPolicy.AS_ARROW, this.iconSize);
        Command clear = new Command(""){

            public void actionPerformed(ActionEvent evt) {
                SearchBar.this.search.clear();
            }
        };
        FontImage img = this.iconSize > 0.0f ? FontImage.createMaterial('\ue5cd', UIManager.getInstance().getComponentStyle("TitleCommand"), this.iconSize) : FontImage.createMaterial('\ue5cd', UIManager.getInstance().getComponentStyle("TitleCommand"));
        clear.setIcon(img);
        this.addCommandToRightBar(clear);
    }

    public void onSearch(String text) {
    }
}

