/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.io.Log;
import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.ImageFactory;
import com.codename1.ui.Label;
import com.codename1.ui.MenuBar;
import com.codename1.ui.NavigationCommand;
import com.codename1.ui.Painter;
import com.codename1.ui.Toolbar;
import com.codename1.ui.animations.Animation;
import com.codename1.ui.animations.CommonTransitions;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.Resources;
import java.util.ArrayList;
import java.util.Vector;

public class SideMenuBar
extends MenuBar {
    public static final String COMMAND_PLACEMENT_KEY = "placement";
    public static final String COMMAND_PLACEMENT_VALUE_RIGHT = "right";
    public static final String COMMAND_PLACEMENT_VALUE_TOP = "top";
    public static final String COMMAND_SIDE_COMPONENT = "SideComponent";
    public static final String COMMAND_ACTIONABLE = "Actionable";
    int initialDragX;
    int initialDragY;
    boolean transitionRunning;
    boolean sideSwipePotential;
    private Button openButton;
    private Button rightSideButton;
    private Form parent;
    private Form menu;
    private Container rightPanel;
    private boolean dragActivated;
    private Transition in;
    private Transition out;
    private Container sidePanel;
    private int draggedX;
    private ArrayList rightCommands;
    private ArrayList leftCommands;
    private ActionListener pointerDragged;
    private ActionListener pointerPressed;
    private boolean rightSideSwipePotential;
    private boolean topSwipePotential;

    public static boolean isShowing() {
        Form f = Display.getInstance().getCurrent();
        return f.getClientProperty("cn1$sideMenuParent") != null;
    }

    public static void closeCurrentMenu() {
        Form f = Display.getInstance().getCurrent();
        SideMenuBar b = (SideMenuBar)f.getClientProperty("cn1$sideMenuParent");
        if (b != null && !b.transitionRunning) {
            b.closeMenu();
        }
    }

    public static void closeCurrentMenu(final Runnable callback) {
        if (Toolbar.isOnTopSideMenu() && (Toolbar.isGlobalToolbar() || Display.getInstance().getCommandBehavior() != 8)) {
            Display.getInstance().getCurrent().getToolbar().closeSideMenu();
            callback.run();
            return;
        }
        Form f = Display.getInstance().getCurrent();
        final SideMenuBar b = (SideMenuBar)f.getClientProperty("cn1$sideMenuParent");
        if (b != null && !b.transitionRunning) {
            b.parent.addShowListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    b.parent.removeShowListener(this);
                    callback.run();
                }
            });
            b.closeMenu();
        } else {
            callback.run();
        }
    }

    protected void initMenuBar(Form parent) {
        if (parent.getClientProperty("Menu") != null) {
            return;
        }
        super.initMenuBar(parent);
        this.parent = parent;
    }

    protected void removeAllCommands() {
        Container t = this.getTitleAreaContainer();
        int count = t.getComponentCount();
        Component[] cmps = new Component[count];
        for (int i = 0; i < count; ++i) {
            cmps[i] = t.getComponentAt(i);
        }
        for (int iter = 0; iter < count; ++iter) {
            Component current = cmps[iter];
            if (current.getClientProperty("TitleCommand") == null) continue;
            Button b = (Button)current;
            t.removeComponent(current);
            t.revalidate();
            if (this.rightCommands != null) {
                this.rightCommands.remove(b.getCommand());
            }
            if (this.leftCommands == null) continue;
            this.leftCommands.remove(b.getCommand());
        }
        super.removeAllCommands();
        this.initTitleBarStatus();
    }

    protected void unInstallMenuBar() {
        super.unInstallMenuBar();
        if (this.pointerDragged != null) {
            this.parent.removePointerDraggedListener(this.pointerDragged);
        }
        if (this.pointerPressed != null) {
            this.parent.removePointerPressedListener(this.pointerPressed);
        }
    }

    protected Button createOpenButton() {
        Button ob = new Button();
        ob.setUIID("MenuButton");
        UIManager uim = this.parent.getUIManager();
        Image i = uim.getThemeImageConstant("sideMenuImage");
        if (i != null) {
            ob.setIcon(i);
        } else {
            float size = 4.5f;
            try {
                size = Float.parseFloat(uim.getThemeConstant("menuImageSize", "4.5"));
            }
            catch (Throwable t) {
                Log.e(t);
            }
            FontImage.setMaterialIcon((Label)ob, '\ue5d2', size);
        }
        Image p = uim.getThemeImageConstant("sideMenuPressImage");
        if (p != null) {
            ob.setPressedIcon(p);
        }
        return ob;
    }

    protected void installMenuBar() {
        if (this.parent.getClientProperty("Menu") != null) {
            return;
        }
        super.installMenuBar();
        if (this.parent instanceof Dialog) {
            return;
        }
        this.openButton = this.createOpenButton();
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SideMenuBar.this.openMenu(null);
            }
        });
        this.addOpenButton(null, true);
        UIManager uim = this.parent.getUIManager();
        final boolean[] hasSideMenus = new boolean[2];
        if (uim.isThemeConstant("sideMenuFoldedSwipeBool", true) && this.parent.getClientProperty("sideMenuFoldedSwipeListeners") == null) {
            this.pointerDragged = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int y;
                    int x;
                    if (SideMenuBar.this.sideSwipePotential && hasSideMenus[0]) {
                        int x2 = evt.getX();
                        int y2 = evt.getY();
                        if (Math.abs(y2 - SideMenuBar.this.initialDragY) > x2 - SideMenuBar.this.initialDragX) {
                            SideMenuBar.this.sideSwipePotential = false;
                            return;
                        }
                        evt.consume();
                        if (x2 - SideMenuBar.this.initialDragX > Display.getInstance().getDisplayWidth() / SideMenuBar.this.getUIManager().getThemeConstant("sideSwipeActivationInt", 15)) {
                            SideMenuBar.this.draggedX = x2;
                            SideMenuBar.this.dragActivated = true;
                            SideMenuBar.this.parent.pointerReleased(-1, -1);
                            SideMenuBar.this.openMenu(null, 0, SideMenuBar.this.draggedX, false);
                            SideMenuBar.this.initialDragX = 0;
                            SideMenuBar.this.initialDragY = 0;
                        }
                        return;
                    }
                    if (SideMenuBar.this.rightSideSwipePotential && (hasSideMenus[1] || hasSideMenus[0] && SideMenuBar.this.isRTL())) {
                        x = evt.getX();
                        y = evt.getY();
                        if (x < 0 || Math.abs(y - SideMenuBar.this.initialDragY) > SideMenuBar.this.initialDragX - x) {
                            SideMenuBar.this.rightSideSwipePotential = false;
                            return;
                        }
                        evt.consume();
                        if (SideMenuBar.this.initialDragX - x > Display.getInstance().getDisplayWidth() / SideMenuBar.this.getUIManager().getThemeConstant("sideSwipeActivationInt", 15)) {
                            SideMenuBar.this.draggedX = x;
                            SideMenuBar.this.dragActivated = true;
                            SideMenuBar.this.parent.pointerReleased(-1, -1);
                            if (SideMenuBar.this.isRTL()) {
                                SideMenuBar.this.openMenu(null, 0, SideMenuBar.this.draggedX, false);
                            } else {
                                SideMenuBar.this.openMenu(SideMenuBar.COMMAND_PLACEMENT_VALUE_RIGHT, 0, SideMenuBar.this.draggedX, false);
                            }
                            SideMenuBar.this.initialDragX = 0;
                            SideMenuBar.this.initialDragY = 0;
                        }
                    }
                    if (SideMenuBar.this.topSwipePotential) {
                        x = evt.getX();
                        y = evt.getY();
                        if (Math.abs(y - SideMenuBar.this.initialDragY) < x - SideMenuBar.this.initialDragX) {
                            SideMenuBar.this.topSwipePotential = false;
                            return;
                        }
                        evt.consume();
                        if (SideMenuBar.this.initialDragY - y > Display.getInstance().getDisplayHeight() / SideMenuBar.this.getUIManager().getThemeConstant("sideSwipeActivationInt", 15)) {
                            SideMenuBar.this.draggedX = y;
                            SideMenuBar.this.dragActivated = true;
                            SideMenuBar.this.parent.pointerReleased(-1, -1);
                            SideMenuBar.this.openMenu(SideMenuBar.COMMAND_PLACEMENT_VALUE_TOP, 0, SideMenuBar.this.draggedX, false);
                            SideMenuBar.this.initialDragX = 0;
                            SideMenuBar.this.initialDragY = 0;
                        }
                    }
                }
            };
            this.parent.addPointerDraggedListener(this.pointerDragged);
            this.pointerPressed = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Object c;
                    SideMenuBar.this.rightSideSwipePotential = false;
                    SideMenuBar.this.topSwipePotential = false;
                    SideMenuBar.this.sideSwipePotential = false;
                    if (SideMenuBar.this.getCommandCount() == 0) {
                        return;
                    }
                    if (SideMenuBar.this.parent.getCommandCount() == 1 && SideMenuBar.this.parent.getCommand(0) == SideMenuBar.this.parent.getBackCommand()) {
                        return;
                    }
                    for (int iter = 0; iter < SideMenuBar.this.getCommandCount(); ++iter) {
                        c = SideMenuBar.this.getCommand(iter);
                        String p = (String)((Command)c).getClientProperty(SideMenuBar.COMMAND_PLACEMENT_KEY);
                        if (p == null) {
                            hasSideMenus[0] = true;
                            continue;
                        }
                        if (!p.equals(SideMenuBar.COMMAND_PLACEMENT_VALUE_RIGHT)) continue;
                        hasSideMenus[1] = true;
                    }
                    int displayWidth = Display.getInstance().getDisplayWidth();
                    if (SideMenuBar.this.rightSideButton != null || SideMenuBar.this.isRTL()) {
                        SideMenuBar.this.rightSideSwipePotential = !SideMenuBar.this.transitionRunning && evt.getX() > displayWidth - displayWidth / SideMenuBar.this.getUIManager().getThemeConstant("sideSwipeSensitiveInt", 10);
                    }
                    if (SideMenuBar.this.getTitleComponent() instanceof Button) {
                        SideMenuBar.this.topSwipePotential = !SideMenuBar.this.transitionRunning && evt.getY() < Display.getInstance().getDisplayHeight() / SideMenuBar.this.getUIManager().getThemeConstant("sideSwipeSensitiveInt", 10);
                    }
                    SideMenuBar.this.sideSwipePotential = !SideMenuBar.this.transitionRunning && evt.getX() < displayWidth / SideMenuBar.this.getUIManager().getThemeConstant("sideSwipeSensitiveInt", 10);
                    SideMenuBar.this.initialDragX = evt.getX();
                    SideMenuBar.this.initialDragY = evt.getY();
                    if ((SideMenuBar.this.sideSwipePotential || SideMenuBar.this.rightSideSwipePotential || SideMenuBar.this.topSwipePotential) && (c = Display.getInstance().getCurrent().getComponentAt(SideMenuBar.this.initialDragX, SideMenuBar.this.initialDragY)) != null && ((Component)c).shouldBlockSideSwipe()) {
                        SideMenuBar.this.sideSwipePotential = false;
                    }
                }
            };
            this.parent.addPointerPressedListener(this.pointerPressed);
            this.parent.putClientProperty("sideMenuFoldedSwipeListeners", "true");
        }
    }

    protected int getDragRegionStatus(int x, int y) {
        if (this.getUIManager().isThemeConstant("sideMenuFoldedSwipeBool", true)) {
            if (this.parent instanceof Dialog || this.getCommandCount() == 0) {
                return 1;
            }
            if (this.parent.getCommandCount() == 1 && this.parent.getCommand(0) == this.parent.getBackCommand()) {
                return 1;
            }
            if (x - this.initialDragX < Display.getInstance().getDisplayWidth() / this.getUIManager().getThemeConstant("sideSwipeActivationInt", 15)) {
                return 21;
            }
        }
        return 1;
    }

    void installRightCommands() {
        if (this.rightCommands != null) {
            for (int i = 0; i < this.rightCommands.size(); ++i) {
                Command cc;
                Layout l;
                Command rightCommand = (Command)this.rightCommands.get(this.rightCommands.size() - 1 - i);
                String uiid = (String)rightCommand.getClientProperty("uiid");
                String landscapeUiid = (String)rightCommand.getClientProperty("luiid");
                if (uiid == null) {
                    uiid = "TitleCommand";
                    if (landscapeUiid == null && UIManager.getInstance().isThemeConstant("landscapeTitleUiidBool", false)) {
                        landscapeUiid = uiid + "Landscape";
                    }
                }
                int txtPosition = 3;
                Integer pos = (Integer)rightCommand.getClientProperty("textPosition");
                if (pos != null) {
                    txtPosition = pos;
                }
                if (!((l = this.getTitleAreaContainer().getLayout()) instanceof BorderLayout)) continue;
                Button b = new Button(rightCommand);
                b.setUIID(uiid, landscapeUiid);
                b.putClientProperty("TitleCommand", Boolean.TRUE);
                b.setTextPosition(txtPosition);
                BorderLayout bl = (BorderLayout)l;
                Component east = bl.getEast();
                if (east == null) {
                    this.getTitleAreaContainer().addComponent("East", (Component)b);
                    continue;
                }
                if (east instanceof Container) {
                    Container cnt = (Container)east;
                    boolean shouldAdd = true;
                    for (int j = 0; j < cnt.getComponentCount(); ++j) {
                        Command cc2;
                        Component c = cnt.getComponentAt(j);
                        if (!(c instanceof Button) || (cc2 = ((Button)c).getCommand()) == null || !cc2.equals(b.getCommand())) continue;
                        shouldAdd = false;
                        break;
                    }
                    if (!shouldAdd) continue;
                    cnt.addComponent(b);
                    continue;
                }
                if (east instanceof Button && (cc = ((Button)east).getCommand()) != null && cc.equals(b.getCommand())) continue;
                east.getParent().removeComponent(east);
                Container buttons = new Container(new BoxLayout(1));
                buttons.addComponent(east);
                buttons.addComponent(b);
                this.getTitleAreaContainer().addComponent("East", (Component)buttons);
            }
        }
        this.initTitleBarStatus();
    }

    void installLeftCommands() {
        if (this.leftCommands != null) {
            for (int i = 0; i < this.leftCommands.size(); ++i) {
                Command cc;
                Layout l;
                Command leftCommand = (Command)this.leftCommands.get(this.leftCommands.size() - 1 - i);
                String uiid = (String)leftCommand.getClientProperty("uiid");
                String landscapeUiid = (String)leftCommand.getClientProperty("luiid");
                if (uiid == null) {
                    uiid = "TitleCommand";
                    if (landscapeUiid == null && UIManager.getInstance().isThemeConstant("landscapeTitleUiidBool", false)) {
                        landscapeUiid = uiid + "Landscape";
                    }
                }
                int txtPosition = 3;
                Integer pos = (Integer)leftCommand.getClientProperty("textPosition");
                if (pos != null) {
                    txtPosition = pos;
                }
                if (!((l = this.getTitleAreaContainer().getLayout()) instanceof BorderLayout)) continue;
                Button b = new Button(leftCommand);
                b.setUIID(uiid, landscapeUiid);
                b.putClientProperty("TitleCommand", Boolean.TRUE);
                b.setTextPosition(txtPosition);
                BorderLayout bl = (BorderLayout)l;
                Component west = bl.getWest();
                if (west == null) {
                    this.getTitleAreaContainer().addComponent("West", (Component)b);
                    continue;
                }
                if (west instanceof Container) {
                    Container cnt = (Container)west;
                    boolean shouldAdd = true;
                    for (int j = 0; j < cnt.getComponentCount(); ++j) {
                        Command cc2;
                        Component c = cnt.getComponentAt(j);
                        if (!(c instanceof Button) || (cc2 = ((Button)c).getCommand()) == null || !cc2.equals(b.getCommand())) continue;
                        shouldAdd = false;
                        break;
                    }
                    if (!shouldAdd) continue;
                    cnt.addComponent(b);
                    continue;
                }
                if (west instanceof Button && (cc = ((Button)west).getCommand()) != null && cc.equals(b.getCommand())) continue;
                west.getParent().removeComponent(west);
                Container buttons = new Container(new BoxLayout(1));
                buttons.addComponent(west);
                buttons.addComponent(b);
                this.getTitleAreaContainer().addComponent("West", (Component)buttons);
            }
        }
        this.initTitleBarStatus();
    }

    public void addCommand(Command cmd) {
        if (cmd.getClientProperty("TitleCommand") != null) {
            if (cmd.getClientProperty("Left") != null) {
                if (this.leftCommands == null) {
                    this.leftCommands = new ArrayList();
                }
                this.leftCommands.add(0, cmd);
            } else {
                if (this.rightCommands == null) {
                    this.rightCommands = new ArrayList();
                }
                this.rightCommands.add(0, cmd);
            }
            this.addOpenButton(cmd, false);
            this.installRightCommands();
            this.installLeftCommands();
            return;
        }
        super.addCommand(cmd);
        if (this.parent instanceof Dialog) {
            return;
        }
        this.addOpenButton(cmd, false);
    }

    public void setBackCommand(Command backCommand) {
        super.setBackCommand(backCommand);
        if (this.parent instanceof Dialog) {
            return;
        }
        this.addOpenButton(null, false);
        this.installRightCommands();
        this.installLeftCommands();
        if (this.getBackCommand() != null && this.getCommandCount() > 0 && !UIManager.getInstance().isThemeConstant("hideBackCommandBool", false) && !this.getCommands().contains(this.getBackCommand())) {
            this.getCommands().insertElementAt(this.getBackCommand(), 0);
        }
    }

    public int getCommandBehavior() {
        return 8;
    }

    protected void addCommand(Command cmd, int index) {
        if (cmd.getClientProperty("TitleCommand") != null) {
            if (cmd.getClientProperty("Left") != null) {
                if (this.leftCommands == null) {
                    this.leftCommands = new ArrayList();
                }
                this.leftCommands.add(0, cmd);
            } else {
                if (this.rightCommands == null) {
                    this.rightCommands = new ArrayList();
                }
                this.rightCommands.add(0, cmd);
            }
            this.addOpenButton(cmd, false);
            this.installRightCommands();
            this.installLeftCommands();
            return;
        }
        super.addCommand(cmd, index);
        if (this.parent instanceof Dialog) {
            return;
        }
        this.addOpenButton(cmd, false);
        if (this.getBackCommand() != null && this.getCommandCount() > 0 && !UIManager.getInstance().isThemeConstant("hideBackCommandBool", false)) {
            this.getCommands().remove(this.getBackCommand());
            this.getCommands().insertElementAt(this.getBackCommand(), this.getCommandCount());
        }
    }

    private void removeCommandComponent(Container cnt, Command cmd) {
        int count = cnt.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            Component c = cnt.getComponentAt(iter);
            if (c instanceof Container) {
                this.removeCommandComponent((Container)c, cmd);
                continue;
            }
            if (!(c instanceof Button) || ((Button)c).getCommand() != cmd) continue;
            Container cc = c.getParent();
            if (cc != null) {
                cc.removeComponent(c);
            }
            return;
        }
    }

    protected void removeCommand(Command cmd) {
        super.removeCommand(cmd);
        if (this.parent instanceof Dialog) {
            return;
        }
        if (cmd.getClientProperty("TitleCommand") != null && this.parent != null) {
            this.removeCommandComponent(this.getTitleAreaContainer(), cmd);
        }
        if (this.rightCommands != null) {
            this.rightCommands.remove(cmd);
        }
        if (this.leftCommands != null) {
            this.leftCommands.remove(cmd);
        }
        if (this.getCommandCount() == 0) {
            if (this.getTitleComponent() != null) {
                this.getTitleComponent().getParent().removeAll();
            }
            this.getTitleAreaContainer().removeAll();
            this.getTitleAreaContainer().addComponent("Center", this.getTitleComponent());
        }
        this.installRightCommands();
        this.installLeftCommands();
    }

    public void keyReleased(int keyCode) {
        if (keyCode == leftSK) {
            if (this.getCommandCount() == 0) {
                return;
            }
            if (this.parent.getCommandCount() == 1 && this.parent.getCommand(0) == this.parent.getBackCommand()) {
                return;
            }
            boolean[] hasSideMenus = new boolean[2];
            for (int iter = 0; iter < this.getCommandCount(); ++iter) {
                Command c = this.getCommand(iter);
                String p = (String)c.getClientProperty(COMMAND_PLACEMENT_KEY);
                if (p == null) {
                    hasSideMenus[0] = true;
                    continue;
                }
                if (!p.equals(COMMAND_PLACEMENT_VALUE_RIGHT)) continue;
                hasSideMenus[1] = true;
            }
            if (hasSideMenus[0]) {
                this.openMenu(null);
            } else if (hasSideMenus[1]) {
                this.openMenu(COMMAND_PLACEMENT_VALUE_RIGHT);
            }
        }
        super.keyReleased(keyCode);
    }

    public void closeMenu() {
        if (Toolbar.isOnTopSideMenu() && Display.getInstance().getCurrent().getToolbar() != null && Display.getInstance().getCommandBehavior() != 8) {
            Display.getInstance().getCurrent().getToolbar().closeSideMenu();
            return;
        }
        if (this.transitionRunning) {
            return;
        }
        if (Display.getInstance().getCurrent() == this.menu) {
            this.parent.showBack();
        }
    }

    public void openMenu(String direction) {
        this.openMenu(direction, -1, this.getUIManager().getThemeConstant("sideMenuAnimSpeedInt", 300), true);
    }

    void openMenu(String direction, int time, int dest, boolean transition) {
        if (Display.getInstance().getCurrent() == this.parent) {
            this.menu = this.createMenu(direction);
            this.out = this.parent.getTransitionOutAnimator();
            this.in = this.parent.getTransitionInAnimator();
            this.parent.setTransitionInAnimator(new MenuTransition(this.getUIManager().getThemeConstant("sideMenuAnimSpeedInt", 300), false, -1, direction));
            if (transition) {
                this.parent.setTransitionOutAnimator(new MenuTransition(dest, true, time, direction));
                this.menu.show();
            } else {
                this.parent.setTransitionOutAnimator(new MenuTransition(0, true, dest, direction));
                this.menu.show();
                this.parent.setTransitionOutAnimator(new MenuTransition(dest, true, time, direction));
            }
        }
    }

    public boolean isMenuOpen() {
        return Display.getInstance().getCurrent() == this.menu;
    }

    private void addOpenButton(Command cmd, boolean checkCommands) {
        if (this.openButton == null) {
            return;
        }
        if (this.parent != null && this.getCommandCount() > 0 && this.openButton.getParent() == null) {
            Component l;
            Container titleArea = this.getTitleAreaContainer();
            titleArea.removeAll();
            String placement = null;
            if (cmd != null) {
                placement = (String)cmd.getClientProperty(COMMAND_PLACEMENT_KEY);
            }
            if (checkCommands) {
                for (int iter = 0; iter < this.getCommandCount(); ++iter) {
                    Command c = this.getCommand(iter);
                    String p = (String)c.getClientProperty(COMMAND_PLACEMENT_KEY);
                    if (p == null) continue;
                    placement = p;
                    break;
                }
            }
            if (placement == null && !this.parent.getUIManager().isThemeConstant("hideLeftSideMenuBool", false)) {
                if (this.parent.getUIManager().isThemeConstant("menuButtonTopBool", false)) {
                    titleArea.addComponent("West", (Component)BorderLayout.north(this.openButton));
                } else if (this.parent.getUIManager().isThemeConstant("menuButtonBottomBool", false)) {
                    titleArea.addComponent("West", (Component)BorderLayout.south(this.openButton));
                } else {
                    titleArea.addComponent("West", (Component)this.openButton);
                }
            }
            if ((l = this.getTitleComponent()).getParent() != null) {
                l.getParent().removeComponent(l);
            }
            titleArea.addComponent("Center", l);
            this.installRightCommands();
            this.installLeftCommands();
            if (this.parent.getToolbar() != null) {
                if (this.parent.getToolbar().isTitleCentered()) {
                    ((BorderLayout)titleArea.getLayout()).setCenterBehavior(2);
                } else {
                    ((BorderLayout)titleArea.getLayout()).setCenterBehavior(0);
                }
            } else if (this.parent.getUIManager().isThemeConstant("leftAlignSideMenuBool", false)) {
                ((BorderLayout)titleArea.getLayout()).setCenterBehavior(0);
            } else {
                ((BorderLayout)titleArea.getLayout()).setCenterBehavior(2);
            }
        }
        if (cmd != null) {
            String placement = (String)cmd.getClientProperty(COMMAND_PLACEMENT_KEY);
            if (placement != null) {
                this.validateCommandPlacement(placement);
            }
        } else if (checkCommands) {
            for (int iter = 0; iter < this.getCommandCount(); ++iter) {
                Command c = this.getCommand(iter);
                String placement = (String)c.getClientProperty(COMMAND_PLACEMENT_KEY);
                if (placement == null) continue;
                this.validateCommandPlacement(placement);
            }
        }
        this.initTitleBarStatus();
    }

    private void validateCommandPlacement(String placement) {
        if (placement == COMMAND_PLACEMENT_VALUE_TOP) {
            ((BorderLayout)this.getTitleAreaContainer().getLayout()).setCenterBehavior(0);
            if (!(this.getTitleComponent() instanceof Button)) {
                Button b = new Button(this.parent.getTitle());
                b.setUIID("Title");
                this.parent.setTitleComponent(b);
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        SideMenuBar.this.openMenu(SideMenuBar.COMMAND_PLACEMENT_VALUE_TOP);
                    }
                });
            }
            return;
        }
        if (placement == COMMAND_PLACEMENT_VALUE_RIGHT) {
            if (this.rightSideButton != null && this.rightSideButton.getParent() != null) {
                return;
            }
            this.rightSideButton = new Button();
            this.rightSideButton.setUIID("MenuButtonRight");
            UIManager uim = this.parent.getUIManager();
            Image i = uim.getThemeImageConstant("rightSideMenuImage");
            if (i != null) {
                this.rightSideButton.setIcon(i);
            } else {
                FontImage.setMaterialIcon(this.rightSideButton, '\ue5d2');
            }
            Image p = uim.getThemeImageConstant("rightSideMenuPressImage");
            if (p != null) {
                this.rightSideButton.setPressedIcon(p);
            }
            this.rightSideButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SideMenuBar.this.openMenu(SideMenuBar.COMMAND_PLACEMENT_VALUE_RIGHT);
                }
            });
            Container ta = this.getTitleAreaContainer();
            ta.addComponent("East", (Component)this.rightSideButton);
            ta.revalidate();
        }
    }

    private void clean() {
        if (this.out != null) {
            this.parent.setTransitionOutAnimator(this.out);
        }
        if (this.in != null) {
            this.parent.setTransitionInAnimator(this.in);
        }
        this.out = null;
        this.in = null;
    }

    private void setMenuGlassPane(Form m, final String placement) {
        boolean isRTLValue = m.isRTL();
        if (placement == COMMAND_PLACEMENT_VALUE_RIGHT) {
            isRTLValue = !isRTLValue;
        }
        final boolean isRTL = isRTLValue;
        final Image image = this.rightPanel.getStyle().getBgImage();
        UIManager uim = this.rightPanel.getUIManager();
        Image sh = uim.getThemeImageConstant("sideMenuShadowImage");
        if (sh == null) {
            sh = Resources.getSystemResource().getImage("sidemenu-shadow.png");
        }
        if (isRTL) {
            sh = sh.flipHorizontally(true);
        }
        final Image shadow = sh;
        if (m.getGlassPane() == null) {
            m.setGlassPane(new Painter(){
                Image img;
                {
                    this.img = image;
                }

                public void paint(Graphics g, Rectangle rect) {
                    if (this.img == null) {
                        Component c = (Component)SideMenuBar.this.rightPanel.getClientProperty("$parent");
                        if (c == null) {
                            return;
                        }
                        boolean b = c.isVisible();
                        c.setVisible(true);
                        if (isRTL) {
                            int x = Math.max(SideMenuBar.this.draggedX, SideMenuBar.this.rightPanel.getWidth()) - c.getWidth();
                            g.translate(x, 0);
                            Container.sidemenuBarTranslation = x;
                            if (shadow != null) {
                                g.tileImage(shadow, x + c.getWidth() - shadow.getWidth(), 0, shadow.getWidth(), SideMenuBar.this.rightPanel.getHeight());
                            }
                            c.paintComponent(g, true);
                            Container.sidemenuBarTranslation = 0;
                            g.translate(-x, 0);
                        } else {
                            int x = Math.min(SideMenuBar.this.draggedX, SideMenuBar.this.rightPanel.getX());
                            g.translate(x, 0);
                            Container.sidemenuBarTranslation = x;
                            if (shadow != null) {
                                g.tileImage(shadow, x - shadow.getWidth(), 0, shadow.getWidth(), SideMenuBar.this.rightPanel.getHeight());
                            }
                            c.paintComponent(g, true);
                            Container.sidemenuBarTranslation = 0;
                            g.translate(-x, 0);
                        }
                        c.setVisible(b);
                    } else {
                        if (Display.getInstance().areMutableImagesFast() && this.img.getHeight() != Display.getInstance().getDisplayHeight()) {
                            this.img = SideMenuBar.this.updateRightPanelBgImage(placement, SideMenuBar.this.parent);
                        }
                        if (isRTL) {
                            int x = Math.max(SideMenuBar.this.draggedX, SideMenuBar.this.rightPanel.getWidth()) - this.img.getWidth();
                            if (shadow != null) {
                                g.tileImage(shadow, x + this.img.getWidth() - shadow.getWidth(), 0, shadow.getWidth(), SideMenuBar.this.rightPanel.getHeight());
                            }
                            g.drawImage(this.img, x, 0);
                        } else {
                            int x = Math.min(SideMenuBar.this.draggedX, SideMenuBar.this.rightPanel.getX());
                            if (shadow != null) {
                                g.tileImage(shadow, x - shadow.getWidth(), 0, shadow.getWidth(), SideMenuBar.this.rightPanel.getHeight());
                            }
                            g.drawImage(this.img, x, 0);
                        }
                    }
                }
            });
        }
    }

    protected Container createSideNavigationComponent(Vector commands) {
        return this.createSideNavigationComponent(commands, null);
    }

    protected Container createSideNavigationComponent(Vector commands, String placement) {
        return this.createSideNavigationPanel(commands, placement);
    }

    protected Container constructSideNavigationComponent() {
        return this.constructSideNavigationPanel();
    }

    Container constructSideNavigationPanel() {
        Container menu = new Container(new BoxLayout(2));
        menu.setUIID("SideNavigationPanel");
        Rectangle safeRect = new Rectangle();
        Display.getInstance().getDisplaySafeArea(safeRect);
        int paddingTop = menu.getStyle().getPaddingTop();
        if (paddingTop < safeRect.getY()) {
            menu.getStyle().setPaddingUnitTop((byte)0);
            menu.getStyle().setPaddingTop(safeRect.getY() + paddingTop);
        }
        menu.setScrollableY(true);
        menu.setScrollVisible(this.getUIManager().isThemeConstant("sideMenuScrollVisibleBool", false));
        return menu;
    }

    Container constructRightSideNavigationPanel() {
        Container menu = new Container(new BoxLayout(2));
        menu.setUIID("RightSideNavigationPanel");
        menu.setScrollableY(true);
        menu.setScrollVisible(this.getUIManager().isThemeConstant("rightSideMenuScrollVisibleBool", false));
        return menu;
    }

    Container createSideNavigationPanel(Vector commands, String placement) {
        Image shadow;
        Container menu = this.constructSideNavigationComponent();
        if (this.getUIManager().isThemeConstant("paintsTitleBarBool", false)) {
            Container bar = new Container();
            bar.setUIID("StatusBarSideMenu");
            this.addComponentToSideMenu(menu, bar);
        }
        if (!this.getUIManager().isThemeConstant("sideMenuTensileDragBool", true)) {
            menu.setTensileDragEnabled(false);
        }
        for (int iter = commands.size() - 1; iter > -1; --iter) {
            Command c = (Command)commands.elementAt(iter);
            if (c.getClientProperty(COMMAND_PLACEMENT_KEY) != placement) continue;
            Component cmp = (Component)c.getClientProperty(COMMAND_SIDE_COMPONENT);
            if (cmp != null) {
                if (cmp.getParent() != null) {
                    cmp.getParent().removeAll();
                }
                if (c.getClientProperty(COMMAND_ACTIONABLE) != null && c.getClientProperty(COMMAND_ACTIONABLE).equals(Boolean.TRUE)) {
                    Container cnt = new Container(new BorderLayout());
                    cnt.addComponent("Center", cmp);
                    Button btn = this.createTouchCommandButton(c);
                    btn.setParent(cnt);
                    cnt.setLeadComponent(btn);
                    this.addComponentToSideMenu(menu, cnt);
                } else {
                    this.addComponentToSideMenu(menu, cmp);
                }
                this.initTitleBarStatus();
                continue;
            }
            if (this.parent.getBackCommand() == c && (c.getCommandName() == null || c.getCommandName().length() == 0) && c.getIcon() == null) continue;
            this.addComponentToSideMenu(menu, this.createTouchCommandButton(c));
        }
        boolean isRTLValue = this.isRTL();
        if (placement == COMMAND_PLACEMENT_VALUE_RIGHT) {
            isRTLValue = !isRTLValue;
        }
        UIManager uim = menu.getUIManager();
        boolean shadowEnabled = uim.isThemeConstant("sideMenuShadowBool", true);
        Image sh = uim.getThemeImageConstant("sideMenuShadowImage");
        if (sh == null && shadowEnabled) {
            sh = Resources.getSystemResource().getImage("sidemenu-shadow.png");
        }
        if (isRTLValue && sh != null) {
            sh = sh.flipHorizontally(true);
        }
        if ((shadow = sh) == null) {
            return menu;
        }
        Container main = new Container(new LayeredLayout());
        Label shadowLabel = new Label();
        shadowLabel.getStyle().setBackgroundType((byte)31);
        shadowLabel.getStyle().setBgImage(shadow);
        shadowLabel.getStyle().setPadding(0, 0, 0, 0);
        shadowLabel.getStyle().setMargin(0, 0, 0, 0);
        shadowLabel.getStyle().setBgTransparency(0);
        Container c = new Container(new BorderLayout());
        if (placement == COMMAND_PLACEMENT_VALUE_RIGHT) {
            shadowLabel.setPreferredW(shadow.getWidth());
            c.addComponent("West", (Component)shadowLabel);
            shadowLabel.getStyle().setBgImage(shadow.rotate180Degrees(true));
        } else if (placement != COMMAND_PLACEMENT_VALUE_TOP) {
            shadowLabel.setPreferredW(shadow.getWidth());
            c.addComponent("East", (Component)shadowLabel);
        }
        main.addComponent(menu);
        main.addComponent(c);
        return main;
    }

    protected void addComponentToSideMenu(Container menu, Component cmp) {
        this.addComponentToSideMenuImpl(menu, cmp);
    }

    void addComponentToSideMenuImpl(Container menu, Component cmp) {
        menu.addComponent(cmp);
    }

    protected Button createTouchCommandButton(Command c) {
        CommandWrapper wrapper = new CommandWrapper(c);
        Button b = super.createTouchCommandButton(wrapper);
        if (c.getIcon() == null) {
            b.setIcon(null);
        }
        b.setText(c.getCommandName());
        b.setTextPosition(3);
        String uiid = (String)c.getClientProperty("uiid");
        String landscapeUiid = (String)c.getClientProperty("luiid");
        if (uiid != null) {
            b.setUIID(uiid, landscapeUiid);
        } else {
            b.setUIID("SideCommand", landscapeUiid);
        }
        return b;
    }

    private Form createMenu(final String placement) {
        int v;
        Form m = new Form(){
            private boolean pressedInRightPanel;
            private boolean manualMotionLock;

            protected boolean shouldSendPointerReleaseToOtherForm() {
                return true;
            }

            void actionCommandImpl(Command cmd, ActionEvent ev) {
                if (cmd instanceof CommandWrapper) {
                    cmd = ((CommandWrapper)cmd).cmd;
                    ev = new ActionEvent((Object)cmd, ActionEvent.Type.Command);
                }
                final Command c = cmd;
                final ActionEvent e = ev;
                Display.getInstance().scheduleBackgroundTask(new Runnable(){

                    public void run() {
                        Display.getInstance().invokeAndBlock(new Runnable(){

                            public void run() {
                                while (Display.getInstance().getCurrent() != SideMenuBar.this.parent) {
                                    try {
                                        Thread.sleep(40L);
                                    }
                                    catch (InterruptedException ex) {
                                        Thread.currentThread().interrupt();
                                        return;
                                    }
                                }
                            }
                        });
                        Display.getInstance().callSerially(new Runnable(){

                            public void run() {
                                SideMenuBar.this.parent.actionCommandImpl(c, e);
                            }
                        });
                    }
                });
            }

            protected void sizeChanged(int w, int h) {
                Style formStyle = this.getStyle();
                int width = w - formStyle.getHorizontalMargins();
                SideMenuBar.this.parent.sizeChangedInternal(w, h);
                if (this.getWidth() != width) {
                    SideMenuBar.this.closeMenu();
                }
                super.sizeChanged(w, h);
            }

            public void pointerPressed(int x, int y) {
                if (this.manualMotionLock) {
                    return;
                }
                super.pointerPressed(x, y);
                if (SideMenuBar.this.rightPanel.contains(x, y)) {
                    this.pressedInRightPanel = true;
                }
            }

            public void pointerDragged(int[] x, int[] y) {
                if (this.manualMotionLock) {
                    return;
                }
                if (!SideMenuBar.this.transitionRunning && this.pressedInRightPanel) {
                    SideMenuBar.this.dragActivated = true;
                    this.pressedInRightPanel = false;
                }
                if (SideMenuBar.this.dragActivated) {
                    SideMenuBar.this.setMenuGlassPane(SideMenuBar.this.menu, placement);
                    SideMenuBar.this.draggedX = x[0];
                    this.repaint();
                    return;
                }
                super.pointerDragged(x, y);
            }

            public void pointerReleased(int x, int y) {
                if (this.manualMotionLock) {
                    return;
                }
                super.pointerReleased(x, y);
                boolean isRTLValue = this.isRTL();
                if (placement == SideMenuBar.COMMAND_PLACEMENT_VALUE_RIGHT) {
                    isRTLValue = !isRTLValue;
                }
                int displayWidth = Display.getInstance().getDisplayWidth();
                if (isRTLValue) {
                    if (!SideMenuBar.this.transitionRunning && SideMenuBar.this.dragActivated && x < (displayWidth - SideMenuBar.this.rightPanel.getWidth()) / 2) {
                        final Motion motion = Motion.createEaseInOutMotion(SideMenuBar.this.draggedX, SideMenuBar.this.rightPanel.getWidth(), 200);
                        motion.start();
                        this.registerAnimated(new Animation(){

                            public boolean animate() {
                                SideMenuBar.this.draggedX = motion.getValue();
                                if (motion.isFinished()) {
                                    SideMenuBar.this.dragActivated = false;
                                    Display.getInstance().getCurrent().setGlassPane(null);
                                    this.deregisterAnimated(this);
                                }
                                return true;
                            }

                            public void paint(Graphics g) {
                                this.repaint();
                            }
                        });
                        return;
                    }
                } else if (!SideMenuBar.this.transitionRunning && SideMenuBar.this.dragActivated && x > (displayWidth - SideMenuBar.this.rightPanel.getWidth()) / 2) {
                    final Motion motion = Motion.createEaseInOutMotion(SideMenuBar.this.draggedX, Display.getInstance().getDisplayWidth() - SideMenuBar.this.rightPanel.getWidth(), 200);
                    motion.start();
                    this.registerAnimated(new Animation(){

                        public boolean animate() {
                            SideMenuBar.this.draggedX = motion.getValue();
                            if (motion.isFinished()) {
                                SideMenuBar.this.dragActivated = false;
                                Display.getInstance().getCurrent().setGlassPane(null);
                                this.deregisterAnimated(this);
                            }
                            return true;
                        }

                        public void paint(Graphics g) {
                            this.repaint();
                        }
                    });
                    return;
                }
                if (SideMenuBar.this.dragActivated || SideMenuBar.this.rightPanel.contains(x, y)) {
                    SideMenuBar.this.setMenuGlassPane(SideMenuBar.this.menu, placement);
                    SideMenuBar.this.draggedX = x;
                    int start = x;
                    int end = 0;
                    if (isRTLValue) {
                        end = this.getWidth();
                    }
                    final Motion motion = Motion.createEaseInOutMotion(start, end, this.getUIManager().getThemeConstant("sideMenuAnimSpeedInt", 300));
                    motion.start();
                    this.manualMotionLock = true;
                    SideMenuBar.this.sideSwipePotential = false;
                    SideMenuBar.this.rightSideSwipePotential = false;
                    SideMenuBar.this.topSwipePotential = false;
                    this.registerAnimated(new Animation(){

                        public boolean animate() {
                            SideMenuBar.this.draggedX = motion.getValue();
                            if (motion.isFinished()) {
                                SideMenuBar.this.dragActivated = false;
                            }
                            return true;
                        }

                        public void paint(Graphics g) {
                            this.repaint();
                            if (SideMenuBar.this.draggedX == motion.getDestinationValue() && motion.isFinished()) {
                                SideMenuBar.this.parent.setTransitionInAnimator(CommonTransitions.createEmpty());
                                SideMenuBar.this.parent.show();
                                this.deregisterAnimated(this);
                                Display.getInstance().callSerially(new Runnable(){

                                    public void run() {
                                        SideMenuBar.this.clean();
                                    }
                                });
                            }
                        }
                    });
                }
            }

            public void keyReleased(int keyCode) {
                if (keyCode == MenuBar.leftSK) {
                    if (SideMenuBar.this.transitionRunning) {
                        return;
                    }
                    SideMenuBar.this.closeMenu();
                    return;
                }
                super.keyReleased(keyCode);
            }
        };
        m.setScrollable(false);
        m.removeComponentFromForm(m.getTitleArea());
        m.putClientProperty("Menu", "true");
        m.setTransitionInAnimator(CommonTransitions.createEmpty());
        m.setTransitionOutAnimator(CommonTransitions.createEmpty());
        m.setBackCommand(new Command(""){

            public void actionPerformed(ActionEvent evt) {
                if (SideMenuBar.this.transitionRunning) {
                    return;
                }
                SideMenuBar.this.closeMenu();
            }
        });
        m.setLayout(new BorderLayout());
        this.rightPanel = Display.getInstance().areMutableImagesFast() ? new Container(new BorderLayout()) : new Container(new BorderLayout()){

            public void paintBackground(Graphics g) {
            }

            public void paintBackgrounds(Graphics g) {
            }

            public void paint(Graphics g) {
                Component c = (Component)SideMenuBar.this.rightPanel.getClientProperty("$parent");
                if (c != null) {
                    boolean b = c.isVisible();
                    c.setVisible(true);
                    int x = this.getAbsoluteX();
                    g.translate(x, 0);
                    Container.sidemenuBarTranslation = x;
                    c.paintComponent(g, true);
                    Container.sidemenuBarTranslation = 0;
                    g.translate(-x, 0);
                    c.setVisible(b);
                }
            }
        };
        if (placement == COMMAND_PLACEMENT_VALUE_TOP) {
            v = 0;
            v = Display.getInstance().isPortrait() ? (Display.getInstance().isTablet() ? ((v = this.getUIManager().getThemeConstant("topMenuSizeTabPortraitInt", -1)) < 0 ? m.getHeight() * 2 / 3 : m.getHeight() / 100 * v) : ((v = this.getUIManager().getThemeConstant("topMenuSizePortraitInt", -1)) < 0 ? this.openButton.getHeight() : m.getHeight() / 100 * v)) : (Display.getInstance().isTablet() ? ((v = this.getUIManager().getThemeConstant("topMenuSizeTabLandscapeInt", -1)) < 0 ? m.getHeight() * 3 / 4 : m.getWidth() / 100 * v) : ((v = this.getUIManager().getThemeConstant("topMenuSizeLandscapeInt", -1)) < 0 ? m.getHeight() * 4 / 10 : m.getHeight() / 100 * v));
            this.rightPanel.setPreferredH(v);
        } else if (Display.getInstance().isPortrait()) {
            v = 0;
            v = Display.getInstance().isTablet() ? ((v = this.getUIManager().getThemeConstant("sideMenuSizeTabPortraitInt", -1)) < 0 ? m.getWidth() * 2 / 3 : m.getWidth() / 100 * v) : ((v = this.getUIManager().getThemeConstant("sideMenuSizePortraitInt", -1)) < 0 ? (placement == COMMAND_PLACEMENT_VALUE_RIGHT ? (this.isRTL() ? this.openButton.getWidth() : this.rightSideButton.getWidth()) : this.openButton.getWidth()) : m.getWidth() / 100 * v);
            this.rightPanel.setPreferredW(v);
        } else {
            v = 0;
            v = Display.getInstance().isTablet() ? ((v = this.getUIManager().getThemeConstant("sideMenuSizeTabLandscapeInt", -1)) < 0 ? m.getWidth() * 3 / 4 : m.getWidth() / 100 * v) : ((v = this.getUIManager().getThemeConstant("sideMenuSizeLandscapeInt", -1)) < 0 ? m.getWidth() * 4 / 10 : m.getWidth() / 100 * v);
            this.rightPanel.setPreferredW(v);
        }
        if (this.sidePanel != null) {
            this.sidePanel.removeAll();
            this.sidePanel = null;
        }
        this.sidePanel = this.createSideNavigationComponent(this.getCommands(), placement);
        if (placement == COMMAND_PLACEMENT_VALUE_RIGHT) {
            m.addComponent("West", (Component)this.rightPanel);
            m.addComponent("Center", (Component)this.sidePanel);
        } else if (placement == COMMAND_PLACEMENT_VALUE_TOP) {
            m.addComponent("North", (Component)this.rightPanel);
            m.addComponent("Center", (Component)this.sidePanel);
            Button button = new Button(" ");
            button.setUIID("Container");
            button.setPreferredH(Display.getInstance().getDisplayHeight() / 10);
            m.addComponent("South", (Component)button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SideMenuBar.this.closeMenu();
                }
            });
        } else {
            m.addComponent("East", (Component)this.rightPanel);
            m.addComponent("Center", (Component)this.sidePanel);
        }
        m.putClientProperty("cn1$sideMenuParent", this);
        return m;
    }

    Image updateRightPanelBgImage(String placement, Component c) {
        Image img = this.rightPanel.getStyle().getBgImage();
        if (img != null && img.getHeight() == Display.getInstance().getDisplayHeight()) {
            return img;
        }
        boolean v = c.isVisible();
        c.setVisible(true);
        Image buffer = ImageFactory.createImage(this, Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight(), 0);
        Graphics g = buffer.getGraphics();
        c.paintComponent(g);
        this.rightPanel.getStyle().setBgImage(buffer);
        c.setVisible(v);
        return buffer;
    }

    Command unwrapCommand(Command cmd) {
        if (cmd instanceof CommandWrapper) {
            return ((CommandWrapper)cmd).cmd;
        }
        return cmd;
    }

    Command wrapCommand(Command cmd) {
        return new CommandWrapper(cmd);
    }

    public Form getParentForm() {
        return this.parent;
    }

    class CommandWrapper
    extends Command {
        Command cmd;

        public CommandWrapper(Command cmd) {
            super(cmd.getCommandName(), cmd.getIcon(), cmd.getId());
            super.setIconFont(cmd.getIconFont());
            super.setMaterialIcon(cmd.getMaterialIcon());
            super.setPressedIcon(cmd.getPressedIcon());
            super.setRolloverIcon(cmd.getRolloverIcon());
            super.setDisabledIcon(cmd.getDisabledIcon());
            super.setIconGapMM(cmd.getIconGapMM());
            this.cmd = cmd;
        }

        public Object getClientProperty(String key) {
            return this.cmd.getClientProperty(key);
        }

        public void putClientProperty(String key, Object value) {
            this.cmd.putClientProperty(key, value);
        }

        public boolean isEnabled() {
            return this.cmd.isEnabled();
        }

        public void setEnabled(boolean b) {
            this.cmd.setEnabled(b);
        }

        public char getMaterialIcon() {
            return this.cmd.getMaterialIcon();
        }

        public void setMaterialIcon(char materialIcon) {
            this.cmd.setMaterialIcon(materialIcon);
        }

        public void actionPerformed(ActionEvent evt) {
            if (Toolbar.isOnTopSideMenu() && (Toolbar.isGlobalToolbar() || Display.getInstance().getCommandBehavior() != 8)) {
                Display.getInstance().getCurrent().getToolbar().closeSideMenu();
                this.cmd.actionPerformed(evt);
                return;
            }
            if (SideMenuBar.this.transitionRunning) {
                return;
            }
            if (this.cmd instanceof NavigationCommand) {
                SideMenuBar.this.rightPanel.getStyle().setBgImage(null);
                SideMenuBar.this.parent.getContentPane().setVisible(false);
                Image img = SideMenuBar.this.updateRightPanelBgImage(null, SideMenuBar.this.parent);
                SideMenuBar.this.rightPanel.getStyle().setBgImage(img);
            }
            SideMenuBar.this.closeMenu();
            SideMenuBar.this.clean();
            SideMenuBar.this.parent.addShowListener(SideMenuBar.this.pointerDragged);
            Display.getInstance().startThread(new ShowWaiter(), "Show Waiter").start();
        }

        class ShowWaiter
        implements Runnable,
        ActionListener {
            private final Object LOCK = new Object();

            ShowWaiter() {
                SideMenuBar.this.parent.addShowListener(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (Display.getInstance().isEdt()) {
                    ActionEvent e = new ActionEvent((Object)CommandWrapper.this.cmd, ActionEvent.Type.Command);
                    if (CommandWrapper.this.cmd instanceof NavigationCommand) {
                        SideMenuBar.this.parent.getContentPane().setVisible(true);
                        final Form nextForm = ((NavigationCommand)CommandWrapper.this.cmd).getNextForm();
                        if (nextForm != null) {
                            final Transition out = SideMenuBar.this.parent.getTransitionOutAnimator();
                            final Transition in = nextForm.getTransitionInAnimator();
                            SideMenuBar.this.parent.setTransitionOutAnimator(CommonTransitions.createEmpty());
                            nextForm.setTransitionInAnimator(CommonTransitions.createEmpty());
                            nextForm.addShowListener(new ActionListener(){

                                public void actionPerformed(ActionEvent evt) {
                                    SideMenuBar.this.parent.setTransitionOutAnimator(out);
                                    nextForm.setTransitionInAnimator(in);
                                    nextForm.removeShowListener(this);
                                }
                            });
                        }
                    }
                    SideMenuBar.this.parent.dispatchCommand(CommandWrapper.this.cmd, e);
                    return;
                }
                Object object = this.LOCK;
                synchronized (object) {
                    while (Display.getInstance().getCurrent() != SideMenuBar.this.parent) {
                        try {
                            this.LOCK.wait(40L);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
                Display.getInstance().callSerially(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt) {
                Object object = this.LOCK;
                synchronized (object) {
                    this.LOCK.notify();
                }
            }
        }
    }

    class MenuTransition
    extends Transition {
        private final int speed;
        private final boolean fwd;
        private Motion motion;
        private int position;
        private Image buffer;
        private final int dest;
        private Image shadow;
        private final String placement;
        private boolean isRTL;

        public MenuTransition(int speed, boolean fwd, int dest, String placement) {
            this.speed = speed;
            this.fwd = fwd;
            this.dest = dest;
            this.placement = placement;
        }

        public void initTransition() {
            super.initTransition();
            if (this.placement == SideMenuBar.COMMAND_PLACEMENT_VALUE_TOP) {
                if (Display.getInstance().areMutableImagesFast()) {
                    if (this.fwd) {
                        this.buffer = SideMenuBar.this.updateRightPanelBgImage(this.placement, this.getSource());
                        this.motion = this.dest > -1 ? Motion.createEaseInOutMotion(0, this.dest, this.speed) : Motion.createEaseInOutMotion(0, this.buffer.getHeight() - SideMenuBar.this.rightPanel.getHeight(), this.speed);
                    } else {
                        this.buffer = SideMenuBar.this.updateRightPanelBgImage(this.placement, this.getDestination());
                        this.motion = this.dest > -1 ? Motion.createEaseInOutMotion(this.dest, 0, this.speed) : Motion.createEaseInOutMotion(this.buffer.getHeight() - SideMenuBar.this.rightPanel.getHeight(), 0, this.speed);
                    }
                    SideMenuBar.this.rightPanel.getStyle().setBackgroundType((byte)20);
                } else if (this.fwd) {
                    this.motion = Motion.createEaseInOutMotion(0, Display.getInstance().getDisplayHeight() - SideMenuBar.this.rightPanel.getHeight(), this.speed);
                    SideMenuBar.this.rightPanel.putClientProperty("$parent", this.getSource());
                } else {
                    this.motion = Motion.createEaseInOutMotion(Display.getInstance().getDisplayHeight() - SideMenuBar.this.rightPanel.getHeight(), 0, this.speed);
                    SideMenuBar.this.rightPanel.putClientProperty("$parent", this.getDestination());
                }
            } else {
                this.isRTL = this.getSource().getUIManager().getLookAndFeel().isRTL();
                if (this.placement == SideMenuBar.COMMAND_PLACEMENT_VALUE_RIGHT) {
                    boolean bl = this.isRTL = !this.isRTL;
                }
                if (Display.getInstance().areMutableImagesFast()) {
                    if (this.fwd) {
                        this.buffer = SideMenuBar.this.updateRightPanelBgImage(this.placement, this.getSource());
                        this.motion = this.dest > -1 ? Motion.createEaseInOutMotion(0, this.dest, this.speed) : Motion.createEaseInOutMotion(0, this.buffer.getWidth() - SideMenuBar.this.rightPanel.getWidth(), this.speed);
                    } else {
                        this.buffer = SideMenuBar.this.updateRightPanelBgImage(this.placement, this.getDestination());
                        this.motion = this.dest > -1 ? Motion.createEaseInOutMotion(this.dest, 0, this.speed) : Motion.createEaseInOutMotion(this.buffer.getWidth() - SideMenuBar.this.rightPanel.getWidth(), 0, this.speed);
                    }
                    if (this.isRTL) {
                        SideMenuBar.this.rightPanel.getStyle().setBackgroundType((byte)26);
                    } else {
                        SideMenuBar.this.rightPanel.getStyle().setBackgroundType((byte)25);
                    }
                    SideMenuBar.this.rightPanel.getStyle().setBgImage(this.buffer);
                } else if (this.fwd) {
                    this.motion = Motion.createEaseInOutMotion(0, Display.getInstance().getDisplayWidth() - SideMenuBar.this.rightPanel.getWidth(), this.speed);
                    SideMenuBar.this.rightPanel.putClientProperty("$parent", this.getSource());
                } else {
                    this.motion = Motion.createEaseInOutMotion(Display.getInstance().getDisplayWidth() - SideMenuBar.this.rightPanel.getWidth(), 0, this.speed);
                    SideMenuBar.this.rightPanel.putClientProperty("$parent", this.getDestination());
                }
            }
            boolean shadowEnabled = SideMenuBar.this.getUIManager().isThemeConstant("sideMenuShadowBool", true);
            this.shadow = SideMenuBar.this.getUIManager().getThemeImageConstant("sideMenuShadowImage");
            if (this.shadow == null && shadowEnabled) {
                this.shadow = Resources.getSystemResource().getImage("sidemenu-shadow.png");
            }
            boolean isRTLValue = SideMenuBar.this.isRTL();
            if (this.placement == SideMenuBar.COMMAND_PLACEMENT_VALUE_RIGHT) {
                boolean bl = isRTLValue = !isRTLValue;
            }
            if (isRTLValue && this.shadow != null) {
                this.shadow = this.shadow.flipHorizontally(true);
            }
            this.motion.start();
        }

        public boolean animate() {
            if (this.motion != null) {
                this.position = this.motion.getValue();
                SideMenuBar.this.transitionRunning = !this.motion.isFinished();
                return SideMenuBar.this.transitionRunning;
            }
            SideMenuBar.this.transitionRunning = false;
            return false;
        }

        public void cleanup() {
            SideMenuBar.this.transitionRunning = false;
            SideMenuBar.this.clean();
        }

        public void paint(Graphics g) {
            if (Display.getInstance().areMutableImagesFast() && this.buffer.getHeight() != Display.getInstance().getDisplayHeight()) {
                this.buffer = this.fwd ? SideMenuBar.this.updateRightPanelBgImage(this.placement, this.getSource()) : SideMenuBar.this.updateRightPanelBgImage(this.placement, this.getDestination());
            }
            Component src = this.getSource();
            Component dest = this.getDestination();
            if (this.placement == SideMenuBar.COMMAND_PLACEMENT_VALUE_TOP) {
                if (Display.getInstance().areMutableImagesFast()) {
                    if (this.fwd) {
                        dest.paintComponent(g, true);
                        g.drawImage(this.buffer, 0, this.position);
                    } else {
                        src.paintComponent(g, true);
                        g.drawImage(this.buffer, 0, this.position);
                    }
                } else if (this.fwd) {
                    dest.paintComponent(g, true);
                    g.translate(0, this.position);
                    src.paintComponent(g, true);
                    g.translate(0, -this.position);
                } else {
                    src.paintComponent(g, true);
                    g.translate(0, this.position);
                    dest.paintComponent(g, true);
                    g.translate(-this.position, 0);
                }
                return;
            }
            if (this.isRTL) {
                this.position *= -1;
            }
            if (Display.getInstance().areMutableImagesFast()) {
                if (this.fwd) {
                    dest.paintComponent(g, true);
                    if (this.shadow != null) {
                        g.tileImage(this.shadow, this.position - this.shadow.getWidth(), 0, this.shadow.getWidth(), src.getHeight());
                    }
                    g.drawImage(this.buffer, this.position, 0);
                } else {
                    src.paintComponent(g, true);
                    if (this.shadow != null) {
                        g.tileImage(this.shadow, this.position - this.shadow.getWidth(), 0, this.shadow.getWidth(), src.getHeight());
                    }
                    g.drawImage(this.buffer, this.position, 0);
                }
            } else if (this.fwd) {
                dest.paintComponent(g, true);
                g.translate(this.position, 0);
                Container.sidemenuBarTranslation = this.position;
                if (this.shadow != null) {
                    g.tileImage(this.shadow, this.position - this.shadow.getWidth(), 0, this.shadow.getWidth(), src.getHeight());
                }
                src.paintComponent(g, true);
                Container.sidemenuBarTranslation = 0;
                g.translate(-this.position, 0);
            } else {
                src.paintComponent(g, true);
                g.translate(this.position, 0);
                Container.sidemenuBarTranslation = this.position;
                if (this.shadow != null) {
                    g.tileImage(this.shadow, this.position - this.shadow.getWidth(), 0, this.shadow.getWidth(), src.getHeight());
                }
                dest.paintComponent(g, true);
                Container.sidemenuBarTranslation = 0;
                g.translate(-this.position, 0);
            }
        }
    }
}

