/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.util.EventDispatcher;

public class SwipeableContainer
extends Container {
    private final EventDispatcher dispatcher = new EventDispatcher();
    private final Container bottomLeftWrapper;
    private final Container bottomRightWrapper;
    private final Container topWrapper;
    private boolean open = false;
    private boolean openedToRight = false;
    private boolean openedToLeft = false;
    private Motion openCloseMotion;
    private boolean swipeActivated = true;
    private final SwipeListener press;
    private final SwipeListener drag;
    private final SwipeListener release;
    private int initialX = -1;
    private int initialY = -1;
    private int topX = -1;
    private boolean waitForRelease;
    private SwipeableContainer previouslyOpened;

    public SwipeableContainer(Component bottomLeft, Component top) {
        this(bottomLeft, null, top);
    }

    public SwipeableContainer(Component bottomLeft, Component bottomRight, Component top) {
        this.setLayout(new LayeredLayout());
        this.bottomLeftWrapper = new Container(new BorderLayout());
        if (bottomLeft != null) {
            this.bottomLeftWrapper.addComponent("West", bottomLeft);
            this.bottomLeftWrapper.setVisible(false);
        }
        this.bottomRightWrapper = new Container(new BorderLayout());
        if (bottomRight != null) {
            this.bottomRightWrapper.addComponent("East", bottomRight);
            this.bottomRightWrapper.setVisible(false);
        }
        this.topWrapper = new Container(new BorderLayout());
        this.topWrapper.addComponent("Center", top);
        this.addComponent(this.bottomRightWrapper);
        this.addComponent(this.bottomLeftWrapper);
        this.addComponent(this.topWrapper);
        this.press = new SwipeListener(0);
        this.drag = new SwipeListener(1);
        this.release = new SwipeListener(2);
    }

    protected void deinitialize() {
        this.waitForRelease = false;
        Form form = this.getComponentForm();
        if (form != null) {
            form.removePointerPressedListener(this.press);
            form.removePointerReleasedListener(this.release);
            form.removePointerDraggedListener(this.drag);
        }
        super.deinitialize();
    }

    protected void initComponent() {
        super.initComponent();
        Form form = this.getComponentForm();
        if (form != null && this.swipeActivated) {
            form.addPointerPressedListener(this.press);
            form.addPointerReleasedListener(this.release);
            form.addPointerDraggedListener(this.drag);
        }
    }

    public void openToRight() {
        if (this.open || this.openedToRight) {
            return;
        }
        if (this.bottomLeftWrapper.getComponentCount() == 0) {
            return;
        }
        Component bottom = this.bottomLeftWrapper.getComponentAt(0);
        if (this.bottomRightWrapper.getComponentCount() > 0) {
            this.bottomRightWrapper.setVisible(false);
        }
        this.bottomLeftWrapper.setVisible(true);
        int topX = this.topWrapper.getX();
        this.openCloseMotion = Motion.createSplineMotion(topX, bottom.getWidth(), 300);
        this.getComponentForm().registerAnimated(this);
        this.openCloseMotion.start();
        this.openedToRight = true;
        this.open = true;
    }

    public void openToLeft() {
        if (this.open || this.openedToLeft) {
            return;
        }
        if (this.bottomRightWrapper.getComponentCount() == 0) {
            return;
        }
        Component bottom = this.bottomRightWrapper.getComponentAt(0);
        if (this.bottomLeftWrapper.getComponentCount() > 0) {
            this.bottomLeftWrapper.setVisible(false);
        }
        this.bottomRightWrapper.setVisible(true);
        int topX = this.topWrapper.getX();
        this.openCloseMotion = Motion.createSplineMotion(-topX, bottom.getWidth(), 300);
        this.getComponentForm().registerAnimated(this);
        this.openCloseMotion.start();
        this.openedToLeft = true;
        this.open = true;
    }

    public void close() {
        if (!this.open) {
            return;
        }
        Form f = this.getComponentForm();
        if (f != null) {
            if (this.openedToRight) {
                int topX = this.topWrapper.getX();
                this.openCloseMotion = Motion.createSplineMotion(topX, 0, 300);
            } else {
                int topX = this.topWrapper.getX();
                this.openCloseMotion = Motion.createSplineMotion(-topX, 0, 300);
            }
            f.registerAnimated(this);
            this.openCloseMotion.start();
        }
        this.open = false;
    }

    public Component getComponentAt(int x, int y) {
        if (!this.open) {
            return this.topWrapper.getComponentAt(x, y);
        }
        return super.getComponentAt(x, y);
    }

    public boolean animate() {
        if (this.openCloseMotion != null) {
            int val = this.openCloseMotion.getValue();
            if (this.openedToRight) {
                this.topWrapper.setX(val);
            } else {
                this.topWrapper.setX(-val);
            }
            this.repaint();
            boolean finished = this.openCloseMotion.isFinished();
            if (finished) {
                this.openCloseMotion = null;
                if (!this.open) {
                    this.bottomRightWrapper.setVisible(false);
                    this.bottomLeftWrapper.setVisible(false);
                    this.openedToLeft = false;
                    this.openedToRight = false;
                } else {
                    this.dispatcher.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.Swipe));
                }
            }
            return !finished;
        }
        return false;
    }

    public boolean isSwipeActivated() {
        return this.swipeActivated;
    }

    public void setSwipeActivated(boolean swipeActivated) {
        this.swipeActivated = swipeActivated;
    }

    public boolean isOpen() {
        return this.open && (this.openedToRight || this.openedToLeft);
    }

    public boolean isOpenedToRight() {
        return this.openedToRight;
    }

    public boolean isOpenedToLeft() {
        return this.openedToLeft;
    }

    void doLayout() {
        int x = this.topWrapper.getX();
        super.doLayout();
        this.topWrapper.setX(x);
    }

    public void addSwipeOpenListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public void removeSwipeOpenListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    public SwipeableContainer getPreviouslyOpened() {
        return this.previouslyOpened;
    }

    public void setPreviouslyOpened(SwipeableContainer previouslyOpened) {
        this.previouslyOpened = previouslyOpened;
    }

    class SwipeListener
    implements ActionListener {
        private static final int PRESS = 0;
        private static final int DRAG = 1;
        private static final int RELEASE = 2;
        private final int type;

        public SwipeListener(int type) {
            this.type = type;
        }

        private void dragInitiatedRecursive(Container cnt) {
            for (Component c : cnt) {
                if (c instanceof Container) {
                    this.dragInitiatedRecursive((Container)c);
                }
                c.dragInitiated();
            }
        }

        public void actionPerformed(ActionEvent evt) {
            if (SwipeableContainer.this.getComponentCount() == 0 || !SwipeableContainer.this.swipeActivated || SwipeableContainer.this.animate()) {
                return;
            }
            int x = evt.getX();
            int y = evt.getY();
            Form f = SwipeableContainer.this.getComponentForm();
            if (f == null) {
                return;
            }
            Component cmp = f.getComponentAt(x, y);
            if (!SwipeableContainer.this.waitForRelease && !SwipeableContainer.this.contains(cmp)) {
                return;
            }
            if (!SwipeableContainer.this.waitForRelease && !SwipeableContainer.this.topWrapper.contains(x, y)) {
                return;
            }
            int bottomLeftW = 0;
            if (SwipeableContainer.this.bottomLeftWrapper.getComponentCount() > 0) {
                Component bottomL = SwipeableContainer.this.bottomLeftWrapper.getComponentAt(0);
                bottomLeftW = bottomL.getWidth();
            }
            int bottomRightW = 0;
            if (SwipeableContainer.this.bottomRightWrapper.getComponentCount() > 0) {
                Component bottomR = SwipeableContainer.this.bottomRightWrapper.getComponentAt(0);
                bottomRightW = bottomR.getWidth();
            }
            switch (this.type) {
                case 0: {
                    if (!SwipeableContainer.this.topWrapper.contains(x, y)) {
                        return;
                    }
                    SwipeableContainer.this.topX = SwipeableContainer.this.topWrapper.getX();
                    SwipeableContainer.this.initialX = x;
                    SwipeableContainer.this.initialY = y;
                    SwipeableContainer.this.waitForRelease = true;
                    break;
                }
                case 1: {
                    if (!SwipeableContainer.this.waitForRelease) {
                        return;
                    }
                    if (Math.abs(y - SwipeableContainer.this.initialY) > Math.abs(x - SwipeableContainer.this.initialX)) {
                        return;
                    }
                    if (!SwipeableContainer.this.topWrapper.contains(x, y)) {
                        return;
                    }
                    Component top = SwipeableContainer.this.topWrapper.getComponentAt(0);
                    top.dragInitiated();
                    if (top instanceof Container && top.getLeadComponent() == null) {
                        this.dragInitiatedRecursive((Container)top);
                    }
                    if (SwipeableContainer.this.initialX == -1) break;
                    if (SwipeableContainer.this.getPreviouslyOpened() != null && SwipeableContainer.this.getPreviouslyOpened() != SwipeableContainer.this && SwipeableContainer.this.getPreviouslyOpened().isOpen()) {
                        SwipeableContainer.this.getPreviouslyOpened().close();
                    }
                    int diff = x - SwipeableContainer.this.initialX;
                    int val = 0;
                    if (!SwipeableContainer.this.isOpen()) {
                        val = Math.min(diff, bottomLeftW);
                        val = Math.max(val, -bottomRightW);
                    }
                    if (SwipeableContainer.this.openedToRight) {
                        val = Math.min(diff, 0);
                        val = Math.max(val, -bottomLeftW + 1);
                    } else if (SwipeableContainer.this.openedToLeft) {
                        val = Math.max(diff, 0);
                        val = Math.min(val, bottomRightW - 1);
                    }
                    SwipeableContainer.this.topWrapper.setX(SwipeableContainer.this.topX + val);
                    if (SwipeableContainer.this.topWrapper.getX() > 0) {
                        SwipeableContainer.this.bottomRightWrapper.setVisible(false);
                        SwipeableContainer.this.bottomLeftWrapper.setVisible(true);
                    } else {
                        SwipeableContainer.this.bottomRightWrapper.setVisible(true);
                        SwipeableContainer.this.bottomLeftWrapper.setVisible(false);
                    }
                    SwipeableContainer.this.repaint();
                    break;
                }
                case 2: {
                    if (!SwipeableContainer.this.waitForRelease) break;
                    SwipeableContainer.this.initialX = -1;
                    int topX = SwipeableContainer.this.topWrapper.getX();
                    if (topX > 0) {
                        if (Display.getInstance().getDragSpeed(false) < 0.0f) {
                            SwipeableContainer.this.open = false;
                            SwipeableContainer.this.openedToRight = false;
                            SwipeableContainer.this.openToRight();
                        } else {
                            SwipeableContainer.this.open = true;
                            SwipeableContainer.this.close();
                        }
                    } else if (topX < 0) {
                        if (Display.getInstance().getDragSpeed(false) > 0.0f) {
                            SwipeableContainer.this.open = false;
                            SwipeableContainer.this.openedToLeft = false;
                            SwipeableContainer.this.openToLeft();
                        } else {
                            SwipeableContainer.this.open = true;
                            SwipeableContainer.this.close();
                        }
                    }
                    SwipeableContainer.this.waitForRelease = false;
                }
            }
        }
    }
}

