/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.cloud.BindTarget;
import com.codename1.compat.java.util.Objects;
import com.codename1.io.Log;
import com.codename1.ui.Component;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.TextHolder;
import com.codename1.ui.TextSelection;
import com.codename1.ui.VirtualInputDevice;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.plaf.LookAndFeel;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;
import com.codename1.ui.util.UITimer;
import java.util.ArrayList;

public class TextArea
extends Component
implements ActionSource,
TextHolder {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    public static final int USERNAME = 0x400000;
    public static final int UPPERCASE = 0x800000;
    private static final char ENTER_KEY = '\n';
    private static int defaultValign = 0;
    private static int defaultMaxSize = 124;
    private static boolean autoDegradeMaxSize = false;
    private static final boolean hadSuccessfulEdit = false;
    private static boolean useStringWidth;
    private static char widestChar;
    private final EventDispatcher listeners = new EventDispatcher();
    private ActionListener doneListener;
    private int valign = defaultValign;
    private int linesToScroll = 1;
    private String unsupportedChars = "\t\r";
    private int constraint = 0x200000;
    private String text = "";
    private boolean editable = true;
    private int maxSize = defaultMaxSize;
    private int rows = 1;
    private int columns = 3;
    private int growLimit = -1;
    private boolean endsWith3Points = false;
    private boolean actAsLabel;
    private ArrayList rowStrings;
    private int widthForRowCalculations = -1;
    private int rowsGap = 2;
    private boolean triggerClose;
    private EventDispatcher actionListeners = null;
    private EventDispatcher bindListeners = null;
    private EventDispatcher closeListeners = null;
    private String lastTextValue = "";
    private boolean growByContent = true;
    private boolean singleLineTextArea;
    private int currentRowWidth;
    private Label hintLabel;
    private boolean suppressActionEvent;
    private final ActionListener formPressListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            Form f = TextArea.this.getComponentForm();
            if (f != null && TextArea.this.isEditing() && f.getComponentAt(evt.getX(), evt.getY()) != TextArea.this) {
                TextArea.this.fireActionEvent();
                TextArea.this.setSuppressActionEvent(true);
            }
        }
    };
    private boolean textSelectionEnabled;
    private TextSelection.Spans span;
    private TextSelection.TextSelectionSupport textSelectionSupport;

    public TextArea(int rows, int columns) {
        this("", defaultMaxSize, rows, columns, 0);
    }

    public TextArea(int rows, int columns, int constraint) {
        this("", defaultMaxSize, rows, columns, constraint);
    }

    public TextArea(String text, int rows, int columns) {
        this(text, defaultMaxSize, rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns, int constraint) {
        this(text, defaultMaxSize, rows, columns, constraint);
    }

    public TextArea(String text, int maxSize) {
        this(text, maxSize, 1, 3, 0);
    }

    public TextArea(String text) {
        this(text, Math.max(defaultMaxSize, TextArea.nl(text)), 1, TextArea.numCols(text), 0);
    }

    public TextArea() {
        this("");
    }

    private TextArea(String text, int maxSize, int rows, int columns, int constraint) {
        this.setUIID("TextArea");
        this.setPreferredTabIndex(0);
        this.maxSize = maxSize;
        this.setText(text);
        this.setConstraint(constraint);
        if (rows <= 0) {
            throw new IllegalArgumentException("rows must be positive");
        }
        if (columns <= 1 && rows != 1) {
            throw new IllegalArgumentException("columns must be larger than 1");
        }
        this.rows = rows;
        this.columns = columns;
        this.setCursor(2);
    }

    public static int getDefaultValign() {
        return defaultValign;
    }

    public static void setDefaultValign(int aDefaultValign) {
        defaultValign = aDefaultValign;
    }

    private static int numCols(String t) {
        if (t == null) {
            return 3;
        }
        int s = t.length();
        if (s < 3) {
            return 3;
        }
        if (s > 80) {
            return 80;
        }
        return s;
    }

    private static int nl(String t) {
        if (t == null) {
            return 0;
        }
        return t.length();
    }

    public static void setDefaultMaxSize(int value) {
        defaultMaxSize = value;
    }

    public static boolean isAutoDegradeMaxSize() {
        return autoDegradeMaxSize;
    }

    public static void setAutoDegradeMaxSize(boolean value) {
        autoDegradeMaxSize = value;
    }

    public static char getWidestChar() {
        return widestChar;
    }

    public static void setWidestChar(char widestC) {
        widestChar = widestC;
    }

    public static void autoDetectWidestChar(String s) {
        Font f = UIManager.getInstance().getComponentStyle("TextArea").getFont();
        int widest = 0;
        int slen = s.length();
        for (int iter = 0; iter < slen; ++iter) {
            char c = s.charAt(iter);
            int w = f.charWidth(c);
            if (w <= widest) continue;
            widest = w;
            TextArea.setWidestChar(c);
        }
    }

    public static boolean isUseStringWidth() {
        return useStringWidth;
    }

    public static void setUseStringWidth(boolean aUseStringWidth) {
        useStringWidth = aUseStringWidth;
    }

    protected void initComponent() {
        super.initComponent();
        Form f = this.getComponentForm();
        if (f != null) {
            f.addPointerPressedListener(this.formPressListener);
        }
    }

    protected void deinitialize() {
        Form f = this.getComponentForm();
        if (f != null) {
            f.removePointerPressedListener(this.formPressListener);
        }
        super.deinitialize();
    }

    protected void initLaf(UIManager uim) {
        super.initLaf(uim);
        this.setSelectCommandText(uim.localize("edit", "Edit"));
        LookAndFeel laf = uim.getLookAndFeel();
        this.setSmoothScrolling(laf.isDefaultSmoothScrolling());
    }

    public int getConstraint() {
        return this.constraint;
    }

    public void setConstraint(int constraint) {
        this.constraint = constraint;
    }

    public void setWidth(int width) {
        if (width != this.getWidth()) {
            this.rowStrings = null;
            if (this.growByContent) {
                this.setShouldCalcPreferredSize(true);
            }
        }
        super.setWidth(width);
    }

    public String getText() {
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String t) {
        String old = this.text;
        if (!Objects.equals(t, old)) {
            this.setSuppressActionEvent(false);
        }
        this.text = t != null ? t : "";
        this.setShouldCalcPreferredSize(true);
        if (this.maxSize < this.text.length()) {
            this.maxSize = this.text.length() + 1;
        }
        TextArea textArea = this;
        synchronized (textArea) {
            this.rowStrings = null;
        }
        if (!Objects.equals(this.text, old)) {
            this.fireDataChanged(2, -1);
        }
        if (Display.getInstance().isNativeInputSupported() && Display.getInstance().isTextEditing(this)) {
            if (!this.text.equals(old)) {
                Display.impl.updateNativeEditorText(this, this.text);
            }
            return;
        }
        this.repaint();
    }

    public int getAsInt(int invalid) {
        try {
            return Integer.parseInt(this.text);
        }
        catch (NumberFormatException e) {
            return invalid;
        }
    }

    public long getAsLong(long invalid) {
        try {
            return Long.parseLong(this.text);
        }
        catch (NumberFormatException e) {
            return invalid;
        }
    }

    public double getAsDouble(double invalid) {
        try {
            return Double.parseDouble(this.text);
        }
        catch (NumberFormatException e) {
            return invalid;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
        this.updateCursor();
    }

    public int getPreferredTabIndex() {
        if (this.isEditable()) {
            return super.getPreferredTabIndex();
        }
        return -1;
    }

    private void updateCursor() {
        this.setCursor(this.isEditable() || this.isTextSelectionEnabled() ? 2 : 0);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        this.setSuppressActionEvent(false);
        int action = Display.getInstance().getGameAction(keyCode);
        this.triggerClose = action == 8;
        Rectangle rect = new Rectangle(this.getScrollX(), this.getScrollY(), this.getWidth(), this.getHeight());
        Font textFont = this.getStyle().getFont();
        if (action == 6) {
            if (this.getScrollY() + this.getHeight() < (this.rowsGap + this.getStyle().getFont().getHeight()) * this.getLines()) {
                rect.setY(rect.getY() + (textFont.getHeight() + this.rowsGap) * this.linesToScroll);
                this.scrollRectToVisible(rect, this);
            } else {
                this.setHandlesInput(false);
            }
        } else if (action == 1) {
            if (this.getScrollY() > 0) {
                rect.setY(Math.max(0, rect.getY() - (textFont.getHeight() + this.rowsGap) * this.linesToScroll));
                this.scrollRectToVisible(rect, this);
            } else {
                this.setHandlesInput(false);
            }
        }
        if (action == 5 || action == 2) {
            this.setHandlesInput(false);
        }
    }

    protected void fireClicked() {
        this.onClick();
    }

    protected boolean isSelectableInteraction() {
        return this.editable;
    }

    private boolean isTypedKey(int code) {
        return code > 0;
    }

    public void keyReleased(int keyCode) {
        int action = Display.getInstance().getGameAction(keyCode);
        if (this.isEditable()) {
            if (this.triggerClose && (action == 8 || this.isEnterKey(keyCode))) {
                this.triggerClose = false;
                this.onClick();
                return;
            }
            if (action == 0 && this.isTypedKey(keyCode)) {
                Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText(), keyCode);
            }
        }
    }

    public boolean isScrollableY() {
        return this.isFocusable() && this.getScrollDimension().getHeight() > this.getHeight();
    }

    void deinitializeImpl() {
        super.deinitializeImpl();
        Display.getInstance().stopEditing(this);
    }

    void onClick() {
        if (this.isEditable()) {
            this.editString();
        }
    }

    void editString() {
        if (autoDegradeMaxSize && this.maxSize > 1024) {
            try {
                Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText());
            }
            catch (IllegalArgumentException err) {
                this.maxSize -= 1024;
                TextArea.setDefaultMaxSize(this.maxSize);
                this.editString();
            }
        } else {
            Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText());
        }
    }

    public void pointerHover(int[] x, int[] y) {
        if (!Display.getInstance().isDesktop()) {
            this.requestFocus();
        }
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        if (!Display.getInstance().isDesktop()) {
            this.requestFocus();
        }
    }

    boolean showLightweightVKB() {
        return false;
    }

    public void pointerReleased(int x, int y) {
        if (this.isDragActivated()) {
            super.pointerReleased(x, y);
        } else {
            super.pointerReleased(x, y);
            if (this.isEditable() && this.isEnabled() && !this.isCellRenderer()) {
                if (Display.impl.isNativeInputImmediate()) {
                    this.editString();
                    return;
                }
                if (Display.getInstance().isTouchScreenDevice()) {
                    if (this.showLightweightVKB() || !(Display.getInstance().getDefaultVirtualKeyboard() instanceof Dialog)) {
                        if (!Display.getInstance().isVirtualKeyboardShowing()) {
                            Display.getInstance().setShowVirtualKeyboard(true);
                        }
                    } else {
                        this.onClick();
                    }
                } else {
                    this.onClick();
                }
            }
        }
    }

    void focusGainedInternal() {
        this.setSuppressActionEvent(false);
        super.focusGainedInternal();
        this.setHandlesInput(this.isScrollableY());
    }

    void focusLostInternal() {
        super.focusLostInternal();
        this.setHandlesInput(false);
        if (this.isEditing()) {
            this.fireActionEvent();
            this.setSuppressActionEvent(true);
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.setShouldCalcPreferredSize(true);
        this.columns = columns;
    }

    public int getActualRows() {
        if (this.growByContent) {
            if (this.growLimit > -1) {
                return Math.min(Math.max(this.rows, this.getLines()), this.growLimit);
            }
            return Math.max(this.rows, this.getLines());
        }
        return this.rows;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.setShouldCalcPreferredSize(true);
        this.rows = rows;
    }

    void initComponentImpl() {
        this.getRowStrings();
        super.initComponentImpl();
    }

    private ArrayList getRowStrings() {
        if (this.rowStrings == null || this.widthForRowCalculations != this.getWidth() - this.getUnselectedStyle().getHorizontalPadding()) {
            this.initRowString();
            this.setShouldCalcPreferredSize(true);
        }
        return this.rowStrings;
    }

    public int getLines() {
        ArrayList v = this.getRowStrings();
        int retVal = v.size();
        return retVal;
    }

    public String getTextAt(int line) {
        ArrayList rowsV = this.getRowStrings();
        int size = rowsV.size();
        if (size == 0) {
            return "";
        }
        if (line >= size) {
            return (String)rowsV.get(size - 1);
        }
        return (String)rowsV.get(line);
    }

    private int indexOf(char[] t, char c, int offset, int length) {
        int tlen = t.length;
        for (int iter = offset; iter < tlen && iter < offset + length; ++iter) {
            if (t[iter] != c) continue;
            return iter;
        }
        return -1;
    }

    protected char[] preprocess(String text) {
        return text.toCharArray();
    }

    private int updateRowWidth(char c, Font font) {
        this.currentRowWidth += font.charWidth(c);
        return this.currentRowWidth;
    }

    private int updateRowWidth(String str, Font font) {
        this.currentRowWidth += font.stringWidth(str);
        return this.currentRowWidth;
    }

    private boolean fastCharWidthCheck(char[] chrs, int off, int length, int width, int charWidth, Font f) {
        if (length * charWidth < width) {
            return true;
        }
        return f.charsWidth(chrs, off, length = Math.min(chrs.length, length)) < width;
    }

    private void initRowString() {
        int cw;
        int w;
        if (!Display.getInstance().isEdt() && this.rowStrings == null) {
            this.rowStrings = new ArrayList();
            this.rowStrings.add(this.getText());
            return;
        }
        Style style = this.getUnselectedStyle();
        this.rowStrings = new ArrayList();
        this.widthForRowCalculations = this.getWidth() - style.getHorizontalPadding();
        if (this.isSingleLineTextArea()) {
            this.rowStrings.add(this.getText());
            return;
        }
        if (this.widthForRowCalculations <= 0) {
            this.rowStrings.add(this.getText());
            this.setShouldCalcPreferredSize(true);
            return;
        }
        if (this.text == null || this.text.equals("")) {
            return;
        }
        Font font = style.getFont();
        if (this.actAsLabel && this.text.length() <= this.columns && this.text.indexOf(10) < 0 && (w = font.stringWidth(this.text)) <= this.getWidth()) {
            if (this.rowStrings == null) {
                this.rowStrings = new ArrayList();
                this.rowStrings.add(this.getText());
                return;
            }
            this.rowStrings.clear();
            this.rowStrings.add(this.getText());
            return;
        }
        char[] text = this.preprocess(this.getText());
        int rows = this.rows;
        if (this.growByContent) {
            rows = Math.max(rows, this.getLines());
        }
        int charWidth = font.charWidth(widestChar);
        Style selectedStyle = this.getSelectedStyle();
        if (selectedStyle.getFont() != style.getFont() && (cw = selectedStyle.getFont().charWidth(widestChar)) > charWidth) {
            charWidth = cw;
            font = selectedStyle.getFont();
        }
        style = this.getStyle();
        int tPadding = style.getHorizontalPadding();
        int textAreaWidth = this.getWidth() - tPadding;
        if (textAreaWidth <= charWidth) {
            if (!this.isInitialized()) {
                this.rowStrings.add(this.getText());
            } else {
                int tlen = text.length;
                for (int iter = 0; iter < tlen; ++iter) {
                    this.rowStrings.add("" + text[iter]);
                }
            }
            return;
        }
        int minCharactersInRow = Math.max(1, textAreaWidth / charWidth);
        int from = 0;
        int to = from + minCharactersInRow;
        int textLength = text.length;
        String rowText = null;
        if (textLength / minCharactersInRow > Math.max(2, rows)) {
            textAreaWidth -= this.getUIManager().getLookAndFeel().getVerticalScrollWidth();
            textAreaWidth -= charWidth / 2;
        }
        String unsupported = this.getUnsupportedChars();
        to = Math.max(Math.min(textLength - 1, to), 0);
        while (to < textLength) {
            int i;
            if (to > textLength) {
                to = textLength;
            }
            int spaceIndex = -1;
            rowText = "";
            int maxLength = to;
            if (useStringWidth || this.actAsLabel) {
                String currentRow = "";
                for (i = to; i < textLength && this.fastCharWidthCheck(text, from, i - from + 1, textAreaWidth, charWidth, font); ++i) {
                    int c = text[i];
                    currentRow = currentRow + (char)c;
                    if (i < textLength - 1 && Character.isSurrogatePair((char)c, text[i + 1])) {
                        currentRow = currentRow + text[++i];
                        maxLength += 2;
                        if (font.stringWidth(currentRow) < textAreaWidth) continue;
                        break;
                    }
                    if (font.stringWidth(currentRow) >= textAreaWidth) break;
                    if (unsupported.indexOf(c) > -1) {
                        text[i] = 32;
                        c = 32;
                    }
                    if (c == 32 || c == 10) {
                        spaceIndex = i;
                        if (c == 10) break;
                    }
                    ++maxLength;
                }
            } else {
                this.currentRowWidth = 0;
                if (to != from) {
                    this.currentRowWidth = font.charsWidth(text, from, to - from);
                }
                for (i = to; i < textLength; ++i) {
                    int c = text[i];
                    if (i < textLength - 1 && Character.isSurrogatePair((char)c, text[i + 1])) {
                        String testStr = new String(new char[]{text[i], text[i + 1]});
                        ++i;
                        if (this.updateRowWidth(testStr, font) < textAreaWidth) {
                            maxLength += 2;
                            continue;
                        }
                        break;
                    }
                    if (this.updateRowWidth((char)c, font) >= textAreaWidth) break;
                    if (unsupported.indexOf(c) > -1) {
                        text[i] = 32;
                        c = 32;
                    }
                    if (c == 32 || c == 10) {
                        spaceIndex = i;
                        if (c == 10) break;
                    }
                    ++maxLength;
                }
            }
            if (i == textLength || text[i] == ' ' || text[i] == '\n') {
                spaceIndex = i;
            }
            if (spaceIndex != -1) {
                int newLine = this.indexOf(text, '\n', from, spaceIndex - from);
                if (newLine > -1 && newLine < spaceIndex) {
                    spaceIndex = newLine;
                }
                rowText = new String(text, from, spaceIndex - from);
                from = spaceIndex + 1;
            } else {
                for (i = to; spaceIndex == -1 && i >= from; --i) {
                    char chr = text[i];
                    if (chr != ' ' && chr != '\n' && chr != '\t') continue;
                    spaceIndex = i;
                    int newLine = this.indexOf(text, '\n', from, i - from);
                    if (newLine > -1 && newLine < spaceIndex) {
                        spaceIndex = newLine;
                    }
                    rowText = new String(text, from, spaceIndex - from);
                    from = spaceIndex + 1;
                }
                if (spaceIndex == -1) {
                    if (maxLength <= 0) {
                        maxLength = 1;
                    }
                    if ((spaceIndex = maxLength) > 0 && spaceIndex < textLength && Character.isSurrogatePair(text[spaceIndex - 1], text[spaceIndex])) {
                        ++spaceIndex;
                        ++maxLength;
                    }
                    rowText = new String(text, from, spaceIndex - from);
                    from = spaceIndex;
                }
            }
            if (rowText.length() == 0 && textAreaWidth <= charWidth) {
                if (!this.isInitialized()) {
                    this.rowStrings.add(this.getText());
                } else {
                    int tlen = text.length;
                    for (int iter = 0; iter < tlen; ++iter) {
                        this.rowStrings.add("" + text[iter]);
                    }
                }
                return;
            }
            this.rowStrings.add(rowText);
            to = from;
        }
        if (text[text.length - 1] == '\n') {
            this.rowStrings.add("");
        }
    }

    public int getRowsGap() {
        return this.rowsGap;
    }

    public void setRowsGap(int rowsGap) {
        this.rowsGap = rowsGap;
    }

    public void paint(Graphics g) {
        if (Display.getInstance().isNativeEditorVisible(this)) {
            if (!Display.impl.nativeEditorPaintsHint()) {
                this.paintHint(g);
            }
            return;
        }
        this.getUIManager().getLookAndFeel().drawTextArea(g, this);
        this.paintHint(g);
    }

    void paintHint(Graphics g) {
        if (Display.getInstance().isNativeEditorVisible(this) && Display.impl.nativeEditorPaintsHint()) {
            return;
        }
        super.paintHint(g);
    }

    protected Dimension calcPreferredSize() {
        Label l;
        if (this.shouldShowHint() && (l = this.getHintLabelImpl()) != null) {
            Dimension d1 = this.getUIManager().getLookAndFeel().getTextAreaSize(this, true);
            Dimension d2 = l.getPreferredSize();
            return new Dimension(Math.max(d1.getWidth(), d2.getWidth()), Math.max(d1.getHeight(), d2.getHeight()));
        }
        return this.getUIManager().getLookAndFeel().getTextAreaSize(this, true);
    }

    protected Dimension calcScrollSize() {
        return this.getUIManager().getLookAndFeel().getTextAreaSize(this, false);
    }

    public void addActionListener(ActionListener a) {
        if (this.actionListeners == null) {
            this.actionListeners = new EventDispatcher();
        }
        this.actionListeners.addListener(a);
    }

    public void removeActionListener(ActionListener a) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.removeListener(a);
        if (!this.actionListeners.hasListeners()) {
            this.actionListeners = null;
        }
    }

    boolean isSuppressActionEvent() {
        return this.suppressActionEvent;
    }

    void setSuppressActionEvent(boolean suppress) {
        this.suppressActionEvent = suppress;
    }

    void fireActionEvent() {
        if (this.suppressActionEvent) {
            return;
        }
        if (this.actionListeners != null) {
            ActionEvent evt = new ActionEvent((Object)this, ActionEvent.Type.Edit);
            this.actionListeners.fireActionEvent(evt);
        }
        if (this.bindListeners != null) {
            String t = this.getText();
            this.bindListeners.fireBindTargetChange(this, "text", this.lastTextValue, t);
            this.lastTextValue = t;
        }
    }

    public void addCloseListener(ActionListener l) {
        if (this.closeListeners == null) {
            this.closeListeners = new EventDispatcher();
        }
        this.closeListeners.addListener(l);
    }

    public void removeCloseListener(ActionListener l) {
        if (this.closeListeners != null && this.closeListeners.hasListeners()) {
            this.closeListeners.removeListener(l);
            if (!this.closeListeners.hasListeners()) {
                this.closeListeners = null;
            }
        }
    }

    void fireCloseEvent() {
        if (this.closeListeners != null && this.closeListeners.hasListeners()) {
            ActionEvent evt = new ActionEvent(this);
            this.closeListeners.fireActionEvent(evt);
        }
    }

    void onEditComplete(String text) {
        if (!Display.getInstance().getImplementation().isAsyncEditMode()) {
            this.setText(text);
        }
        if (this.getParent() != null) {
            this.getParent().revalidate();
        }
    }

    public boolean isGrowByContent() {
        return this.growByContent;
    }

    public void setGrowByContent(boolean growByContent) {
        this.growByContent = growByContent;
    }

    public String getUnsupportedChars() {
        return this.unsupportedChars;
    }

    public void setUnsupportedChars(String unsupportedChars) {
        this.unsupportedChars = unsupportedChars;
    }

    public int getLinesToScroll() {
        return this.linesToScroll;
    }

    public void setLinesToScroll(int linesToScroll) {
        if (linesToScroll < 1) {
            throw new IllegalArgumentException("lines to scroll has to be >= 1");
        }
        this.linesToScroll = linesToScroll;
    }

    public boolean isSingleLineTextArea() {
        return this.singleLineTextArea;
    }

    public void setSingleLineTextArea(boolean singleLineTextArea) {
        this.singleLineTextArea = singleLineTextArea;
    }

    public int getAlignment() {
        return this.getStyle().getAlignment();
    }

    public void setAlignment(int align) {
        this.getAllStyles().setAlignment(align);
    }

    public int getAbsoluteAlignment() {
        int a = this.getAlignment();
        if (this.isRTL()) {
            switch (a) {
                case 3: {
                    return 1;
                }
                case 1: {
                    return 3;
                }
            }
        }
        return a;
    }

    public boolean isPendingCommit() {
        return false;
    }

    public int getCursorPosition() {
        return -1;
    }

    public int getCursorY() {
        return -1;
    }

    public int getCursorX() {
        return -1;
    }

    public boolean isQwertyInput() {
        return false;
    }

    public String getInputMode() {
        return null;
    }

    public String[] getInputModeOrder() {
        return null;
    }

    public boolean isEnableInputScroll() {
        return false;
    }

    protected boolean isEnterKey(int keyCode) {
        return keyCode == 10;
    }

    public String getHint() {
        return super.getHint();
    }

    public void setHint(String hint) {
        super.setHint(hint, this.getHintIcon());
    }

    public Image getHintIcon() {
        return super.getHintIcon();
    }

    public void setHintIcon(Image icon) {
        this.setHint(this.getHint(), icon);
    }

    public void setHint(String hint, Image icon) {
        super.setHint(hint, icon);
    }

    public Label getHintLabel() {
        return this.getHintLabelImpl();
    }

    Label getHintLabelImpl() {
        return this.hintLabel;
    }

    void setHintLabelImpl(Label hintLabel) {
        this.hintLabel = hintLabel;
    }

    boolean shouldShowHint() {
        return this.getText().equals("");
    }

    public int getVerticalAlignment() {
        if (this.valign != 0 && !this.isSingleLineTextArea() && this.isEditable() && !Display.impl.supportsNativeTextAreaVerticalAlignment()) {
            return 0;
        }
        return this.valign;
    }

    public void setVerticalAlignment(int valign) {
        if (valign != 4 && valign != 0 && valign != 2) {
            throw new IllegalArgumentException("Alignment can't be set to " + valign);
        }
        this.valign = valign;
    }

    public String[] getBindablePropertyNames() {
        return new String[]{"text"};
    }

    public Class[] getBindablePropertyTypes() {
        return new Class[]{String.class};
    }

    public void bindProperty(String prop, BindTarget target) {
        if (prop.equals("text")) {
            if (this.bindListeners == null) {
                this.bindListeners = new EventDispatcher();
            }
            this.bindListeners.addListener(target);
            return;
        }
        super.bindProperty(prop, target);
    }

    public void unbindProperty(String prop, BindTarget target) {
        if (prop.equals("text")) {
            if (this.bindListeners == null) {
                return;
            }
            this.bindListeners.removeListener(target);
            if (!this.bindListeners.hasListeners()) {
                this.bindListeners = null;
            }
            return;
        }
        super.unbindProperty(prop, target);
    }

    public Object getBoundPropertyValue(String prop) {
        if (prop.equals("text")) {
            return this.getText();
        }
        return super.getBoundPropertyValue(prop);
    }

    public void setBoundPropertyValue(String prop, Object value) {
        if (prop.equals("text")) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText((String)value);
            }
            return;
        }
        super.setBoundPropertyValue(prop, value);
    }

    public int getGrowLimit() {
        return this.growLimit;
    }

    public void setGrowLimit(int growLimit) {
        this.growLimit = growLimit;
    }

    public boolean isEndsWith3Points() {
        return this.endsWith3Points;
    }

    public void setEndsWith3Points(boolean endsWith3Points) {
        this.endsWith3Points = endsWith3Points;
    }

    public void registerAsInputDevice() {
        Form f = this.getComponentForm();
        if (f != null && Display.impl.getEditingText() != this) {
            try {
                TextAreaInputDevice previousInput = null;
                if (f.getCurrentInputDevice() instanceof TextAreaInputDevice && (previousInput = (TextAreaInputDevice)f.getCurrentInputDevice()).editedTextArea == this) {
                    previousInput.enabled = false;
                }
                if (previousInput != null) {
                    previousInput.deferStopEditingToNativeLayer = true;
                }
                TextAreaInputDevice currInput = new TextAreaInputDevice(this);
                f.setCurrentInputDevice(currInput);
            }
            catch (Exception ex) {
                Log.e(ex);
            }
        }
    }

    public void startEditing() {
        if (!Display.getInstance().isTextEditing(this)) {
            Display.getInstance().editString(this, this.maxSize, this.constraint, this.text);
        }
    }

    public void startEditingAsync() {
        if (!Display.getInstance().isTextEditing(this)) {
            Component c;
            if (Display.impl.usesInvokeAndBlockForEditString() && (c = Display.impl.getEditingText()) != this && c != null && c instanceof TextArea) {
                ((TextArea)c).stopEditing();
                final TextArea ta = (TextArea)c;
                UITimer.timer(30, false, new Runnable(){

                    public void run() {
                        ta.repaint();
                        Display.getInstance().editString(TextArea.this, TextArea.this.maxSize, TextArea.this.constraint, TextArea.this.text);
                    }
                });
                return;
            }
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    Display.getInstance().editString(TextArea.this, TextArea.this.maxSize, TextArea.this.constraint, TextArea.this.text);
                }
            });
        }
    }

    public boolean isEditing() {
        return Display.getInstance().isTextEditing(this);
    }

    public void stopEditing() {
        if (this.isEditing()) {
            Display.getInstance().stopEditing(this);
        }
    }

    public void stopEditing(Runnable onFinish) {
        if (this.isEditing()) {
            Display.getInstance().stopEditing(this, onFinish);
        } else if (onFinish != null) {
            onFinish.run();
        }
    }

    public Style getStyle() {
        if (this.isEditing()) {
            return this.getSelectedStyle();
        }
        return super.getStyle();
    }

    public void addDataChangedListener(DataChangedListener d) {
        this.listeners.addListener(d);
    }

    public void removeDataChangedListener(DataChangedListener d) {
        this.listeners.removeListener(d);
    }

    public void addDataChangeListener(DataChangedListener d) {
        this.listeners.addListener(d);
    }

    public void removeDataChangeListener(DataChangedListener d) {
        this.listeners.removeListener(d);
    }

    public void fireDataChanged(int type, int index) {
        if (this.listeners != null) {
            this.listeners.fireDataChangeEvent(index, type);
        }
    }

    public ActionListener getDoneListener() {
        return this.doneListener;
    }

    public void setDoneListener(ActionListener l) {
        this.doneListener = l;
    }

    public void fireDoneEvent() {
        this.fireDoneEvent(-1);
    }

    public void fireDoneEvent(final int keyEvent) {
        if (this.doneListener != null) {
            if (!Display.getInstance().isEdt()) {
                Display.getInstance().callSerially(new Runnable(){

                    public void run() {
                        TextArea.this.fireDoneEvent(keyEvent);
                    }
                });
                return;
            }
            this.doneListener.actionPerformed(new ActionEvent((Object)this, ActionEvent.Type.Done, keyEvent));
        }
    }

    public boolean isActAsLabel() {
        return this.actAsLabel;
    }

    public void setActAsLabel(boolean actAsLabel) {
        this.actAsLabel = actAsLabel;
    }

    protected boolean shouldRenderComponentSelection() {
        return this.isEditing() || super.shouldRenderComponentSelection();
    }

    protected TextSelection.Spans calculateTextSelectionSpan(TextSelection sel) {
        return this.getUIManager().getLookAndFeel().calculateTextAreaSpan(sel, this);
    }

    public boolean isTextSelectionEnabled() {
        return this.textSelectionEnabled;
    }

    public void setTextSelectionEnabled(boolean enabled) {
        this.textSelectionEnabled = enabled;
        this.updateCursor();
    }

    public TextSelection.TextSelectionSupport getTextSelectionSupport() {
        if (this.textSelectionSupport == null) {
            this.textSelectionSupport = new TextSelection.TextSelectionSupport(){

                public TextSelection.Spans getTextSelectionForBounds(TextSelection sel, Rectangle bounds) {
                    TextArea.this.span = TextArea.this.calculateTextSelectionSpan(sel);
                    if (TextArea.this.span == null) {
                        return sel.newSpans();
                    }
                    TextSelection.Spans result = TextArea.this.span.getIntersection(bounds, true);
                    TextSelection.Spans out = sel.newSpans();
                    out.add(result);
                    return out;
                }

                public boolean isTextSelectionEnabled(TextSelection sel) {
                    return !TextArea.this.isEditable() && TextArea.this.textSelectionEnabled || TextArea.this.isEditable() && !TextArea.this.isEnabled();
                }

                public boolean isTextSelectionTriggerEnabled(TextSelection sel) {
                    return !TextArea.this.isEditable() && TextArea.this.textSelectionEnabled || TextArea.this.isEditable() && !TextArea.this.isEnabled();
                }

                public TextSelection.Span triggerSelectionAt(TextSelection sel, int x, int y) {
                    int startPos;
                    TextArea.this.span = TextArea.this.getUIManager().getLookAndFeel().calculateTextAreaSpan(sel, TextArea.this);
                    if (TextArea.this.span.isEmpty()) {
                        return null;
                    }
                    TextSelection.Char charAtPoint = TextArea.this.span.charAt(x, y);
                    if (charAtPoint == null) {
                        return null;
                    }
                    TextSelection.Span sp = TextArea.this.span.spanOfCharAt(x, y);
                    int endPos = charAtPoint.getPosition() + 1;
                    String dividers = " \t\r\n-.;";
                    for (startPos = charAtPoint.getPosition(); startPos > sp.first().getPosition(); --startPos) {
                        if (dividers.indexOf(TextArea.this.getText().substring(startPos, startPos + 1)) < 0) {
                            continue;
                        }
                        if (startPos >= sp.last().getPosition()) break;
                        ++startPos;
                        break;
                    }
                    while (endPos < sp.last().getPosition() + 1) {
                        if (dividers.indexOf(TextArea.this.getText().substring(endPos - 1, endPos)) < 0) {
                            ++endPos;
                            continue;
                        }
                        if (endPos <= sp.first().getPosition()) break;
                        --endPos;
                        break;
                    }
                    return sp.subspan(startPos, endPos);
                }

                public String getTextForSpan(TextSelection sel, TextSelection.Span span) {
                    int offset = span.getStartPos();
                    offset = Math.max(0, offset);
                    offset = Math.min(TextArea.this.getText().length() - 1, offset);
                    int end = span.getEndPos() + 1;
                    end = Math.min(TextArea.this.getText().length(), end);
                    return TextArea.this.getText().substring(offset, end);
                }
            };
        }
        return this.textSelectionSupport;
    }

    static {
        widestChar = (char)87;
    }

    private static class TextAreaInputDevice
    implements VirtualInputDevice {
        private final TextArea editedTextArea;
        private boolean deferStopEditingToNativeLayer;
        private boolean enabled = true;

        TextAreaInputDevice(TextArea ta) {
            this.editedTextArea = ta;
        }

        public void close() throws Exception {
            if (!this.enabled) {
                return;
            }
            this.editedTextArea.fireCloseEvent();
            if (this.deferStopEditingToNativeLayer) {
                return;
            }
            if (this.editedTextArea.isEditing()) {
                this.editedTextArea.stopEditing();
            }
        }
    }
}

