/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.InputComponent;
import com.codename1.ui.Label;
import com.codename1.ui.TextField;
import com.codename1.ui.animations.ComponentAnimation;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.LayeredLayout;

public class TextComponent
extends InputComponent {
    private static final int animationSpeed = 100;
    private final TextField field = new TextField(){

        void paintHint(Graphics g) {
            if (TextComponent.this.isFocusAnimation()) {
                if (!this.hasFocus()) {
                    super.paintHint(g);
                }
            } else {
                super.paintHint(g);
            }
        }

        void focusGainedInternal() {
            super.focusGainedInternal();
            if (this.isInitialized() && TextComponent.this.isFocusAnimation()) {
                TextComponent.this.getLabel().setFocus(true);
                if (!TextComponent.this.getLabel().isVisible()) {
                    final Label text = new Label(this.getHint(), "TextHint");
                    this.setHint("");
                    final Label placeholder = new Label();
                    Component.setSameSize(placeholder, TextComponent.this.field);
                    TextComponent.this.animationLayer.add((Object)"North", text);
                    TextComponent.this.animationLayer.add((Object)"Center", placeholder);
                    text.setX(this.getX());
                    text.setY(this.getY());
                    text.setWidth(this.getWidth());
                    text.setHeight(this.getHeight());
                    ComponentAnimation anim = ComponentAnimation.compoundAnimation(TextComponent.this.animationLayer.createAnimateLayout(100), text.createStyleAnimation("FloatingHint", 100));
                    this.getAnimationManager().addAnimation(anim, new Runnable(){

                        public void run() {
                            Component.setSameSize(TextComponent.this.field);
                            text.remove();
                            placeholder.remove();
                            TextComponent.this.getLabel().setVisible(true);
                        }
                    });
                }
            }
        }

        void focusLostInternal() {
            super.focusLostInternal();
            if (this.isInitialized() && TextComponent.this.isFocusAnimation()) {
                TextComponent.this.getLabel().setFocus(false);
                if (this.getText().length() == 0 && TextComponent.this.getLabel().isVisible() && TextComponent.this.isOnTopMode()) {
                    final Label text = new Label(TextComponent.this.getLabel().getText(), TextComponent.this.getLabel().getUIID());
                    final Label placeholder = new Label();
                    Component.setSameSize(placeholder, TextComponent.this.getLabel());
                    TextComponent.this.animationLayer.add((Object)"North", placeholder);
                    TextComponent.this.animationLayer.add((Object)"Center", text);
                    text.setX(TextComponent.this.getLabel().getX());
                    text.setY(TextComponent.this.getLabel().getY());
                    text.setWidth(TextComponent.this.getLabel().getWidth());
                    text.setHeight(TextComponent.this.getLabel().getHeight());
                    String hintLabelUIID = "TextHint";
                    if (this.getHintLabel() != null) {
                        hintLabelUIID = this.getHintLabel().getUIID();
                    }
                    ComponentAnimation anim = ComponentAnimation.compoundAnimation(TextComponent.this.animationLayer.createAnimateLayout(100), text.createStyleAnimation(hintLabelUIID, 100));
                    this.getAnimationManager().addAnimation(anim, new Runnable(){

                        public void run() {
                            this.setHint(TextComponent.this.getLabel().getText());
                            TextComponent.this.getLabel().setVisible(false);
                            Component.setSameSize(TextComponent.this.getLabel());
                            text.remove();
                            placeholder.remove();
                        }
                    });
                }
            }
        }
    };
    private Container animationLayer;
    private Boolean focusAnimation;

    public TextComponent() {
        this.initInput();
    }

    private void updateLabel() {
        if (this.isFocusAnimation() && (this.field.getText() == null || this.field.getText().length() == 0)) {
            this.field.setHint(this.getLabel().getText());
            this.getLabel().setVisible(false);
        } else {
            this.getLabel().setVisible(true);
        }
    }

    void constructUI() {
        if (this.getComponentCount() == 0) {
            if (this.isOnTopMode() && this.isFocusAnimation()) {
                this.getLabel().setUIID("FloatingHint");
                this.setLayout(new LayeredLayout());
                Container tfContainer = this.action != null ? BorderLayout.center(LayeredLayout.encloseIn(this.field, FlowLayout.encloseRightMiddle(this.action))) : BorderLayout.center(this.field);
                tfContainer.add((Object)"North", this.getLabel()).add((Object)"South", LayeredLayout.encloseIn(this.getErrorMessage(), this.getDescriptionMessage()));
                this.add(tfContainer);
                Label errorMessageFiller = new Label();
                Component.setSameSize(errorMessageFiller, this.getErrorMessage());
                this.animationLayer = BorderLayout.south(errorMessageFiller);
                this.add(this.animationLayer);
                this.updateLabel();
            } else {
                super.constructUI();
            }
        }
    }

    public Component getEditor() {
        return this.field;
    }

    void refreshForGuiBuilder() {
        if (guiBuilderMode.booleanValue()) {
            if (this.animationLayer != null) {
                this.animationLayer.remove();
            }
            super.refreshForGuiBuilder();
        }
    }

    public boolean isFocusAnimation() {
        if (this.focusAnimation != null) {
            return this.focusAnimation;
        }
        return this.getUIManager().isThemeConstant("textComponentAnimBool", false);
    }

    public TextComponent focusAnimation(boolean focusAnimation) {
        this.focusAnimation = focusAnimation;
        this.refreshForGuiBuilder();
        return this;
    }

    public TextComponent text(String text) {
        this.field.setText(text);
        this.updateLabel();
        this.refreshForGuiBuilder();
        return this;
    }

    public TextComponent onTopMode(boolean onTopMode) {
        return (TextComponent)super.onTopMode(onTopMode);
    }

    public TextComponent action(char icon) {
        super.action(icon);
        return this;
    }

    public TextComponent actionClick(ActionListener c) {
        super.actionClick(c);
        return this;
    }

    public TextComponent errorMessage(String errorMessage) {
        super.errorMessage(errorMessage);
        return this;
    }

    public TextComponent descriptionMessage(String descriptionMessage) {
        super.descriptionMessage(descriptionMessage);
        return this;
    }

    public TextComponent label(String text) {
        super.label(text);
        return this;
    }

    public TextComponent actionAsButton(boolean asButton) {
        return (TextComponent)super.actionAsButton(asButton);
    }

    public TextComponent actionUIID(String uiid) {
        return (TextComponent)super.actionUIID(uiid);
    }

    public TextComponent actionText(String text) {
        return (TextComponent)super.actionText(text);
    }

    public TextComponent labelAndHint(String text) {
        super.label(text);
        this.hint(text);
        return this;
    }

    public TextComponent hint(String hint) {
        this.field.setHint(hint);
        this.refreshForGuiBuilder();
        return this;
    }

    public TextComponent hint(Image hint) {
        this.field.setHintIcon(hint);
        this.refreshForGuiBuilder();
        return this;
    }

    public TextComponent multiline(boolean multiline) {
        this.field.setSingleLineTextArea(!multiline);
        this.refreshForGuiBuilder();
        return this;
    }

    public TextComponent columns(int columns) {
        this.field.setColumns(columns);
        this.refreshForGuiBuilder();
        return this;
    }

    public TextComponent rows(int rows) {
        this.field.setRows(rows);
        this.refreshForGuiBuilder();
        return this;
    }

    public TextComponent constraint(int constraint) {
        this.field.setConstraint(constraint);
        return this;
    }

    public TextField getField() {
        return this.field;
    }

    public String[] getPropertyNames() {
        return new String[]{"text", "label", "hint", "multiline", "columns", "rows", "constraint"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{String.class, String.class, String.class, Boolean.class, Integer.class, Integer.class, Integer.class};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"String", "String", "String", "Boolean", "Integer", "Integer", "Integer"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("text")) {
            return this.field.getText();
        }
        if (name.equals("hint")) {
            return this.field.getHint();
        }
        if (name.equals("multiline")) {
            return !this.field.isSingleLineTextArea();
        }
        if (name.equals("columns")) {
            return this.field.getColumns();
        }
        if (name.equals("rows")) {
            return this.field.getRows();
        }
        if (name.equals("constraint")) {
            return this.field.getConstraint();
        }
        return super.getPropertyValue(name);
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("text")) {
            this.text((String)value);
            return null;
        }
        if (name.equals("hint")) {
            this.hint((String)value);
            return null;
        }
        if (name.equals("multiline")) {
            this.field.setSingleLineTextArea((Boolean)value == false);
            return null;
        }
        if (name.equals("columns")) {
            this.field.setColumns((Integer)value);
            return null;
        }
        if (name.equals("rows")) {
            this.field.setRows((Integer)value);
            return null;
        }
        if (name.equals("constraint")) {
            this.field.setConstraint((Integer)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public String getText() {
        return this.field.getText();
    }
}

