/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.MenuBar;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextSelection;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.GridLayout;
import com.codename1.ui.plaf.UIManager;
import java.util.Hashtable;
import java.util.Vector;

public class TextField
extends TextArea {
    private static final char[] DEFAULT_SYMBOL_TABLE = new char[]{'.', ',', '?', '!', '$', '@', '\'', '-', '_', ')', '(', ':', ';', '&', '/', '~', '\\', '%', '*', '#', '+', '>', '=', '<', '\"'};
    private static final String[] DEFAULT_KEY_CODES = new String[]{" 0", ".,?!'\"1-()@/:_", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9"};
    private static boolean replaceMenuDefault = true;
    private static String clearText = "Clear";
    private static String t9Text = "T9";
    private static Hashtable inputModes;
    private static String[] defaultInputModeOrder;
    private static final Vector firstUppercaseInputMode;
    private static boolean qwertyAutoDetect;
    private static boolean qwertyDevice;
    private static int defaultChangeInputModeKey;
    private static int defaultSymbolDialogKey;
    private static boolean useNativeTextInput;
    private static char[] symbolTable;
    private long cursorBlinkTime = System.currentTimeMillis();
    private boolean drawCursor = true;
    private int cursorY = 0;
    private int cursorX = -1;
    private boolean pressedAndNotReleased;
    private long pressTime;
    private boolean useSoftkeys = true;
    private long releaseTime;
    private String previousText;
    private int commitTimeout = 1000;
    private boolean pendingCommit;
    private int pressCount = 0;
    private int lastKeyCode;
    private int pressedKeyCode;
    private boolean longClick;
    private Command originalClearCommand;
    private String inputMode = defaultInputModeOrder[0];
    private String[] inputModeOrder = defaultInputModeOrder;
    private int blinkOnTime = 800;
    private int blinkOffTime = 200;
    private boolean qwertyInitialized;
    private boolean qwerty = qwertyDevice;
    private boolean replaceMenu = replaceMenuDefault;
    private Command[] originalCommands;
    private boolean overwriteMode;
    private boolean enableInputScroll = true;
    private int keyFwd = 5;
    private int keyBack = 2;
    private boolean leftAndRightEditingTrigger = true;
    private Command selectCommand;
    private final Command DELETE_COMMAND = new CommandHandler(clearText, 1);
    private final Command T9_COMMAND = new CommandHandler(t9Text, 2);

    public TextField() {
        super(1, 20);
        this.setUIID("TextField");
        this.setSingleLineTextArea(true);
    }

    public TextField(int columns) {
        super(1, columns);
        this.setUIID("TextField");
        this.setSingleLineTextArea(true);
    }

    public TextField(String text) {
        super(text, 1, 20);
        this.setUIID("TextField");
        this.setSingleLineTextArea(true);
    }

    public TextField(String text, String hint) {
        this(text);
        this.setHint(hint);
    }

    public TextField(String text, String hint, int columns, int constraint) {
        this(text);
        this.setHint(hint);
        this.setColumns(columns);
        this.setConstraint(constraint);
    }

    public TextField(String text, int columns) {
        super(text, 1, columns);
        this.setUIID("TextField");
        this.setSingleLineTextArea(true);
    }

    public static boolean isUseNativeTextInput() {
        return useNativeTextInput;
    }

    public static void setUseNativeTextInput(boolean aUseNativeTextInput) {
        useNativeTextInput = aUseNativeTextInput;
    }

    public static void setClearText(String text) {
        clearText = text;
    }

    public static void setT9Text(String text) {
        t9Text = text;
    }

    public static TextArea create(String text, int columns) {
        if (Display.impl.isNativeInputSupported()) {
            return new TextArea(text, 1, columns);
        }
        return new TextField(text, columns);
    }

    public static TextArea create() {
        return TextField.create(20);
    }

    public static TextArea create(int columns) {
        return TextField.create("", columns);
    }

    public static TextArea create(String text) {
        return TextField.create(text, 20);
    }

    private static void initInputModes() {
        if (inputModes == null) {
            firstUppercaseInputMode.addElement("Abc");
            inputModes = new Hashtable();
            Hashtable<Integer, String> upcase = new Hashtable<Integer, String>();
            int dlen = DEFAULT_KEY_CODES.length;
            for (int iter = 0; iter < dlen; ++iter) {
                upcase.put(48 + iter, DEFAULT_KEY_CODES[iter]);
            }
            inputModes.put("ABC", upcase);
            Hashtable<Integer, String> lowcase = new Hashtable<Integer, String>();
            for (int iter = 0; iter < dlen; ++iter) {
                lowcase.put(48 + iter, DEFAULT_KEY_CODES[iter].toLowerCase());
            }
            inputModes.put("abc", lowcase);
            Hashtable<Integer, String> numbers = new Hashtable<Integer, String>();
            for (int iter = 0; iter < 10; ++iter) {
                numbers.put(48 + iter, "" + iter);
            }
            inputModes.put("123", numbers);
        }
    }

    public static void addInputMode(String name, Hashtable values, boolean firstUpcase) {
        TextField.initInputModes();
        inputModes.put(name, values);
        if (firstUpcase) {
            firstUppercaseInputMode.addElement(name);
        }
    }

    public static String[] getDefaultInputModeOrder() {
        return defaultInputModeOrder;
    }

    public static void setDefaultInputModeOrder(String[] order) {
        defaultInputModeOrder = order;
    }

    public static char[] getSymbolTable() {
        return symbolTable;
    }

    public static void setSymbolTable(char[] table) {
        symbolTable = table;
    }

    public static boolean isReplaceMenuDefault() {
        return replaceMenuDefault;
    }

    public static void setReplaceMenuDefault(boolean replaceMenu) {
        replaceMenuDefault = replaceMenu;
    }

    public static boolean isQwertyAutoDetect() {
        return qwertyAutoDetect;
    }

    public static void setQwertyAutoDetect(boolean v) {
        qwertyAutoDetect = v;
    }

    public static boolean isQwertyDevice() {
        return qwertyDevice;
    }

    public static void setQwertyDevice(boolean v) {
        qwertyDevice = v;
    }

    public static int getDefaultChangeInputModeKey() {
        return defaultChangeInputModeKey;
    }

    public static void setDefaultChangeInputModeKey(int k) {
        defaultChangeInputModeKey = k;
    }

    public static int getDefaultSymbolDialogKey() {
        return defaultSymbolDialogKey;
    }

    public static void setDefaultSymbolDialogKey(int d) {
        defaultSymbolDialogKey = d;
    }

    public boolean isEnableInputScroll() {
        return this.enableInputScroll;
    }

    public void setEnableInputScroll(boolean enableInputScroll) {
        this.enableInputScroll = enableInputScroll;
    }

    public void deleteChar() {
        int cursorCharPosition;
        String text = this.getText();
        if (text.length() > 0 && (cursorCharPosition = this.getCursorPosition()) > 0) {
            int tmpCursorCharPosition = cursorCharPosition - 1;
            if (!this.overwriteMode) {
                text = tmpCursorCharPosition == text.length() ? text.substring(0, text.length() - 1) : text.substring(0, tmpCursorCharPosition) + text.substring(tmpCursorCharPosition + 1);
                super.setText(text);
                this.commitChange();
                this.fireDataChanged(0, tmpCursorCharPosition);
            }
            if (cursorCharPosition == 1) {
                this.cursorX = 0;
                cursorCharPosition = 0;
            } else {
                this.setCursorPosition(tmpCursorCharPosition);
            }
        }
    }

    protected void commitChange() {
        this.pendingCommit = false;
        this.previousText = null;
        this.pressCount = 0;
    }

    public boolean isPendingCommit() {
        return this.pendingCommit;
    }

    public int getCommitTimeout() {
        return this.commitTimeout;
    }

    public void setCommitTimeout(int commitTimeout) {
        this.commitTimeout = commitTimeout;
    }

    public String getInputMode() {
        return this.inputMode;
    }

    public void setInputMode(String inputMode) {
        this.inputMode = inputMode;
        this.repaint();
    }

    protected boolean isChangeInputMode(int keyCode) {
        return keyCode == defaultChangeInputModeKey;
    }

    boolean showLightweightVKB() {
        return true;
    }

    public String[] getInputModeOrder() {
        return this.inputModeOrder;
    }

    public void setInputModeOrder(String[] order) {
        this.inputModeOrder = order;
        this.inputMode = order[0];
    }

    private String pickLowerOrUpper(String inputMode) {
        String text;
        int pos = this.getCursorPosition() - 1;
        if (this.pendingCommit) {
            --pos;
        }
        if (pos >= (text = this.getText()).length()) {
            pos = text.length() - 1;
        }
        while (pos > -1) {
            if (text.charAt(pos) == '.') {
                return inputMode.toUpperCase();
            }
            if (text.charAt(pos) != ' ') {
                return inputMode.toLowerCase();
            }
            --pos;
        }
        return inputMode.toUpperCase();
    }

    protected String getLongClickInputMode() {
        return "123";
    }

    protected char getCharPerKeyCode(int pressCount, int keyCode, boolean longClick) {
        String s;
        TextField.initInputModes();
        String input = this.inputMode;
        if (longClick) {
            input = this.getLongClickInputMode();
        } else if (firstUppercaseInputMode.contains(input)) {
            input = this.pickLowerOrUpper(input);
        }
        Hashtable mode = (Hashtable)inputModes.get(input);
        if (mode != null && (s = (String)mode.get(keyCode)) != null) {
            return s.charAt(pressCount %= s.length());
        }
        return '\u0000';
    }

    void onClick() {
        if (useNativeTextInput && Display.getInstance().isNativeInputSupported()) {
            super.onClick();
        }
    }

    private void increaseCursor() {
        ++this.cursorX;
        String txt = this.getCurrentTextLine();
        if (this.cursorX > txt.length() || this.cursorY >= this.getLines()) {
            if (this.isSingleLineTextArea()) {
                this.cursorX = 0;
                return;
            }
            ++this.cursorY;
            if (this.cursorY > this.getLines()) {
                this.cursorY = 0;
                if (!this.isCursorPositionCycle()) {
                    this.cursorY = this.getLines();
                    this.cursorX = txt.length();
                }
            } else {
                this.cursorX = 0;
            }
        }
        this.updateScroll();
    }

    private void decreaseCursor() {
        --this.cursorX;
        if (this.cursorX < 0 || this.cursorY >= this.getLines()) {
            if (this.isSingleLineTextArea()) {
                this.cursorX = this.getCurrentTextLine().length();
                return;
            }
            --this.cursorY;
            if (this.cursorY < 0) {
                this.cursorY = this.getLines() - 1;
                if (!this.isCursorPositionCycle()) {
                    this.cursorY = 0;
                    this.cursorX = 0;
                }
            } else {
                this.cursorX = this.getTextAt(this.cursorY).length();
            }
        }
        this.updateScroll();
    }

    private void increaseCursorLine() {
        String line;
        ++this.cursorY;
        if (this.cursorY >= this.getLines()) {
            this.cursorY = this.isCursorPositionCycle() ? 0 : --this.cursorY;
        }
        if (this.cursorX > (line = this.getTextAt(this.cursorY)).length()) {
            this.cursorX = line.length();
        }
        this.updateScroll();
    }

    private void decreaseCursorLine() {
        String line;
        --this.cursorY;
        if (this.cursorY < 0) {
            this.cursorY = this.isCursorPositionCycle() ? this.getLines() - 1 : ++this.cursorY;
        }
        if (this.cursorX > (line = this.getTextAt(this.cursorY)).length()) {
            this.cursorX = line.length();
        }
        this.updateScroll();
    }

    private void updateScroll() {
        if (!this.isSingleLineTextArea() && this.isScrollableY()) {
            Font textFont = this.getStyle().getFont();
            int rowsGap = this.getRowsGap();
            int lineHeight = textFont.getHeight() + rowsGap;
            Rectangle rect = new Rectangle(this.getScrollX(), this.getCursorY() * lineHeight, this.getWidth(), lineHeight);
            this.scrollRectToVisible(rect, this);
        }
    }

    private void updateCursorLocation(int pos) {
        int currentY;
        if (this.isSingleLineTextArea()) {
            this.cursorX = pos;
            return;
        }
        String text = this.getText();
        String currentLine = "";
        int currentLineLength = 0;
        int numOfChars = 0;
        for (currentY = 0; numOfChars <= pos && currentY < this.getLines(); numOfChars += currentLineLength, ++currentY) {
            currentLine = this.getTextAt(currentY);
            currentLineLength = currentLine.length();
            if (numOfChars + currentLineLength >= text.length() || text.charAt(numOfChars + currentLineLength) != '\n' && text.charAt(numOfChars + currentLineLength) != ' ') continue;
            ++currentLineLength;
        }
        this.cursorY = Math.max(0, currentY - 1);
        this.cursorX = currentLineLength - (numOfChars - pos);
        if (this.cursorX == currentLineLength && currentLineLength > currentLine.length()) {
            --this.cursorX;
        }
    }

    private String getCurrentTextLine() {
        if (this.isSingleLineTextArea()) {
            return this.getText();
        }
        return this.getTextAt(this.getCursorY());
    }

    private void moveCursor(int game) {
        if (this.handlesInput()) {
            if (game == this.keyFwd) {
                this.increaseCursor();
                this.repaint();
            } else if (game == this.keyBack) {
                this.decreaseCursor();
                this.repaint();
            }
            if (!this.isSingleLineTextArea()) {
                if (game == 1) {
                    this.decreaseCursorLine();
                    this.repaint();
                } else if (game == 6) {
                    this.increaseCursorLine();
                    this.repaint();
                }
            }
        }
    }

    public int getCursorPosition() {
        String txt = this.getText();
        if (txt == null || txt.length() == 0) {
            this.updateCursorLocation(0);
            return 0;
        }
        if (this.cursorX == -1) {
            this.updateCursorLocation(this.getText().length());
        }
        if (this.isSingleLineTextArea()) {
            return this.getCursorX();
        }
        int pos = 0;
        for (int line = 0; line < this.cursorY && line < this.getLines(); ++line) {
            String l = this.getTextAt(line);
            if ((pos += l.length()) >= txt.length() || txt.charAt(pos) != '\n' && txt.charAt(pos) != ' ') continue;
            ++pos;
        }
        return Math.min(this.getText().length(), pos + this.cursorX);
    }

    public void setCursorPosition(int pos) {
        if (pos < -1) {
            throw new IllegalArgumentException("Illegal cursor position: " + pos);
        }
        pos = Math.min(pos, this.getText().length());
        pos = Math.max(0, pos);
        this.updateCursorLocation(pos);
    }

    public int getCursorY() {
        return this.cursorY;
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public void setText(String text) {
        super.setText(text);
        if (text != null) {
            int pos = this.getCursorPosition();
            if (pos < 0) {
                pos = text.length();
            } else if (pos > text.length()) {
                pos = text.length();
            }
            this.setCursorPosition(pos);
        } else {
            this.setCursorPosition(0);
        }
    }

    public void clear() {
        if (this.isEditing()) {
            this.stopEditing();
            this.setText("");
            this.commitChange();
            this.startEditingAsync();
        } else {
            this.setText("");
            this.commitChange();
        }
    }

    private void longClick(int keyCode) {
        this.longClick = true;
        this.keyReleaseOrLongClick(keyCode, true);
        this.moveCursor(Display.getInstance().getGameAction(keyCode));
    }

    protected boolean isClearKey(int keyCode) {
        return keyCode == MenuBar.clearSK || keyCode == MenuBar.backspaceSK;
    }

    protected void longKeyPress(int keyCode) {
        if (this.isClearKey(keyCode)) {
            this.setText("");
        }
    }

    public boolean isQwertyInput() {
        if (!this.qwertyInitialized) {
            this.qwertyInitialized = true;
            int type = Display.getInstance().getKeyboardType();
            if (type == 0) {
                this.qwerty = qwertyDevice;
            } else {
                boolean bl = this.qwerty = type == 2 || type == 3;
                if (!qwertyDevice) {
                    qwertyDevice = this.qwerty;
                }
            }
        }
        return this.qwerty;
    }

    public void setQwertyInput(boolean qwerty) {
        this.qwerty = qwerty;
    }

    protected boolean isImmediateInputMode(String mode) {
        return "123".equals(mode);
    }

    private boolean keyReleaseOrLongClick(int keyCode, boolean longClick) {
        if (this.lastKeyCode != keyCode && this.pendingCommit) {
            this.commitChange();
        }
        this.lastKeyCode = keyCode;
        boolean isClearKey = this.isClearKey(keyCode);
        int pos = this.getCursorPosition();
        if (this.isQwertyInput() && !isClearKey) {
            if (keyCode > 0) {
                if (this.previousText == null) {
                    this.previousText = this.getText();
                }
                if (pos < 0) {
                    pos = 0;
                    this.setCursorPosition(pos);
                }
                this.insertChars("" + (char)keyCode);
                this.commitChange();
                this.fireDataChanged(1, pos);
                return true;
            }
        } else {
            char c = this.getCharPerKeyCode(this.pressCount, keyCode, longClick);
            if (c != '\u0000') {
                if (this.previousText == null) {
                    this.previousText = this.getText();
                }
                if (!this.pendingCommit) {
                    this.insertChars("" + c);
                    this.pendingCommit = true;
                    ++this.pressCount;
                } else if (this.overwriteMode) {
                    this.decreaseCursor();
                    this.insertChars("" + c);
                    ++this.pressCount;
                } else if (pos > 0 && pos < this.getMaxSize() && this.previousText.length() < this.getMaxSize() && this.validChar("" + c)) {
                    String text = this.previousText.substring(0, pos - 1) + c + this.previousText.substring(pos - 1);
                    this.pendingCommit = true;
                    ++this.pressCount;
                    super.setText(text);
                }
                if (this.isImmediateInputMode(this.inputMode)) {
                    this.commitChange();
                    this.fireDataChanged(1, pos);
                } else if (this.pressCount == 1) {
                    this.fireDataChanged(1, pos);
                } else {
                    this.fireDataChanged(2, pos);
                }
                return true;
            }
        }
        if (this.isChangeInputMode(keyCode)) {
            int ilen = this.inputModeOrder.length;
            for (int iter = 0; iter < ilen; ++iter) {
                if (!this.inputModeOrder[iter].equals(this.inputMode)) continue;
                if (++iter < this.inputModeOrder.length) {
                    this.setInputMode(this.inputModeOrder[iter]);
                } else {
                    this.setInputMode(this.inputModeOrder[0]);
                }
                return true;
            }
            return true;
        }
        if (isClearKey) {
            if (longClick) {
                this.setText("");
                this.commitChange();
            } else {
                this.deleteChar();
            }
            return true;
        }
        if (this.isSymbolDialogKey(keyCode)) {
            this.showSymbolDialog();
            return true;
        }
        return false;
    }

    public void insertChars(String c) {
        String currentText = this.getText();
        if (!this.validChar(c)) {
            return;
        }
        int pos = this.getCursorPosition() + 1;
        if (this.overwriteMode && pos <= currentText.length()) {
            this.setText(currentText.substring(0, pos - 1) + c + currentText.substring(pos));
        } else {
            if (currentText.length() + c.length() > this.getMaxSize()) {
                return;
            }
            this.setText(currentText.substring(0, pos - 1) + c + currentText.substring(pos - 1));
        }
        if (c.length() > 1) {
            this.setCursorPosition(pos += c.length() - 1);
            return;
        }
        this.increaseCursor();
    }

    public boolean validChar(String c) {
        if (this.getConstraint() == 2) {
            return c.charAt(0) >= '0' && c.charAt(0) <= '9';
        }
        if (this.getConstraint() == 3) {
            return c.charAt(0) >= '0' && c.charAt(0) <= '9' || c.charAt(0) == '+';
        }
        if (this.getConstraint() == 5) {
            return c.charAt(0) >= '0' && c.charAt(0) <= '9' || c.charAt(0) == '+' || c.charAt(0) == '-' || c.charAt(0) == '.' || c.charAt(0) == ',';
        }
        return true;
    }

    protected void showSymbolDialog() {
        Command cancel = new Command(this.getUIManager().localize("cancel", "Cancel"));
        Command r = Dialog.show("", (Component)this.createSymbolTable(), cancel);
        if (r != null && r != cancel) {
            this.insertChars(r.getCommandName());
        }
    }

    protected Container createSymbolTable() {
        char[] symbolArray = TextField.getSymbolTable();
        Container symbols = new Container(new GridLayout(symbolArray.length / 5, 5));
        int slen = symbolArray.length;
        for (int iter = 0; iter < slen; ++iter) {
            Button button = new Button(new Command("" + symbolArray[iter]));
            button.setUIID("VKBButton");
            button.setAlignment(4);
            symbols.addComponent(button);
        }
        return symbols;
    }

    public void keyReleased(int keyCode) {
        if (useNativeTextInput && Display.getInstance().isNativeInputSupported()) {
            super.keyReleased(keyCode);
            return;
        }
        if (!this.isEditable()) {
            return;
        }
        this.pressedAndNotReleased = false;
        this.releaseTime = System.currentTimeMillis();
        if (!this.longClick && this.keyReleaseOrLongClick(keyCode, false)) {
            return;
        }
        this.longClick = false;
        super.keyReleased(keyCode);
    }

    protected int getLongClickDuration() {
        return 800;
    }

    protected boolean isCursorPositionCycle() {
        return true;
    }

    protected boolean isSymbolDialogKey(int keyCode) {
        return keyCode == defaultSymbolDialogKey;
    }

    protected void deinitialize() {
        Form f = this.getComponentForm();
        if (f != null) {
            f.deregisterAnimated(this);
        }
        if (this.handlesInput()) {
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                if (f != null) {
                    f.setClearCommand(this.originalClearCommand);
                }
                this.originalClearCommand = null;
            }
            this.pressedAndNotReleased = false;
            this.setHandlesInput(false);
        }
        super.deinitialize();
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
        if (!b && this.handlesInput()) {
            this.setHandlesInput(false);
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form f = this.getComponentForm();
                f.setClearCommand(this.originalClearCommand);
                this.originalClearCommand = null;
            }
            this.pressedAndNotReleased = false;
        }
    }

    public void keyRepeated(int keyCode) {
        if (useNativeTextInput && Display.getInstance().isNativeInputSupported()) {
            super.keyRepeated(keyCode);
            return;
        }
        if (this.isQwertyInput()) {
            super.keyRepeated(keyCode);
        }
    }

    public void keyPressed(int keyCode) {
        this.setSuppressActionEvent(false);
        if (useNativeTextInput && Display.getInstance().isNativeInputSupported()) {
            super.keyPressed(keyCode);
            return;
        }
        if (!this.isEditable()) {
            return;
        }
        this.pressedAndNotReleased = true;
        this.pressedKeyCode = keyCode;
        this.pressTime = System.currentTimeMillis();
        if (qwertyAutoDetect && !this.qwerty && (keyCode >= 97 && keyCode <= 122 || keyCode >= 65 && keyCode <= 90)) {
            qwertyDevice = true;
            this.qwerty = true;
        }
        if (!this.handlesInput() && this.isEditingTrigger(keyCode)) {
            this.setHandlesInput(true);
            if (this.useSoftkeys) {
                this.T9_COMMAND.setDisposesDialog(false);
                this.DELETE_COMMAND.setDisposesDialog(false);
                this.originalClearCommand = this.installCommands(this.DELETE_COMMAND, this.T9_COMMAND);
            } else {
                Form f = this.getComponentForm();
                if (f != null) {
                    this.originalClearCommand = f.getClearCommand();
                    f.setClearCommand(this.DELETE_COMMAND);
                }
            }
            return;
        }
        this.moveCursor(Display.getInstance().getGameAction(keyCode));
        if (this.handlesInput() && this.isEditingEndTrigger(keyCode)) {
            this.setHandlesInput(false);
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form f = this.getComponentForm();
                if (f != null) {
                    f.setClearCommand(this.originalClearCommand);
                    this.originalClearCommand = null;
                }
            }
            this.fireActionEvent();
            return;
        }
        if (this.handlesInput()) {
            return;
        }
        super.keyPressed(keyCode);
    }

    protected Command installCommands(Command clear, Command t9) {
        Form f = this.getComponentForm();
        if (f != null) {
            Command original = f.getClearCommand();
            if (original instanceof CommandHandler) {
                original = this.originalClearCommand;
            }
            if (this.replaceMenu && this.originalCommands == null) {
                this.originalCommands = new Command[f.getCommandCount()];
                int olen = this.originalCommands.length;
                for (int iter = 0; iter < olen; ++iter) {
                    this.originalCommands[iter] = f.getCommand(iter);
                }
                f.removeAllCommands();
                if (Display.getInstance().isThirdSoftButton()) {
                    this.getComponentForm().getMenuBar().addSelectCommand(this.getSelectCommandText());
                    this.selectCommand = this.getComponentForm().getCommand(0);
                }
            }
            f.addCommand(clear, 0);
            f.addCommand(t9, 0);
            f.setClearCommand(clear);
            f.revalidate();
            return original;
        }
        return null;
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    protected void fireClicked() {
        if (useNativeTextInput && Display.getInstance().isNativeInputSupported()) {
            super.fireClicked();
            return;
        }
        if (!this.handlesInput()) {
            this.setHandlesInput(true);
            if (this.useSoftkeys) {
                this.T9_COMMAND.setDisposesDialog(false);
                this.DELETE_COMMAND.setDisposesDialog(false);
                this.originalClearCommand = this.installCommands(this.DELETE_COMMAND, this.T9_COMMAND);
            } else {
                Form f = this.getComponentForm();
                this.originalClearCommand = f.getClearCommand();
                f.setClearCommand(this.DELETE_COMMAND);
            }
            return;
        }
        if (this.handlesInput()) {
            this.setHandlesInput(false);
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form f = this.getComponentForm();
                f.setClearCommand(this.originalClearCommand);
                this.originalClearCommand = null;
            }
            this.fireActionEvent();
        } else if (this.handlesInput()) {
            // empty if block
        }
    }

    protected void removeCommands(Command clear, Command t9, Command originalClear) {
        Form f = this.getComponentForm();
        if (f != null) {
            f.removeCommand(clear);
            f.removeCommand(t9);
            if (this.selectCommand != null) {
                f.removeCommand(this.selectCommand);
            }
            f.setClearCommand(this.originalClearCommand);
            if (this.replaceMenu && this.originalCommands != null) {
                int olen = this.originalCommands.length;
                for (int iter = olen - 1; iter >= 0; --iter) {
                    f.addCommand(this.originalCommands[iter]);
                }
                this.originalCommands = null;
            }
            f.revalidate();
        }
    }

    void focusLostInternal() {
        Form f;
        this.stopComponentLableTicker();
        if (this.handlesInput() || this.pressedAndNotReleased || this.pendingCommit) {
            this.setHandlesInput(false);
            f = this.getComponentForm();
            if (f != null) {
                if (this.useSoftkeys) {
                    this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
                } else {
                    f.setClearCommand(this.originalClearCommand);
                }
            }
            this.releaseTime = System.currentTimeMillis();
            this.commitChange();
            this.pressedAndNotReleased = false;
            this.longClick = false;
        }
        if (this.isEditing()) {
            this.fireActionEvent();
            this.setSuppressActionEvent(true);
        }
        if ((f = this.getComponentForm()) != null) {
            if (f.getFocused() instanceof TextField) {
                return;
            }
            if (f.getFocused() instanceof TextArea && Display.getInstance().isNativeInputSupported()) {
                return;
            }
            Display.getInstance().setShowVirtualKeyboard(false);
        }
    }

    void focusGainedInternal() {
        this.setSuppressActionEvent(false);
        this.startComponentLableTicker();
        this.releaseTime = System.currentTimeMillis();
        this.pressedAndNotReleased = false;
        this.longClick = false;
    }

    protected boolean isEditingTrigger(int keyCode) {
        if (!this.isEditable()) {
            return false;
        }
        int gk = Display.getInstance().getGameAction(keyCode);
        if (this.isQwertyInput()) {
            return keyCode > 0 || gk == 8 || this.isClearKey(keyCode) || this.isEnterKey(keyCode) || this.leftAndRightEditingTrigger && (gk == 2 || gk == 5);
        }
        return keyCode >= 48 && keyCode <= 57 || this.isClearKey(keyCode) || gk == 8 || this.leftAndRightEditingTrigger && (gk == 2 || gk == 5);
    }

    protected boolean isEditingEndTrigger(int keyCode) {
        int k = Display.getInstance().getGameAction(keyCode);
        boolean endTrigger = false;
        endTrigger = this.isQwertyInput() ? (this.isSingleLineTextArea() ? keyCode < 0 && (k == 8 || k == 1 || k == 6 || this.isEnterKey(keyCode)) : keyCode < 0 && k == 8) : (this.isSingleLineTextArea() ? k == 8 || k == 1 || k == 6 : k == 8);
        return endTrigger;
    }

    public void paint(Graphics g) {
        if (useNativeTextInput && Display.getInstance().isNativeEditorVisible(this)) {
            if (!Display.impl.nativeEditorPaintsHint()) {
                this.paintHint(g);
            }
            return;
        }
        UIManager manager = this.getUIManager();
        manager.getLookAndFeel().drawTextField(g, this);
        if (this.drawCursor && this.hasFocus() && this.isEditable()) {
            manager.getLookAndFeel().drawTextFieldCursor(g, this);
        }
        this.paintHint(g);
    }

    protected Dimension calcPreferredSize() {
        if (this.isSingleLineTextArea()) {
            return this.getUIManager().getLookAndFeel().getTextFieldPreferredSize(this);
        }
        return this.getUIManager().getLookAndFeel().getTextAreaSize(this, true);
    }

    void initComponentImpl() {
        super.initComponentImpl();
        boolean rtl = this.isRTL();
        this.keyFwd = rtl ? 2 : 5;
        this.keyBack = rtl ? 5 : 2;
        Form f = this.getComponentForm();
        if (f != null) {
            f.registerAnimated(this);
        }
    }

    public int getCursorBlinkTimeOn() {
        return this.blinkOnTime;
    }

    public void setCursorBlinkTimeOn(int time) {
        this.blinkOnTime = time;
    }

    public int getCursorBlinkTimeOff() {
        return this.blinkOffTime;
    }

    public void setCursorBlinkTimeOff(int time) {
        this.blinkOffTime = time;
    }

    public boolean animate() {
        boolean ani = super.animate();
        if (Display.getInstance().isNativeEditorVisible(this)) {
            return ani;
        }
        if (this.hasFocus() && this.isVisible()) {
            long currentTime = System.currentTimeMillis();
            if (this.drawCursor) {
                if (currentTime - this.cursorBlinkTime > (long)this.blinkOnTime) {
                    this.cursorBlinkTime = currentTime;
                    this.drawCursor = false;
                    return true;
                }
            } else if (currentTime - this.cursorBlinkTime > (long)this.blinkOffTime) {
                this.cursorBlinkTime = currentTime;
                this.drawCursor = true;
                return true;
            }
            if (this.pressedAndNotReleased) {
                if (currentTime - this.pressTime >= (long)this.getLongClickDuration()) {
                    this.pressedAndNotReleased = false;
                    this.longClick(this.pressedKeyCode);
                }
            } else if (this.pendingCommit && currentTime - this.releaseTime > (long)this.commitTimeout) {
                this.commitChange();
            }
        } else {
            this.drawCursor = false;
        }
        return ani;
    }

    public void pointerReleased(int x, int y) {
        int width;
        int line;
        if (useNativeTextInput && Display.getInstance().isNativeInputSupported()) {
            super.pointerReleased(x, y);
            return;
        }
        int lineHeight = this.getStyle().getFont().getHeight() + this.getRowsGap();
        this.cursorY = line = (y - this.getAbsoluteY()) / lineHeight;
        this.cursorY = Math.min(this.cursorY, this.getLines() - 1);
        this.cursorY = Math.max(this.cursorY, 0);
        String text = this.getTextAt(this.cursorY);
        int textLength = text.length();
        int position = 0;
        Font f = this.getStyle().getFont();
        x -= this.getAbsoluteX();
        int iter = 0;
        while (iter < textLength && x > (width = f.substringWidth(text, 0, iter))) {
            position = iter++;
        }
        if (position == textLength - 1 && f.stringWidth(text) < x) {
            position = textLength;
        }
        this.cursorX = position;
        if (!this.isEditable()) {
            return;
        }
        super.pointerReleased(x, y);
    }

    public boolean isUseSoftkeys() {
        return this.useSoftkeys;
    }

    public void setUseSoftkeys(boolean useSoftkeys) {
        this.useSoftkeys = useSoftkeys;
    }

    void onEditComplete(String text) {
        super.onEditComplete(text);
        this.setCursorPosition(text.length());
    }

    public boolean isReplaceMenu() {
        return this.replaceMenu;
    }

    public void setReplaceMenu(boolean replaceMenu) {
        this.replaceMenu = replaceMenu;
    }

    public boolean isOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(boolean overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public boolean isLeftAndRightEditingTrigger() {
        return this.leftAndRightEditingTrigger;
    }

    public void setLeftAndRightEditingTrigger(boolean leftAndRightEditingTrigger) {
        this.leftAndRightEditingTrigger = leftAndRightEditingTrigger;
    }

    public void setAlignment(int align) {
        if (align == 4) {
            throw new IllegalArgumentException("CENTER alignment is not supported in TextField.");
        }
        super.setAlignment(align);
    }

    protected TextSelection.Spans calculateTextSelectionSpan(TextSelection sel) {
        return this.getUIManager().getLookAndFeel().calculateTextFieldSpan(sel, this);
    }

    static {
        defaultInputModeOrder = new String[]{"Abc", "ABC", "abc", "123"};
        firstUppercaseInputMode = new Vector();
        qwertyAutoDetect = true;
        defaultChangeInputModeKey = 35;
        defaultSymbolDialogKey = 42;
        useNativeTextInput = true;
        symbolTable = DEFAULT_SYMBOL_TABLE;
    }

    class CommandHandler
    extends Command {
        CommandHandler(String title, int id) {
            super(title, id);
        }

        public void actionPerformed(ActionEvent ev) {
            ev.consume();
            switch (this.getId()) {
                case 1: {
                    TextField.this.releaseTime = System.currentTimeMillis();
                    TextField.this.pressedAndNotReleased = false;
                    TextField.this.longClick = false;
                    TextField.this.deleteChar();
                    break;
                }
                case 2: {
                    ev.consume();
                    TextField.this.editString();
                }
            }
        }
    }
}

