/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.io.CharArrayReader;
import com.codename1.io.JSONParser;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.ui.Button;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Label;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.GridLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.table.TableLayout;
import com.codename1.xml.Element;
import com.codename1.xml.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFragment {
    private final Element root;
    private Container view;
    private ComponentFactory factory = new DefaultComponentFactory();
    private final Map<String, Component> index = new HashMap<String, Component>();
    private final Map<String, Component> parameters = new HashMap<String, Component>();

    private UIFragment(Element el) {
        this.root = el;
    }

    public static UIFragment parseXML(InputStream input) {
        try {
            XMLParser p = new XMLParser();
            Element el = p.parse(new InputStreamReader(input));
            return new UIFragment(el);
        }
        catch (Exception ex) {
            Log.e(ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static UIFragment parseXML(String xml) {
        try {
            XMLParser p = new XMLParser();
            p.setCaseSensitive(true);
            Element el = p.parse(new CharArrayReader(xml.toCharArray()));
            return new UIFragment(el);
        }
        catch (Exception ex) {
            Log.e(ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static UIFragment parseJSON(String json) {
        try {
            Element el = UINotationParser.parseJSONNotation(json);
            return new UIFragment(el);
        }
        catch (Exception ex) {
            Log.e(ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    private static boolean inArray(Object needle, Object[] haystack) {
        int len = haystack.length;
        for (int i = 0; i < len; ++i) {
            if (!needle.equals(haystack[i])) continue;
            return true;
        }
        return false;
    }

    public Container getView() {
        if (this.view == null) {
            this.view = (Container)this.getFactory().newComponent(this.root);
            this.decorate(this.root, this.view);
            this.build(this.root, this.view);
        }
        return this.view;
    }

    private void decorate(Element el, Component cmp) {
        String flags;
        String name;
        String id;
        String uiid;
        String classAttr = el.getAttribute("class");
        if (classAttr != null && classAttr.length() > 0) {
            String[] tags = Util.split(classAttr, " ");
            ComponentSelector.$(cmp).addTags(tags);
        }
        if ((uiid = el.getAttribute("uiid")) != null && uiid.length() > 0) {
            cmp.setUIID(uiid);
        }
        if ((id = el.getAttribute("id")) != null && id.length() > 0) {
            this.index.put(id, cmp);
        }
        if ((name = el.getAttribute("name")) != null && name.length() > 0) {
            cmp.setName(name);
        }
        if ((flags = el.getAttribute("flags")) != null && flags.indexOf("safeArea") >= 0 && cmp instanceof Container) {
            ((Container)cmp).setSafeArea(true);
        }
    }

    private List<Element> getChildren(Element el) {
        String tagName = el.getTagName();
        if ("table".equals(tagName)) {
            ArrayList<Element> out = new ArrayList<Element>();
            for (Object row : el.getChildrenByTagName("tr")) {
                Element erow = (Element)row;
                for (Object cell : erow.getChildrenByTagName("td")) {
                    Element ecell = (Element)cell;
                    if (ecell.getNumChildren() <= 0) continue;
                    out.add(ecell.getChildAt(0));
                }
            }
            return out;
        }
        ArrayList<Element> out = new ArrayList<Element>();
        int len = el.getNumChildren();
        for (int i = 0; i < len; ++i) {
            out.add(el.getChildAt(i));
        }
        return out;
    }

    private void build(Element model, Container view) {
        List<Element> children = this.getChildren(model);
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Component cmp;
            Element child = children.get(i);
            if (child.isTextElement()) continue;
            String tagName = child.getTagName();
            if (tagName.startsWith("$")) {
                String pname = tagName.substring(1);
                if (!this.parameters.containsKey(pname)) {
                    throw new IllegalArgumentException("Missing parameter " + pname);
                }
                cmp = this.parameters.get(pname);
                this.decorate(child, cmp);
            } else {
                cmp = this.getFactory().newComponent(child);
                this.decorate(child, cmp);
            }
            Object constraint = this.getFactory().newConstraint(view, model, cmp, child);
            view.add(constraint, cmp);
            if (!(cmp instanceof Container)) continue;
            this.build(child, (Container)cmp);
        }
    }

    private void reset() {
        this.view = null;
        this.index.clear();
    }

    public UIFragment set(String paramName, Component param) {
        if (this.view != null) {
            this.reset();
        }
        this.parameters.put(paramName, param);
        if (param != null && param.getName() == null) {
            param.setName(paramName);
        }
        return this;
    }

    public Component findById(String id) {
        this.getView();
        return this.index.get(id.toLowerCase());
    }

    public ComponentFactory getFactory() {
        return this.factory;
    }

    public UIFragment setFactory(ComponentFactory factory) {
        this.factory = factory;
        return this;
    }

    private static class UINotationParser {
        private static final String[] ATTRIBUTES = new String[]{"uiid", "id", "class", "cols", "rows", "align", "valign", "name", "grow", "noGrow", "behaviour", "behavior", "bottomLast"};
        private static final String[] BORDER_LAYOUT_CONSTRAINTS = new String[]{"north", "south", "east", "west", "overlay", "center"};
        private static final String[] BORDER_LAYOUT_SINGLE_CHAR_ALIASES = new String[]{"n", "s", "e", "w", "c", "o"};
        private static final String[] BORDER_LAYOUT_KEYS = new String[]{"north", "south", "east", "west", "overlay", "center", "n", "s", "e", "w", "c", "o", "centerAbsolute", "centerScale", "centerAbs", "centerTotalBelow", "ca", "cs", "ctb"};
        private static final String[] BORDER_LAYOUT_CENTER_ALIASES = new String[]{"c", "centerAbsolute", "centerScale", "centerAbs", "centerTotalBelow", "ca", "cs", "ctb"};

        private UINotationParser() {
        }

        private static Map parseJSON(String json) throws IOException {
            JSONParser parser = new JSONParser();
            parser.setStrict(false);
            return parser.parseJSON(new CharArrayReader(json.toCharArray()));
        }

        private static Element parseJSONNotation(String json) throws IOException {
            Map m = UINotationParser.parseJSON(json);
            return UINotationParser.buildXMLFromJSONNotation(m);
        }

        private static boolean isBorderLayout(Map m) {
            for (String key : BORDER_LAYOUT_KEYS) {
                if (!m.containsKey(key)) continue;
                return true;
            }
            return false;
        }

        private static void setBorderLayoutBehaviour(Map m) {
            if (m.containsKey("behavior")) {
                return;
            }
            if (m.containsKey("centerAbsolute") || m.containsKey("ca") || m.containsKey("centerAbs")) {
                m.put("behavior", "absolute");
                return;
            }
            if (m.containsKey("centerScale") || m.containsKey("cs")) {
                m.put("behavior", "scale");
                return;
            }
            if (m.containsKey("centerTotalBelow") || m.containsKey("ctb")) {
                m.put("behavior", "totalBelow");
            }
        }

        private static boolean isBoxLayoutX(Map m) {
            return m.containsKey("x") || m.containsKey("xng") || m.containsKey("xNoGrow");
        }

        private static void setBoxLayoutXNoGrow(Map m) {
            if (m.containsKey("xNoGrow")) {
                m.put("x", m.get("xNoGrow"));
                m.put("noGrow", "true");
                return;
            }
            if (m.containsKey("xng")) {
                m.put("x", m.get("xng"));
                m.put("noGrow", "true");
            }
        }

        private static void setBoxLayoutYBottomLast(Map m) {
            if (m.containsKey("yBottom")) {
                m.put("y", m.get("yBottom"));
                m.put("bottomLast", "true");
                return;
            }
            if (m.containsKey("yBottomLast")) {
                m.put("y", m.get("yBottomLast"));
                m.put("bottomLast", "true");
                return;
            }
            if (m.containsKey("ybl")) {
                m.put("y", m.get("ybl"));
                m.put("bottomLast", "true");
            }
        }

        private static boolean isBoxLayoutY(Map m) {
            return m.containsKey("y") || m.containsKey("yBottom") || m.containsKey("yBottomLast") || m.containsKey("ybl");
        }

        private static boolean isGridLayout(Map m) {
            return m.containsKey("grid");
        }

        private static boolean isFlowLayout(Map m) {
            return m.containsKey("flow");
        }

        private static boolean isLayered(Map m) {
            return m.containsKey("layered");
        }

        private static boolean isTableLayout(Map m) {
            return m.containsKey("table");
        }

        private static Element buildXMLFromJSONNotation(Object o) throws IOException {
            Element el = null;
            if (o instanceof Map) {
                Map m = (Map)o;
                if (m.get("root") != null) {
                    return UINotationParser.buildXMLFromJSONNotation(m.get("root"));
                }
                Object children = null;
                if (UINotationParser.isBorderLayout(m)) {
                    UINotationParser.setBorderLayoutBehaviour(m);
                    el = new Element("border");
                } else if (UINotationParser.isBoxLayoutX(m)) {
                    UINotationParser.setBoxLayoutXNoGrow(m);
                    el = new Element("x");
                    children = m.get("x");
                } else if (UINotationParser.isBoxLayoutY(m)) {
                    UINotationParser.setBoxLayoutYBottomLast(m);
                    el = new Element("y");
                    children = m.get("y");
                } else if (UINotationParser.isGridLayout(m)) {
                    el = new Element("grid");
                    children = m.get("grid");
                } else if (UINotationParser.isLayered(m)) {
                    el = new Element("layered");
                    children = m.get("layered");
                } else if (UINotationParser.isFlowLayout(m)) {
                    el = new Element("flow");
                    children = m.get("flow");
                } else if (UINotationParser.isTableLayout(m)) {
                    el = new Element("table");
                    children = m.get("table");
                }
                if (children instanceof List) {
                    if (UINotationParser.isTableLayout(m)) {
                        for (Object child : (List)children) {
                            if (child instanceof List) {
                                Element row = new Element("tr");
                                for (Object cell : (List)child) {
                                    Element td = new Element("td");
                                    td.addChild(UINotationParser.buildXMLFromJSONNotation(cell));
                                    row.addChild(td);
                                }
                                el.addChild(row);
                                continue;
                            }
                            throw new RuntimeException("Tables require 2D array representing rows and columns");
                        }
                    } else {
                        for (Object child : (List)children) {
                            el.addChild(UINotationParser.buildXMLFromJSONNotation(child));
                        }
                    }
                } else if (UINotationParser.isBorderLayout(m)) {
                    block11: for (String string : BORDER_LAYOUT_SINGLE_CHAR_ALIASES) {
                        if (!m.containsKey(string)) continue;
                        char c = string.charAt(0);
                        switch (c) {
                            case 'n': {
                                m.put("north", m.get("n"));
                                continue block11;
                            }
                            case 's': {
                                m.put("south", m.get("s"));
                                continue block11;
                            }
                            case 'e': {
                                m.put("east", m.get("e"));
                                continue block11;
                            }
                            case 'w': {
                                m.put("west", m.get("w"));
                                continue block11;
                            }
                            case 'c': {
                                m.put("center", m.get("c"));
                                continue block11;
                            }
                            case 'o': {
                                m.put("overlay", m.get("o"));
                            }
                        }
                    }
                    if (!m.containsKey("center")) {
                        for (String string : BORDER_LAYOUT_CENTER_ALIASES) {
                            if (!m.containsKey(string)) continue;
                            m.put("center", m.get(string));
                            break;
                        }
                    }
                    for (String string : BORDER_LAYOUT_CONSTRAINTS) {
                        if (!m.containsKey(string)) continue;
                        Element north = UINotationParser.buildXMLFromJSONNotation(m.get(string));
                        north.setAttribute("constraint", string);
                        el.addChild(north);
                    }
                } else {
                    el.addChild(UINotationParser.buildXMLFromJSONNotation(children));
                }
                for (String string : ATTRIBUTES) {
                    if (!m.containsKey(string)) continue;
                    Object val = m.get(string);
                    if (val instanceof Double && ("cols".equals(string) || "rows".equals(string))) {
                        val = ((Double)val).intValue();
                    }
                    el.setAttribute(string, String.valueOf(val));
                }
                return el;
            }
            if (o instanceof List) {
                List l = (List)o;
                int len = l.size();
                if (len > 0) {
                    Object first = l.get(0);
                    if (first instanceof String) {
                        String s = (String)first;
                        el = "x".equals(first) ? new Element("x") : ("y".equals(first) ? new Element("y") : ("grid".equals(first) ? new Element("grid") : ("layered".equals(first) ? new Element("layered") : new Element("flow"))));
                        if (!UIFragment.inArray(s, new String[]{"x", "y", "grid", "flow", "layered"})) {
                            el.addChild(UINotationParser.buildXMLFromJSONNotation(first));
                        }
                    } else {
                        el.addChild(UINotationParser.buildXMLFromJSONNotation(first));
                    }
                    for (int i = 1; i < len; ++i) {
                        Element child = UINotationParser.buildXMLFromJSONNotation(l.get(i));
                        el.addChild(child);
                    }
                } else {
                    el = new Element("flow");
                }
                return el;
            }
            if (o instanceof String) {
                String str = (String)o;
                if (str.startsWith("$")) {
                    el = new Element(str);
                    return el;
                }
                el = new Element("label");
                Element textEl = new Element(null, true);
                textEl.setText(str);
                el.addChild(textEl);
                return el;
            }
            throw new IOException("Unexpected token type in UINotation: " + o);
        }
    }

    public static class DefaultComponentFactory
    implements ComponentFactory {
        private static int centerBehaviour(String behaviour) {
            if ("scale".equalsIgnoreCase(behaviour)) {
                return 0;
            }
            if ("absolute".equalsIgnoreCase(behaviour)) {
                return 2;
            }
            if ("center".equalsIgnoreCase(behaviour)) {
                return 1;
            }
            if ("totalBelow".equalsIgnoreCase(behaviour)) {
                return 3;
            }
            return 0;
        }

        private static boolean grow(String grow) {
            return "true".equalsIgnoreCase(grow);
        }

        private static int align(String align) {
            if ("left".equals(align)) {
                return 1;
            }
            if ("right".equals(align)) {
                return 3;
            }
            if ("center".equals(align)) {
                return 4;
            }
            return 0;
        }

        private static int valign(String valign) {
            if ("top".equals(valign)) {
                return 0;
            }
            if ("center".equals(valign)) {
                return 4;
            }
            if ("bottom".equals(valign)) {
                return 2;
            }
            return 0;
        }

        private static boolean empty(Element el, String attName) {
            String val = el.getAttribute(attName);
            return val == null || val.length() == 0;
        }

        public Component newComponent(Element el) {
            String name = el.getTagName().toLowerCase();
            if (name.startsWith("border")) {
                BorderLayout l = new BorderLayout();
                if (name.startsWith("borderabs")) {
                    l.setCenterBehavior(2);
                } else if (name.startsWith("borderscale")) {
                    l.setCenterBehavior(0);
                } else if (name.startsWith("bordertotalbelow")) {
                    l.setCenterBehavior(3);
                } else if (!DefaultComponentFactory.empty(el, "behaviour")) {
                    l.setCenterBehavior(DefaultComponentFactory.centerBehaviour(el.getAttribute("behaviour")));
                } else if (!DefaultComponentFactory.empty(el, "behavior")) {
                    l.setCenterBehavior(DefaultComponentFactory.centerBehaviour(el.getAttribute("behavior")));
                }
                return new Container(l);
            }
            if (name.startsWith("y")) {
                BoxLayout l = name.startsWith("ybottom") || name.equals("ybl") ? new BoxLayout(4) : ("true".equalsIgnoreCase(el.getAttribute("bottomLast")) ? new BoxLayout(4) : new BoxLayout(2));
                return new Container(l);
            }
            if (name.startsWith("x")) {
                BoxLayout l = name.startsWith("xnogrow") || name.equals("xng") ? new BoxLayout(3) : ("true".equalsIgnoreCase(el.getAttribute("noGrow")) || "false".equalsIgnoreCase(el.getAttribute("grow")) ? new BoxLayout(3) : new BoxLayout(1));
                return new Container(l);
            }
            if (name.equals("flow")) {
                FlowLayout fl = new FlowLayout();
                String align = el.getAttribute("align");
                String valign = el.getAttribute("valign");
                if (align != null && align.length() > 0) {
                    fl.setAlign(DefaultComponentFactory.align(align));
                }
                if (valign != null && valign.length() > 0) {
                    fl.setValign(DefaultComponentFactory.valign(valign));
                }
                return new Container(fl);
            }
            if (name.equals("grid")) {
                int rows;
                int cols;
                block28: {
                    String colsStr = el.getAttribute("cols");
                    try {
                        cols = Integer.parseInt(colsStr);
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("grid requires cols attribute.");
                    }
                    String rowsStr = el.getAttribute("rows");
                    rows = -1;
                    try {
                        rows = Integer.parseInt(rowsStr);
                    }
                    catch (Throwable t) {
                        rows = (int)Math.ceil((double)el.getNumChildren() / (double)cols);
                        if (rows != 0) break block28;
                        rows = 1;
                    }
                }
                return new Container(new GridLayout(rows, cols));
            }
            if (name.equals("table")) {
                String colsStr = el.getAttribute("cols");
                String rowsStr = el.getAttribute("rows");
                int rows = -1;
                int cols = -1;
                if (colsStr != null && colsStr.length() > 0) {
                    cols = Integer.parseInt(colsStr);
                }
                if (rowsStr != null && rowsStr.length() > 0) {
                    rows = Integer.parseInt(rowsStr);
                }
                Vector children = el.getChildrenByTagName("tr");
                if (rows < 0) {
                    rows = children.size();
                }
                if (cols < 0 && children.size() > 0) {
                    Element firstRow = (Element)children.get(0);
                    Vector firstRowCols = firstRow.getChildrenByTagName("td");
                    cols = firstRowCols.size();
                }
                rows = Math.max(1, rows);
                cols = Math.max(1, cols);
                TableLayout tl = new TableLayout(rows, cols);
                return new Container(tl);
            }
            if (name.equals("layered")) {
                return new Container(new LayeredLayout());
            }
            if (name.equals("label")) {
                Element textEl = el.getNumChildren() > 0 ? el.getChildAt(0) : null;
                String text = textEl != null ? textEl.getText() : "";
                return new Label(text);
            }
            if (name.equals("button")) {
                Element textEl = el.getNumChildren() > 0 ? el.getChildAt(0) : null;
                String text = textEl != null ? textEl.getText() : "";
                return new Button(text);
            }
            throw new IllegalArgumentException("Unsupported element " + name);
        }

        public Object newConstraint(Container parent, Element parentEl, Component child, Element childEl) {
            Layout l = parent.getLayout();
            if (l instanceof BorderLayout) {
                String cnst = childEl.getAttribute("constraint");
                if (cnst == null) {
                    return "Center";
                }
                if ("north".equals(cnst = cnst.toLowerCase())) {
                    return "North";
                }
                if ("south".equals(cnst)) {
                    return "South";
                }
                if ("east".equals(cnst)) {
                    return "East";
                }
                if ("west".equals(cnst)) {
                    return "West";
                }
                if ("center".equals(cnst)) {
                    return "Center";
                }
                if ("overlay".equals(cnst)) {
                    return "Overlay";
                }
                throw new IllegalArgumentException("Unsupported constraint " + cnst);
            }
            return null;
        }
    }

    public static interface ComponentFactory {
        public Component newComponent(Element var1);

        public Object newConstraint(Container var1, Element var2, Component var3, Element var4);
    }
}

