/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.animations;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Painter;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.geom.GeneralPath;
import com.codename1.ui.plaf.Style;

public class BubbleTransition
extends Transition {
    private Component originSrc;
    private Component originDest;
    private Image destBuffer;
    private Motion clipMotion;
    private Motion locMotionX;
    private Motion locMotionY;
    private int duration = 200;
    private int clipSize;
    private int x;
    private int y;
    private String componentName;
    private boolean roundBubble = true;
    private GeneralPath bubbleShape;

    public BubbleTransition() {
    }

    public BubbleTransition(int duration) {
        this.duration = duration;
    }

    public BubbleTransition(int duration, String componentName) {
        this(duration);
        this.componentName = componentName;
    }

    private static Component findByName(Container root, String componentName) {
        int count = root.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            Component c = root.getComponentAt(iter);
            String n = c.getName();
            if (n != null && n.equals(componentName)) {
                return c;
            }
            if (!(c instanceof Container) || (c = BubbleTransition.findByName((Container)c, componentName)) == null) continue;
            return c;
        }
        return null;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void initTransition() {
        Component src;
        Graphics g;
        Dialog dlg;
        Component source = this.getSource();
        Component destination = this.getDestination();
        int w = source.getWidth();
        int h = source.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        Form sourceForm = source.getComponentForm();
        this.originSrc = BubbleTransition.findByName(sourceForm, this.componentName);
        Form destForm = destination.getComponentForm();
        this.originDest = BubbleTransition.findByName(destForm, this.componentName);
        Display d = Display.getInstance();
        if (this.getDestination() instanceof Dialog) {
            dlg = (Dialog)destination;
            this.destBuffer = Image.createImage(Math.min(d.getDisplayWidth(), this.getDialogParent(dlg).getWidth()), Math.min(d.getDisplayHeight(), dlg.getContentPane().getParent().getHeight()), 0);
            g = this.destBuffer.getGraphics();
            Style stl = dlg.getDialogComponent().getStyle();
            byte bgt = stl.getBgTransparency();
            stl.setBgTransparency(255);
            this.drawDialogCmp(this.destBuffer.getGraphics(), dlg);
            stl.setBgTransparency(bgt & 0xFF, true);
        } else if (this.getSource() instanceof Dialog) {
            dlg = (Dialog)source;
            this.destBuffer = Image.createImage(Math.min(d.getDisplayWidth(), this.getDialogParent(dlg).getWidth()), Math.min(d.getDisplayHeight(), dlg.getContentPane().getParent().getHeight()), 0);
            g = this.destBuffer.getGraphics();
            Style stl = dlg.getDialogComponent().getStyle();
            byte bgt = stl.getBgTransparency();
            stl.setBgTransparency(255);
            this.drawDialogCmp(this.destBuffer.getGraphics(), dlg);
            stl.setBgTransparency(bgt & 0xFF, true);
        } else if (this.originDest != null) {
            this.destBuffer = this.createMutableImage(source.getWidth(), source.getHeight());
            this.paint(this.destBuffer.getGraphics(), source, -source.getAbsoluteX(), -source.getAbsoluteY());
        } else {
            this.destBuffer = this.createMutableImage(destination.getWidth(), destination.getHeight());
            this.paint(this.destBuffer.getGraphics(), destination, -destination.getAbsoluteX(), -destination.getAbsoluteY());
        }
        Component dest = this.getDestination();
        if (dest instanceof Dialog) {
            dest = this.getDialogParent(dest);
        }
        if ((src = this.getSource()) instanceof Dialog) {
            src = this.getDialogParent(src);
        }
        if (this.originSrc != null) {
            this.locMotionX = Motion.createLinearMotion(this.originSrc.getAbsoluteX() + this.originSrc.getWidth() / 2 - dest.getWidth() / 2, dest.getAbsoluteX(), this.duration);
            this.locMotionX.start();
            this.locMotionY = Motion.createLinearMotion(this.originSrc.getAbsoluteY() + this.originSrc.getHeight() / 2 - dest.getHeight() / 2, dest.getAbsoluteY(), this.duration);
            this.locMotionY.start();
            this.clipMotion = Motion.createLinearMotion(Math.min(this.originSrc.getWidth(), this.originSrc.getHeight()), Math.max(dest.getWidth(), dest.getHeight()) * 3 / 2, this.duration);
        } else if (this.originDest != null) {
            this.locMotionX = Motion.createLinearMotion(src.getAbsoluteX(), this.originDest.getAbsoluteX() + this.originDest.getWidth() / 2 - src.getWidth() / 2, this.duration);
            this.locMotionX.start();
            this.locMotionY = Motion.createLinearMotion(src.getAbsoluteY(), this.originDest.getAbsoluteY() + this.originDest.getHeight() / 2 - src.getHeight() / 2, this.duration);
            this.locMotionY.start();
            this.clipMotion = Motion.createLinearMotion(Math.max(src.getWidth(), src.getHeight()) * 3 / 2, Math.min(this.originDest.getWidth(), this.originDest.getHeight()), this.duration);
        } else {
            this.x = dest.getAbsoluteX();
            this.y = dest.getAbsoluteY();
            this.clipMotion = Motion.createLinearMotion(0, Math.max(dest.getWidth(), dest.getHeight()) * 3 / 2, this.duration);
        }
        this.clipMotion.start();
    }

    public boolean animate() {
        this.clipSize = this.clipMotion.getValue();
        if (this.originSrc != null || this.originDest != null) {
            this.x = this.locMotionX.getValue();
            this.y = this.locMotionY.getValue();
        }
        return !this.clipMotion.isFinished();
    }

    private GeneralPath getBubbleShape() {
        if (this.bubbleShape == null) {
            this.bubbleShape = new GeneralPath();
        }
        return this.bubbleShape;
    }

    public void paint(Graphics g) {
        Component source = this.getSource();
        Component dest = this.getDestination();
        Component srcCmp = source;
        Component destCmp = dest;
        if (source instanceof Dialog && dest instanceof Form || this.originDest != null) {
            srcCmp = dest;
            destCmp = source;
        }
        this.paint(g, srcCmp, -srcCmp.getAbsoluteX(), -srcCmp.getAbsoluteY(), true);
        int[] clip = g.getClip();
        if (destCmp instanceof Dialog) {
            destCmp = this.getDialogParent(destCmp);
        }
        if (this.roundBubble && g.isShapeClipSupported()) {
            GeneralPath p = this.getBubbleShape();
            p.reset();
            p.arc((double)(this.x + destCmp.getWidth() / 2 - this.clipSize / 2), (double)(this.y + destCmp.getHeight() / 2 - this.clipSize / 2), (double)this.clipSize, (double)this.clipSize, 0.0, Math.toRadians(360.0));
            g.setClip(p);
        } else {
            g.setClip(this.x + destCmp.getWidth() / 2 - this.clipSize / 2, this.y + destCmp.getHeight() / 2 - this.clipSize / 2, this.clipSize, this.clipSize);
        }
        g.drawImage(this.destBuffer, this.x, this.y);
        g.setClip(clip);
    }

    public void setRoundBubble(boolean roundBubble) {
        this.roundBubble = roundBubble;
    }

    private Image createMutableImage(int w, int h) {
        Display d = Display.getInstance();
        return Image.createImage(Math.min(d.getDisplayWidth(), w), Math.min(d.getDisplayHeight(), h));
    }

    private void paint(Graphics g, Component cmp, int x, int y) {
        this.paint(g, cmp, x, y, false);
    }

    private void paint(Graphics g, Component cmp, int x, int y, boolean background) {
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        g.translate(x, y);
        if (cmp instanceof Dialog) {
            ((Dialog)cmp).getDialogComponent().paintComponent(g);
        } else {
            cmp.paintComponent(g, background);
        }
        g.translate(-x, -y);
        g.setClip(cx, cy, cw, ch);
    }

    public void cleanup() {
        this.destBuffer = null;
        this.originSrc = null;
        this.originDest = null;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    private void drawDialogCmp(Graphics g, Dialog dlg) {
        Container menuBar;
        Painter p = dlg.getStyle().getBgPainter();
        dlg.getStyle().setBgPainter(null);
        g.setClip(0, 0, dlg.getWidth(), dlg.getHeight());
        g.translate(-this.getDialogParent(dlg).getX(), -this.getDialogParent(dlg).getY());
        this.getDialogParent(dlg).paintComponent(g, false);
        if (dlg.getCommandCount() > 0 && (menuBar = dlg.getSoftButton(0).getParent()) != null) {
            g.setClip(0, 0, dlg.getWidth(), dlg.getHeight());
            menuBar.paintComponent(g, false);
        }
        dlg.getStyle().setBgPainter(p);
    }

    private Container getDialogParent(Component dlg) {
        return ((Dialog)dlg).getDialogComponent();
    }

    public Transition copy(boolean reverse) {
        BubbleTransition bt = new BubbleTransition(this.duration, this.componentName);
        bt.roundBubble = this.roundBubble;
        return bt;
    }
}

