/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.animations;

import com.codename1.io.Log;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Painter;
import com.codename1.ui.RGBImage;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.animations.Timeline;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.plaf.Style;
import com.codename1.util.LazyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonTransitions
extends Transition {
    public static final int SLIDE_HORIZONTAL = 0;
    public static final int SLIDE_VERTICAL = 1;
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_SLIDE = 1;
    private static final int TYPE_FADE = 2;
    private static final int TYPE_FAST_SLIDE = 3;
    private static final int TYPE_TIMELINE = 4;
    private static final int TYPE_SLIDE_AND_FADE = 5;
    private static final int TYPE_PULSATE_DIALOG = 6;
    private static final int TYPE_COVER = 7;
    private static final int TYPE_UNCOVER = 8;
    private static boolean defaultLinearMotion = false;
    private Motion motion;
    private Motion motion2;
    private LazyValue<Motion> lazyMotion;
    private long startTime;
    private int slideType;
    private int speed;
    private int position;
    private int transitionType;
    private Image buffer;
    private Image secondaryBuffer;
    private Image timeline;
    private byte pulseState;
    private boolean linearMotion = defaultLinearMotion;
    private boolean motionSetManually;
    private int originalWidth;
    private int originalHeight;
    private int originalX;
    private int originalY;
    private RGBImage rgbBuffer;
    private boolean forward;
    private boolean drawDialogMenu;
    private boolean firstFinished;

    private CommonTransitions(int type) {
        this.transitionType = type;
    }

    public static CommonTransitions createEmpty() {
        CommonTransitions t = new CommonTransitions(0);
        return t;
    }

    public static CommonTransitions createSlideFadeTitle(boolean forward, int duration) {
        CommonTransitions c = new CommonTransitions(5);
        c.forward = forward;
        c.speed = duration;
        return c;
    }

    public static CommonTransitions createDialogPulsate() {
        CommonTransitions c = new CommonTransitions(6);
        return c;
    }

    public static CommonTransitions createFastSlide(int type, boolean forward, int duration) {
        if (Display.getInstance().areMutableImagesFast()) {
            return CommonTransitions.createFastSlide(type, forward, duration, false);
        }
        return CommonTransitions.createSlide(type, forward, duration);
    }

    public static CommonTransitions createSlide(int type, boolean forward, int duration) {
        return CommonTransitions.createSlide(type, forward, duration, false);
    }

    public static CommonTransitions createSlide(int type, boolean forward, int duration, boolean drawDialogMenu) {
        CommonTransitions t = new CommonTransitions(1);
        t.slideType = type;
        t.forward = forward;
        t.speed = duration;
        t.position = 0;
        t.drawDialogMenu = drawDialogMenu;
        return t;
    }

    public static CommonTransitions createCover(int type, boolean forward, int duration) {
        CommonTransitions t = new CommonTransitions(7);
        t.slideType = type;
        t.forward = forward;
        t.speed = duration;
        t.position = 0;
        return t;
    }

    public static CommonTransitions createUncover(int type, boolean forward, int duration) {
        CommonTransitions t = new CommonTransitions(8);
        t.slideType = type;
        t.forward = forward;
        t.speed = duration;
        t.position = 0;
        return t;
    }

    public static CommonTransitions createFastSlide(int type, boolean forward, int duration, boolean drawDialogMenu) {
        CommonTransitions t = new CommonTransitions(1);
        t.slideType = type;
        t.forward = forward;
        t.speed = duration;
        t.position = 0;
        t.drawDialogMenu = drawDialogMenu;
        return t;
    }

    public static CommonTransitions createFade(int duration) {
        CommonTransitions t = new CommonTransitions(2);
        t.speed = duration;
        return t;
    }

    public static CommonTransitions createTimeline(Image animation) {
        CommonTransitions t = new CommonTransitions(4);
        t.timeline = animation;
        t.transitionType = 4;
        return t;
    }

    public static boolean isDefaultLinearMotion() {
        return defaultLinearMotion;
    }

    public static void setDefaultLinearMotion(boolean aDefaultLinearMotion) {
        defaultLinearMotion = aDefaultLinearMotion;
    }

    public boolean isHorizontalSlide() {
        return (this.transitionType == 1 || this.transitionType == 3) && this.slideType == 0;
    }

    public boolean isVerticalSlide() {
        return (this.transitionType == 1 || this.transitionType == 3) && this.slideType == 1;
    }

    public boolean isHorizontalCover() {
        return (this.transitionType == 7 || this.transitionType == 3) && this.slideType == 0;
    }

    public boolean isVerticalCover() {
        return (this.transitionType == 7 || this.transitionType == 3) && this.slideType == 1;
    }

    public boolean isForwardSlide() {
        return this.forward;
    }

    public int getTransitionSpeed() {
        return this.speed;
    }

    private Container getDialogParent(Component dlg) {
        return ((Dialog)dlg).getDialogComponent();
    }

    @Override
    public void initTransition() {
        this.firstFinished = false;
        if (this.transitionType == 0) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        Component source = this.getSource();
        Component destination = this.getDestination();
        this.position = 0;
        int w = source.getWidth();
        int h = source.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        if (this.transitionType == 5) {
            if (this.getSource() instanceof Form && this.getDestination() instanceof Form) {
                this.motion = this.createMotion(100, 200, this.speed);
                this.motion2 = this.createMotion(0, this.getDestination().getWidth(), this.speed);
                this.motion.start();
                this.motion2.start();
                return;
            }
            this.transitionType = 1;
        }
        if (this.transitionType == 6) {
            if (this.getDestination() instanceof Dialog) {
                this.motion = this.createMotion(600, 1100, 150);
                this.motion.start();
                this.motion2 = this.createMotion(100, 255, 225);
                this.motion2.start();
                this.pulseState = 0;
                Container c = this.getDialogParent(this.getDestination());
                this.originalX = c.getX();
                this.originalY = c.getY();
                this.originalWidth = c.getWidth();
                this.originalHeight = c.getHeight();
                Display d = Display.getInstance();
                Dialog dlg = (Dialog)destination;
                this.buffer = Image.createImage(Math.min(d.getDisplayWidth(), this.getDialogParent(dlg).getWidth()), Math.min(d.getDisplayHeight(), dlg.getContentPane().getParent().getHeight() + this.getDialogTitleHeight(dlg)), 0);
                Style stl = dlg.getDialogComponent().getStyle();
                byte bgt = stl.getBgTransparency();
                stl.setBgTransparency(255);
                this.drawDialogCmp(this.buffer.getGraphics(), dlg);
                stl.setBgTransparency(bgt & 0xFF, true);
                return;
            }
            this.transitionType = 0;
            this.motion = this.createMotion(0, 0, 0);
            this.pulseState = (byte)3;
            return;
        }
        if (Display.getInstance().areMutableImagesFast() || this.transitionType == 4) {
            if (this.buffer == null) {
                this.buffer = this.createMutableImage(w, h);
            } else if (this.buffer.getWidth() != w || this.buffer.getHeight() != h) {
                this.buffer = this.createMutableImage(w, h);
                this.rgbBuffer = null;
                this.motion = null;
            }
        }
        if (this.transitionType == 2) {
            this.motion = this.createMotion(0, 256, this.speed);
            this.motion.start();
            if (Display.getInstance().areMutableImagesFast()) {
                this.hideInterformContainers();
                Graphics g = this.buffer.getGraphics();
                g.translate(-source.getAbsoluteX(), -source.getAbsoluteY());
                if (this.getSource().getComponentForm() != null) {
                    this.getSource().getComponentForm().paintComponent(g);
                } else {
                    this.getSource().paintBackgrounds(g);
                }
                g.setClip(source.getAbsoluteX(), source.getAbsoluteY(), this.buffer.getWidth(), this.buffer.getHeight());
                this.paint(g, this.getDestination(), 0, 0, false);
                source.paintIntersectingComponentsAbove(g);
                this.rgbBuffer = new RGBImage(this.buffer.getRGBCached(), this.buffer.getWidth(), this.buffer.getHeight());
                if (this.getSource().getComponentForm() != null) {
                    this.getSource().getComponentForm().paintComponent(g);
                } else {
                    this.paint(g, this.getSource(), 0, 0, true);
                    source.paintIntersectingComponentsAbove(g);
                }
                g.translate(source.getAbsoluteX(), source.getAbsoluteY());
                this.showInterformContainers();
            }
            return;
        }
        if (this.transitionType == 4) {
            this.hideInterformContainers();
            Graphics g = this.buffer.getGraphics();
            g.translate(-source.getAbsoluteX(), -source.getAbsoluteY());
            g.setClip(0, 0, this.buffer.getWidth() + source.getAbsoluteX(), this.buffer.getHeight() + source.getAbsoluteY());
            if (this.timeline.getWidth() != this.buffer.getWidth() || this.timeline.getHeight() != this.buffer.getHeight()) {
                this.timeline = this.timeline.scaled(this.buffer.getWidth(), this.buffer.getHeight());
            }
            if (this.timeline instanceof Timeline) {
                ((Timeline)this.timeline).setTime(0);
                ((Timeline)this.timeline).setLoop(false);
                ((Timeline)this.timeline).setAnimationDelay(0);
            }
            this.paint(g, this.getDestination(), 0, 0);
            g.translate(source.getAbsoluteX(), source.getAbsoluteY());
            this.showInterformContainers();
            return;
        }
        if (this.transitionType == 1 || this.transitionType == 3 || this.transitionType == 7 || this.transitionType == 8) {
            int dest;
            int startOffset = 0;
            boolean direction = this.forward;
            if (source.getUIManager().getLookAndFeel().isRTL() && this.slideType == 0) {
                boolean bl = direction = !direction;
            }
            if (this.slideType == 0) {
                dest = w;
                if (destination instanceof Dialog) {
                    startOffset = w - this.getDialogParent(destination).getWidth();
                    startOffset = direction ? (startOffset -= this.getDialogParent(destination).getStyle().getMarginLeft(destination.isRTL())) : (startOffset -= this.getDialogParent(destination).getStyle().getMarginRight(destination.isRTL()));
                } else if (source instanceof Dialog) {
                    dest = this.getDialogParent(source).getWidth();
                    dest = direction ? (dest += this.getDialogParent(source).getStyle().getMarginLeft(source.isRTL())) : (dest += this.getDialogParent(source).getStyle().getMarginRight(source.isRTL()));
                }
            } else {
                Container p;
                dest = h;
                if (destination instanceof Dialog) {
                    startOffset = h - this.getDialogParent(destination).getHeight() - this.getDialogTitleHeight((Dialog)destination);
                    if (direction) {
                        startOffset -= this.getDialogParent(destination).getStyle().getMarginBottom();
                    } else {
                        startOffset -= this.getDialogParent(destination).getStyle().getMarginTop();
                        startOffset -= ((Dialog)destination).getTitleStyle().getMarginTop();
                        if (!this.drawDialogMenu && ((Dialog)destination).getCommandCount() > 0 && (p = ((Dialog)destination).getSoftButton(0).getParent()) != null) {
                            startOffset -= p.getHeight();
                        }
                    }
                } else if (source instanceof Dialog) {
                    dest = this.getDialogParent(source).getHeight() + this.getDialogTitleHeight((Dialog)source);
                    if (direction) {
                        dest += this.getDialogParent(source).getStyle().getMarginBottom();
                    } else {
                        dest += this.getDialogParent(source).getStyle().getMarginTop();
                        dest += ((Dialog)source).getTitleStyle().getMarginTop();
                        if (((Dialog)source).getCommandCount() > 0 && (p = ((Dialog)source).getSoftButton(0).getParent()) != null) {
                            dest += p.getHeight();
                        }
                    }
                }
            }
            this.motion = this.createMotion(startOffset, dest, this.speed);
            if (!Display.getInstance().areMutableImagesFast()) {
                this.motion.start();
                this.buffer = null;
                return;
            }
            Graphics g = this.buffer.getGraphics();
            if (this.getSource() instanceof Dialog) {
                this.paint(g, this.getDestination(), 0, 0);
                if (this.transitionType == 3 && !(destination instanceof Dialog)) {
                    Dialog d = (Dialog)source;
                    this.secondaryBuffer = this.createMutableImage(this.getDialogParent(d).getWidth(), this.getDialogParent(d).getHeight() + this.getDialogTitleHeight(d));
                    this.drawDialogCmp(this.secondaryBuffer.getGraphics(), d);
                }
            } else if (this.getDestination() instanceof Dialog) {
                this.paint(g, this.getSource(), 0, 0);
                if (this.transitionType == 3 && !(source instanceof Dialog)) {
                    Dialog d = (Dialog)destination;
                    this.secondaryBuffer = this.createMutableImage(this.getDialogParent(d).getWidth(), d.getContentPane().getParent().getHeight() + this.getDialogTitleHeight(d));
                    this.drawDialogCmp(this.secondaryBuffer.getGraphics(), d);
                }
            } else {
                this.hideInterformContainers();
                this.paint(g, source, -source.getAbsoluteX(), -source.getAbsoluteY(), true);
                if (this.transitionType == 3) {
                    this.secondaryBuffer = this.createMutableImage(destination.getWidth(), destination.getHeight());
                    this.paint(this.secondaryBuffer.getGraphics(), destination, -destination.getAbsoluteX(), -destination.getAbsoluteY());
                }
                this.showInterformContainers();
            }
            this.motion.start();
        }
    }

    private Image createMutableImage(int w, int h) {
        Display d = Display.getInstance();
        return Image.createImage(Math.min(d.getDisplayWidth(), w), Math.min(d.getDisplayHeight(), h));
    }

    private Motion createMotion(int startOffset, int dest, int speed) {
        if (this.motionSetManually) {
            if (this.lazyMotion != null) {
                return this.lazyMotion.get(startOffset, dest, speed);
            }
            return this.motion;
        }
        if (this.linearMotion) {
            return Motion.createLinearMotion(startOffset, dest, speed);
        }
        return Motion.createEaseInOutMotion(startOffset, dest, speed);
    }

    @Override
    public boolean animate() {
        if (this.timeline != null) {
            boolean val = this.timeline.animate();
            return val;
        }
        if (this.motion == null) {
            return false;
        }
        this.position = this.motion.getValue();
        if (this.firstFinished) {
            return false;
        }
        boolean finished = this.motion.isFinished();
        if (finished) {
            if (this.transitionType == 6) {
                switch (this.pulseState) {
                    case 0: {
                        this.pulseState = 1;
                        this.motion = this.createMotion(1100, 900, 70);
                        this.motion.start();
                        return true;
                    }
                    case 1: {
                        this.pulseState = (byte)2;
                        this.motion = this.createMotion(900, 1000, 140);
                        this.motion.start();
                        return true;
                    }
                }
            }
            if (!this.firstFinished) {
                this.firstFinished = true;
            }
        }
        return true;
    }

    @Override
    public void paint(Graphics g) {
        try {
            switch (this.transitionType) {
                case 1: 
                case 3: {
                    this.hideInterformContainers();
                    if (this.slideType == 0) {
                        this.paintSlideAtPosition(g, this.position, 0);
                    } else {
                        this.paintSlideAtPosition(g, 0, this.position);
                    }
                    this.paintInterformContainers(g);
                    return;
                }
                case 8: {
                    this.hideInterformContainers();
                    int p = this.motion.getDestinationValue() - this.position;
                    if (this.slideType == 0) {
                        this.paintCoverAtPosition(g, p, 0);
                    } else {
                        this.paintCoverAtPosition(g, 0, p);
                    }
                    this.paintInterformContainers(g);
                    return;
                }
                case 7: {
                    this.hideInterformContainers();
                    if (this.slideType == 0) {
                        this.paintCoverAtPosition(g, this.position, 0);
                    } else {
                        this.paintCoverAtPosition(g, 0, this.position);
                    }
                    this.paintInterformContainers(g);
                    return;
                }
                case 2: {
                    this.hideInterformContainers();
                    this.paintAlpha(g);
                    this.paintInterformContainers(g);
                    return;
                }
                case 4: {
                    this.hideInterformContainers();
                    Object mask = this.timeline.createMask();
                    this.paint(g, this.getSource(), 0, 0);
                    g.drawImage(this.buffer.applyMask(mask), 0, 0);
                    this.paintInterformContainers(g);
                    return;
                }
                case 5: {
                    Form sourceForm = (Form)this.getSource();
                    Form destForm = (Form)this.getDestination();
                    Container titleArea = sourceForm.getTitleArea();
                    Container destTitleArea = destForm.getTitleArea();
                    if (titleArea == null || titleArea.isHidden(true) || destTitleArea == null || destTitleArea.isHidden(true)) {
                        this.hideInterformContainers();
                        this.paintSlideAtPosition(g, this.motion2.getValue(), 0);
                        this.paintInterformContainers(g);
                        return;
                    }
                    int alpha = this.position;
                    int slidePos = this.motion2.getValue();
                    int clipX = g.getClipX();
                    int clipY = g.getClipY();
                    int clipW = g.getClipWidth();
                    int clipH = g.getClipHeight();
                    if (clipW <= 0 || clipH <= 0) {
                        return;
                    }
                    g.translate(0, sourceForm.getTitleArea().getHeight());
                    Container sourcePane = ((Form)this.getSource()).getContentPane();
                    Container destPane = ((Form)this.getDestination()).getContentPane();
                    boolean dir = this.forward;
                    if (sourceForm != null && sourceForm.getUIManager().getLookAndFeel().isRTL()) {
                        dir = !dir;
                    }
                    this.hideInterformContainers();
                    if (dir) {
                        g.translate(slidePos, 0);
                        this.paint(g, sourcePane, -sourcePane.getAbsoluteX() - sourcePane.getScrollX(), -sourcePane.getAbsoluteY() - sourcePane.getScrollY(), true);
                        g.translate(-destPane.getWidth(), 0);
                        this.paint(g, destPane, -destPane.getAbsoluteX() - destPane.getScrollX(), -destPane.getAbsoluteY() - destPane.getScrollY(), true);
                        g.translate(destPane.getWidth() - slidePos, 0);
                    } else {
                        g.translate(-slidePos, 0);
                        this.paint(g, sourcePane, -sourcePane.getAbsoluteX() - sourcePane.getScrollX(), -sourcePane.getAbsoluteY() - sourcePane.getScrollY(), true);
                        g.translate(destPane.getWidth(), 0);
                        this.paint(g, destPane, -destPane.getAbsoluteX() - destPane.getScrollX(), -destPane.getAbsoluteY() - destPane.getScrollY(), true);
                        g.translate(slidePos - destPane.getWidth(), 0);
                    }
                    g.translate(0, -sourceForm.getTitleArea().getHeight());
                    g.setClip(clipX, clipY, clipW, clipH);
                    this.paintInterformContainers(g);
                    titleArea.paintComponentBackground(g);
                    this.paintShiftFadeHierarchy(titleArea, 255 - alpha, g, false);
                    this.paintShiftFadeHierarchy(destTitleArea, alpha, g, true);
                    return;
                }
                case 6: {
                    this.paint(g, this.getSource(), 0, 0);
                    int alpha = g.getAlpha();
                    if (this.motion2 != null) {
                        g.setAlpha(this.motion2.getValue());
                    }
                    Container c = this.getDialogParent(this.getDestination());
                    float ratio = (float)this.position / 1000.0f;
                    if (g.isAffineSupported()) {
                        g.scale(ratio, ratio);
                        int w = (int)((float)this.originalWidth * ratio);
                        int h = (int)((float)this.originalHeight * ratio);
                        c.setX(this.originalX + (this.originalWidth - w) / 2);
                        c.setY(this.originalY + (this.originalHeight - h) / 2);
                        int currentDlgX = this.getDialogParent(this.getDestination()).getX();
                        int currentDlgY = this.getDialogParent(this.getDestination()).getY();
                        g.drawImage(this.buffer, currentDlgX, currentDlgY);
                        g.resetAffine();
                    } else {
                        c.setWidth((int)((float)this.originalWidth * ratio));
                        c.setHeight((int)((float)this.originalHeight * ratio));
                        c.setX(this.originalX + (this.originalWidth - c.getWidth()) / 2);
                        c.setY(this.originalY + (this.originalHeight - c.getHeight()) / 2);
                        this.paint(g, c, 0, 0);
                    }
                    g.setAlpha(alpha);
                }
            }
        }
        catch (Throwable t) {
            this.motion = null;
            Log.p("An exception occurred during transition paint this might be valid in case of a resize in the middle of a transition");
            Log.e(t);
        }
    }

    private void paintShiftFadeHierarchy(Container c, int alpha, Graphics g, boolean incoming) {
        int componentCount = c.getComponentCount();
        for (int iter = 0; iter < componentCount; ++iter) {
            Component current = c.getComponentAt(iter);
            if (current instanceof Container) {
                this.paintShiftFadeHierarchy((Container)current, alpha, g, incoming);
                continue;
            }
            g.setAlpha(alpha);
            Motion m = this.getComponentShiftMotion(current, incoming);
            if (m != null) {
                int tval = m.getValue();
                g.translate(tval, 0);
                current.paintComponent(g, false);
                g.translate(-tval, 0);
            }
            g.setAlpha(255);
        }
    }

    private Motion getComponentShiftMotion(Component c, boolean incoming) {
        Motion m = (Motion)c.getClientProperty("$shm");
        if (m == null) {
            Component dest = this.getDestination();
            if (dest == null || c == null) {
                return m;
            }
            int travelDestination = dest.getWidth() - c.getWidth() - c.getAbsoluteX();
            if (this.getDestination().getWidth() - c.getWidth() < 10) {
                travelDestination = c.getWidth() / 2 - c.getPreferredW() / 2;
            }
            boolean dir = this.forward;
            if (c.getUIManager().getLookAndFeel().isRTL()) {
                boolean bl = dir = !dir;
            }
            m = incoming ? (dir ? this.createMotion(-travelDestination, 0, this.speed) : this.createMotion(travelDestination, 0, this.speed)) : (dir ? this.createMotion(0, travelDestination, this.speed) : this.createMotion(0, -travelDestination, this.speed));
            m.start();
            c.putClientProperty("$shm", m);
        }
        return m;
    }

    private void paintAlpha(Graphics graphics) {
        Component src = this.getSource();
        int w = src.getWidth();
        int h = src.getHeight();
        int position = this.position;
        if (position > 255) {
            position = 255;
        } else if (position < 0) {
            position = 0;
        }
        if (this.buffer == null) {
            Component dest = this.getDestination();
            Component srcCmp = src;
            Component destCmp = dest;
            int alpha = position;
            if (src instanceof Dialog && dest instanceof Form) {
                srcCmp = dest;
                destCmp = src;
                alpha = 255 - position;
            }
            this.paint(graphics, srcCmp, 0, 0);
            destCmp.setX(srcCmp.getX());
            destCmp.setY(srcCmp.getY());
            destCmp.setWidth(srcCmp.getWidth());
            destCmp.setHeight(srcCmp.getHeight());
            graphics.setAlpha(alpha);
            this.paint(graphics, destCmp, 0, 0);
            graphics.setAlpha(255);
            return;
        }
        if (this.rgbBuffer != null || this.secondaryBuffer != null) {
            if (this.secondaryBuffer != null) {
                Component dest = this.getDestination();
                int x = dest.getAbsoluteX();
                int y = dest.getAbsoluteY();
                graphics.drawImage(this.buffer, x, y);
                graphics.setAlpha(position);
                graphics.drawImage(this.secondaryBuffer, x, y);
                graphics.setAlpha(255);
            } else {
                int alpha = position << 24;
                int[] bufferArray = this.rgbBuffer.getRGB();
                int size = bufferArray.length;
                for (int iter = 0; iter < size; ++iter) {
                    bufferArray[iter] = bufferArray[iter] & 0xFFFFFF | alpha;
                }
                Component dest = this.getDestination();
                int x = dest.getAbsoluteX();
                int y = dest.getAbsoluteY();
                graphics.drawImage(this.buffer, x, y);
                graphics.drawImage(this.rgbBuffer, x, y);
            }
        }
    }

    private void removeConstant(Container c) {
        int componentCount = c.getComponentCount();
        c.putClientProperty("$shm", null);
        for (int iter = 0; iter < componentCount; ++iter) {
            Component cmp = c.getComponentAt(iter);
            cmp.putClientProperty("$shm", null);
            if (!(cmp instanceof Container)) continue;
            this.removeConstant((Container)cmp);
        }
    }

    @Override
    public void cleanup() {
        if (this.transitionType == 5) {
            Component c = this.getSource();
            if (c instanceof Container) {
                this.removeConstant((Container)c);
            }
            if ((c = this.getDestination()) instanceof Container) {
                this.removeConstant((Container)c);
            }
        }
        super.cleanup();
        this.buffer = null;
        this.rgbBuffer = null;
        this.secondaryBuffer = null;
        this.timeline = null;
    }

    private void paintSlideAtPosition(Graphics g, int slideX, int slideY) {
        Component source = this.getSource();
        if (source == null) {
            return;
        }
        Component dest = this.getDestination();
        int w = source.getWidth();
        int h = source.getHeight();
        if (this.slideType == 0) {
            h = 0;
        } else {
            w = 0;
        }
        boolean dir = this.forward;
        if (dest != null && dest.getUIManager().getLookAndFeel().isRTL() && this.slideType == 0) {
            boolean bl = dir = !dir;
        }
        if (dir) {
            w = -w;
            h = -h;
        } else {
            slideX = -slideX;
            slideY = -slideY;
        }
        g.setClip(source.getAbsoluteX() + source.getScrollX(), source.getAbsoluteY() + source.getScrollY(), source.getWidth(), source.getHeight());
        if (source instanceof Dialog) {
            if (this.buffer != null) {
                g.drawImage(this.buffer, 0, 0);
            } else {
                this.paint(g, dest, 0, 0);
            }
            this.paint(g, source, -slideX, -slideY);
            return;
        }
        if (dest instanceof Dialog) {
            if (this.buffer != null) {
                g.drawImage(this.buffer, 0, 0);
            } else {
                this.paint(g, source, 0, 0);
            }
            this.paint(g, dest, -slideX - w, -slideY - h);
            return;
        }
        if (source.getParent() != null || this.buffer == null) {
            source.paintBackgrounds(g);
            this.paint(g, source, slideX, slideY);
        } else {
            g.drawImage(this.buffer, slideX, slideY);
        }
        this.paint(g, dest, slideX + w, slideY + h);
    }

    private void paintCoverAtPosition(Graphics g, int slideX, int slideY) {
        Component source = this.getSource();
        if (source == null) {
            return;
        }
        Component dest = this.getDestination();
        int w = source.getWidth();
        int h = source.getHeight();
        if (this.slideType == 0) {
            h = 0;
        } else {
            w = 0;
        }
        boolean dir = this.forward;
        if (dest != null && dest.getUIManager().getLookAndFeel().isRTL()) {
            boolean bl = dir = !dir;
        }
        if (dir) {
            w = -w;
            h = -h;
        } else {
            slideX = -slideX;
            slideY = -slideY;
        }
        g.setClip(source.getAbsoluteX() + source.getScrollX(), source.getAbsoluteY() + source.getScrollY(), source.getWidth(), source.getHeight());
        if (source instanceof Dialog) {
            if (this.buffer != null) {
                g.drawImage(this.buffer, 0, 0);
            } else {
                this.paint(g, dest, 0, 0);
            }
            this.paint(g, source, -slideX, -slideY);
            return;
        }
        if (dest instanceof Dialog) {
            if (this.buffer != null) {
                g.drawImage(this.buffer, 0, 0);
            } else {
                this.paint(g, source, 0, 0);
            }
            this.paint(g, dest, -slideX - w, -slideY - h);
            return;
        }
        if (this.transitionType == 8) {
            this.paint(g, dest, 0, 0);
            if (source.getParent() != null || this.buffer == null) {
                source.paintBackgrounds(g);
                this.paint(g, source, slideX + w, slideY + h);
            } else {
                g.drawImage(this.buffer, slideX + w, slideY + h);
            }
        } else {
            if (source.getParent() != null || this.buffer == null) {
                source.paintBackgrounds(g);
                this.paint(g, source, 0, 0);
            } else {
                g.drawImage(this.buffer, 0, 0);
            }
            this.paint(g, dest, slideX + w, slideY + h);
        }
    }

    private int getDialogTitleHeight(Dialog d) {
        return 0;
    }

    private void drawDialogCmp(Graphics g, Dialog dlg) {
        Container menuBar;
        Painter p = dlg.getStyle().getBgPainter();
        dlg.getStyle().setBgPainter(null);
        g.setClip(0, 0, dlg.getWidth(), dlg.getHeight());
        g.translate(-this.getDialogParent(dlg).getX(), -this.getDialogParent(dlg).getY() + this.getDialogTitleHeight(dlg));
        this.getDialogParent(dlg).paintComponent(g, false);
        if (this.drawDialogMenu && dlg.getCommandCount() > 0 && (menuBar = dlg.getSoftButton(0).getParent()) != null) {
            g.setClip(0, 0, dlg.getWidth(), dlg.getHeight());
            menuBar.paintComponent(g, false);
        }
        dlg.getStyle().setBgPainter(p);
    }

    private void paint(Graphics g, Component cmp, int x, int y) {
        this.paint(g, cmp, x, y, false);
    }

    private void paint(Graphics g, Component cmp, int x, int y, boolean background) {
        boolean b = cmp.isVisible();
        cmp.setVisible(true);
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        if (cmp instanceof Dialog) {
            if (this.transitionType == 2 && Display.getInstance().areMutableImagesFast()) {
                cmp.paintComponent(g, background);
                return;
            }
            if (!(this.getSource() instanceof Dialog) || !(this.getDestination() instanceof Dialog) || cmp != this.getDestination()) {
                Container menuBar;
                Painter p = cmp.getStyle().getBgPainter();
                cmp.getStyle().setBgPainter(null);
                g.translate(x, y);
                Dialog dlg = (Dialog)cmp;
                g.setClip(0, 0, cmp.getWidth(), cmp.getHeight());
                this.getDialogParent(dlg).paintComponent(g, false);
                g.translate(-x, -y);
                if (this.drawDialogMenu && dlg.getCommandCount() > 0 && (menuBar = dlg.getSoftButton(0).getParent()) != null) {
                    g.setClip(0, 0, cmp.getWidth(), cmp.getHeight());
                    menuBar.paintComponent(g, false);
                }
                g.setClip(cx, cy, cw, ch);
                cmp.getStyle().setBgPainter(p);
            } else {
                cmp.paintComponent(g, background);
            }
            return;
        }
        g.translate(x, y);
        cmp.paintComponent(g, background);
        g.translate(-x, -y);
        g.setClip(cx, cy, cw, ch);
        cmp.setVisible(b);
    }

    public Motion getMotion() {
        return this.motion;
    }

    public void setMotion(Motion motion) {
        this.motionSetManually = true;
        this.motion = motion;
    }

    public void setMotion(LazyValue<Motion> motion) {
        this.motionSetManually = true;
        this.lazyMotion = motion;
    }

    @Override
    public Transition copy(boolean reverse) {
        CommonTransitions retVal = null;
        switch (this.transitionType) {
            case 4: {
                retVal = CommonTransitions.createTimeline(this.timeline);
                break;
            }
            case 2: {
                retVal = CommonTransitions.createFade(this.speed);
                break;
            }
            case 1: {
                boolean fwd = this.forward;
                if (reverse) {
                    retVal = CommonTransitions.createSlide(this.slideType, !fwd, this.speed, this.drawDialogMenu);
                    break;
                }
                retVal = CommonTransitions.createSlide(this.slideType, fwd, this.speed, this.drawDialogMenu);
                break;
            }
            case 7: {
                boolean fwd = this.forward;
                if (reverse) {
                    retVal = CommonTransitions.createCover(this.slideType, !fwd, this.speed);
                    break;
                }
                retVal = CommonTransitions.createCover(this.slideType, fwd, this.speed);
                break;
            }
            case 8: {
                boolean fwd = this.forward;
                if (reverse) {
                    retVal = CommonTransitions.createUncover(this.slideType, !fwd, this.speed);
                    break;
                }
                retVal = CommonTransitions.createUncover(this.slideType, fwd, this.speed);
                break;
            }
            case 5: {
                boolean fwd = this.forward;
                if (reverse) {
                    retVal = CommonTransitions.createSlideFadeTitle(!fwd, this.speed);
                    break;
                }
                retVal = CommonTransitions.createSlideFadeTitle(fwd, this.speed);
                break;
            }
            case 3: {
                boolean fwd = this.forward;
                if (reverse) {
                    retVal = CommonTransitions.createFastSlide(this.slideType, !fwd, this.speed, this.drawDialogMenu);
                    break;
                }
                retVal = CommonTransitions.createFastSlide(this.slideType, fwd, this.speed, this.drawDialogMenu);
                break;
            }
            case 0: {
                retVal = CommonTransitions.createEmpty();
                break;
            }
            case 6: {
                retVal = CommonTransitions.createDialogPulsate();
            }
        }
        retVal.linearMotion = this.linearMotion;
        return retVal;
    }

    public boolean isLinearMotion() {
        return this.linearMotion;
    }

    public void setLinearMotion(boolean linearMotion) {
        this.linearMotion = linearMotion;
    }
}

