/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.events;

import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;

public class ActionEvent {
    private final Type trigger;
    private boolean consumed;
    private final Object source;
    private Object sourceComponent;
    private int keyEvent = -1;
    private int y = -1;
    private boolean longEvent = false;
    private boolean pointerPressedDuringDrag;

    public ActionEvent(Object source) {
        this.source = source;
        this.trigger = Type.Other;
    }

    public ActionEvent(Object source, Type type) {
        this.source = source;
        this.trigger = type;
        if (type == Type.LongPointerPress) {
            this.longEvent = true;
        }
    }

    public ActionEvent(Object source, Type type, int x, int y) {
        this.source = source;
        this.keyEvent = x;
        this.y = y;
        this.trigger = type;
        if (type == Type.LongPointerPress) {
            this.longEvent = true;
        }
    }

    public ActionEvent(Command source, Type type, Component sourceComponent, int x, int y) {
        this.source = source;
        this.sourceComponent = sourceComponent;
        this.keyEvent = x;
        this.y = y;
        this.trigger = type;
        if (type == Type.LongPointerPress) {
            this.longEvent = true;
        }
    }

    public ActionEvent(Component dragged, Type type, Component drop, int x, int y) {
        this.source = dragged;
        this.sourceComponent = drop;
        this.keyEvent = x;
        this.y = y;
        this.trigger = type;
        if (type == Type.LongPointerPress) {
            this.longEvent = true;
        }
    }

    public ActionEvent(Object source, Type type, int keyEvent) {
        this.source = source;
        this.keyEvent = keyEvent;
        this.trigger = type;
        if (type == Type.LongPointerPress) {
            this.longEvent = true;
        }
    }

    public ActionEvent(Object source, int keyEvent) {
        this.source = source;
        this.keyEvent = keyEvent;
        this.trigger = Type.KeyRelease;
    }

    public ActionEvent(Object source, int keyEvent, boolean longClick) {
        this.source = source;
        this.keyEvent = keyEvent;
        this.longEvent = longClick;
        this.trigger = Type.KeyPress;
    }

    public ActionEvent(Object source, int x, int y, boolean longPointer) {
        this.source = source;
        this.keyEvent = x;
        this.y = y;
        this.longEvent = longPointer;
        this.trigger = Type.PointerReleased;
    }

    public ActionEvent(Object source, int x, int y) {
        this.source = source;
        this.keyEvent = x;
        this.y = y;
        this.trigger = Type.Pointer;
    }

    public ActionEvent(Command source, Component sourceComponent, int x, int y) {
        this.source = source;
        this.sourceComponent = sourceComponent;
        this.keyEvent = x;
        this.y = y;
        this.trigger = Type.Command;
    }

    public ActionEvent(Component dragged, Component drop, int x, int y) {
        this.source = dragged;
        this.sourceComponent = drop;
        this.keyEvent = x;
        this.y = y;
        this.trigger = Type.PointerDrag;
    }

    public Type getEventType() {
        return this.trigger;
    }

    public Object getSource() {
        return this.source;
    }

    public int getKeyEvent() {
        return this.keyEvent;
    }

    public int getProgress() {
        return this.keyEvent;
    }

    public Command getCommand() {
        if (this.source instanceof Command) {
            return (Command)this.source;
        }
        return null;
    }

    public Component getActualComponent() {
        Container lead;
        Component c = this.getComponent();
        if (c != null && (lead = c instanceof Container ? ((Container)c).getLeadParent() : c.getParent().getLeadParent()) != null) {
            return lead;
        }
        return c;
    }

    public Component getComponent() {
        if (this.sourceComponent != null) {
            return (Component)this.sourceComponent;
        }
        if (this.source instanceof Component) {
            return (Component)this.source;
        }
        return null;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public int getX() {
        return this.keyEvent;
    }

    public int getY() {
        return this.y;
    }

    public boolean isLongEvent() {
        return this.longEvent;
    }

    public Component getDraggedComponent() {
        return (Component)this.source;
    }

    public Component getDropTarget() {
        return (Component)this.sourceComponent;
    }

    public boolean isPointerPressedDuringDrag() {
        return this.pointerPressedDuringDrag;
    }

    public void setPointerPressedDuringDrag(boolean pressed) {
        this.pointerPressedDuringDrag = pressed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Other,
        Command,
        Pointer,
        PointerPressed,
        PointerReleased,
        PointerDrag,
        Swipe,
        KeyPress,
        KeyRelease,
        Exception,
        Response,
        Progress,
        Data,
        Calendar,
        Edit,
        Done,
        JavaScript,
        Log,
        Theme,
        Show,
        SizeChange,
        OrientationChange,
        DragFinished,
        Change,
        LongPointerPress,
        OpenGallery,
        IsGalleryTypeSupported;

    }
}

