/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.geom;

import com.codename1.ui.Transform;

public class AffineTransform {
    private double m00;
    private double m10;
    private double m01;
    private double m11;
    private double m02;
    private double m12;

    public AffineTransform() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public AffineTransform(AffineTransform Tx) {
        this.m00 = Tx.m00;
        this.m10 = Tx.m10;
        this.m01 = Tx.m01;
        this.m11 = Tx.m11;
        this.m02 = Tx.m02;
        this.m12 = Tx.m12;
        this.check();
    }

    public AffineTransform(float m00, float m10, float m01, float m11, float m02, float m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.check();
    }

    public AffineTransform(float[] m) {
        int len = m.length;
        this.m00 = m[0];
        this.m10 = m[1];
        this.m01 = m[2];
        this.m11 = m[3];
        if (len >= 6) {
            this.m02 = m[4];
            this.m12 = m[5];
        }
        this.check();
    }

    public AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.check();
    }

    public AffineTransform(double[] m) {
        int len = m.length;
        this.m00 = m[0];
        this.m10 = m[1];
        this.m01 = m[2];
        this.m11 = m[3];
        if (len >= 6) {
            this.m02 = m[4];
            this.m12 = m[5];
        }
        this.check();
    }

    public static AffineTransform getRotateInstance(double theta) {
        AffineTransform Tx = new AffineTransform();
        Tx.setToRotation(theta);
        return Tx;
    }

    public static AffineTransform getRotateInstance(double theta, double anchorx, double anchory) {
        AffineTransform Tx = new AffineTransform();
        Tx.setToRotation(theta, anchorx, anchory);
        return Tx;
    }

    private void check() {
    }

    public void setToScale(double sx, double sy) {
        this.m00 = sx;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = sy;
        this.m02 = 0.0;
        this.m12 = 0.0;
    }

    public void setToShear(double shx, double shy) {
        this.m00 = 1.0;
        this.m01 = shx;
        this.m10 = shy;
        this.m11 = 1.0;
        this.m02 = 0.0;
        this.m12 = 0.0;
    }

    public void setToRotation(double vecx, double vecy) {
        double cos;
        double sin;
        if (vecy == 0.0) {
            sin = 0.0;
            cos = vecx < 0.0 ? -1.0 : 1.0;
        } else if (vecx == 0.0) {
            cos = 0.0;
            sin = vecy > 0.0 ? 1.0 : -1.0;
        } else {
            double len = Math.sqrt(vecx * vecx + vecy * vecy);
            cos = vecx / len;
            sin = vecy / len;
        }
        this.m00 = cos;
        this.m10 = sin;
        this.m01 = -sin;
        this.m11 = cos;
        this.m02 = 0.0;
        this.m12 = 0.0;
    }

    public void setToRotation(double vecx, double vecy, double anchorx, double anchory) {
        this.setToRotation(vecx, vecy);
        double sin = this.m10;
        double oneMinusCos = 1.0 - this.m00;
        this.m02 = anchorx * oneMinusCos + anchory * sin;
        this.m12 = anchory * oneMinusCos - anchorx * sin;
    }

    public void setToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
    }

    public void setToTranslation(double tx, double ty) {
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = 1.0;
        this.m02 = tx;
        this.m12 = ty;
    }

    public void setToRotation(double theta, double anchorx, double anchory) {
        this.setToRotation(theta);
        double sin = this.m10;
        double oneMinusCos = 1.0 - this.m00;
        this.m02 = anchorx * oneMinusCos + anchory * sin;
        this.m12 = anchory * oneMinusCos - anchorx * sin;
    }

    public void setToRotation(double theta) {
        double cos;
        double sin = Math.sin(theta);
        if (sin == 1.0 || sin == -1.0) {
            cos = 0.0;
        } else {
            cos = Math.cos(theta);
            if (cos == -1.0) {
                sin = 0.0;
            } else if (cos == 1.0) {
                sin = 0.0;
            }
        }
        this.m00 = cos;
        this.m10 = sin;
        this.m01 = -sin;
        this.m11 = cos;
        this.m02 = 0.0;
        this.m12 = 0.0;
    }

    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
    }

    public Transform toTransform() {
        return Transform.makeAffine(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
    }

    public String toString() {
        return "AffineTransform{" + this.m00 + "," + this.m10 + "," + this.m01 + "," + this.m11 + "," + this.m02 + "," + this.m12 + "}";
    }
}

