/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.geom;

import com.codename1.ui.Graphics;
import com.codename1.ui.Stroke;
import com.codename1.ui.Transform;
import com.codename1.ui.geom.GeneralPath;
import com.codename1.ui.geom.PathIterator;
import com.codename1.ui.geom.Point2D;
import com.codename1.ui.geom.Rectangle2D;
import com.codename1.ui.geom.Shape;
import com.codename1.util.MathUtil;
import java.util.Arrays;
import java.util.List;

class Geometry {
    Geometry() {
    }

    private static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("factorial does not support negative numbers");
        }
        if (n == 0) {
            return 1;
        }
        return n * Geometry.factorial(n - 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BezierCurve {
        final double[] x;
        final double[] y;
        private Point2D startPoint;
        private Point2D endPoint;
        private Rectangle2D boundingRect;

        public BezierCurve(double ... pts) {
            int len = pts.length;
            if (len % 2 != 0) {
                throw new IllegalArgumentException("Length of points array must be even.");
            }
            this.x = new double[len / 2];
            this.y = new double[len / 2];
            for (int i = 0; i < len; i += 2) {
                this.x[i / 2] = pts[i];
                this.y[i / 2] = pts[i + 1];
            }
        }

        public BezierCurve(BezierCurve toCopy) {
            this.x = new double[toCopy.x.length];
            this.y = new double[toCopy.y.length];
            System.arraycopy(toCopy.x, 0, this.x, 0, toCopy.x.length);
            System.arraycopy(toCopy.y, 0, this.y, 0, toCopy.y.length);
        }

        public static void extractBezierCurvesFromPath(Shape shape, List<BezierCurve> out) {
            PathIterator it = shape.getPathIterator();
            double[] buf = new double[6];
            double prevX = 0.0;
            double prevY = 0.0;
            double markX = 0.0;
            double markY = 0.0;
            while (!it.isDone()) {
                int type = it.currentSegment(buf);
                switch (type) {
                    case 0: {
                        prevX = buf[0];
                        prevY = buf[1];
                        markX = prevX;
                        markY = prevY;
                        break;
                    }
                    case 1: {
                        prevX = buf[0];
                        prevY = buf[1];
                        break;
                    }
                    case 4: {
                        prevX = markX;
                        prevY = markY;
                        break;
                    }
                    case 2: {
                        out.add(new BezierCurve(prevX, prevY, buf[0], buf[1], buf[2], buf[3]));
                        prevX = buf[2];
                        prevY = buf[3];
                        break;
                    }
                    case 3: {
                        out.add(new BezierCurve(prevX, prevY, buf[0], buf[1], buf[2], buf[3], buf[4], buf[5]));
                        prevX = buf[4];
                        prevY = buf[5];
                    }
                }
                it.next();
            }
        }

        private static boolean contains(double needle, double[] haystack, double epsilon, int startIndex, int endIndex) {
            for (int i = startIndex; i < endIndex; ++i) {
                if (!(Math.abs(needle - haystack[i]) < epsilon)) continue;
                return true;
            }
            return false;
        }

        private static int arraycopy(double[] src, int srcStart, double[] dst, int dstStart, int len, double epsilon) {
            int numCopied = 0;
            for (int i = 0; i < len; ++i) {
                if (BezierCurve.contains(src[srcStart + i], dst, epsilon, 0, dstStart)) continue;
                dst[dstStart++] = src[srcStart + i];
                ++numCopied;
            }
            return numCopied;
        }

        public String toString() {
            return "Curve{x=" + Arrays.toString(this.x) + ", y=" + Arrays.toString(this.y) + "}";
        }

        public Point2D getEndPoint() {
            if (this.endPoint == null) {
                this.endPoint = new Point2D(this.x[this.n()], this.y[this.n()]);
            }
            return this.endPoint;
        }

        public Point2D getStartPoint() {
            if (this.startPoint == null) {
                this.startPoint = new Point2D(this.x[0], this.y[0]);
            }
            return this.startPoint;
        }

        public int n() {
            return this.x.length - 1;
        }

        public double cx(int j) {
            return (double)(Geometry.factorial(this.n()) / Geometry.factorial(this.n() - j)) * this.sumFactorX(j, j);
        }

        private double sumFactorX(int j, int i) {
            if (i == 0) {
                return MathUtil.pow(-1.0, j) * this.x[0] / (double)Geometry.factorial(j);
            }
            return MathUtil.pow(-1.0, i + j) * this.x[i] / (double)Geometry.factorial(i) / (double)Geometry.factorial(j - i) + this.sumFactorX(j, i - 1);
        }

        public double cy(int j) {
            return (double)(Geometry.factorial(this.n()) / Geometry.factorial(this.n() - j)) * this.sumFactorY(j, j);
        }

        private double sumFactorY(int j, int i) {
            if (i == 0) {
                return MathUtil.pow(-1.0, j) * this.y[0] / (double)Geometry.factorial(j);
            }
            return MathUtil.pow(-1.0, i + j) * this.y[i] / (double)Geometry.factorial(i) / (double)Geometry.factorial(j - i) + this.sumFactorY(j, i - 1);
        }

        public double x(double t) {
            return this.termX(t, this.n());
        }

        private double termX(double t, int j) {
            if (j == 0) {
                return this.cx(j);
            }
            return this.cx(j) * MathUtil.pow(t, j) + this.termX(t, j - 1);
        }

        public double[] getDerivativeCoefficientsX() {
            switch (this.n()) {
                case 1: {
                    return new double[]{this.cx(1), 0.0, 0.0};
                }
                case 2: {
                    return new double[]{this.cx(1), 2.0 * this.cx(2), 0.0};
                }
                case 3: {
                    return new double[]{this.cx(1), 2.0 * this.cx(2), 3.0 * this.cx(3)};
                }
            }
            throw new IllegalArgumentException("Derivative coefficients only implements for beziers of order 3 or lower.");
        }

        public double[] getDerivativeCoefficientsY() {
            switch (this.n()) {
                case 1: {
                    return new double[]{this.cy(1), 0.0, 0.0};
                }
                case 2: {
                    return new double[]{this.cy(1), 2.0 * this.cy(2), 0.0};
                }
                case 3: {
                    return new double[]{this.cy(1), 2.0 * this.cy(2), 3.0 * this.cy(3)};
                }
            }
            throw new IllegalArgumentException("Derivative coefficients only implements for beziers of order 3 or lower.");
        }

        public double y(double t) {
            return this.termY(t, this.n());
        }

        private double termY(double t, int j) {
            if (j == 0) {
                return this.cy(j);
            }
            return this.cy(j) * MathUtil.pow(t, j) + this.termY(t, j - 1);
        }

        private int findTValuesForX(double x, double[] res) {
            switch (this.n()) {
                case 2: {
                    return GeneralPath.ShapeUtil.solveQuad(new double[]{this.cx(0) - x, this.cx(1), this.cx(2), 0.0}, res);
                }
                case 3: {
                    return GeneralPath.ShapeUtil.solveCubic(new double[]{this.cx(0) - x, this.cx(1), this.cx(2), this.cx(3)}, res);
                }
            }
            throw new IllegalArgumentException("Only 2 and 3 degree bezier curves are supported");
        }

        private int findTValuesForY(double y, double[] res) {
            switch (this.n()) {
                case 2: {
                    return GeneralPath.ShapeUtil.solveQuad(new double[]{this.cy(0) - y, this.cy(1), this.cy(2)}, res);
                }
                case 3: {
                    return GeneralPath.ShapeUtil.solveCubic(new double[]{this.cy(0) - y, this.cy(1), this.cy(2), this.cy(3)}, res);
                }
            }
            throw new IllegalArgumentException("Only 2 and 3 degree bezier curves are supported");
        }

        public BezierCurve reverse() {
            int len = this.x.length;
            double[] params = new double[len * 2];
            int index = 0;
            for (int i = len - 1; i >= 0; --i) {
                params[index++] = this.x[i];
                params[index++] = this.y[i];
            }
            return new BezierCurve(params);
        }

        public void segment(double t, List<BezierCurve> out) {
            out.add(this.segment(t));
            out.add(this.reverse().segment(1.0 - t).reverse());
        }

        public void addToPath(GeneralPath p, boolean join) {
            if (this.n() == 2) {
                if (!join) {
                    p.moveTo(this.x[0], this.y[0]);
                }
                p.quadTo(this.x[1], this.y[1], this.x[2], this.y[2]);
            } else if (this.n() == 3) {
                if (!join) {
                    p.moveTo(this.x[0], this.y[0]);
                }
                p.curveTo(this.x[1], this.y[1], this.x[2], this.y[2], this.x[3], this.y[3]);
            } else if (this.n() == 1) {
                if (join) {
                    p.moveTo(this.x[0], this.y[0]);
                }
                p.lineTo(this.x[1], this.y[1]);
            }
        }

        public void stroke(Graphics g, Stroke stroke, int translateX, int translateY) {
            if (stroke == null) {
                stroke = new Stroke(1.0f, 0, 0, 1.0f);
            }
            GeneralPath p = new GeneralPath();
            this.addToPath(p, false);
            p.transform(Transform.makeTranslation(translateX, translateY));
            g.drawShape(p, stroke);
        }

        public Rectangle2D getBoundingRect() {
            if (this.boundingRect == null) {
                Point2D start = this.getStartPoint();
                Point2D end = this.getEndPoint();
                int numSolutions = 0;
                double[] res = new double[3];
                double x1 = Math.min(start.getX(), end.getX());
                double y1 = Math.min(start.getY(), end.getY());
                double x2 = Math.max(start.getX(), end.getX());
                double y2 = Math.max(start.getY(), end.getY());
                switch (this.n()) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        double yt;
                        double xt;
                        double t;
                        int i;
                        numSolutions = GeneralPath.ShapeUtil.solveQuad(this.getDerivativeCoefficientsX(), res);
                        if (numSolutions > 0) {
                            for (i = 0; i < numSolutions; ++i) {
                                t = res[i];
                                if (t < 0.0 || t > 1.0) continue;
                                xt = this.x(t);
                                yt = this.y(t);
                                x1 = Math.min(x1, xt);
                                y1 = Math.min(y1, yt);
                                x2 = Math.max(x2, xt);
                                y2 = Math.max(y2, yt);
                            }
                        }
                        if ((numSolutions = GeneralPath.ShapeUtil.solveQuad(this.getDerivativeCoefficientsY(), res)) <= 0) break;
                        for (i = 0; i < numSolutions; ++i) {
                            t = res[i];
                            if (t < 0.0 || t > 1.0) continue;
                            xt = this.x(t);
                            yt = this.y(t);
                            x1 = Math.min(x1, xt);
                            y1 = Math.min(y1, yt);
                            x2 = Math.max(x2, xt);
                            y2 = Math.max(y2, yt);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("getBoundingRect() only supported for bezier curves of order 3 or less");
                    }
                }
                this.boundingRect = new Rectangle2D(x1, y1, x2 - x1, y2 - y1);
            }
            return this.boundingRect;
        }

        public BezierCurve segment(double t) {
            return this.segment(0.0, t);
        }

        public int findTValuesForX(double x, double minY, double maxY, double[] out) {
            int numMatches = this.findTValuesForX(x, out);
            int numFiltered = 0;
            for (int i = 0; i < numMatches; ++i) {
                double ty;
                if (out[i] < 0.0 || out[i] > 1.0 || !((ty = this.y(out[i])) >= minY) || !(ty <= maxY)) continue;
                out[numFiltered] = out[i];
                ++numFiltered;
            }
            return numFiltered;
        }

        public int findTValuesForY(double y, double minX, double maxX, double[] out) {
            int numMatches = this.findTValuesForY(y, out);
            int numFiltered = 0;
            for (int i = 0; i < numMatches; ++i) {
                double tx;
                if (out[i] < 0.0 || out[i] > 1.0 || !((tx = this.x(out[i])) >= minX) || !(tx <= maxX)) continue;
                out[numFiltered] = out[i];
                ++numFiltered;
            }
            return numFiltered;
        }

        public boolean equals(BezierCurve c, double epsilon) {
            if (c.n() != this.n()) {
                return false;
            }
            int len = this.x.length;
            for (int i = 0; i < len; ++i) {
                if (Math.abs(this.x[i] - c.x[i]) > epsilon) {
                    return false;
                }
                if (!(Math.abs(this.y[i] - c.y[i]) > epsilon)) continue;
                return false;
            }
            return true;
        }

        public void segment(Rectangle2D rect, List<BezierCurve> out) {
            int numIntersections;
            int n = this.n() == 2 ? GeneralPath.ShapeUtil.intersectQuad(this.x[0], this.y[0], this.x[1], this.y[1], this.x[2], this.y[2], rect.getX(), rect.getY(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight()) : (this.n() == 3 ? GeneralPath.ShapeUtil.intersectCubic(this.x[0], this.y[0], this.x[1], this.y[1], this.x[2], this.y[2], this.x[3], this.y[3], rect.getX(), rect.getY(), rect.getX() + rect.getWidth(), rect.getHeight() + rect.getY()) : (numIntersections = this.n() == 1 ? GeneralPath.ShapeUtil.intersectLine(this.x[0], this.y[0], this.x[1], this.y[1], rect.getX(), rect.getY(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight()) : -1));
            if (numIntersections == -1) {
                throw new IllegalArgumentException("Cannot segment bezier curve of this order: " + this.n());
            }
            if (numIntersections == 0) {
                out.add(new BezierCurve(this));
                return;
            }
            double[] tvals = new double[numIntersections];
            int nextTvalIndex = 0;
            double[] res = new double[3];
            int numMatches = 0;
            double epsilon = 0.01;
            numMatches = this.findTValuesForX(rect.getX(), rect.getY(), rect.getY() + rect.getHeight(), res);
            if (numMatches > 0) {
                nextTvalIndex += BezierCurve.arraycopy(res, 0, tvals, nextTvalIndex, numMatches, epsilon);
            }
            if ((numMatches = this.findTValuesForX(rect.getX() + rect.getWidth(), rect.getY(), rect.getY() + rect.getHeight(), res)) > 0) {
                nextTvalIndex += BezierCurve.arraycopy(res, 0, tvals, nextTvalIndex, numMatches, epsilon);
            }
            if ((numMatches = this.findTValuesForY(rect.getY(), rect.getX(), rect.getX() + rect.getWidth(), res)) > 0) {
                nextTvalIndex += BezierCurve.arraycopy(res, 0, tvals, nextTvalIndex, numMatches, epsilon);
            }
            if ((numMatches = this.findTValuesForY(rect.getY() + rect.getHeight(), rect.getX(), rect.getX() + rect.getWidth(), res)) > 0) {
                nextTvalIndex += BezierCurve.arraycopy(res, 0, tvals, nextTvalIndex, numMatches, epsilon);
            }
            Arrays.sort(tvals, 0, nextTvalIndex);
            int numSegments = nextTvalIndex + 1;
            switch (numSegments) {
                case 1: {
                    out.add(new BezierCurve(this));
                    return;
                }
                case 2: {
                    if (tvals[0] > epsilon && tvals[0] < 1.0 - epsilon) {
                        this.segment(tvals[0], out);
                    } else {
                        out.add(new BezierCurve(this));
                    }
                    return;
                }
            }
            int tIndex = 0;
            while (tvals[tIndex] < epsilon || tvals[tIndex] > 1.0 - epsilon) {
                if (++tIndex < nextTvalIndex) continue;
                out.add(new BezierCurve(this));
                return;
            }
            this.segment(tvals[tIndex], out);
            BezierCurve last = out.remove(out.size() - 1);
            if (last.equals(this, epsilon)) {
                out.add(last);
            } else {
                last.segment(rect, out);
            }
        }

        private BezierCurve segment(double t0, double t1) {
            if (t1 <= 0.0 || t1 >= 1.0) {
                throw new IllegalArgumentException("t must be between 0 and 1 but found " + t1);
            }
            if (this.n() == 2) {
                double x0 = this.x(t0);
                double y0 = this.y(t0);
                double xt = this.x(t1);
                double yt = this.y(t1);
                double x3 = (this.x[1] - this.x[0]) * t1 + this.x[0];
                double y3 = (this.y[1] - this.y[0]) * t1 + this.y[0];
                BezierCurve b1 = new BezierCurve(x0, y0, x3, y3, xt, yt);
                return b1;
            }
            if (this.n() == 3) {
                if (t0 != 0.0) {
                    throw new IllegalArgumentException("Only supports t0=0 right now with cubics");
                }
                double t = t1;
                double x1 = this.x[0];
                double y1 = this.y[0];
                double x2 = this.x[1];
                double y2 = this.y[1];
                double x3 = this.x[2];
                double y3 = this.y[2];
                double x4 = this.x[3];
                double y4 = this.y[3];
                double x12 = (x2 - x1) * t + x1;
                double y12 = (y2 - y1) * t + y1;
                double x23 = (x3 - x2) * t + x2;
                double y23 = (y3 - y2) * t + y2;
                double x34 = (x4 - x3) * t + x3;
                double y34 = (y4 - y3) * t + y3;
                double x123 = (x23 - x12) * t + x12;
                double y123 = (y23 - y12) * t + y12;
                double x234 = (x34 - x23) * t + x23;
                double y234 = (y34 - y23) * t + y23;
                double x1234 = (x234 - x123) * t + x123;
                double y1234 = (y234 - y123) * t + y123;
                return new BezierCurve(x1, y1, x12, y12, x123, y123, x1234, y1234);
            }
            throw new IllegalArgumentException("Cannot segment bezier curves with order " + this.n());
        }
    }
}

