/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.html;

import com.codename1.ui.Font;
import com.codename1.ui.html.HTMLComponent;
import com.codename1.ui.html.HTMLElement;
import java.util.Vector;

class HTMLFont {
    static final int BOLD = 0;
    static final int ITALIC = 1;
    static final int BIG = 2;
    static final int SMALL = 3;
    private static final char TOKEN = '.';
    static Vector SPECIAL_FONT_TAGS = new Vector();
    private static final int[] SPECIAL_FONT_TAGS_ID = new int[]{13, 26, 11, 10, 24, 20, 27, 9, 14, 15, 16, 17, 18, 19, 64};
    boolean systemFont;
    Font font;
    String family;
    int size;
    int style;
    boolean bold;
    boolean italic;
    String tagFont;
    private final HTMLFont[] counterpartFonts = new HTMLFont[4];

    HTMLFont(String fontKey, Font font) {
        this.font = font;
        boolean bl = this.systemFont = font.getCharset() == null;
        if (this.isSystemFont()) {
            this.bold = (font.getStyle() & 1) != 0;
            this.italic = (font.getStyle() & 2) != 0;
            this.size = font.getSize();
            if (font.getFace() == 0) {
                this.family = "system";
            } else if (font.getFace() == 32) {
                this.family = "monospace";
            } else if (font.getFace() == 64) {
                this.family = "proportional";
            }
        } else if (fontKey != null) {
            boolean sufficientInfo = false;
            int lastIndex = 0;
            if (!fontKey.endsWith(".")) {
                fontKey = fontKey + '.';
            }
            int index = fontKey.indexOf(46);
            while (index != -1) {
                block22: {
                    String str = fontKey.substring(lastIndex, index);
                    try {
                        int num;
                        this.size = num = Integer.parseInt(str);
                    }
                    catch (NumberFormatException nfe) {
                        if (str.equalsIgnoreCase("bold")) {
                            this.bold = true;
                        }
                        if (str.equalsIgnoreCase("italic")) {
                            this.italic = true;
                        }
                        if (str.equalsIgnoreCase("plain")) break block22;
                        if (SPECIAL_FONT_TAGS.contains(str)) {
                            HTMLComponent.fonts.put(str, this);
                            sufficientInfo = true;
                        }
                        this.family = str.toLowerCase();
                        sufficientInfo = true;
                    }
                }
                lastIndex = index + 1;
                index = fontKey.indexOf(46, lastIndex);
            }
            if (!sufficientInfo) {
                System.out.println("WARNING: Font was added with key '" + fontKey + "' which doesn't contain info on the font's family or attributes it to a special tag. The font will probably be unusable by the font engine.");
            }
        }
        if (this.bold) {
            ++this.style;
            this.counterpartFonts[0] = this;
        }
        if (this.italic) {
            this.style += 2;
            this.counterpartFonts[1] = this;
        }
        if (this.isSystemFont()) {
            if (this.size == 16) {
                this.counterpartFonts[2] = this;
            } else if (this.size == 8) {
                this.counterpartFonts[3] = this;
            }
        }
    }

    boolean isSystemFont() {
        return this.systemFont;
    }

    boolean isBold() {
        return this.bold;
    }

    boolean isItalic() {
        return this.italic;
    }

    boolean isCounterpart(int attribute, HTMLFont font) {
        switch (attribute) {
            case 0: {
                return this.isBoldCounterpart(font);
            }
            case 1: {
                return this.isItalicCounterpart(font);
            }
            case 2: {
                return this.isBigCounterpart(font);
            }
            case 3: {
                return this.isSmallCounterpart(font);
            }
        }
        return false;
    }

    boolean isSameFamily(HTMLFont font) {
        return this.family != null && font.getFamily() != null && this.family.equals(font.getFamily());
    }

    private boolean isBigCounterpart(HTMLFont font) {
        if (this.size <= font.getSize()) {
            return false;
        }
        return this.isSameFamily(font) && this.style == font.getStyle();
    }

    private boolean isSmallCounterpart(HTMLFont font) {
        if (this.size >= font.getSize()) {
            return false;
        }
        return this.isSameFamily(font) && this.style == font.getStyle();
    }

    private boolean isBoldCounterpart(HTMLFont font) {
        if (!this.bold) {
            return false;
        }
        return this.size == font.getSize() && this.isSameFamily(font) && this.italic == font.isItalic();
    }

    private boolean isItalicCounterpart(HTMLFont font) {
        if (!this.italic) {
            return false;
        }
        return this.size == font.getSize() && this.isSameFamily(font) && this.bold == font.isBold();
    }

    String getFamily() {
        return this.family;
    }

    Font getFont() {
        return this.font;
    }

    HTMLFont getCounterpartFont(int attribute) {
        if (this.systemFont && this.counterpartFonts[attribute] == null) {
            switch (attribute) {
                case 0: {
                    this.counterpartFonts[attribute] = new HTMLFont(null, Font.createSystemFont(this.font.getFace(), this.style + 1, this.size));
                    break;
                }
                case 1: {
                    this.counterpartFonts[attribute] = new HTMLFont(null, Font.createSystemFont(this.font.getFace(), this.style + 2, this.size));
                    break;
                }
                case 2: {
                    int counterpartSize = this.size == 8 ? 0 : 16;
                    this.counterpartFonts[attribute] = new HTMLFont(null, Font.createSystemFont(this.font.getFace(), this.style, counterpartSize));
                    break;
                }
                case 3: {
                    int counterpartSize = this.size == 16 ? 0 : 8;
                    this.counterpartFonts[attribute] = new HTMLFont(null, Font.createSystemFont(this.font.getFace(), this.style, counterpartSize));
                }
            }
        }
        return this.counterpartFonts[attribute];
    }

    void setCounterpartFont(int attribute, HTMLFont counterpartFont) {
        this.counterpartFonts[attribute] = counterpartFont;
    }

    int getHeight() {
        return this.font.getHeight();
    }

    int stringWidth(String str) {
        return this.font.stringWidth(str);
    }

    int getFace() {
        return this.font.getFace();
    }

    int getStyle() {
        return this.style;
    }

    int getSize() {
        return this.size;
    }

    int getSizeInPixels() {
        if (this.systemFont) {
            return this.font.getHeight() - 2;
        }
        return this.size;
    }

    static {
        for (int i = 0; i < SPECIAL_FONT_TAGS_ID.length; ++i) {
            SPECIAL_FONT_TAGS.addElement(HTMLElement.TAG_NAMES[SPECIAL_FONT_TAGS_ID[i]]);
        }
    }
}

