/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.html;

import com.codename1.ui.Component;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.html.CellConstraint;
import com.codename1.ui.html.HTMLElement;
import com.codename1.ui.table.TableModel;
import com.codename1.ui.util.EventDispatcher;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class HTMLTableModel
implements TableModel {
    static final int SEGMENT_THEAD = 0;
    static final int SEGMENT_TBODY = 1;
    static final int SEGMENT_TFOOT = 2;
    Vector rows = new Vector();
    Vector headers = new Vector();
    int maxColumn;
    Vector currentRow = new Vector();
    Vector lastCommittedRow;
    Hashtable constraints = new Hashtable();
    HTMLElement captionTextTag;
    Vector segmentEnds;
    int curSegmentType = 1;
    int rowInsretionPos = -1;
    int bodyInsertionPos = 0;
    boolean hasTHead;
    boolean hasTFoot;
    private final EventDispatcher dispatcher = new EventDispatcher();

    HTMLTableModel() {
    }

    void addCell(Component cell, boolean isHeader, CellConstraint constraint) {
        if (isHeader) {
            this.headers.addElement(cell);
        }
        this.currentRow.addElement(cell);
        if (this.currentRow.size() > this.maxColumn) {
            this.maxColumn = this.currentRow.size();
        }
        if (constraint != null) {
            this.constraints.put(cell, constraint);
        }
    }

    void setAlignToAll(boolean isHorizontal, int align) {
        Enumeration e = this.constraints.elements();
        while (e.hasMoreElements()) {
            CellConstraint cc = (CellConstraint)e.nextElement();
            if (isHorizontal) {
                cc.setHorizontalAlign(align);
                continue;
            }
            cc.setVerticalAlign(align);
        }
    }

    CellConstraint getConstraint(Object object) {
        return (CellConstraint)this.constraints.get(object);
    }

    boolean isHeader(Object object) {
        return this.headers.contains(object);
    }

    void commitRow() {
        if (this.rowInsretionPos == -1) {
            this.rows.addElement(this.currentRow);
        } else {
            this.rows.insertElementAt(this.currentRow, this.rowInsretionPos++);
        }
        if (this.curSegmentType != 2) {
            ++this.bodyInsertionPos;
        }
        this.lastCommittedRow = this.currentRow;
        this.currentRow = new Vector();
    }

    void commitRowIfNotEmpty() {
        if (this.currentRow.size() > 0) {
            this.commitRow();
        }
    }

    void startSegment(int segmentType) {
        if (segmentType == 0 && !this.hasTHead) {
            this.rowInsretionPos = 0;
            this.hasTHead = true;
            this.curSegmentType = 0;
        } else if (segmentType == 2 && !this.hasTFoot) {
            this.rowInsretionPos = -1;
            this.hasTFoot = true;
            this.curSegmentType = 2;
        } else {
            this.rowInsretionPos = this.bodyInsertionPos;
            this.curSegmentType = 1;
        }
    }

    void endSegment() {
        if (this.lastCommittedRow != null) {
            if (this.segmentEnds == null) {
                this.segmentEnds = new Vector();
            }
            this.segmentEnds.addElement(this.lastCommittedRow);
        }
        this.curSegmentType = 1;
        this.rowInsretionPos = this.bodyInsertionPos;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.maxColumn;
    }

    public String getColumnName(int i) {
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int row, int column) {
        if (row >= this.rows.size()) {
            return null;
        }
        Vector columns = (Vector)this.rows.elementAt(row);
        if (column >= columns.size()) {
            return null;
        }
        return columns.elementAt(column);
    }

    public void setValueAt(int row, int column, Object o) {
        Vector columns = (Vector)this.rows.elementAt(row);
        columns.removeElementAt(column);
        columns.setElementAt(o, column);
        this.dispatcher.fireDataChangeEvent(column, row);
    }

    public void addDataChangeListener(DataChangedListener d) {
        this.dispatcher.addListener(d);
    }

    public void removeDataChangeListener(DataChangedListener d) {
        this.dispatcher.removeListener(d);
    }

    boolean isSegmentEnd(int row) {
        if (this.segmentEnds == null || row < 0 || row >= this.rows.size()) {
            return false;
        }
        return this.segmentEnds.contains(this.rows.elementAt(row));
    }
}

