/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.Style;
import java.util.HashMap;

public class BorderLayout
extends Layout {
    public static final int CENTER_BEHAVIOR_SCALE = 0;
    public static final int CENTER_BEHAVIOR_CENTER = 1;
    public static final int CENTER_BEHAVIOR_CENTER_ABSOLUTE = 2;
    public static final int CENTER_BEHAVIOR_TOTAL_BELLOW = 3;
    public static final int CENTER_BEHAVIOR_TOTAL_BELOW = 3;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String CENTER = "Center";
    public static final String WEST = "West";
    public static final String EAST = "East";
    public static final String OVERLAY = "Overlay";
    private boolean scaleEdges = true;
    private Component portraitNorth;
    private Component portraitSouth;
    private Component portraitCenter;
    private Component portraitWest;
    private Component portraitEast;
    private Component overlay;
    private HashMap<String, String> landscapeSwap;
    private int centerBehavior;
    private final Dimension dim = new Dimension(0, 0);

    public BorderLayout() {
    }

    public BorderLayout(int behavior) {
        this.setCenterBehavior(behavior);
    }

    public static BorderLayout center() {
        return new BorderLayout(1);
    }

    public static BorderLayout absolute() {
        return new BorderLayout(2);
    }

    public static BorderLayout totalBelow() {
        return new BorderLayout(3);
    }

    public static Container center(Component center) {
        return Container.encloseIn((Layout)new BorderLayout(), center, CENTER);
    }

    public static Container centerEastWest(Component center, Component east, Component west) {
        Container c = center != null ? BorderLayout.center(center) : new Container(new BorderLayout());
        if (east != null) {
            c.add((Object)EAST, east);
        }
        if (west != null) {
            c.add((Object)WEST, west);
        }
        return c;
    }

    public static Container centerAbsoluteEastWest(Component center, Component east, Component west) {
        Container c = center != null ? BorderLayout.centerAbsolute(center) : new Container(new BorderLayout(2));
        if (east != null) {
            c.add((Object)EAST, east);
        }
        if (west != null) {
            c.add((Object)WEST, west);
        }
        return c;
    }

    public static Container centerCenterEastWest(Component center, Component east, Component west) {
        Container c = center != null ? BorderLayout.centerCenter(center) : new Container(new BorderLayout(1));
        if (east != null) {
            c.add((Object)EAST, east);
        }
        if (west != null) {
            c.add((Object)WEST, west);
        }
        return c;
    }

    public static Container centerTotalBelowEastWest(Component center, Component east, Component west) {
        Container c = center != null ? BorderLayout.centerTotalBelow(center) : new Container(new BorderLayout(3));
        if (east != null) {
            c.add((Object)EAST, east);
        }
        if (west != null) {
            c.add((Object)WEST, west);
        }
        return c;
    }

    public static Container centerCenter(Component center) {
        return Container.encloseIn((Layout)new BorderLayout(1), center, CENTER);
    }

    public static Container centerAbsolute(Component center) {
        return Container.encloseIn((Layout)new BorderLayout(2), center, CENTER);
    }

    public static Container centerTotalBelow(Component center) {
        return Container.encloseIn((Layout)new BorderLayout(3), center, CENTER);
    }

    public static Container north(Component north) {
        return Container.encloseIn((Layout)new BorderLayout(), north, NORTH);
    }

    public static Container south(Component south) {
        return Container.encloseIn((Layout)new BorderLayout(), south, SOUTH);
    }

    public static Container east(Component east) {
        return Container.encloseIn((Layout)new BorderLayout(), east, EAST);
    }

    public static Container west(Component west) {
        return Container.encloseIn((Layout)new BorderLayout(), west, WEST);
    }

    public void addLayoutComponent(Object name, Component comp, Container c) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot add component to BorderLayout Container without constraint parameter");
        }
        if (name instanceof Integer) {
            switch ((Integer)name) {
                case 0: {
                    name = NORTH;
                    break;
                }
                case 2: {
                    name = SOUTH;
                    break;
                }
                case 1: {
                    name = WEST;
                    break;
                }
                case 3: {
                    name = EAST;
                    break;
                }
                case 4: {
                    name = CENTER;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("BorderLayout Container expects one of the constraints BorderLayout.NORTH/SOUTH/EAST/WEST/CENTER");
                }
            }
        }
        Component previous = null;
        if (CENTER.equals(name)) {
            previous = this.portraitCenter;
            this.portraitCenter = comp;
        } else if (NORTH.equals(name)) {
            previous = this.portraitNorth;
            this.portraitNorth = comp;
        } else if (SOUTH.equals(name)) {
            previous = this.portraitSouth;
            this.portraitSouth = comp;
        } else if (EAST.equals(name)) {
            previous = this.portraitEast;
            this.portraitEast = comp;
        } else if (WEST.equals(name)) {
            previous = this.portraitWest;
            this.portraitWest = comp;
        } else if (OVERLAY.equals(name)) {
            previous = this.overlay;
            this.overlay = comp;
        } else {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
        }
        if (previous != null && previous != comp) {
            c.removeComponent(previous);
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == this.portraitCenter) {
            this.portraitCenter = null;
        } else if (comp == this.portraitNorth) {
            this.portraitNorth = null;
        } else if (comp == this.portraitSouth) {
            this.portraitSouth = null;
        } else if (comp == this.portraitEast) {
            this.portraitEast = null;
        } else if (comp == this.portraitWest) {
            this.portraitWest = null;
        } else if (comp == this.overlay) {
            this.overlay = null;
        }
    }

    public Object getComponentConstraint(Component comp) {
        if (comp == this.portraitCenter) {
            return CENTER;
        }
        if (comp == this.portraitNorth) {
            return NORTH;
        }
        if (comp == this.portraitSouth) {
            return SOUTH;
        }
        if (comp == this.portraitEast) {
            return EAST;
        }
        if (comp == this.overlay) {
            return OVERLAY;
        }
        if (comp == this.portraitWest) {
            return WEST;
        }
        return null;
    }

    public void layoutContainer(Container target) {
        Component c;
        Component c2;
        Style s = target.getStyle();
        int top = s.getPaddingTop();
        int bottom = target.getLayoutHeight() - target.getBottomGap() - s.getPaddingBottom();
        int left = s.getPaddingLeft(target.isRTL());
        int right = target.getLayoutWidth() - target.getSideGap() - s.getPaddingRight(target.isRTL());
        int targetWidth = target.getWidth();
        int targetHeight = target.getHeight();
        boolean rtl = target.isRTL();
        if (rtl) {
            left += target.getSideGap();
        }
        Component east = this.getEast();
        Component west = this.getWest();
        Component south = this.getSouth();
        Component north = this.getNorth();
        Component center = this.getCenter();
        if (north != null) {
            c2 = north;
            this.positionTopBottom(target, c2, right, left, targetHeight);
            c2.setY(top + c2.getStyle().getMarginTop());
            top += c2.getHeight() + c2.getStyle().getMarginTop() + c2.getStyle().getMarginBottom();
        }
        if (south != null) {
            c2 = south;
            this.positionTopBottom(target, c2, right, left, targetHeight);
            c2.setY(bottom - c2.getHeight() - c2.getStyle().getMarginBottom());
            bottom -= c2.getHeight() + c2.getStyle().getMarginTop() + c2.getStyle().getMarginBottom();
        }
        Component realEast = east;
        Component realWest = west;
        if (rtl) {
            realEast = west;
            realWest = east;
        }
        if (realEast != null) {
            c = realEast;
            this.positionLeftRight(realEast, targetWidth, bottom, top);
            c.setX(right - c.getWidth() - c.getStyle().getMarginRight(rtl));
            right -= c.getWidth() + c.getStyle().getHorizontalMargins();
        }
        if (realWest != null) {
            c = realWest;
            this.positionLeftRight(realWest, targetWidth, bottom, top);
            c.setX(left + c.getStyle().getMarginLeft(rtl));
            left += c.getWidth() + c.getStyle().getMarginLeftNoRTL() + c.getStyle().getMarginRightNoRTL();
        }
        if (center != null) {
            c = center;
            int w = right - left - c.getStyle().getMarginLeftNoRTL() - c.getStyle().getMarginRightNoRTL();
            int h = bottom - top - c.getStyle().getMarginTop() - c.getStyle().getMarginBottom();
            int x = left + c.getStyle().getMarginLeft(rtl);
            int y = top + c.getStyle().getMarginTop();
            switch (this.centerBehavior) {
                case 2: {
                    Dimension d = c.getPreferredSize();
                    for (int passNum = 0; passNum < 2; ++passNum) {
                        if (d.getWidth() < w) {
                            int newX = s.getPaddingLeft(rtl) - s.getPaddingRight(rtl) + targetWidth / 2 - d.getWidth() / 2;
                            if (newX > x) {
                                x = newX;
                            }
                            w = d.getWidth();
                        }
                        if (passNum != 0) continue;
                        c.setWidth(w);
                        d = c.getPreferredSize();
                    }
                    int append = 0;
                    int th = targetHeight;
                    if (north != null) {
                        append = north.getHeight();
                        th -= append;
                    }
                    if (south != null) {
                        th -= south.getHeight();
                    }
                    if (d.getHeight() >= h) break;
                    int newY = (s.getPaddingTop() + th) / 2 - d.getHeight() / 2 + append;
                    if (newY > y) {
                        y = newY;
                    }
                    h = d.getHeight();
                    break;
                }
                case 1: {
                    Dimension d = c.getPreferredSize();
                    for (int passNum = 0; passNum < 2; ++passNum) {
                        if (d.getWidth() < w) {
                            x += w / 2 - d.getWidth() / 2;
                            w = d.getWidth();
                        }
                        if (passNum != 0) continue;
                        c.setWidth(w);
                        d = c.getPreferredSize();
                    }
                    if (d.getHeight() >= h) break;
                    y += h / 2 - d.getHeight() / 2;
                    h = d.getHeight();
                    break;
                }
                case 3: {
                    w = targetWidth;
                    h = targetHeight;
                    x = s.getPaddingLeft(rtl);
                    y = s.getPaddingTop();
                }
            }
            c.setWidth(w);
            c.setHeight(h);
            c.setX(x);
            c.setY(y);
        }
        if (this.overlay != null) {
            c = this.overlay;
            c.setWidth(targetWidth);
            c.setHeight(targetHeight);
            c.setX(0);
            c.setY(0);
        }
    }

    private void positionLeftRight(Component c, int targetWidth, int bottom, int top) {
        int y = top + c.getStyle().getMarginTop();
        int h = bottom - top - c.getStyle().getMarginTop() - c.getStyle().getMarginBottom();
        if (this.scaleEdges) {
            c.setY(y);
            c.setHeight(h);
        } else {
            int ph = c.getPreferredH();
            if (ph < h) {
                c.setHeight(ph);
                c.setY(y + (h - ph) / 2);
            } else {
                c.setY(y);
                c.setHeight(h);
            }
        }
        c.setWidth(Math.min(targetWidth, c.getPreferredW()));
    }

    private void positionTopBottom(Component target, Component c, int right, int left, int targetHeight) {
        int w = right - left - c.getStyle().getMarginLeftNoRTL() - c.getStyle().getMarginRightNoRTL();
        int x = left + c.getStyle().getMarginLeft(target.isRTL());
        if (this.scaleEdges) {
            c.setWidth(w);
            c.setX(x);
        } else {
            int pw = c.getPreferredW();
            if (pw < w) {
                c.setWidth(pw);
                c.setX(x + (w - pw) / 2);
            } else {
                c.setWidth(w);
                c.setX(x);
            }
        }
        c.setHeight(Math.min(targetHeight, c.getPreferredH()));
    }

    public Dimension getPreferredSize(Container parent) {
        this.dim.setWidth(0);
        this.dim.setHeight(0);
        Component east = this.getEast();
        Component west = this.getWest();
        Component south = this.getSouth();
        Component north = this.getNorth();
        Component center = this.getCenter();
        if (east != null) {
            this.dim.setWidth(east.getPreferredW() + east.getStyle().getMarginLeftNoRTL() + east.getStyle().getMarginRightNoRTL());
            this.dim.setHeight(Math.max(east.getPreferredH() + east.getStyle().getMarginTop() + east.getStyle().getMarginBottom(), this.dim.getHeight()));
        }
        if (west != null) {
            this.dim.setWidth(this.dim.getWidth() + west.getPreferredW() + west.getStyle().getMarginLeftNoRTL() + west.getStyle().getMarginRightNoRTL());
            this.dim.setHeight(Math.max(west.getPreferredH() + west.getStyle().getMarginTop() + west.getStyle().getMarginBottom(), this.dim.getHeight()));
        }
        if (center != null) {
            this.dim.setWidth(this.dim.getWidth() + center.getPreferredW() + center.getStyle().getMarginLeftNoRTL() + center.getStyle().getMarginRightNoRTL());
            this.dim.setHeight(Math.max(center.getPreferredH() + center.getStyle().getMarginTop() + center.getStyle().getMarginBottom(), this.dim.getHeight()));
        }
        if (north != null) {
            this.dim.setWidth(Math.max(north.getPreferredW() + north.getStyle().getMarginLeftNoRTL() + north.getStyle().getMarginRightNoRTL(), this.dim.getWidth()));
            this.dim.setHeight(this.dim.getHeight() + north.getPreferredH() + north.getStyle().getMarginTop() + north.getStyle().getMarginBottom());
        }
        if (south != null) {
            this.dim.setWidth(Math.max(south.getPreferredW() + south.getStyle().getMarginLeftNoRTL() + south.getStyle().getMarginRightNoRTL(), this.dim.getWidth()));
            this.dim.setHeight(this.dim.getHeight() + south.getPreferredH() + south.getStyle().getMarginTop() + south.getStyle().getMarginBottom());
        }
        this.dim.setWidth(this.dim.getWidth() + parent.getStyle().getHorizontalPadding());
        this.dim.setHeight(this.dim.getHeight() + parent.getStyle().getVerticalPadding());
        return this.dim;
    }

    private boolean isLandscape() {
        Display d = Display.getInstance();
        return !d.isPortrait();
    }

    private Component getComponentAtIgnoreLandscape(String constraint) {
        if (constraint != null) {
            if (constraint.equals(NORTH)) {
                return this.portraitNorth;
            }
            if (constraint.equals(SOUTH)) {
                return this.portraitSouth;
            }
            if (constraint.equals(EAST)) {
                return this.portraitEast;
            }
            if (constraint.equals(WEST)) {
                return this.portraitWest;
            }
            if (constraint.equals(CENTER)) {
                return this.portraitCenter;
            }
        }
        return null;
    }

    private Component getComponentImpl(Component noLandscape, String orientation) {
        String s;
        if (this.landscapeSwap != null && this.isLandscape() && (s = this.landscapeSwap.get(orientation)) != null) {
            return this.getComponentAtIgnoreLandscape(s);
        }
        return noLandscape;
    }

    public Component getSouth() {
        return this.getComponentImpl(this.portraitSouth, SOUTH);
    }

    public Component getCenter() {
        return this.getComponentImpl(this.portraitCenter, CENTER);
    }

    public Component getNorth() {
        return this.getComponentImpl(this.portraitNorth, NORTH);
    }

    public Component getEast() {
        return this.getComponentImpl(this.portraitEast, EAST);
    }

    public Component getWest() {
        return this.getComponentImpl(this.portraitWest, WEST);
    }

    public Component getOverlay() {
        return this.overlay;
    }

    public String toString() {
        return "BorderLayout";
    }

    public void defineLandscapeSwap(String portraitPosition, String landscapePosition) {
        if (this.landscapeSwap == null) {
            this.landscapeSwap = new HashMap();
        }
        this.landscapeSwap.put(portraitPosition, landscapePosition);
        this.landscapeSwap.put(landscapePosition, portraitPosition);
    }

    public String getLandscapeSwap(String portraitPosition) {
        if (this.landscapeSwap == null) {
            return null;
        }
        return this.landscapeSwap.get(portraitPosition);
    }

    public boolean equals(Object o) {
        if (super.equals(o) && this.centerBehavior == ((BorderLayout)o).centerBehavior) {
            if (this.landscapeSwap == ((BorderLayout)o).landscapeSwap) {
                return true;
            }
            if (this.landscapeSwap != null) {
                return this.landscapeSwap.equals(((BorderLayout)o).landscapeSwap);
            }
        }
        return false;
    }

    public boolean isAbsoluteCenter() {
        return this.centerBehavior == 1;
    }

    public void setAbsoluteCenter(boolean absoluteCenter) {
        if (absoluteCenter) {
            this.setCenterBehavior(1);
        } else {
            this.setCenterBehavior(0);
        }
    }

    public int getCenterBehavior() {
        return this.centerBehavior;
    }

    public void setCenterBehavior(int centerBehavior) {
        this.centerBehavior = centerBehavior;
    }

    public boolean isOverlapSupported() {
        return this.centerBehavior == 3 || this.overlay != null;
    }

    public boolean isScaleEdges() {
        return this.scaleEdges;
    }

    public void setScaleEdges(boolean scaleEdges) {
        this.scaleEdges = scaleEdges;
    }

    public boolean isConstraintTracking() {
        return true;
    }

    public boolean obscuresPotential(Container parent) {
        return this.getCenter() != null;
    }

    public boolean overridesTabIndices(Container parent) {
        return true;
    }

    protected Component[] getChildrenInTraversalOrder(Container parent) {
        return new Component[]{this.portraitNorth, this.portraitWest, this.portraitCenter, this.portraitEast, this.portraitSouth};
    }
}

