/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.geom.Dimension;

public abstract class Layout {
    private static int updateTabIndicesImpl(Container parent, Component[] components, int offset) {
        int len = components.length;
        int idx = offset;
        for (int i = 0; i < len; ++i) {
            Component cmp = components[i];
            if (cmp == null) continue;
            int prefIdx = cmp.getPreferredTabIndex();
            if (prefIdx == 0) {
                cmp.setTabIndex(idx++);
            } else {
                cmp.setTabIndex(prefIdx);
            }
            if (!(cmp instanceof Container)) continue;
            idx = ((Container)cmp).updateTabIndices(idx);
        }
        return idx;
    }

    public abstract void layoutContainer(Container var1);

    public abstract Dimension getPreferredSize(Container var1);

    public void addLayoutComponent(Object value, Component comp, Container c) {
        if (value != null) {
            throw new IllegalStateException("Layout doesn't support adding with arguments: " + this.getClass().getName());
        }
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Object getComponentConstraint(Component comp) {
        return null;
    }

    public Object cloneConstraint(Object constraint) {
        return constraint;
    }

    public boolean isOverlapSupported() {
        return false;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean isConstraintTracking() {
        return false;
    }

    public boolean obscuresPotential(Container parent) {
        return false;
    }

    public boolean overridesTabIndices(Container parent) {
        return false;
    }

    public final int updateTabIndices(Container parent, int offset) {
        if (this.overridesTabIndices(parent)) {
            Component[] cmps = this.getChildrenInTraversalOrder(parent);
            return Layout.updateTabIndicesImpl(parent, cmps, offset);
        }
        return offset;
    }

    protected Component[] getChildrenInTraversalOrder(Container parent) {
        return null;
    }
}

