/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;

public class LayoutStyle {
    public static final int RELATED = 0;
    public static final int UNRELATED = 1;
    public static final int INDENT = 3;
    private static LayoutStyle layoutStyle = new LayoutStyle();

    public static LayoutStyle getSharedInstance() {
        return layoutStyle;
    }

    public static void setSharedInstance(LayoutStyle layout) {
        layoutStyle = layout;
    }

    public int getPreferredGap(Component component1, Component component2, int type, int position, Container parent) {
        if (position != 1 && position != 5 && position != 7 && position != 3) {
            throw new IllegalArgumentException("Invalid position");
        }
        if (component1 == null || component2 == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        if (type == 0) {
            return Display.getInstance().convertToPixels(1, true);
        }
        if (type == 1) {
            return Display.getInstance().convertToPixels(2, true);
        }
        if (type == 3) {
            if (position == 3 || position == 7) {
                int gap = this.getButtonChildIndent(component1, position);
                if (gap != 0) {
                    return gap;
                }
                return Display.getInstance().convertToPixels(1, true);
            }
            return Display.getInstance().convertToPixels(1, true);
        }
        throw new IllegalArgumentException("Invalid type");
    }

    public int getContainerGap(Component component, int position, Container parent) {
        if (position != 1 && position != 5 && position != 7 && position != 3) {
            throw new IllegalArgumentException("Invalid position");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must be non-null");
        }
        return Display.getInstance().convertToPixels(2, true);
    }

    int getCBRBPadding(Component source, Component target, int position, int offset) {
        if ((offset -= this.getCBRBPadding(source, position)) > 0) {
            offset -= this.getCBRBPadding(target, this.flipDirection(position));
        }
        if (offset < 0) {
            return 0;
        }
        return offset;
    }

    int getCBRBPadding(Component source, int position, int offset) {
        return Math.max(offset -= this.getCBRBPadding(source, position), 0);
    }

    int flipDirection(int position) {
        switch (position) {
            case 1: {
                return 5;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Illegal position: " + position);
    }

    private int getCBRBPadding(Component c, int position) {
        return 0;
    }

    private int getInset(Component c, int position) {
        int insetLeft = c.getStyle().getMarginLeftNoRTL();
        int insetTop = c.getStyle().getMarginTop();
        int insetRight = c.getStyle().getMarginRightNoRTL();
        int insetBottom = c.getStyle().getMarginBottom();
        switch (position) {
            case 1: {
                return insetTop;
            }
            case 5: {
                return insetBottom;
            }
            case 3: {
                return insetRight;
            }
            case 7: {
                return insetLeft;
            }
        }
        throw new IllegalArgumentException("Illegal argument position: " + position);
    }

    int getButtonChildIndent(Component c, int position) {
        return 0;
    }
}

