/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.InputComponent;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.table.TableLayout;
import java.util.ArrayList;

public class TextModeLayout
extends Layout {
    public final TableLayout table;
    private final Layout actual;
    private boolean autoGrouping = true;
    private int lastComponentCount = 0;

    public TextModeLayout(int rows, int columns) {
        this.table = new TableLayout(rows, columns);
        this.table.setGrowHorizontally(true);
        this.actual = !UIManager.getInstance().isThemeConstant("textComponentOnTopBool", false) ? BoxLayout.y() : this.table;
    }

    public void addLayoutComponent(Object value, Component comp, Container c) {
        if (this.actual == this.table) {
            if (!(value instanceof TableLayout.Constraint)) {
                value = this.createConstraint();
            }
            this.table.addLayoutComponent(value, comp, c);
        }
    }

    public Object cloneConstraint(Object constraint) {
        return this.actual.cloneConstraint(constraint);
    }

    public Object getComponentConstraint(Component comp) {
        return this.actual.getComponentConstraint(comp);
    }

    public boolean isConstraintTracking() {
        return this.actual.isConstraintTracking();
    }

    public boolean isOverlapSupported() {
        return this.actual.isOverlapSupported();
    }

    public boolean obscuresPotential(Container parent) {
        return this.actual.obscuresPotential(parent);
    }

    public void removeLayoutComponent(Component comp) {
        this.actual.removeLayoutComponent(comp);
    }

    public void layoutContainer(Container parent) {
        if (this.autoGrouping && this.actual != this.table && this.lastComponentCount != parent.getComponentCount()) {
            this.lastComponentCount = parent.getComponentCount();
            ArrayList<Component> tc = new ArrayList<Component>();
            for (Component c : parent) {
                if (!(c instanceof InputComponent)) continue;
                tc.add(c);
            }
            if (tc.size() > 0) {
                Component[] tcArr = new Component[tc.size()];
                tc.toArray(tcArr);
                InputComponent.group(tcArr);
            }
        }
        this.actual.layoutContainer(parent);
    }

    public Dimension getPreferredSize(Container parent) {
        return this.actual.getPreferredSize(parent);
    }

    public TableLayout.Constraint createConstraint() {
        return this.table.createConstraint().verticalAlign(0);
    }

    public TableLayout.Constraint cc() {
        return this.table.createConstraint().verticalAlign(0);
    }

    public TableLayout.Constraint createConstraint(int row, int column) {
        return this.table.createConstraint(row, column).verticalAlign(0);
    }

    public TableLayout.Constraint cc(int row, int column) {
        return this.table.createConstraint(row, column).verticalAlign(0);
    }

    public boolean isAutoGrouping() {
        return this.autoGrouping;
    }

    public void setAutoGrouping(boolean autoGrouping) {
        this.autoGrouping = autoGrouping;
    }
}

