/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts.mig;

import com.codename1.ui.layouts.mig.BoundSize;
import com.codename1.ui.layouts.mig.ConstraintParser;
import com.codename1.ui.layouts.mig.DimConstraint;
import com.codename1.ui.layouts.mig.UnitValue;
import java.util.ArrayList;
import java.util.Collections;

public final class AC {
    private final ArrayList<DimConstraint> cList = new ArrayList(8);
    private transient int curIx = 0;

    public AC() {
        this.cList.add(new DimConstraint());
    }

    public DimConstraint[] getConstaints() {
        return this.cList.toArray(new DimConstraint[this.cList.size()]);
    }

    public void setConstaints(DimConstraint[] constr) {
        if (constr == null || constr.length < 1) {
            constr = new DimConstraint[]{new DimConstraint()};
        }
        this.cList.clear();
        this.cList.ensureCapacity(constr.length);
        Collections.addAll(this.cList, constr);
    }

    public int getCount() {
        return this.cList.size();
    }

    public AC count(int size) {
        this.makeSize(size);
        return this;
    }

    public AC noGrid() {
        return this.noGrid(this.curIx);
    }

    public AC noGrid(int ... indexes) {
        for (int i = indexes.length - 1; i >= 0; --i) {
            int ix = indexes[i];
            this.makeSize(ix);
            this.cList.get(ix).setNoGrid(true);
        }
        return this;
    }

    public AC index(int i) {
        this.makeSize(i);
        this.curIx = i;
        return this;
    }

    public AC fill() {
        return this.fill(this.curIx);
    }

    public AC fill(int ... indexes) {
        for (int i = indexes.length - 1; i >= 0; --i) {
            int ix = indexes[i];
            this.makeSize(ix);
            this.cList.get(ix).setFill(true);
        }
        return this;
    }

    public AC sizeGroup() {
        return this.sizeGroup("", this.curIx);
    }

    public AC sizeGroup(String s) {
        return this.sizeGroup(s, this.curIx);
    }

    public AC sizeGroup(String s, int ... indexes) {
        for (int i = indexes.length - 1; i >= 0; --i) {
            int ix = indexes[i];
            this.makeSize(ix);
            this.cList.get(ix).setSizeGroup(s);
        }
        return this;
    }

    public AC size(String s) {
        return this.size(s, this.curIx);
    }

    public AC size(String size, int ... indexes) {
        BoundSize bs = ConstraintParser.parseBoundSize(size, false, true);
        for (int i = indexes.length - 1; i >= 0; --i) {
            int ix = indexes[i];
            this.makeSize(ix);
            this.cList.get(ix).setSize(bs);
        }
        return this;
    }

    public AC gap() {
        ++this.curIx;
        return this;
    }

    public AC gap(String size) {
        return this.gap(size, this.curIx++);
    }

    public AC gap(String size, int ... indexes) {
        BoundSize bsa = size != null ? ConstraintParser.parseBoundSize(size, true, true) : null;
        for (int i = indexes.length - 1; i >= 0; --i) {
            int ix = indexes[i];
            this.makeSize(ix);
            if (bsa == null) continue;
            this.cList.get(ix).setGapAfter(bsa);
        }
        return this;
    }

    public AC align(String side) {
        return this.align(side, this.curIx);
    }

    public AC align(String side, int ... indexes) {
        UnitValue al = ConstraintParser.parseAlignKeywords(side, true);
        if (al == null) {
            al = ConstraintParser.parseAlignKeywords(side, false);
        }
        for (int i = indexes.length - 1; i >= 0; --i) {
            int ix = indexes[i];
            this.makeSize(ix);
            this.cList.get(ix).setAlign(al);
        }
        return this;
    }

    public AC growPrio(int p) {
        return this.growPrio(p, this.curIx);
    }

    public AC growPrio(int p, int ... indexes) {
        for (int i = indexes.length - 1; i >= 0; --i) {
            int ix = indexes[i];
            this.makeSize(ix);
            this.cList.get(ix).setGrowPriority(p);
        }
        return this;
    }

    public AC grow() {
        return this.grow(1.0f, this.curIx);
    }

    public AC grow(float w) {
        return this.grow(w, this.curIx);
    }

    public AC grow(float w, int ... indexes) {
        Float gw = new Float(w);
        for (int i = indexes.length - 1; i >= 0; --i) {
            int ix = indexes[i];
            this.makeSize(ix);
            this.cList.get(ix).setGrow(gw);
        }
        return this;
    }

    public AC shrinkPrio(int p) {
        return this.shrinkPrio(p, this.curIx);
    }

    public AC shrinkPrio(int p, int ... indexes) {
        for (int i = indexes.length - 1; i >= 0; --i) {
            int ix = indexes[i];
            this.makeSize(ix);
            this.cList.get(ix).setShrinkPriority(p);
        }
        return this;
    }

    public AC shrink() {
        return this.shrink(100.0f, this.curIx);
    }

    public AC shrink(float w) {
        return this.shrink(w, this.curIx);
    }

    public AC shrink(float w, int ... indexes) {
        Float sw = new Float(w);
        for (int i = indexes.length - 1; i >= 0; --i) {
            int ix = indexes[i];
            this.makeSize(ix);
            this.cList.get(ix).setShrink(sw);
        }
        return this;
    }

    public AC shrinkWeight(float w) {
        return this.shrink(w);
    }

    public AC shrinkWeight(float w, int ... indexes) {
        return this.shrink(w, indexes);
    }

    private void makeSize(int sz) {
        if (this.cList.size() <= sz) {
            this.cList.ensureCapacity(sz);
            for (int i = this.cList.size(); i <= sz; ++i) {
                this.cList.add(new DimConstraint());
            }
        }
    }
}

