/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts.mig;

import com.codename1.ui.layouts.mig.BoundSize;
import com.codename1.ui.layouts.mig.ConstraintParser;
import com.codename1.ui.layouts.mig.LayoutUtil;
import com.codename1.ui.layouts.mig.UnitValue;

public final class LC {
    private int wrapAfter = 2097051;
    private Boolean leftToRight = null;
    private UnitValue[] insets = null;
    private UnitValue alignX = null;
    private UnitValue alignY = null;
    private BoundSize gridGapX = null;
    private BoundSize gridGapY = null;
    private BoundSize width = BoundSize.NULL_SIZE;
    private BoundSize height = BoundSize.NULL_SIZE;
    private BoundSize packW = BoundSize.NULL_SIZE;
    private BoundSize packH = BoundSize.NULL_SIZE;
    private float pwAlign = 0.5f;
    private float phAlign = 1.0f;
    private int debugMillis = 0;
    private int hideMode = 0;
    private boolean noCache = false;
    private boolean flowX = true;
    private boolean fillX = false;
    private boolean fillY = false;
    private boolean topToBottom = true;
    private boolean noGrid = false;
    private boolean visualPadding = true;

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean b) {
        this.noCache = b;
    }

    public UnitValue getAlignX() {
        return this.alignX;
    }

    public void setAlignX(UnitValue uv) {
        this.alignX = uv;
    }

    public UnitValue getAlignY() {
        return this.alignY;
    }

    public void setAlignY(UnitValue uv) {
        this.alignY = uv;
    }

    public int getDebugMillis() {
        return this.debugMillis;
    }

    public void setDebugMillis(int millis) {
        this.debugMillis = millis;
    }

    public boolean isFillX() {
        return this.fillX;
    }

    public void setFillX(boolean b) {
        this.fillX = b;
    }

    public boolean isFillY() {
        return this.fillY;
    }

    public void setFillY(boolean b) {
        this.fillY = b;
    }

    public boolean isFlowX() {
        return this.flowX;
    }

    public void setFlowX(boolean b) {
        this.flowX = b;
    }

    public BoundSize getGridGapX() {
        return this.gridGapX;
    }

    public void setGridGapX(BoundSize x) {
        this.gridGapX = x;
    }

    public BoundSize getGridGapY() {
        return this.gridGapY;
    }

    public void setGridGapY(BoundSize y) {
        this.gridGapY = y;
    }

    public int getHideMode() {
        return this.hideMode;
    }

    public void setHideMode(int mode) {
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException("Wrong hideMode: " + mode);
        }
        this.hideMode = mode;
    }

    public UnitValue[] getInsets() {
        UnitValue[] unitValueArray;
        if (this.insets != null) {
            UnitValue[] unitValueArray2 = new UnitValue[4];
            unitValueArray2[0] = this.insets[0];
            unitValueArray2[1] = this.insets[1];
            unitValueArray2[2] = this.insets[2];
            unitValueArray = unitValueArray2;
            unitValueArray2[3] = this.insets[3];
        } else {
            unitValueArray = null;
        }
        return unitValueArray;
    }

    public void setInsets(UnitValue[] ins) {
        UnitValue[] unitValueArray;
        if (ins != null) {
            UnitValue[] unitValueArray2 = new UnitValue[4];
            unitValueArray2[0] = ins[0];
            unitValueArray2[1] = ins[1];
            unitValueArray2[2] = ins[2];
            unitValueArray = unitValueArray2;
            unitValueArray2[3] = ins[3];
        } else {
            unitValueArray = null;
        }
        this.insets = unitValueArray;
    }

    public Boolean getLeftToRight() {
        return this.leftToRight;
    }

    public void setLeftToRight(Boolean b) {
        this.leftToRight = b;
    }

    public boolean isNoGrid() {
        return this.noGrid;
    }

    public void setNoGrid(boolean b) {
        this.noGrid = b;
    }

    public boolean isTopToBottom() {
        return this.topToBottom;
    }

    public void setTopToBottom(boolean b) {
        this.topToBottom = b;
    }

    public boolean isVisualPadding() {
        return this.visualPadding;
    }

    public void setVisualPadding(boolean b) {
        this.visualPadding = b;
    }

    public int getWrapAfter() {
        return this.wrapAfter;
    }

    public void setWrapAfter(int count) {
        this.wrapAfter = count;
    }

    public BoundSize getPackWidth() {
        return this.packW;
    }

    public void setPackWidth(BoundSize size) {
        this.packW = size != null ? size : BoundSize.NULL_SIZE;
    }

    public BoundSize getPackHeight() {
        return this.packH;
    }

    public void setPackHeight(BoundSize size) {
        this.packH = size != null ? size : BoundSize.NULL_SIZE;
    }

    public float getPackHeightAlign() {
        return this.phAlign;
    }

    public void setPackHeightAlign(float align) {
        this.phAlign = Math.max(0.0f, Math.min(1.0f, align));
    }

    public float getPackWidthAlign() {
        return this.pwAlign;
    }

    public void setPackWidthAlign(float align) {
        this.pwAlign = Math.max(0.0f, Math.min(1.0f, align));
    }

    public BoundSize getWidth() {
        return this.width;
    }

    public void setWidth(BoundSize size) {
        this.width = size != null ? size : BoundSize.NULL_SIZE;
    }

    public BoundSize getHeight() {
        return this.height;
    }

    public void setHeight(BoundSize size) {
        this.height = size != null ? size : BoundSize.NULL_SIZE;
    }

    public LC pack() {
        return this.pack("pref", "pref");
    }

    public LC pack(String width, String height) {
        this.setPackWidth(width != null ? ConstraintParser.parseBoundSize(width, false, true) : BoundSize.NULL_SIZE);
        this.setPackHeight(height != null ? ConstraintParser.parseBoundSize(height, false, false) : BoundSize.NULL_SIZE);
        return this;
    }

    public LC packAlign(float alignX, float alignY) {
        this.setPackWidthAlign(alignX);
        this.setPackHeightAlign(alignY);
        return this;
    }

    public LC wrap() {
        this.setWrapAfter(0);
        return this;
    }

    public LC wrapAfter(int count) {
        this.setWrapAfter(count);
        return this;
    }

    public LC noCache() {
        this.setNoCache(true);
        return this;
    }

    public LC flowY() {
        this.setFlowX(false);
        return this;
    }

    public LC flowX() {
        this.setFlowX(true);
        return this;
    }

    public LC fill() {
        this.setFillX(true);
        this.setFillY(true);
        return this;
    }

    public LC fillX() {
        this.setFillX(true);
        return this;
    }

    public LC fillY() {
        this.setFillY(true);
        return this;
    }

    public LC leftToRight(boolean b) {
        this.setLeftToRight(b ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public LC rightToLeft() {
        this.setLeftToRight(Boolean.FALSE);
        return this;
    }

    public LC bottomToTop() {
        this.setTopToBottom(false);
        return this;
    }

    public LC topToBottom() {
        this.setTopToBottom(true);
        return this;
    }

    public LC noGrid() {
        this.setNoGrid(true);
        return this;
    }

    public LC noVisualPadding() {
        this.setVisualPadding(false);
        return this;
    }

    public LC insetsAll(String allSides) {
        UnitValue insH = ConstraintParser.parseUnitValue(allSides, true);
        UnitValue insV = ConstraintParser.parseUnitValue(allSides, false);
        this.insets = new UnitValue[]{insV, insH, insV, insH};
        return this;
    }

    public LC insets(String s) {
        this.insets = ConstraintParser.parseInsets(s, true);
        return this;
    }

    public LC insets(String top, String left, String bottom, String right) {
        this.insets = new UnitValue[]{ConstraintParser.parseUnitValue(top, false), ConstraintParser.parseUnitValue(left, true), ConstraintParser.parseUnitValue(bottom, false), ConstraintParser.parseUnitValue(right, true)};
        return this;
    }

    public LC alignX(String align) {
        this.setAlignX(ConstraintParser.parseUnitValueOrAlign(align, true, null));
        return this;
    }

    public LC alignY(String align) {
        this.setAlignY(ConstraintParser.parseUnitValueOrAlign(align, false, null));
        return this;
    }

    public LC align(String ax, String ay) {
        if (ax != null) {
            this.alignX(ax);
        }
        if (ay != null) {
            this.alignY(ay);
        }
        return this;
    }

    public LC gridGapX(String boundsSize) {
        this.setGridGapX(ConstraintParser.parseBoundSize(boundsSize, true, true));
        return this;
    }

    public LC gridGapY(String boundsSize) {
        this.setGridGapY(ConstraintParser.parseBoundSize(boundsSize, true, false));
        return this;
    }

    public LC gridGap(String gapx, String gapy) {
        if (gapx != null) {
            this.gridGapX(gapx);
        }
        if (gapy != null) {
            this.gridGapY(gapy);
        }
        return this;
    }

    public LC debug() {
        this.setDebugMillis(300);
        return this;
    }

    public LC debug(int repaintMillis) {
        this.setDebugMillis(repaintMillis);
        return this;
    }

    public LC hideMode(int mode) {
        this.setHideMode(mode);
        return this;
    }

    public LC minWidth(String width) {
        this.setWidth(LayoutUtil.derive(this.getWidth(), ConstraintParser.parseUnitValue(width, true), null, null));
        return this;
    }

    public LC width(String width) {
        this.setWidth(ConstraintParser.parseBoundSize(width, false, true));
        return this;
    }

    public LC maxWidth(String width) {
        this.setWidth(LayoutUtil.derive(this.getWidth(), null, null, ConstraintParser.parseUnitValue(width, true)));
        return this;
    }

    public LC minHeight(String height) {
        this.setHeight(LayoutUtil.derive(this.getHeight(), ConstraintParser.parseUnitValue(height, false), null, null));
        return this;
    }

    public LC height(String height) {
        this.setHeight(ConstraintParser.parseBoundSize(height, false, false));
        return this;
    }

    public LC maxHeight(String height) {
        this.setHeight(LayoutUtil.derive(this.getHeight(), null, null, ConstraintParser.parseUnitValue(height, false)));
        return this;
    }
}

