/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts.mig;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.TextArea;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.layouts.mig.AC;
import com.codename1.ui.layouts.mig.BoundSize;
import com.codename1.ui.layouts.mig.CC;
import com.codename1.ui.layouts.mig.CodenameOneMiGComponentWrapper;
import com.codename1.ui.layouts.mig.CodenameOneMiGContainerWrapper;
import com.codename1.ui.layouts.mig.ComponentWrapper;
import com.codename1.ui.layouts.mig.ConstraintParser;
import com.codename1.ui.layouts.mig.ContainerWrapper;
import com.codename1.ui.layouts.mig.Grid;
import com.codename1.ui.layouts.mig.LC;
import com.codename1.ui.layouts.mig.LayoutCallback;
import com.codename1.ui.layouts.mig.LayoutUtil;
import com.codename1.ui.layouts.mig.PlatformDefaults;
import com.codename1.ui.layouts.mig.UnitValue;
import com.codename1.ui.plaf.Style;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigLayout
extends Layout {
    private final Map<Component, Object> scrConstrMap = new IdentityHashMap<Component, Object>(8);
    private final Map<ComponentWrapper, CC> ccMap = new HashMap<ComponentWrapper, CC>(8);
    private Object layoutConstraints = "";
    private Object colConstraints = "";
    private Object rowConstraints = "";
    private ContainerWrapper cacheParentW = null;
    private LC lc = null;
    private AC colSpecs = null;
    private AC rowSpecs = null;
    private Grid grid = null;
    private int lastModCount = PlatformDefaults.getModCount();
    private int lastHash = -1;
    private Dimension lastInvalidSize = null;
    private boolean lastWasInvalid = false;
    private Dimension lastParentSize = null;
    private ArrayList<LayoutCallback> callbackList = null;
    private boolean dirty = true;
    private final long lastSize = 0L;

    public MigLayout() {
        this("", "", "");
    }

    public MigLayout(String layoutConstraints) {
        this(layoutConstraints, "", "");
    }

    public MigLayout(String layoutConstraints, String colConstraints) {
        this(layoutConstraints, colConstraints, "");
    }

    public MigLayout(String layoutConstraints, String colConstraints, String rowConstraints) {
        this.setLayoutConstraints(layoutConstraints);
        this.setColumnConstraints(colConstraints);
        this.setRowConstraints(rowConstraints);
    }

    public MigLayout(LC layoutConstraints) {
        this(layoutConstraints, null, null);
    }

    public MigLayout(LC layoutConstraints, AC colConstraints) {
        this(layoutConstraints, colConstraints, null);
    }

    public MigLayout(LC layoutConstraints, AC colConstraints, AC rowConstraints) {
        this.setLayoutConstraints(layoutConstraints);
        this.setColumnConstraints(colConstraints);
        this.setRowConstraints(rowConstraints);
    }

    public static <E> E findType(Class<E> clazz, Component comp) {
        while (comp != null && !clazz.isInstance(comp)) {
            comp = comp.getParent();
        }
        return (E)comp;
    }

    public Object getLayoutConstraints() {
        return this.layoutConstraints;
    }

    public void setLayoutConstraints(Object constr) {
        if (constr == null || constr instanceof String) {
            constr = ConstraintParser.prepare((String)constr);
            this.lc = ConstraintParser.parseLayoutConstraint((String)constr);
        } else if (constr instanceof LC) {
            this.lc = (LC)constr;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + constr.getClass());
        }
        this.layoutConstraints = constr;
        this.dirty = true;
    }

    public Object getColumnConstraints() {
        return this.colConstraints;
    }

    public void setColumnConstraints(Object constr) {
        if (constr == null || constr instanceof String) {
            constr = ConstraintParser.prepare((String)constr);
            this.colSpecs = ConstraintParser.parseColumnConstraints((String)constr);
        } else if (constr instanceof AC) {
            this.colSpecs = (AC)constr;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + constr.getClass());
        }
        this.colConstraints = constr;
        this.dirty = true;
    }

    public Object getRowConstraints() {
        return this.rowConstraints;
    }

    public void setRowConstraints(Object constr) {
        if (constr == null || constr instanceof String) {
            constr = ConstraintParser.prepare((String)constr);
            this.rowSpecs = ConstraintParser.parseRowConstraints((String)constr);
        } else if (constr instanceof AC) {
            this.rowSpecs = (AC)constr;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + constr.getClass());
        }
        this.rowConstraints = constr;
        this.dirty = true;
    }

    public Map<Component, Object> getConstraintMap() {
        return new IdentityHashMap<Component, Object>(this.scrConstrMap);
    }

    public void setConstraintMap(Map<Component, Object> map) {
        this.scrConstrMap.clear();
        this.ccMap.clear();
        for (Map.Entry<Component, Object> entry : map.entrySet()) {
            this.setComponentConstraintsImpl(entry.getKey(), entry.getValue(), true);
        }
    }

    public Object getComponentConstraints(Component comp) {
        return this.scrConstrMap.get(comp);
    }

    public void setComponentConstraints(Component comp, Object constr) {
        this.setComponentConstraintsImpl(comp, constr, false);
    }

    private void setComponentConstraintsImpl(Component comp, Object constr, boolean noCheck) {
        if (!noCheck && !this.scrConstrMap.containsKey(comp)) {
            throw new IllegalArgumentException("Component must already be added to parent!");
        }
        CodenameOneMiGComponentWrapper cw = new CodenameOneMiGComponentWrapper(comp);
        if (constr == null || constr instanceof String) {
            String cStr = ConstraintParser.prepare((String)constr);
            this.scrConstrMap.put(comp, constr);
            this.ccMap.put(cw, ConstraintParser.parseComponentConstraint(cStr));
        } else if (constr instanceof CC) {
            this.scrConstrMap.put(comp, constr);
            this.ccMap.put(cw, (CC)constr);
        } else {
            throw new IllegalArgumentException("Constraint must be String or ComponentConstraint: " + constr.getClass());
        }
        this.dirty = true;
    }

    public boolean isManagingComponent(Component c) {
        return this.scrConstrMap.containsKey(c);
    }

    public void addLayoutCallback(LayoutCallback callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        if (this.callbackList == null) {
            this.callbackList = new ArrayList(1);
        }
        this.callbackList.add(callback);
        this.grid = null;
    }

    public void removeLayoutCallback(LayoutCallback callback) {
        if (this.callbackList != null) {
            this.callbackList.remove(callback);
        }
    }

    private void setDebug(ComponentWrapper parentW, boolean b) {
    }

    private boolean getDebug() {
        return false;
    }

    private int getDebugMillis() {
        int globalDebugMillis = LayoutUtil.getGlobalDebugMillis();
        return globalDebugMillis > 0 ? globalDebugMillis : this.lc.getDebugMillis();
    }

    private void checkCache(Container parent) {
        if (parent == null) {
            return;
        }
        if (this.dirty) {
            this.grid = null;
        }
        this.cleanConstraintMaps(parent);
        int mc = PlatformDefaults.getModCount();
        if (this.lastModCount != mc) {
            this.grid = null;
            this.lastModCount = mc;
        }
        if (!this.lastWasInvalid) {
            this.lastWasInvalid = true;
            int hash = 0;
            boolean resetLastInvalidOnParent = false;
            for (ComponentWrapper wrapper : this.ccMap.keySet()) {
                Object component = wrapper.getComponent();
                if (component instanceof TextArea) {
                    resetLastInvalidOnParent = true;
                }
                hash ^= wrapper.getLayoutHashCode();
                hash += 285134905;
            }
            if (resetLastInvalidOnParent) {
                this.resetLastInvalidOnParent(parent);
            }
            if (hash != this.lastHash) {
                this.grid = null;
                this.lastHash = hash;
            }
            Dimension ps = new Dimension(parent.getWidth(), parent.getHeight());
            if (this.lastInvalidSize == null || !this.lastInvalidSize.equals(ps)) {
                this.grid = null;
                this.lastInvalidSize = ps;
            }
        }
        ContainerWrapper par = this.checkParent(parent);
        this.setDebug(par, this.getDebugMillis() > 0);
        if (this.grid == null) {
            this.grid = new Grid(par, this.lc, this.rowSpecs, this.colSpecs, this.ccMap, this.callbackList);
        }
        this.dirty = false;
    }

    private void cleanConstraintMaps(Container parent) {
        HashSet<Component> parentCompSet = new HashSet<Component>();
        for (int iter = 0; iter < parent.getComponentCount(); ++iter) {
            parentCompSet.add(parent.getComponentAt(iter));
        }
        Iterator<Map.Entry<ComponentWrapper, CC>> it = this.ccMap.entrySet().iterator();
        while (it.hasNext()) {
            Component c = (Component)it.next().getKey().getComponent();
            if (parentCompSet.contains(c)) continue;
            it.remove();
            this.scrConstrMap.remove(c);
        }
    }

    private void resetLastInvalidOnParent(Container parent) {
        while (parent != null) {
            Layout layoutManager = parent.getLayout();
            if (layoutManager instanceof MigLayout) {
                ((MigLayout)layoutManager).lastWasInvalid = false;
            }
            parent = parent.getParent();
        }
    }

    private ContainerWrapper checkParent(Container parent) {
        if (parent == null) {
            return null;
        }
        if (this.cacheParentW == null || this.cacheParentW.getComponent() != parent) {
            this.cacheParentW = new CodenameOneMiGContainerWrapper(parent);
        }
        return this.cacheParentW;
    }

    @Override
    public void layoutContainer(Container parent) {
        this.checkCache(parent);
        Style i = parent.getStyle();
        int[] b = new int[]{i.getMarginLeftNoRTL(), i.getMarginTop(), parent.getWidth() - i.getHorizontalMargins(), parent.getHeight() - i.getVerticalMargins()};
        if (this.grid.layout(b, this.lc.getAlignX(), this.lc.getAlignY(), this.getDebug())) {
            this.grid = null;
            this.checkCache(parent);
            this.grid.layout(b, this.lc.getAlignX(), this.lc.getAlignY(), this.getDebug());
        }
        this.lastInvalidSize = null;
    }

    private void adjustWindowSize(ContainerWrapper parent) {
    }

    private Container getPackable(Component comp) {
        return null;
    }

    private int constrain(ContainerWrapper parent, int winSize, int prefSize, BoundSize constrain) {
        if (constrain == null) {
            return winSize;
        }
        int retSize = winSize;
        UnitValue wUV = constrain.getPreferred();
        if (wUV != null) {
            retSize = wUV.getPixels(prefSize, parent, parent);
        }
        retSize = constrain.constrain(retSize, prefSize, parent);
        return constrain.getGapPush() ? Math.max(winSize, retSize) : retSize;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.getSizeImpl(parent, 0);
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (this.lastParentSize == null || parent.getWidth() != this.lastParentSize.getWidth() || parent.getHeight() != this.lastParentSize.getHeight()) {
            for (ComponentWrapper wrapper : this.ccMap.keySet()) {
                if (wrapper.getContentBias() == -1) continue;
                this.layoutContainer(parent);
                break;
            }
        }
        this.lastParentSize = new Dimension(parent.getWidth(), parent.getHeight());
        return this.getSizeImpl(parent, 1);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private Dimension getSizeImpl(Container parent, int sizeType) {
        this.checkCache(parent);
        Style i = parent.getStyle();
        int w = LayoutUtil.getSizeSafe(this.grid != null ? this.grid.getWidth() : null, sizeType) + i.getHorizontalPadding();
        int h = LayoutUtil.getSizeSafe(this.grid != null ? this.grid.getHeight() : null, sizeType) + i.getVerticalPadding();
        return new Dimension(w, h);
    }

    public float getLayoutAlignmentX(Container parent) {
        return this.lc != null && this.lc.getAlignX() != null ? (float)this.lc.getAlignX().getPixels(1.0f, this.checkParent(parent), null) : 0.0f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return this.lc != null && this.lc.getAlignY() != null ? (float)this.lc.getAlignY().getPixels(1.0f, this.checkParent(parent), null) : 0.0f;
    }

    @Override
    public void addLayoutComponent(Object value, Component comp, Container c) {
        this.addLayoutComponent(comp, value);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        this.setComponentConstraintsImpl(comp, constraints, true);
    }

    @Override
    public boolean isConstraintTracking() {
        return true;
    }

    @Override
    public Object getComponentConstraint(Component comp) {
        return this.scrConstrMap.get(comp);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.scrConstrMap.remove(comp);
        this.ccMap.remove(new CodenameOneMiGComponentWrapper(comp));
        this.grid = null;
    }

    public void invalidateLayout(Container target) {
        this.dirty = true;
    }

    @Override
    public Dimension getPreferredSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }
}

