/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.list;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.events.SelectionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.list.CellRenderer;
import com.codename1.ui.list.DefaultListCellRenderer;
import com.codename1.ui.list.DefaultListModel;
import com.codename1.ui.list.ListModel;
import com.codename1.ui.util.EventDispatcher;
import java.util.Collection;
import java.util.Vector;

public class ContainerList
extends Container {
    private CellRenderer renderer = new DefaultListCellRenderer();
    private ListModel model;
    private Listeners listener;
    private final EventDispatcher dispatcher = new EventDispatcher();

    public ContainerList() {
        this(new DefaultListModel());
    }

    public ContainerList(ListModel m) {
        this.init(m);
    }

    public ContainerList(Layout l, ListModel m) {
        super(l);
        this.init(m);
    }

    private void init(ListModel m) {
        this.setModel(m);
        this.setUIID("ContainerList");
        this.setScrollableY(true);
    }

    public CellRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CellRenderer r) {
        this.renderer = r;
        for (int iter = 0; iter < this.getComponentCount(); ++iter) {
            this.getComponentAt(iter).setShouldCalcPreferredSize(true);
        }
        this.setScrollSize(null);
        if (this.isInitialized()) {
            this.revalidate();
        }
    }

    private void updateComponentCount() {
        int modelCount;
        int cc = this.getComponentCount();
        if (cc != (modelCount = this.model.getSize())) {
            Form f;
            if (cc < modelCount) {
                for (int iter = cc; iter < modelCount; ++iter) {
                    this.addComponent(new Entry(iter));
                }
            } else {
                while (this.getComponentCount() > modelCount) {
                    this.removeComponent(this.getComponentAt(this.getComponentCount() - 1));
                }
            }
            if ((f = this.getComponentForm()) != null) {
                f.revalidate();
            }
        }
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel model) {
        if (this.model != null && this.listener != null) {
            this.model.removeDataChangedListener(this.listener);
            this.model.removeSelectionListener(this.listener);
            this.listener = null;
        }
        this.model = model;
        this.updateComponentCount();
        if (model.getSelectedIndex() > 0) {
            this.getComponentAt(model.getSelectedIndex()).requestFocus();
        }
        if (this.isInitialized()) {
            this.bindListeners();
        }
        this.repaint();
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public Vector getActionListeners() {
        return this.dispatcher.getListenerVector();
    }

    public Collection getListeners() {
        return this.dispatcher.getListenerCollection();
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    protected void initComponent() {
        if (this.model != null) {
            int i = this.model.getSelectedIndex();
            if (i > 0) {
                this.getComponentAt(i).requestFocus();
            }
            this.bindListeners();
        }
    }

    protected void deinitialize() {
        if (this.model != null && this.listener != null) {
            this.model.removeDataChangedListener(this.listener);
            this.model.removeSelectionListener(this.listener);
            this.listener = null;
        }
    }

    private void bindListeners() {
        if (this.listener == null) {
            this.listener = new Listeners();
            this.model.addDataChangedListener(this.listener);
            this.model.addSelectionListener(this.listener);
        }
    }

    public Object getSelectedItem() {
        int i = this.model.getSelectedIndex();
        if (i > -1) {
            return this.model.getItemAt(i);
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Selection index is negative:" + index);
        }
        this.getComponentAt(index).requestFocus();
        this.model.setSelectedIndex(index);
    }

    protected void fireActionEvent(ActionEvent evt) {
        if (this.isEnabled() && !Display.getInstance().hasDragOccured()) {
            this.dispatcher.fireActionEvent(evt);
        }
    }

    public String[] getPropertyNames() {
        return new String[]{"ListItems", "Renderer"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{CodenameOneImplementation.getObjectArrayClass(), CellRenderer.class};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"Object[]", "CellRenderer"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("ListItems")) {
            Object[] obj = new Object[this.model.getSize()];
            int olen = obj.length;
            for (int iter = 0; iter < olen; ++iter) {
                obj[iter] = this.model.getItemAt(iter);
            }
            return obj;
        }
        if (name.equals("Renderer")) {
            return this.getRenderer();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("ListItems")) {
            this.setModel(new DefaultListModel<Object>((Object[])value));
            return null;
        }
        if (name.equals("Renderer")) {
            this.setRenderer((CellRenderer)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public Rectangle getSelectedRect() {
        Component cmp = this.getComponentAt(this.getSelectedIndex());
        return cmp.getSelectedRect();
    }

    protected int getDragRegionStatus(int x, int y) {
        if (!this.isScrollable()) {
            return 1;
        }
        if (this.isScrollableX()) {
            if (this.isScrollableY()) {
                return 12;
            }
            return 10;
        }
        return 11;
    }

    private class Listeners
    implements DataChangedListener,
    SelectionListener {
        private Listeners() {
        }

        public void dataChanged(int status, int index) {
            ContainerList.this.updateComponentCount();
        }

        public void selectionChanged(int oldSelected, int newSelected) {
            ContainerList.this.getComponentAt(newSelected).requestFocus();
        }
    }

    class Entry
    extends Component {
        private int offset;

        Entry(int off) {
            this.setUIID("Container");
            this.setFocusable(true);
            this.offset = off;
        }

        public void initComponent() {
            this.offset = this.getParent().getComponentIndex(this);
        }

        protected void focusGained() {
            ContainerList.this.model.setSelectedIndex(this.offset);
        }

        public void paintBackground(Graphics g) {
        }

        public void paintBorder(Graphics g) {
        }

        public void paint(Graphics g) {
            Component cmp = ContainerList.this.renderer.getCellRendererComponent(ContainerList.this, ContainerList.this.model, ContainerList.this.model.getItemAt(this.offset), this.offset, this.hasFocus());
            cmp.setX(this.getX());
            cmp.setY(this.getY());
            cmp.setWidth(this.getWidth());
            cmp.setHeight(this.getHeight());
            if (cmp instanceof Container) {
                ((Container)cmp).revalidate();
            }
            cmp.setFocus(this.hasFocus());
            cmp.paintComponent(g);
        }

        public void longPointerPress(int x, int y) {
            super.longPointerPress(x, y);
            this.pointerReleasedImpl(x, y, true);
        }

        public void pointerReleased(int x, int y) {
            super.pointerReleased(x, y);
            this.pointerReleasedImpl(x, y, false);
        }

        public void pointerReleasedImpl(int x, int y, boolean longPress) {
            if (!this.isDragActivated()) {
                Component cmp = ContainerList.this.renderer.getCellRendererComponent(ContainerList.this, ContainerList.this.model, ContainerList.this.model.getItemAt(this.offset), this.offset, this.hasFocus());
                if (cmp instanceof Container) {
                    int newY;
                    int absX = this.getAbsoluteX();
                    int absY = this.getAbsoluteY();
                    int newX = x - absX + cmp.getX();
                    Component selectionCmp = ((Container)cmp).getComponentAt(newX, newY = y - absY + cmp.getY());
                    if (selectionCmp != null) {
                        selectionCmp.setX(0);
                        selectionCmp.setY(0);
                        if (longPress) {
                            selectionCmp.longPointerPress(newX, newY);
                            ContainerList.this.fireActionEvent(new ActionEvent((Object)ContainerList.this, x, y, true));
                            return;
                        }
                        selectionCmp.pointerPressed(newX, newY);
                        selectionCmp.pointerReleased(newX, newY);
                    }
                }
                ContainerList.this.fireActionEvent(new ActionEvent((Object)ContainerList.this, x, y, longPress));
            }
        }

        public void keyReleased(int keyCode) {
            super.keyReleased(keyCode);
            if (Display.getInstance().getGameAction(keyCode) == 8) {
                ContainerList.this.fireActionEvent(new ActionEvent((Object)ContainerList.this, keyCode));
            }
        }

        public Dimension getPreferredSize() {
            ContainerList.this.setScrollSize(null);
            return this.calcPreferredSize();
        }

        public Dimension calcPreferredSize() {
            Component c = ContainerList.this.renderer.getCellRendererComponent(ContainerList.this, ContainerList.this.model, ContainerList.this.model.getItemAt(this.offset), this.offset, this.hasFocus());
            if (this.getWidth() <= 0) {
                c.setWidth(Display.getInstance().getDisplayWidth());
                c.setHeight(Display.getInstance().getDisplayHeight());
            } else {
                c.setWidth(this.getWidth());
                c.setHeight(this.getHeight());
            }
            if (c instanceof Container) {
                ((Container)c).revalidate();
            }
            Dimension d = c.getPreferredSize();
            return d;
        }
    }
}

