/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.list;

import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.List;
import com.codename1.ui.list.CellRenderer;
import com.codename1.ui.list.ListCellRenderer;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListCellRenderer<T>
extends Label
implements ListCellRenderer<T>,
CellRenderer<T> {
    private static boolean showNumbersDefault = true;
    private boolean showNumbers;
    private boolean showNumbersForce;
    private final Label focusComponent = new Label();
    private boolean rightAlignNumbers;
    private boolean alwaysRenderSelection;

    public DefaultListCellRenderer() {
        super("");
        this.setCellRenderer(true);
        this.setEndsWith3Points(false);
        this.focusComponent.setUIID("ListRendererFocus");
        this.focusComponent.setFocus(true);
        this.setUIID("ListRenderer");
    }

    public DefaultListCellRenderer(boolean showNumbers) {
        this();
        this.showNumbersForce = true;
        this.showNumbers = showNumbers;
    }

    public static boolean isShowNumbersDefault() {
        return showNumbersDefault;
    }

    public static void setShowNumbersDefault(boolean def) {
        showNumbersDefault = def;
    }

    @Override
    protected void initLaf(UIManager uim) {
        super.initLaf(uim);
        if (!this.showNumbersForce) {
            this.showNumbers = uim.isThemeConstant("rendererShowsNumbersBool", showNumbersDefault);
        }
    }

    @Override
    public void refreshTheme(boolean merge) {
        super.refreshTheme(merge);
        this.focusComponent.refreshTheme(merge);
    }

    @Override
    public Component getCellRendererComponent(Component list, Object model, T value, int index, boolean isSelected) {
        if (!this.alwaysRenderSelection && !Display.getInstance().shouldRenderSelection(list)) {
            isSelected = false;
        }
        this.setFocus(isSelected);
        if (this.showNumbers) {
            String o;
            String text = "" + value;
            Map<String, String> t = UIManager.getInstance().getBundle();
            if (t != null && value != null && (o = t.get(value.toString())) != null) {
                text = o;
            }
            if (this.isRTL()) {
                this.setText(text + " ." + (index + 1));
            } else {
                this.setText("" + (index + 1) + ". " + text);
            }
        } else if (value != null) {
            String v = value.toString();
            this.setText(v);
            if (this.isRightAlignNumbers()) {
                char c = v.charAt(0);
                Style s = this.getStyle();
                if (c >= '0' && c <= '9') {
                    s.setAlignment(3);
                } else {
                    s.setAlignment(1);
                }
            }
        } else {
            this.setText("null");
        }
        if (value instanceof Command) {
            Image i = ((Command)value).getIcon();
            if (i == null) {
                if (((Command)value).getMaterialIcon() != '\u0000') {
                    if (((Command)value).getIconFont() != null) {
                        this.setFontIcon(((Command)value).getIconFont(), ((Command)value).getMaterialIcon());
                    } else {
                        this.setMaterialIcon(((Command)value).getMaterialIcon());
                    }
                } else {
                    this.setIcon(null);
                }
            } else {
                this.setIcon(i);
            }
            this.setEnabled(((Command)value).isEnabled());
        }
        return this;
    }

    @Override
    public Style getStyle() {
        if (this.alwaysRenderSelection && this.hasFocus()) {
            return this.getSelectedStyle();
        }
        return super.getStyle();
    }

    @Override
    public Component getListCellRendererComponent(List list, T value, int index, boolean isSelected) {
        return this.getCellRendererComponent(list, list.getModel(), value, index, isSelected);
    }

    @Override
    public Component getListFocusComponent(List list) {
        return this.focusComponent;
    }

    @Override
    public void repaint() {
    }

    public boolean isShowNumbers() {
        return this.showNumbers;
    }

    public void setShowNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
        this.showNumbersForce = true;
    }

    public int getSelectionTransparency() {
        return this.focusComponent.getUnselectedStyle().getBgTransparency() & 0xFF;
    }

    public void setSelectionTransparency(int selectionTransparency) {
        this.focusComponent.getUnselectedStyle().setBgTransparency(selectionTransparency);
    }

    @Override
    public Component getFocusComponent(Component list) {
        return this.focusComponent;
    }

    public boolean isRightAlignNumbers() {
        return this.rightAlignNumbers;
    }

    public void setRightAlignNumbers(boolean rightAlignNumbers) {
        this.rightAlignNumbers = rightAlignNumbers;
    }

    public boolean isAlwaysRenderSelection() {
        return this.alwaysRenderSelection;
    }

    public void setAlwaysRenderSelection(boolean alwaysRenderSelection) {
        this.alwaysRenderSelection = alwaysRenderSelection;
    }
}

