/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.plaf;

import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.ImageFactory;
import com.codename1.ui.Stroke;
import com.codename1.ui.geom.GeneralPath;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.plaf.Border;

public class RoundBorder
extends Border {
    private static final String CACHE_KEY = "cn1$$-rbcache";
    private static int instanceCounter;
    private final int instanceVal;
    private long modificationTime;
    private int color = 13840175;
    private int opacity = 255;
    private int strokeColor;
    private int strokeOpacity = 255;
    private Stroke stroke;
    private float strokeThickness;
    private boolean strokeMM;
    private int shadowSpread = Display.getInstance().convertToPixels(2.0f);
    private int shadowOpacity = 0;
    private float shadowX = 0.5f;
    private float shadowY = 0.5f;
    private float shadowBlur = 10.0f;
    private boolean shadowMM;
    private boolean rectangle;
    private boolean onlyLeftRounded;
    private boolean onlyRightRounded;
    private boolean uiid;
    private int strokeAngle = 360;

    private RoundBorder() {
        this.instanceVal = ++instanceCounter;
    }

    public static RoundBorder create() {
        return new RoundBorder();
    }

    public RoundBorder uiid(boolean uiid) {
        this.uiid = uiid;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public boolean getUIID() {
        return this.uiid;
    }

    public RoundBorder color(int color) {
        this.color = color;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder opacity(int opacity) {
        this.opacity = opacity;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder strokeOpacity(int strokeOpacity) {
        this.strokeOpacity = strokeOpacity;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder strokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder stroke(Stroke stroke) {
        this.stroke = stroke;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder stroke(float stroke, boolean mm) {
        this.strokeThickness = stroke;
        if (this.strokeThickness == 0.0f) {
            this.stroke = null;
            return this;
        }
        this.strokeMM = mm;
        if (mm) {
            stroke = Display.getInstance().convertToPixels(stroke);
        }
        return this.stroke(new Stroke(stroke, 2, 0, 1.0f));
    }

    public RoundBorder strokeAngle(int strokeAngle) {
        this.strokeAngle = strokeAngle;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder shadowSpread(int shadowSpread, boolean mm) {
        this.shadowMM = mm;
        this.shadowSpread = shadowSpread;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder shadowSpread(int shadowSpread) {
        this.shadowSpread = shadowSpread;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder shadowOpacity(int shadowOpacity) {
        this.shadowOpacity = shadowOpacity;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder shadowX(float shadowX) {
        this.shadowX = shadowX;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder shadowY(float shadowY) {
        this.shadowY = shadowY;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder shadowBlur(float shadowBlur) {
        this.shadowBlur = shadowBlur;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder rectangle(boolean rectangle) {
        this.rectangle = rectangle;
        this.modificationTime = System.currentTimeMillis();
        return this;
    }

    public RoundBorder onlyLeftRounded(boolean onlyLeftRounded) {
        this.onlyLeftRounded = onlyLeftRounded;
        return this;
    }

    public boolean isOnlyLeftRounded() {
        return this.onlyLeftRounded;
    }

    public RoundBorder onlyRightRounded(boolean onlyRightRounded) {
        this.onlyRightRounded = onlyRightRounded;
        return this;
    }

    public boolean isOnlyRightRounded() {
        return this.onlyRightRounded;
    }

    private Image createTargetImage(Component c, int w, int h, boolean fast) {
        Image target = ImageFactory.createImage(c, w, h, 0);
        int shapeX = 0;
        int shapeY = 0;
        int shapeW = w;
        int shapeH = h;
        Graphics tg = target.getGraphics();
        tg.setAntiAliased(true);
        int shadowSpreadL = this.shadowSpread;
        if (this.shadowMM) {
            shadowSpreadL = Display.getInstance().convertToPixels(shadowSpreadL);
        }
        if (this.shadowOpacity > 0) {
            shapeW -= shadowSpreadL;
            shapeW = (int)((float)shapeW - this.shadowBlur / 2.0f);
            shapeH -= shadowSpreadL;
            shapeH = (int)((float)shapeH - this.shadowBlur / 2.0f);
            shapeX += Math.round(((float)shadowSpreadL + this.shadowBlur / 2.0f) * this.shadowX);
            shapeY += Math.round(((float)shadowSpreadL + this.shadowBlur / 2.0f) * this.shadowY);
            for (int iter = shadowSpreadL - 1; iter >= 0; --iter) {
                tg.translate(iter, iter);
                this.fillShape(tg, 0, this.shadowOpacity / shadowSpreadL, w - iter * 2, h - iter * 2, false);
                tg.translate(-iter, -iter);
            }
            if (Display.getInstance().isGaussianBlurSupported() && !fast) {
                Image blured = Display.getInstance().gaussianBlurImage(target, this.shadowBlur / 2.0f);
                target = ImageFactory.createImage(c, w, h, 0);
                tg = target.getGraphics();
                tg.drawImage(blured, 0, 0);
                tg.setAntiAliased(true);
            }
        }
        tg.translate(shapeX, shapeY);
        if (this.uiid && tg.isShapeClipSupported()) {
            c.getStyle().setBorder(Border.createEmpty());
            GeneralPath gp = new GeneralPath();
            if (this.rectangle) {
                float sw = this.stroke != null ? this.stroke.getLineWidth() : 0.0f;
                gp.moveTo((double)shapeH / 2.0, (double)sw);
                if (this.onlyLeftRounded) {
                    gp.lineTo(shapeW, sw);
                    gp.lineTo(shapeW, (float)shapeH - sw);
                } else {
                    gp.lineTo((double)shapeW - (double)shapeH / 2.0, (double)sw);
                    gp.arcTo((double)shapeW - (double)shapeH / 2.0, (double)shapeH / 2.0, (double)shapeW - (double)shapeH / 2.0, (double)((float)shapeH - sw), true);
                }
                if (this.onlyRightRounded) {
                    gp.lineTo(sw, (float)shapeH - sw);
                    gp.lineTo(sw, sw);
                } else {
                    gp.lineTo((double)shapeH / 2.0, (double)((float)shapeH - sw));
                    gp.arcTo((double)shapeH / 2.0, (double)shapeH / 2.0, (double)shapeH / 2.0, (double)sw, true);
                }
                gp.closePath();
            } else {
                int size = shapeW;
                int xPos = 0;
                int yPos = 0;
                if (shapeW != shapeH) {
                    if (shapeW > shapeH) {
                        size = shapeH;
                        xPos = (shapeW - shapeH) / 2;
                    } else {
                        size = shapeW;
                        yPos = (shapeH - shapeW) / 2;
                    }
                }
                gp.arc((double)xPos, (double)yPos, (double)size, (double)size, 0.0, Math.PI * 2);
            }
            tg.setClip(gp);
            c.getStyle().getBgPainter().paint(tg, new Rectangle(0, 0, w, h));
            c.getStyle().setBorder(this);
            if (this.strokeOpacity > 0 && this.stroke != null) {
                tg.setColor(this.strokeColor);
                tg.setAlpha(this.strokeOpacity);
                tg.setAntiAliased(true);
                tg.drawShape(gp, this.stroke);
            }
        } else {
            this.fillShape(tg, this.color, this.opacity, shapeW, shapeH, true);
        }
        return target;
    }

    public void paintBorderBackground(Graphics g, final Component c) {
        final int w = c.getWidth();
        final int h = c.getHeight();
        int x = c.getX();
        int y = c.getY();
        if (w > 0 && h > 0) {
            Object k = c.getClientProperty(CACHE_KEY + this.instanceVal);
            if (k instanceof CacheValue) {
                CacheValue val = (CacheValue)k;
                if (val.modificationTime == this.modificationTime && val.img.getWidth() == w && val.img.getHeight() == h) {
                    g.drawImage(val.img, x, y);
                    return;
                }
            }
        } else {
            return;
        }
        Image target = this.createTargetImage(c, w, h, true);
        g.drawImage(target, x, y);
        c.putClientProperty(CACHE_KEY + this.instanceVal, new CacheValue(target, this.modificationTime));
        Display.getInstance().callSeriallyOnIdle(new Runnable(){

            public void run() {
                if (w == c.getWidth() && h == c.getHeight()) {
                    Image target = RoundBorder.this.createTargetImage(c, w, h, false);
                    c.putClientProperty(RoundBorder.CACHE_KEY + RoundBorder.this.instanceVal, new CacheValue(target, RoundBorder.this.modificationTime));
                    c.repaint();
                }
            }
        });
    }

    public int getMinimumHeight() {
        return this.shadowSpread + Math.round(this.shadowBlur) + Display.getInstance().convertToPixels(1.0f);
    }

    public int getMinimumWidth() {
        return this.shadowSpread + Math.round(this.shadowBlur) + Display.getInstance().convertToPixels(1.0f);
    }

    private void fillShape(Graphics g, int color, int opacity, int width, int height, boolean stroke) {
        g.setColor(color);
        g.setAlpha(opacity);
        if (!this.rectangle || width <= height) {
            int x = 0;
            int y = 0;
            int size = width;
            if (width != height) {
                if (width > height) {
                    size = height;
                    x = (width - height) / 2;
                } else {
                    size = width;
                    y = (height - width) / 2;
                }
            }
            if (size < 5) {
                return;
            }
            if (stroke && this.stroke != null) {
                int sw = (int)Math.ceil(stroke && this.stroke != null ? (double)this.stroke.getLineWidth() : 0.0);
                GeneralPath arc = new GeneralPath();
                arc.arc((double)(x + sw / 2), (double)(y + sw / 2), (double)(size - sw), (double)(size - sw), 0.0, Math.PI * 2);
                g.fillShape(arc);
                g.setColor(this.strokeColor);
                g.setAlpha(this.strokeOpacity);
                if (this.strokeAngle != 360) {
                    arc = new GeneralPath();
                    arc.arc((double)(x + sw / 2), (double)(y + sw / 2), (double)(size - sw), (double)(size - sw), 1.5707963267948966, -Math.toRadians(this.strokeAngle));
                }
                g.drawShape(arc, this.stroke);
            } else {
                g.fillArc(x, y, size, size, 0, 360);
            }
        } else {
            GeneralPath gp = new GeneralPath();
            float sw = stroke && this.stroke != null ? this.stroke.getLineWidth() : 0.0f;
            gp.moveTo((double)height / 2.0, (double)sw);
            if (this.onlyLeftRounded) {
                gp.lineTo(width, sw);
                gp.lineTo(width, (float)height - sw);
            } else {
                gp.lineTo((double)width - (double)height / 2.0, (double)sw);
                gp.arcTo((double)width - (double)height / 2.0, (double)height / 2.0, (double)width - (double)height / 2.0, (double)((float)height - sw), true);
            }
            if (this.onlyRightRounded) {
                gp.lineTo(sw, (float)height - sw);
                gp.lineTo(sw, sw);
            } else {
                gp.lineTo((double)height / 2.0, (double)((float)height - sw));
                gp.arcTo((double)height / 2.0, (double)height / 2.0, (double)height / 2.0, (double)sw, true);
            }
            gp.closePath();
            g.fillShape(gp);
            if (stroke && this.stroke != null) {
                g.setAlpha(this.strokeOpacity);
                g.setColor(this.strokeColor);
                g.drawShape(gp, this.stroke);
            }
        }
    }

    public boolean isBackgroundPainter() {
        return true;
    }

    public int getColor() {
        return this.color;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public int getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public float getStrokeThickness() {
        return this.strokeThickness;
    }

    public boolean isStrokeMM() {
        return this.strokeMM;
    }

    public int getShadowSpread() {
        return this.shadowSpread;
    }

    public int getShadowOpacity() {
        return this.shadowOpacity;
    }

    public float getShadowX() {
        return this.shadowX;
    }

    public float getShadowY() {
        return this.shadowY;
    }

    public float getShadowBlur() {
        return this.shadowBlur;
    }

    public boolean isShadowMM() {
        return this.shadowMM;
    }

    public boolean isRectangle() {
        return this.rectangle;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    static class CacheValue {
        Image img;
        long modificationTime;

        public CacheValue() {
        }

        public CacheValue(Image img, long modificationTime) {
            this.img = img;
            this.modificationTime = modificationTime;
        }
    }
}

