/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.plaf;

import com.codename1.charts.util.ColorUtil;
import com.codename1.io.Log;
import com.codename1.ui.CN;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Image;
import com.codename1.ui.TextField;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.DefaultLookAndFeel;
import com.codename1.ui.plaf.LookAndFeel;
import com.codename1.ui.plaf.RoundRectBorder;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.StyleParser;
import com.codename1.ui.util.EventDispatcher;
import com.codename1.ui.util.Resources;
import com.codename1.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIManager {
    static UIManager instance;
    static boolean accessible;
    static boolean localeAccessible;
    private LookAndFeel current;
    private final HashMap<String, Style> styles = new HashMap();
    private final HashMap<String, Style> selectedStyles = new HashMap();
    private HashMap<String, Object> themeProps;
    private final HashMap<String, Object> themeConstants = new HashMap();
    private Style defaultStyle = new Style();
    private Style defaultSelectedStyle = new Style();
    private final HashMap<String, Image> imageCache = new HashMap();
    private Hashtable resourceBundle;
    private Map<String, String> bundle;
    private boolean wasThemeInstalled;
    private EventDispatcher themelisteners;
    private Map<String, String> parseCache;

    UIManager() {
        if (instance == null) {
            instance = this;
        }
        this.current = new DefaultLookAndFeel(this);
        this.resetThemeProps(null);
    }

    public static UIManager getInstance() {
        if (instance == null) {
            instance = new UIManager();
        }
        return instance;
    }

    public static UIManager createInstance() {
        return new UIManager();
    }

    private static Image parseImage(String value) throws IOException {
        byte[] imageData = new byte[value.length() / 2];
        int vlen = value.length();
        for (int index = 0; index < vlen; index += 2) {
            String byteStr = value.substring(index, index + 2);
            imageData[index / 2] = Integer.valueOf(byteStr, 16).byteValue();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(imageData);
        Image image = Image.createImage(in);
        in.close();
        return image;
    }

    private static Font parseFont(String fontStr) {
        if (fontStr.startsWith("System")) {
            int face = 0;
            int style = 0;
            int size = 0;
            String sysFont = fontStr.substring(fontStr.indexOf("{") + 1, fontStr.indexOf("}"));
            String faceStr = sysFont.substring(0, sysFont.indexOf(";"));
            sysFont = sysFont.substring(sysFont.indexOf(";") + 1);
            String styleStr = sysFont.substring(0, sysFont.indexOf(";"));
            String sizeStr = sysFont.substring(sysFont.indexOf(";") + 1);
            if (faceStr.indexOf("FACE_SYSTEM") > -1) {
                face = 0;
            } else if (faceStr.indexOf("FACE_MONOSPACE") > -1) {
                face = 32;
            } else if (faceStr.indexOf("FACE_PROPORTIONAL") > -1) {
                face = 64;
            }
            if (styleStr.indexOf("STYLE_PLAIN") > -1) {
                style = 0;
            } else {
                if (styleStr.indexOf("STYLE_BOLD") > -1) {
                    style = 1;
                }
                if (styleStr.indexOf("STYLE_ITALIC") > -1) {
                    style |= 2;
                }
                if (styleStr.indexOf("STYLE_UNDERLINED") > -1) {
                    style |= 4;
                }
            }
            if (sizeStr.indexOf("SIZE_SMALL") > -1) {
                size = 8;
            } else if (sizeStr.indexOf("SIZE_MEDIUM") > -1) {
                size = 0;
            } else if (sizeStr.indexOf("SIZE_LARGE") > -1) {
                size = 16;
            }
            return Font.createSystemFont(face, style, size);
        }
        if (fontStr.toLowerCase().startsWith("bitmap")) {
            try {
                String bitmapFont;
                String nameStr = bitmapFont = fontStr.substring(fontStr.indexOf("{") + 1, fontStr.indexOf("}"));
                if (nameStr.toLowerCase().startsWith("highcontrast")) {
                    nameStr = nameStr.substring(nameStr.indexOf(";") + 1);
                    Font f = Font.getBitmapFont(nameStr);
                    f.addContrast((byte)30);
                    return f;
                }
                return Font.getBitmapFont(nameStr);
            }
            catch (Exception ex) {
                Log.e(ex);
            }
        }
        return null;
    }

    public static Resources initFirstTheme(String resourceFile) {
        try {
            Resources theme = Resources.openLayered(resourceFile);
            UIManager.getInstance().setThemeProps(theme.getTheme(theme.getThemeResourceNames()[0]));
            Resources.setGlobalResources(theme);
            return theme;
        }
        catch (IOException e) {
            Log.e(e);
            return null;
        }
    }

    public static Resources initNamedTheme(String resourceFile, String resName) {
        try {
            Resources theme = Resources.openLayered(resourceFile);
            UIManager.getInstance().setThemeProps(theme.getTheme(resName));
            Resources.setGlobalResources(theme);
            return theme;
        }
        catch (IOException e) {
            Log.e(e);
            return null;
        }
    }

    public boolean wasThemeInstalled() {
        return this.wasThemeInstalled;
    }

    public LookAndFeel getLookAndFeel() {
        return this.current;
    }

    public void setLookAndFeel(LookAndFeel plaf) {
        this.current.uninstall();
        this.current = plaf;
    }

    public void setComponentStyle(String id, Style style) {
        id = id == null || id.length() == 0 ? "" : id + ".";
        this.styles.put(id, style);
    }

    public void setComponentStyle(String id, Style style, String type) {
        id = type != null && type.length() > 0 ? (id == null || id.length() == 0 ? type + "#" : id + "." + type + "#") : (id == null || id.length() == 0 ? "" : id + ".");
        this.styles.put(id, style);
    }

    public void setComponentSelectedStyle(String id, Style style) {
        id = id == null || id.length() == 0 ? "" : id + ".";
        this.selectedStyles.put(id, style);
    }

    public Style getComponentStyle(String id) {
        return this.getComponentStyleImpl(id, false, "");
    }

    public String getIconUIIDFor(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        if (this.themeProps == null) {
            return null;
        }
        String iconUIID = id + "Icon";
        String baseStyle = (String)this.themeProps.get(iconUIID + ".derive");
        if (!id.equals(baseStyle)) {
            return null;
        }
        return iconUIID;
    }

    public Style parseComponentStyle(Resources theme, String baseStyle, String id, String ... styleString) {
        return this.parseStyle(theme, id, "", baseStyle, false, styleString);
    }

    public Style getComponentSelectedStyle(String id) {
        return this.getComponentStyleImpl(id, true, "sel#");
    }

    public Style parseComponentSelectedStyle(Resources theme, String baseStyle, String id, String ... styleString) {
        return this.parseStyle(theme, id, "sel#", baseStyle, true, styleString);
    }

    public Style getComponentCustomStyle(String id, String type) {
        return this.getComponentStyleImpl(id, false, type + "#");
    }

    public Style parseComponentCustomStyle(Resources theme, String baseStyle, String id, String type, String ... styleString) {
        return this.parseStyle(theme, id, type + "#", baseStyle, false, styleString);
    }

    private Style getComponentStyleImpl(String id, boolean selected, String prefix) {
        try {
            Style style = null;
            id = id == null || id.length() == 0 ? "" : id + ".";
            if (selected) {
                style = this.selectedStyles.get(id);
                if (style == null) {
                    style = this.createStyle(id, prefix, true);
                    this.selectedStyles.put(id, style);
                }
            } else if (prefix.length() == 0) {
                style = this.styles.get(id);
                if (style == null) {
                    style = this.createStyle(id, prefix, false);
                    this.styles.put(id, style);
                }
            } else {
                return this.createStyle(id, prefix, false);
            }
            return new Style(style);
        }
        catch (Throwable err) {
            Log.p("Error creating style " + id + " selected: " + selected + " prefix: " + prefix);
            Log.e(err);
            return new Style(this.defaultStyle);
        }
    }

    public String getThemeName() {
        if (this.themeProps != null) {
            return (String)this.themeProps.get("name");
        }
        return null;
    }

    HashMap<String, Object> getThemeProps() {
        return this.themeProps;
    }

    public void setThemeProps(Hashtable themeProps) {
        if (accessible) {
            this.setThemePropsImpl(themeProps);
        }
        this.wasThemeInstalled = true;
    }

    private void resetThemeProps(Hashtable installedTheme) {
        this.themeProps = new HashMap();
        this.wasThemeInstalled = false;
        if (this.current == null) {
            this.current = new DefaultLookAndFeel(this);
        }
        String disabledColor = Integer.toHexString(this.getLookAndFeel().getDisableColor());
        Integer centerAlign = 4;
        Integer rightAlign = 3;
        Integer leftAlign = 1;
        this.themeProps.put("sel#transparency", "255");
        this.themeProps.put("dis#fgColor", disabledColor);
        Boolean darkModeBoolean = (Boolean)this.themeProps.get("@darkModeBool");
        boolean darkMode = darkModeBoolean != null && darkModeBoolean != false && CN.isDarkMode() != null && CN.isDarkMode() != false;
        Font lightFont = Font.getDefaultFont();
        Font italic = Font.createSystemFont(0, 2, 0);
        Font bold = Font.createSystemFont(0, 1, 0);
        if (Font.isNativeFontSchemeSupported()) {
            int size = Display.getInstance().convertToPixels(2.5f);
            lightFont = Font.createTrueTypeFont("native:MainLight", "native:MainLight").derive(size, 0);
            italic = Font.createTrueTypeFont("native:ItalicLight", "native:ItalicLight").derive(size, 2);
            bold = Font.createTrueTypeFont("native:MainBold", "native:MainBold").derive(size, 1);
        }
        if (installedTheme == null || !installedTheme.containsKey("ToolbarSearch.derive")) {
            this.themeProps.put("ToolbarSearch.derive", "Toolbar");
        }
        this.themeProps.put("ToolbarLandscape.derive", "Toolbar");
        this.themeProps.put("TitleCommandLandscape.derive", "TitleCommand");
        this.themeProps.put("BackCommandLandscape.derive", "BackCommand");
        this.themeProps.put("TitleLandscape.derive", "Title");
        this.themeProps.put("StatusBarLandscape.derive", "StatusBar");
        String foreground = "0";
        String background = "ffffff";
        if (darkMode) {
            foreground = "ffffff";
            background = "0";
        }
        if (installedTheme == null || !installedTheme.containsKey("TextFieldSearch.derive")) {
            this.themeProps.put("TextFieldSearch.derive", "Title");
            this.themeProps.put("TextFieldSearch.align", leftAlign);
            this.themeProps.put("TextFieldSearch.sel#align", leftAlign);
            this.themeProps.put("TextFieldSearch.press#align", leftAlign);
            this.themeProps.put("TextFieldSearch.dis#align", leftAlign);
            this.themeProps.put("TextFieldSearch.sel#derive", "TextFieldSearch");
            this.themeProps.put("TextFieldSearch.press#derive", "TextFieldSearch");
            this.themeProps.put("TextFieldSearch.dis#derive", "TextFieldSearch");
        }
        if (installedTheme == null || !installedTheme.containsKey("TextHintSearch.derive")) {
            this.themeProps.put("TextHintSearch.derive", "TextHint");
            this.themeProps.put("TextHintSearch.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("AccordionItem.derive")) {
            this.themeProps.put("AccordionItem.margin", "0,0,0,0");
            this.themeProps.put("AccordionItem.padding", "1,1,1,1");
            this.themeProps.put("AccordionItem.border", Border.createLineBorder(1));
        }
        if (installedTheme == null || !installedTheme.containsKey("AccordionHeader.derive")) {
            this.themeProps.put("AccordionHeader.margin", "0,0,0,0");
            this.themeProps.put("AccordionHeader.sel#margin", "0,0,0,0");
            this.themeProps.put("AccordionHeader.press#margin", "0,0,0,0");
            this.themeProps.put("AccordionHeader.padding", "0,0,0,0");
            this.themeProps.put("AccordionHeader.sel#padding", "0,0,0,0");
            this.themeProps.put("AccordionHeader.press#padding", "0,0,0,0");
        }
        if (installedTheme == null || !installedTheme.containsKey("SignatureButton.derive")) {
            this.themeProps.put("SignatureButton.align", centerAlign);
            this.themeProps.put("SignatureButton.sel#derive", "SignatureButton");
            this.themeProps.put("SignatureButton.press#derive", "SignatureButton");
            this.themeProps.put("SignatureButton.dis#derive", "SignatureButton");
        }
        if (installedTheme == null || !installedTheme.containsKey("SignatureButtonBox.derive")) {
            this.themeProps.put("SignatureButtonBox.fgColor", centerAlign);
            this.themeProps.put("SignatureButtonBox.sel#derive", "SignatureButtonBox");
            this.themeProps.put("SignatureButtonBox.press#derive", "SignatureButtonBox");
            this.themeProps.put("SignatureButtonBox.dis#derive", "SignatureButtonBox");
        }
        if (installedTheme == null || !installedTheme.containsKey("SignaturePanel.derive")) {
            this.themeProps.put("SignaturePanel.bgColor", "ffffff");
            this.themeProps.put("SignaturePanel.transparency", "255");
            this.themeProps.put("SignaturePanel.sel#derive", "SignaturePanel");
            this.themeProps.put("SignaturePanel.press#derive", "SignaturePanel");
            this.themeProps.put("SignaturePanel.dis#derive", "SignaturePanel");
        }
        if (installedTheme == null || !installedTheme.containsKey("SignaturePanelBox.derive")) {
            this.themeProps.put("SignaturePanelBox.fgColor", "666666");
            this.themeProps.put("SignaturePanelBox.transparency", "255");
            this.themeProps.put("SignaturePanelBox.sel#derive", "SignaturePanelBox");
            this.themeProps.put("SignaturePanelBox.press#derive", "SignaturePanelBox");
            this.themeProps.put("SignaturePanelBox.dis#derive", "SignaturePanelBox");
        }
        if (installedTheme == null || !installedTheme.containsKey("SignaturePanelSignature.derive")) {
            this.themeProps.put("SignaturePanelSignature.fgColor", "0");
            this.themeProps.put("SignaturePanelSignature.transparency", "255");
            this.themeProps.put("SignaturePanelSignature.sel#derive", "SignaturePanelSignature");
            this.themeProps.put("SignaturePanelSignature.press#derive", "SignaturePanelSignature");
            this.themeProps.put("SignaturePanelSignature.dis#derive", "SignaturePanelSignature");
        }
        if (installedTheme == null || !installedTheme.containsKey("ToastBar.derive")) {
            this.themeProps.put("ToastBar.margin", "0,0,0,0");
            if (darkMode) {
                this.themeProps.put("ToastBar.bgColor", "dddddd");
            } else {
                this.themeProps.put("ToastBar.bgColor", "0");
            }
            this.themeProps.put("ToastBar.transparency", "200");
            this.themeProps.put("ToastBar.bgType", (byte)0);
            this.themeProps.put("ToastBar.border", Border.createEmpty());
            this.themeProps.put("ToastBar.sel#derive", "ToastBar");
            this.themeProps.put("ToastBar.press#derive", "ToastBar");
            this.themeProps.put("ToastBar.dis#derive", "ToastBar");
        }
        if (installedTheme == null || !installedTheme.containsKey("ToastBarMessage.derive")) {
            this.themeProps.put("ToastBarMessage.font", lightFont);
            this.themeProps.put("ToastBarMessage.transparency", "0");
            this.themeProps.put("ToastBarMessage.fgColor", "FFFFFF");
            this.themeProps.put("ToastBarMessage.bgType", (byte)0);
            this.themeProps.put("ToastBarMessage.border", Border.createEmpty());
            this.themeProps.put("ToastBarMessage.sel#derive", "ToastBarMessage");
            this.themeProps.put("ToastBarMessage.press#derive", "ToastBarMessage");
            this.themeProps.put("ToastBarMessage.dis#derive", "ToastBarMessage");
        }
        if (installedTheme == null || !installedTheme.containsKey("Sheet.derive")) {
            this.themeProps.put("Sheet.padding", "0,0,0,0");
            this.themeProps.put("Sheet.margin", "0,0,0,0");
            this.themeProps.put("Sheet.bgType", (byte)0);
            if (darkMode) {
                this.themeProps.put("Sheet.bgColor", "333333");
            } else {
                this.themeProps.put("Sheet.bgColor", "FFFFFF");
            }
            this.themeProps.put("Sheet.transparency", "255");
            this.themeProps.put("Sheet.border", RoundRectBorder.create().bottomLeftMode(false).bottomRightMode(false).cornerRadius(2.0f));
            this.themeProps.put("Sheet.sel#derive", "Sheet");
            this.themeProps.put("Sheet.press#derive", "Sheet");
            this.themeProps.put("Sheet.dis#derive", "Sheet");
            this.themeProps.put("SheetTitle.fgColor", foreground);
            this.themeProps.put("SheetTitle.transparency", "0");
            this.themeProps.put("SheetTitle.font", bold);
            this.themeProps.put("SheetTitle.align", centerAlign);
            this.themeProps.put("SheetTitle.sel#derive", "SheetTitle");
            this.themeProps.put("SheetTitle.press#derive", "SheetTitle");
            this.themeProps.put("SheetTitle.dis#derive", "SheetTitle");
            this.themeProps.put("SheetTitleBar.transparency", "0");
            this.themeProps.put("SheetTitleBar.border", Border.createCompoundBorder(Border.createEmpty(), Border.createLineBorder(1, 0xCCCCCC), Border.createEmpty(), Border.createEmpty()));
            this.themeProps.put("SheetTitleBar.sel#derive", "SheetTitleBar");
            this.themeProps.put("SheetTitleBar.press#derive", "SheetTitleBar");
            this.themeProps.put("SheetTitleBar.dis#derive", "SheetTitleBar");
            if (darkMode) {
                this.themeProps.put("SheetBackButton.fgColor", "999999");
            } else {
                this.themeProps.put("SheetBackButton.fgColor", "333333");
            }
            this.themeProps.put("SheetBackButton.transparency", "0");
            this.themeProps.put("SheetBackButton.border", Border.createEmpty());
            this.themeProps.put("SheetBackButton.sel#derive", "SheetBackButton");
            this.themeProps.put("SheetBackButton.press#derive", "SheetBackButton");
            this.themeProps.put("SheetBackButton.dis#derive", "SheetBackButton");
        }
        if (installedTheme == null || !installedTheme.containsKey("ChartComponent.derive")) {
            this.themeProps.put("ChartComponent.transparency", "0");
            this.themeProps.put("ChartComponent.sel#derive", "ChartComponent");
            this.themeProps.put("ChartComponent.press#derive", "ChartComponent");
        }
        if (installedTheme == null || !installedTheme.containsKey("Button.derive")) {
            this.themeProps.put("Button.border", Border.getDefaultBorder());
            this.themeProps.put("Button.padding", "4,4,4,4");
        }
        if (installedTheme == null || !installedTheme.containsKey("Button.sel#derive")) {
            this.themeProps.put("Button.sel#border", Border.getDefaultBorder());
            this.themeProps.put("Button.sel#bgColor", "a0a0a0");
            this.themeProps.put("Button.sel#padding", "4,4,4,4");
        }
        if (installedTheme == null || !installedTheme.containsKey("RaisedButton.derive")) {
            this.themeProps.put("RaisedButton.derive", "Button");
            this.themeProps.put("RaisedButton.sel#derive", "Button.sel");
            this.themeProps.put("RaisedButton.press#derive", "Button.press");
            this.themeProps.put("RaisedButton.dis#derive", "Button.dis");
        }
        if (installedTheme == null || !installedTheme.containsKey("Button.press#derive")) {
            this.themeProps.put("Button.press#border", Border.getDefaultBorder().createPressedVersion());
            this.themeProps.put("Button.press#derive", "Button");
            this.themeProps.put("Button.press#padding", "4,4,4,4");
        }
        this.themeProps.put("Button.dis#derive", "Button");
        if (installedTheme == null || !installedTheme.containsKey("CalendarTitle.derive")) {
            this.themeProps.put("CalendarTitle.align", centerAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("CalendarMultipleDay.derive")) {
            this.themeProps.put("CalendarMultipleDay.border", Border.getDefaultBorder());
            this.themeProps.put("CalendarMultipleDay.align", centerAlign);
        }
        this.themeProps.put("CalendarMultipleDay.sel#derive", "CalendarMultipleDay");
        if (installedTheme == null || !installedTheme.containsKey("CalendarSelectedDay.derive")) {
            this.themeProps.put("CalendarSelectedDay.border", Border.getDefaultBorder());
            this.themeProps.put("CalendarSelectedDay.align", centerAlign);
        }
        this.themeProps.put("CalendarSelectedDay.sel#derive", "CalendarSelectedDay");
        if (installedTheme == null || !installedTheme.containsKey("CalendarDay.derive")) {
            this.themeProps.put("CalendarDay.align", centerAlign);
        }
        this.themeProps.put("CalendarDay.dis#derive", "CalendarDay");
        this.themeProps.put("CalendarDay.press#derive", "CalendarDay");
        if (installedTheme == null || !installedTheme.containsKey("CalendarDay.sel#derive")) {
            this.themeProps.put("CalendarDay.sel#align", centerAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("ComboBox.derive")) {
            this.themeProps.put("ComboBox.border", Border.getDefaultBorder());
        }
        this.themeProps.put("ComboBox.sel#derive", "ComboBox");
        if (installedTheme == null || !installedTheme.containsKey("MenuButton.derive")) {
            this.themeProps.put("MenuButton.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("ComboBoxItem.derive")) {
            this.themeProps.put("ComboBoxItem.margin", "0,0,0,0");
            this.themeProps.put("ComboBoxItem.transparency", "0");
        }
        this.themeProps.put("ComboBoxItem.sel#derive", "ComboBoxItem");
        this.themeProps.put("ComboBoxItem.dis#derive", "ComboBoxItem");
        if (installedTheme == null || !installedTheme.containsKey("ComboBoxList.derive")) {
            this.themeProps.put("ComboBoxList.margin", "2,2,2,2");
            this.themeProps.put("ComboBoxList.padding", "0,0,0,0");
            this.themeProps.put("ComboBoxList.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("ComboBoxList.sel#derive")) {
            this.themeProps.put("ComboBoxList.sel#margin", "2,2,2,2");
            this.themeProps.put("ComboBoxList.sel#padding", "0,0,0,0");
            this.themeProps.put("ComboBoxList.sel#transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("ComboBoxPopup.derive")) {
            this.themeProps.put("ComboBoxPopup.border", Border.getDefaultBorder());
        }
        this.themeProps.put("ComboBoxPopup.sel#derive", "ComboBoxPopup");
        if (installedTheme == null || !installedTheme.containsKey("Command.derive")) {
            this.themeProps.put("Command.margin", "0,0,0,0");
            this.themeProps.put("Command.transparency", "0");
        }
        this.themeProps.put("Command.sel#derive", "Command");
        this.themeProps.put("Command.dis#derive", "Command");
        if (installedTheme == null || !installedTheme.containsKey("CommandList.derive")) {
            this.themeProps.put("CommandList.margin", "0,0,0,0");
            this.themeProps.put("CommandList.padding", "0,0,0,0");
            this.themeProps.put("CommandList.transparency", "0");
        }
        this.themeProps.put("CommandList.sel#derive", "CommandList");
        if (installedTheme == null || !installedTheme.containsKey("ComponentGroup.derive")) {
            this.themeProps.put("ComponentGroup.derive", "Container");
        }
        if (installedTheme == null || !installedTheme.containsKey("Container.derive")) {
            this.themeProps.put("Container.transparency", "0");
            this.themeProps.put("Container.margin", "0,0,0,0");
            this.themeProps.put("Container.padding", "0,0,0,0");
        }
        this.themeProps.put("Container.sel#derive", "Container");
        this.themeProps.put("Container.dis#derive", "Container");
        this.themeProps.put("Container.press#derive", "Container");
        if (installedTheme == null || !installedTheme.containsKey("Switch.derive")) {
            this.themeProps.put("Switch.transparency", "255");
            this.themeProps.put("Switch.bgColor", "9F9E9E");
            this.themeProps.put("Switch.fgColor", "EDEDED");
        }
        if (installedTheme == null || !installedTheme.containsKey("Switch.sel#derive")) {
            this.themeProps.put("Switch.sel#transparency", "255");
            this.themeProps.put("Switch.sel#bgColor", "757E84");
            this.themeProps.put("Switch.sel#fgColor", "222C32");
        }
        if (installedTheme == null || !installedTheme.containsKey("OnOffSwitch.derive")) {
            this.themeProps.put("OnOffSwitch.transparency", "255");
            this.themeProps.put("OnOffSwitch.bgColor", "222222");
            this.themeProps.put("OnOffSwitch.padding", "0,0,0,0");
            this.themeProps.put("OnOffSwitch.font", lightFont);
        }
        if (installedTheme == null || !installedTheme.containsKey("OnOffSwitch.sel#derive")) {
            this.themeProps.put("OnOffSwitch.sel#transparency", "255");
            this.themeProps.put("OnOffSwitch.sel#bgColor", "222222");
            this.themeProps.put("OnOffSwitch.sel#padding", "0,0,0,0");
            this.themeProps.put("OnOffSwitch.sel#font", lightFont);
        }
        if (installedTheme == null || !installedTheme.containsKey("ContentPane.derive")) {
            this.themeProps.put("ContentPane.transparency", "0");
            this.themeProps.put("ContentPane.margin", "0,0,0,0");
            this.themeProps.put("ContentPane.padding", "0,0,0,0");
        }
        this.themeProps.put("ContentPane.sel#derive", "ContentPane");
        if (installedTheme == null || !installedTheme.containsKey("PopupDialog.derive")) {
            this.themeProps.put("PopupDialog.derive", "Dialog");
            this.themeProps.put("PopupDialog.border", RoundRectBorder.create().cornerRadius(2.0f).shadowOpacity(60).shadowSpread(3.0f));
            this.themeProps.put("PopupDialog.transparency", "255");
            this.themeProps.put("PopupDialog.bgColor", background);
            this.themeProps.put("PopupDialog.padding", "4,4,4,4");
            this.themeProps.put("PopupDialog.padUnit", new byte[]{2, 2, 2, 2});
        }
        if (installedTheme == null || !installedTheme.containsKey("TooltipDialog.derive")) {
            this.themeProps.put("TooltipDialog.derive", "Dialog");
            this.themeProps.put("TooltipDialog.border", RoundRectBorder.create().cornerRadius(2.0f));
            this.themeProps.put("TooltipDialog.transparency", "255");
            this.themeProps.put("TooltipDialog.bgColor", "dddddd");
            this.themeProps.put("TooltipDialog.padding", "4,4,4,4");
            this.themeProps.put("TooltipDialog.padUnit", new byte[]{2, 2, 2, 2});
        }
        if (installedTheme == null || !installedTheme.containsKey("Tooltip.derive")) {
            this.themeProps.put("Tooltip.derive", "Label");
            this.themeProps.put("Tooltip.fgColor", "0");
            this.themeProps.put("Tooltip.align", centerAlign);
            this.themeProps.put("TooltipDialog.padding", "2,2,2,2");
            this.themeProps.put("TooltipDialog.padUnit", new byte[]{2, 2, 2, 2});
        }
        if (installedTheme == null || !installedTheme.containsKey("DialogContentPane.derive")) {
            this.themeProps.put("DialogContentPane.margin", "0,0,0,0");
            this.themeProps.put("DialogContentPane.padding", "0,0,0,0");
            this.themeProps.put("DialogContentPane.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("PopupContentPane.derive")) {
            this.themeProps.put("PopupContentPane.derive", "DialogContentPane");
        }
        if (installedTheme == null || !installedTheme.containsKey("DialogTitle.derive")) {
            this.themeProps.put("DialogTitle.align", centerAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("PopupDialogTitle.derive")) {
            this.themeProps.put("PopupDialogTitle.derive", "DialogTitle");
        }
        if (installedTheme == null || !installedTheme.containsKey("Form.derive")) {
            this.themeProps.put("Form.padding", "0,0,0,0");
            this.themeProps.put("Form.margin", "0,0,0,0");
        }
        this.themeProps.put("Form.sel#derive", "Form");
        if (installedTheme == null || !installedTheme.containsKey("HorizontalScroll.derive")) {
            this.themeProps.put("HorizontalScroll.margin", "0,0,0,0");
            this.themeProps.put("HorizontalScroll.padding", "1,1,1,1");
        }
        if (installedTheme == null || !installedTheme.containsKey("HorizontalScrollThumb.derive")) {
            this.themeProps.put("HorizontalScrollThumb.padding", "0,0,0,0");
            this.themeProps.put("HorizontalScrollThumb.bgColor", foreground);
            this.themeProps.put("HorizontalScrollThumb.margin", "0,0,0,0");
        }
        if (installedTheme == null || !installedTheme.containsKey("List.derive")) {
            this.themeProps.put("List.transparency", "0");
            this.themeProps.put("List.margin", "0,0,0,0");
        }
        this.themeProps.put("List.sel#derive", "List");
        if (installedTheme == null || !installedTheme.containsKey("ListRenderer.derive")) {
            this.themeProps.put("ListRenderer.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("ListRenderer.sel#derive")) {
            this.themeProps.put("ListRenderer.sel#transparency", "100");
        }
        this.themeProps.put("ListRenderer.dis#derive", "ListRenderer");
        if (installedTheme == null || !installedTheme.containsKey("Menu.derive")) {
            this.themeProps.put("Menu.padding", "0,0,0,0");
        }
        this.themeProps.put("Menu.sel#derive", "Menu");
        if (installedTheme == null || !installedTheme.containsKey("PopupContentPane.derive")) {
            this.themeProps.put("PopupContentPane.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("Scroll.derive")) {
            this.themeProps.put("Scroll.margin", "0,0,0,0");
            int halfMM = Display.getInstance().convertToPixels(10, true) / 20;
            halfMM = Math.max(1, halfMM);
            this.themeProps.put("Scroll.padding", halfMM + "," + halfMM + "," + halfMM + "," + halfMM);
        }
        if (installedTheme == null || !installedTheme.containsKey("ScrollThumb.derive")) {
            this.themeProps.put("ScrollThumb.padding", "0,0,0,0");
            this.themeProps.put("ScrollThumb.margin", "0,0,0,0");
            this.themeProps.put("ScrollThumb.bgColor", foreground);
        }
        if (installedTheme == null || !installedTheme.containsKey("SliderFull.derive")) {
            this.themeProps.put("SliderFull.bgColor", foreground);
        }
        this.themeProps.put("SliderFull.sel#derive", "SliderFull");
        if (installedTheme == null || !installedTheme.containsKey("SoftButton.derive")) {
            this.themeProps.put("SoftButton.transparency", "255");
            this.themeProps.put("SoftButton.margin", "0,0,0,0");
            this.themeProps.put("SoftButton.padding", "0,0,0,0");
        }
        this.themeProps.put("SoftButton.sel#derive", "SoftButton");
        if (installedTheme == null || !installedTheme.containsKey("SoftButtonCenter.derive")) {
            this.themeProps.put("SoftButtonCenter.align", centerAlign);
            this.themeProps.put("SoftButtonCenter.transparency", "0");
            this.themeProps.put("SoftButtonCenter.derive", "SoftButton");
            this.themeProps.put("SoftButtonCenter.padding", "4,4,4,4");
        }
        this.themeProps.put("SoftButtonCenter.sel#derive", "SoftButtonCenter");
        this.themeProps.put("SoftButtonCenter.press#derive", "SoftButtonCenter");
        this.themeProps.put("SoftButtonCenter.dis#derive", "SoftButtonCenter");
        if (installedTheme == null || !installedTheme.containsKey("SoftButtonLeft.derive")) {
            this.themeProps.put("SoftButtonLeft.transparency", "0");
            this.themeProps.put("SoftButtonLeft.derive", "SoftButton");
            this.themeProps.put("SoftButtonLeft.padding", "4,4,4,4");
        }
        this.themeProps.put("SoftButtonLeft.sel#derive", "SoftButtonLeft");
        this.themeProps.put("SoftButtonLeft.press#derive", "SoftButtonLeft");
        this.themeProps.put("SoftButtonLeft.dis#derive", "SoftButtonLeft");
        if (installedTheme == null || !installedTheme.containsKey("SoftButtonRight.derive")) {
            this.themeProps.put("SoftButtonRight.align", rightAlign);
            this.themeProps.put("SoftButtonRight.transparency", "0");
            this.themeProps.put("SoftButtonRight.derive", "SoftButton");
            this.themeProps.put("SoftButtonRight.padding", "4,4,4,4");
        }
        this.themeProps.put("SoftButtonRight.sel#derive", "SoftButtonRight");
        this.themeProps.put("SoftButtonRight.press#derive", "SoftButtonRight");
        this.themeProps.put("SoftButtonRight.dis#derive", "SoftButtonRight");
        if (installedTheme == null || !installedTheme.containsKey("Spinner.derive")) {
            this.themeProps.put("Spinner.border", Border.getDefaultBorder());
        }
        this.themeProps.put("Spinner.sel#derive", "Spinner");
        if (installedTheme == null || !installedTheme.containsKey("SpinnerOverlay.derive")) {
            this.themeProps.put("SpinnerOverlay.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("Tab.derive")) {
            this.themeProps.put("Tab.margin", "1,1,1,1");
        }
        if (installedTheme == null || !installedTheme.containsKey("Tab.sel#derive")) {
            this.themeProps.put("Tab.sel#derive", "Tab");
            this.themeProps.put("Tab.sel#border", Border.createLineBorder(1));
        }
        this.themeProps.put("TabbedPane.margin", "0,0,0,0");
        this.themeProps.put("TabbedPane.padding", "0,0,0,0");
        this.themeProps.put("TabbedPane.transparency", "0");
        this.themeProps.put("TabbedPane.sel#margin", "0,0,0,0");
        this.themeProps.put("TabbedPane.sel#padding", "0,0,0,0");
        if (installedTheme == null || !installedTheme.containsKey("Table.derive")) {
            this.themeProps.put("Table.border", Border.getDefaultBorder());
        }
        this.themeProps.put("Table.sel#derive", "Table");
        if (installedTheme == null || !installedTheme.containsKey("TableCell.derive")) {
            this.themeProps.put("TableCell.transparency", "0");
        }
        this.themeProps.put("TableCell.sel#derive", "TableCell");
        if (installedTheme == null || !installedTheme.containsKey("TableHeader.derive")) {
            this.themeProps.put("TableHeader.transparency", "0");
        }
        this.themeProps.put("TableHeader.sel#derive", "TableHeader");
        if (installedTheme == null || !installedTheme.containsKey("Tabs.derive")) {
            this.themeProps.put("Tabs.bgColor", "a0a0a0");
            this.themeProps.put("Tabs.padding", "0,0,0,0");
        }
        if (installedTheme == null || !installedTheme.containsKey("TabsContainer.derive")) {
            this.themeProps.put("TabsContainer.padding", "0,0,0,0");
            this.themeProps.put("TabsContainer.margin", "0,0,0,0");
            this.themeProps.put("TabsContainer.bgColor", "a0a0a0");
        }
        if (installedTheme == null || !installedTheme.containsKey("TextArea.derive")) {
            this.themeProps.put("TextArea.border", Border.getDefaultBorder());
        }
        this.themeProps.put("TextArea.sel#derive", "TextArea");
        this.themeProps.put("TextArea.dis#derive", "TextArea");
        if (installedTheme == null || !installedTheme.containsKey("TextField.derive")) {
            this.themeProps.put("TextField.border", Border.getDefaultBorder());
        }
        this.themeProps.put("InvalidEmblem.derive", "Label");
        this.themeProps.put("InvalidEmblem.fgColor", "ff0000");
        this.themeProps.put("InvalidEmblem.transparency", "0");
        this.themeProps.put("TextField.sel#derive", "TextField");
        this.themeProps.put("TextField.dis#derive", "TextField");
        if (installedTheme == null || !installedTheme.containsKey("TextFieldInvalid.derive")) {
            this.themeProps.put("TextFieldInvalid.derive", "TextField");
            this.themeProps.put("TextFieldInvalid.fgColor", "ff0000");
            this.themeProps.put("TextFieldInvalid.sel#fgColor", "ff0000");
            this.themeProps.put("TextFieldInvalid.sel#fgColor", "ff0000");
            this.themeProps.put("TextFieldInvalid.sel#derive", "TextField");
            this.themeProps.put("TextFieldInvalid.dis#derive", "TextField");
        }
        if (installedTheme == null || !installedTheme.containsKey("TextAreaInvalid.derive")) {
            this.themeProps.put("TextAreaInvalid.derive", "TextArea");
            this.themeProps.put("TextAreaInvalid.fgColor", "ff0000");
            this.themeProps.put("TextAreaInvalid.sel#fgColor", "ff0000");
            this.themeProps.put("TextAreaInvalid.sel#fgColor", "ff0000");
            this.themeProps.put("TextAreaInvalid.sel#derive", "TextArea");
            this.themeProps.put("TextAreaInvalid.dis#derive", "TextArea");
        }
        if (installedTheme == null || !installedTheme.containsKey("TextHint.derive")) {
            this.themeProps.put("TextHint.transparency", "0");
            this.themeProps.put("TextHint.fgColor", "cccccc");
            this.themeProps.put("TextHint.font", italic);
        }
        if (installedTheme == null || !installedTheme.containsKey("Title.derive")) {
            this.themeProps.put("Title.margin", "0,0,0,0");
            this.themeProps.put("Title.transparency", "255");
            this.themeProps.put("Title.align", centerAlign);
        }
        this.themeProps.put("Title.sel#derive", "Title");
        if (installedTheme == null || !installedTheme.containsKey("TitleArea.derive")) {
            this.themeProps.put("TitleArea.transparency", "0");
            this.themeProps.put("TitleArea.margin", "0,0,0,0");
            this.themeProps.put("TitleArea.padding", "0,0,0,0");
        }
        if (installedTheme == null || !installedTheme.containsKey("TouchCommand.derive")) {
            this.themeProps.put("TouchCommand.border", Border.getDefaultBorder());
            this.themeProps.put("TouchCommand.padding", "10,10,10,10");
            this.themeProps.put("TouchCommand.margin", "0,0,0,0");
            this.themeProps.put("TouchCommand.align", centerAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("TouchCommand.press#derive")) {
            this.themeProps.put("TouchCommand.press#border", Border.getDefaultBorder().createPressedVersion());
            this.themeProps.put("TouchCommand.press#derive", "TouchCommand");
        }
        this.themeProps.put("TouchCommand.sel#derive", "TouchCommand");
        if (installedTheme == null || !installedTheme.containsKey("TouchCommand.dis#derive")) {
            this.themeProps.put("TouchCommand.dis#derive", "TouchCommand");
            this.themeProps.put("TouchCommand.dis#fgColor", disabledColor);
        }
        if (installedTheme == null || !installedTheme.containsKey("AdsComponent.sel#derive")) {
            this.themeProps.put("AdsComponent.sel#border", Border.getDefaultBorder());
            this.themeProps.put("AdsComponent.sel#padding", "2,2,2,2");
            this.themeProps.put("AdsComponent.sel#transparency", "0");
        }
        this.themeProps.put("AdsComponent#derive", "Container");
        this.themeProps.put("WebBrowser#derive", "Container");
        if (installedTheme == null || !installedTheme.containsKey("MapZoomOut.derive")) {
            this.themeProps.put("MapZoomOut.derive", "Button");
        }
        this.themeProps.put("MapZoomOut.sel#derive", "Button.sel");
        this.themeProps.put("MapZoomOut.press#derive", "Button.press");
        if (installedTheme == null || !installedTheme.containsKey("MapZoomIn.derive")) {
            this.themeProps.put("MapZoomIn.derive", "Button");
        }
        this.themeProps.put("MapZoomIn.sel#derive", "Button.sel");
        this.themeProps.put("MapZoomIn.press#derive", "Button.press");
        if (installedTheme == null || !installedTheme.containsKey("SideCommand.derive")) {
            this.themeProps.put("SideCommand.derive", "TouchCommand");
            this.themeProps.put("SideCommand.align", leftAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("SideCommand.sel#.derive")) {
            this.themeProps.put("SideCommand.sel#derive", "TouchCommand.sel");
            this.themeProps.put("SideCommand.sel#align", leftAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("SideCommand.press#.derive")) {
            this.themeProps.put("SideCommand.press#derive", "TouchCommand.press");
            this.themeProps.put("SideCommand.press#align", leftAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("RightSideCommand.derive")) {
            this.themeProps.put("RightSideCommand.derive", "SideCommand");
            this.themeProps.put("RightSideCommand.align", rightAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("RightSideCommand.sel#.derive")) {
            this.themeProps.put("RightSideCommand.sel#derive", "SideCommand.sel");
            this.themeProps.put("RightSideCommand.sel#align", rightAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("RightSideCommand.press#.derive")) {
            this.themeProps.put("RightSideCommand.press#derive", "SideCommand.press");
            this.themeProps.put("RightSideCommand.press#align", rightAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("SideNavigationPanel.derive")) {
            this.themeProps.put("SideNavigationPanel.padding", "0,0,0,0");
            this.themeProps.put("SideNavigationPanel.margin", "0,0,0,0");
            this.themeProps.put("SideNavigationPanel.bgColor", "343434");
            this.themeProps.put("SideNavigationPanel.transparency", "255");
        }
        if (installedTheme == null || !installedTheme.containsKey("RightSideNavigationPanel.derive")) {
            this.themeProps.put("RightSideNavigationPanel.derive", "SideNavigationPanel");
        }
        if (installedTheme == null || !installedTheme.containsKey("PullToRefresh.derive")) {
            this.themeProps.put("PullToRefresh.padding", "0,0,0,0");
            this.themeProps.put("PullToRefresh.margin", "0,0,0,0");
            this.themeProps.put("PullToRefresh.align", centerAlign);
            this.themeProps.put("PullToRefresh.transparency", "0");
            this.themeProps.put("PullToRefresh.fgColor", foreground);
        }
        if (installedTheme == null || !installedTheme.containsKey("AutoCompletePopup.derive")) {
            this.themeProps.put("AutoCompletePopup.transparency", "255");
            this.themeProps.put("AutoCompletePopup.padding", "0,0,0,0");
            this.themeProps.put("AutoCompletePopup.border", Border.createLineBorder(1));
        }
        if (installedTheme == null || !installedTheme.containsKey("AutoCompletePopup.sel#derive")) {
            this.themeProps.put("AutoCompletePopup.sel#transparency", "255");
            this.themeProps.put("AutoCompletePopup.sel#padding", "0,0,0,0");
            this.themeProps.put("AutoCompletePopup.sel#border", Border.createLineBorder(1));
        }
        if (installedTheme == null || !installedTheme.containsKey("AutoCompleteList.derive")) {
            this.themeProps.put("AutoCompleteList.margin", "1,1,1,1");
            this.themeProps.put("AutoCompleteList.padding", "0,0,0,0");
        }
        if (installedTheme == null || !installedTheme.containsKey("AutoCompleteList.sel#derive")) {
            this.themeProps.put("AutoCompleteList.sel#margin", "1,1,1,1");
            this.themeProps.put("AutoCompleteList.sel#padding", "0,0,0,0");
        }
        if (installedTheme == null || !installedTheme.containsKey("AutoCompleteList.press#derive")) {
            this.themeProps.put("AutoCompleteList.press#margin", "1,1,1,1");
            this.themeProps.put("AutoCompleteList.press#padding", "0,0,0,0");
        }
        if (installedTheme == null || !installedTheme.containsKey("CommandList.derive")) {
            this.themeProps.put("CommandList.transparency", "255");
            this.themeProps.put("CommandList.border", Border.createLineBorder(1));
        }
        if (installedTheme == null || !installedTheme.containsKey("CommandList.sel#derive")) {
            this.themeProps.put("CommandList.sel#transparency", "255");
            this.themeProps.put("CommandList.sel#border", Border.createLineBorder(1));
        }
        if (installedTheme == null || !installedTheme.containsKey("Toolbar.derive")) {
            this.themeProps.put("Toolbar.derive", "TitleArea");
        }
        if (installedTheme == null || !installedTheme.containsKey("FloatingActionButton.derive")) {
            this.themeProps.put("FloatingActionButton.fgColor", "ffffff");
            this.themeProps.put("FloatingActionButton.bgColor", "d32f2f");
            this.themeProps.put("FloatingActionButton.transparency", "0");
            this.themeProps.put("FloatingActionButton.marUnit", new byte[]{2, 2, 2, 2});
            this.themeProps.put("FloatingActionButton.margin", "0,2,1,2");
        }
        if (installedTheme == null || !installedTheme.containsKey("FloatingActionButton.press#derive")) {
            this.themeProps.put("FloatingActionButton.press#fgColor", "ffffff");
            this.themeProps.put("FloatingActionButton.press#bgColor", "b71c1c");
            this.themeProps.put("FloatingActionButton.sel#transparency", "0");
            this.themeProps.put("FloatingActionButton.press#marUnit", new byte[]{2, 2, 2, 2});
            this.themeProps.put("FloatingActionButton.press#margin", "0,2,1,2");
        }
        if (installedTheme == null || !installedTheme.containsKey("FloatingActionButton.sel#derive")) {
            this.themeProps.put("FloatingActionButton.sel#fgColor", "ffffff");
            this.themeProps.put("FloatingActionButton.sel#transparency", "0");
            this.themeProps.put("FloatingActionButton.sel#bgColor", "b71c1c");
            this.themeProps.put("FloatingActionButton.sel#marUnit", new byte[]{2, 2, 2, 2});
            this.themeProps.put("FloatingActionButton.sel#margin", "0,2,1,2");
        }
        if (installedTheme == null || !installedTheme.containsKey("RefreshLabel.derive")) {
            this.themeProps.put("RefreshLabel.fgColor", "0");
            this.themeProps.put("RefreshLabel.bgColor", "ffffff");
            this.themeProps.put("RefreshLabel.transparency", "0");
            this.themeProps.put("RefreshLabel.marUnit", new byte[]{0, 0, 0, 0});
            this.themeProps.put("RefreshLabel.padUnit", new byte[]{2, 2, 2, 2});
            this.themeProps.put("RefreshLabel.margin", "1,1,1,1");
            this.themeProps.put("RefreshLabel.padding", "2,3,2,3");
        }
        if (installedTheme == null || !installedTheme.containsKey("Badge.derive")) {
            this.themeProps.put("Badge.fgColor", "ffffff");
            this.themeProps.put("Badge.bgColor", "d32f2f");
            this.themeProps.put("Badge.press#fgColor", "ffffff");
            this.themeProps.put("Badge.press#bgColor", "b71c1c");
            this.themeProps.put("Badge.sel#fgColor", "ffffff");
            this.themeProps.put("Badge.sel#bgColor", "b71c1c");
            this.themeProps.put("Badge#padUnit", new byte[]{2, 2, 2, 2});
            this.themeProps.put("Badge#padding", "0,0,0,0");
            this.themeProps.put("Badge.sel#padUnit", new byte[]{2, 2, 2, 2});
            this.themeProps.put("Badge.sel#padding", "0,0,0,0");
            this.themeProps.put("Badge.press#padUnit", new byte[]{2, 2, 2, 2});
            this.themeProps.put("Badge.press#padding", "0,0,0,0");
            if (Font.isNativeFontSchemeSupported()) {
                Font fnt = lightFont.derive(Display.getInstance().convertToPixels(1.5f), 0);
                this.themeProps.put("Badge.font", fnt);
                this.themeProps.put("Badge.sel#font", fnt);
                this.themeProps.put("Badge.press#font", fnt);
            }
            this.themeProps.put("Badge.align", centerAlign);
            this.themeProps.put("Badge.sel#align", centerAlign);
            this.themeProps.put("Badge.press#align", centerAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("FloatingActionText.derive")) {
            this.themeProps.put("FloatingActionText.bgColor", background);
            this.themeProps.put("FloatingActionText.fgColor", "a0a0a0");
            this.themeProps.put("FloatingActionText.align", rightAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("ErrorLabel.derive")) {
            this.themeProps.put("ErrorLabel.derive", "FloatingHint");
            this.themeProps.put("ErrorLabel.sel#derive", "FloatingHint");
            this.themeProps.put("ErrorLabel.press#derive", "FloatingHint");
            this.themeProps.put("ErrorLabel.fgColor", "ff1744");
            this.themeProps.put("ErrorLabel.sel#fgColor", "ff1744");
            this.themeProps.put("ErrorLabel.press#fgColor", "ff1744");
        }
        if (installedTheme == null || !installedTheme.containsKey("InputComponentAction.derive")) {
            this.themeProps.put("InputComponentAction.derive", "FloatingHint");
            this.themeProps.put("InputComponentAction.font", Font.createTrueTypeFont("native:MainLight", 3.0f));
        }
        if (installedTheme == null || !installedTheme.containsKey("DescriptionLabel.derive")) {
            this.themeProps.put("DescriptionLabel.derive", "FloatingHint");
            this.themeProps.put("DescriptionLabel.sel#derive", "FloatingHint");
            this.themeProps.put("DescriptionLabel.press#derive", "FloatingHint");
            this.themeProps.put("DescriptionLabel.fgColor", "666666");
            this.themeProps.put("DescriptionLabel.sel#fgColor", "666666");
            this.themeProps.put("DescriptionLabel.press#fgColor", "666666");
        }
        if (installedTheme == null || !installedTheme.containsKey("TextComponent.derive")) {
            this.themeProps.put("TextComponent.derive", "Container");
        }
        if (installedTheme == null || !installedTheme.containsKey("Spinner3DRow.derive")) {
            this.themeProps.put("Spinner3DRow.derive", "Label");
            this.themeProps.put("Spinner3DRow.sel#derive", "Label");
            this.themeProps.put("Spinner3DRow.fgColor", "878A93");
            this.themeProps.put("Spinner3DRow.transparency", "0");
            this.themeProps.put("Spinner3DRow.sel#fgColor", "2A2B2F");
            this.themeProps.put("Spinner3DRow.border", Border.createEmpty());
            this.themeProps.put("Spinner3DRow.align", centerAlign);
            this.themeProps.put("Spinner3DRow.sel#align", centerAlign);
            this.themeProps.put("Spinner3DRow.padding", "1.5,1.5,1,1");
            this.themeProps.put("Spinner3DRow.sel#padding", "1.5,1.5,1,1");
            this.themeProps.put("Spinner3DRow.padUnit", new byte[]{2, 2, 2, 2});
            this.themeProps.put("Spinner3DRow.sel#padUnit", new byte[]{2, 2, 2, 2});
            this.themeProps.put("Spinner3DRow.font", Font.createTrueTypeFont("native:MainLight", 2.8f));
            this.themeProps.put("Spinner3DRow.sel#font", Font.createTrueTypeFont("native:MainLight", 2.8f));
        }
        if (installedTheme == null || !installedTheme.containsKey("Spinner3DOverlay.bgColor")) {
            this.themeProps.put("Spinner3DOverlay.transparency", "255");
            this.themeProps.put("Spinner3DOverlay.bgColor", "efeff4");
            this.themeProps.put("Spinner3DOverlay.fgColor", "abb8b7");
        }
        if (installedTheme == null || !installedTheme.containsKey("PickerDialog.border")) {
            this.themeProps.put("PickerDialog.padding", "0,0,0,0");
            this.themeProps.put("PickerDialog.border", Border.createEmpty());
        }
        if (installedTheme == null || !installedTheme.containsKey("PickerDialogTablet.derive")) {
            this.themeProps.put("PickerDialogTablet.derive", "Dialog");
        }
        if (installedTheme == null || !installedTheme.containsKey("PickerDialogContent.bgColor")) {
            this.themeProps.put("PickerDialogContent.padding", "0,0,0,0");
            this.themeProps.put("PickerDialogContent.margin", "0,0,0,0");
            this.themeProps.put("PickerDialogContent.border", Border.createEmpty());
            this.themeProps.put("PickerDialogContent.bgColor", "D1D4DD");
            this.themeProps.put("PickerDialogContent.transparency", "255");
        }
        if (installedTheme == null || !installedTheme.containsKey("PicketDialogContentTablet.derive")) {
            this.themeProps.put("PickerDialogContentTablet.derive", "PopupContentPane");
        }
        if (installedTheme == null || !installedTheme.containsKey("PickerButtonBarTablet")) {
            if (installedTheme != null && installedTheme.containsKey("PickerButtonBarTabletNative")) {
                this.themeProps.put("PickerButtonBarTablet.derive", "PickerButtonBarTabletNative");
            } else {
                this.themeProps.put("PickerButtonBarTablet.derive", "Container");
            }
        }
        if (installedTheme == null || !installedTheme.containsKey("PickerButton")) {
            this.themeProps.put("PickerButton.derive", "Button");
            this.themeProps.put("PickerButton.sel#derive", "Button.sel");
            this.themeProps.put("PickerButton.press#derive", "Button.pres");
        }
        if (installedTheme == null || !installedTheme.containsKey("Picker.derive")) {
            this.themeProps.put("Picker.derive", "TextField");
            this.themeProps.put("Picker.sel#derive", "TextField.sel");
            this.themeProps.put("Picker.press#derive", "TextField.press");
            this.themeProps.put("Picker.dis#derive", "TextField.dis");
            this.themeProps.put("Picker.sel#border", Border.createLineBorder(1, 2124539));
        }
    }

    public void addThemeProps(Hashtable themeProps) {
        if (accessible) {
            this.buildTheme(themeProps);
            this.styles.clear();
            this.selectedStyles.clear();
            this.imageCache.clear();
            this.current.refreshTheme(false);
        }
    }

    public int getThemeConstant(String constantName, int def) {
        String v = (String)this.themeConstants.get(constantName);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException err) {
                Log.e(err);
            }
        }
        return def;
    }

    public String getThemeConstant(String constantName, String def) {
        String v = (String)this.themeConstants.get(constantName);
        if (v != null) {
            return v;
        }
        return def;
    }

    public boolean isThemeConstant(String constantName, boolean def) {
        String c = this.getThemeConstant(constantName, null);
        if (c == null) {
            return def;
        }
        return c.equalsIgnoreCase("true") || c.equals("1");
    }

    public Boolean isThemeConstant(String constantName) {
        String c = this.getThemeConstant(constantName, null);
        if (c == null) {
            return null;
        }
        if (c.equalsIgnoreCase("true") || c.equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Image getThemeImageConstant(String constantName) {
        return (Image)this.themeConstants.get(constantName);
    }

    public Object getThemeMaskConstant(String constantName) {
        Object o = this.themeConstants.get(constantName + "Mask");
        if (o != null) {
            return o;
        }
        Image i = (Image)this.themeConstants.get(constantName);
        if (i == null) {
            return null;
        }
        o = i.createMask();
        this.themeConstants.put(constantName + "Mask", o);
        return o;
    }

    void setThemePropsImpl(Hashtable themeProps) {
        this.resetThemeProps(themeProps);
        this.styles.clear();
        this.themeConstants.clear();
        this.selectedStyles.clear();
        this.imageCache.clear();
        if (this.themelisteners != null) {
            this.themelisteners.fireActionEvent(new ActionEvent((Object)themeProps, ActionEvent.Type.Theme));
        }
        this.buildTheme(themeProps);
        this.current.refreshTheme(true);
    }

    private void buildTheme(Hashtable themeProps) {
        String con = (String)themeProps.get("@includeNativeBool");
        if (con != null && con.equalsIgnoreCase("true") && Display.getInstance().hasNativeTheme()) {
            boolean a = accessible;
            accessible = true;
            Display.getInstance().installNativeTheme();
            accessible = a;
        }
        Enumeration e = themeProps.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("@")) {
                this.themeConstants.put(key.substring(1), themeProps.get(key));
                continue;
            }
            this.themeProps.put(key, themeProps.get(key));
        }
        if (!this.themeProps.containsKey("PickerButtonBar.derive")) {
            if (this.themeProps.containsKey("PickerButtonBarNative.derive")) {
                this.themeProps.put("PickerButtonBar.derive", "PickerButtonBarNative");
            } else {
                this.themeProps.put("PickerButtonBar.margin", "0,0,0,0");
                this.themeProps.put("PickerButtonBar.border", Border.createCompoundBorder(Border.createLineBorder(1, ColorUtil.rgb(148, 150, 151)), Border.createEmpty(), Border.createEmpty(), Border.createEmpty()));
                this.themeProps.put("PickerButtonBar.bgColor", "F0F1F3");
                this.themeProps.put("PickerButtonBar.transparency", "255");
            }
        }
        if (!this.themeProps.containsKey("PickerButtonTablet.derive")) {
            if (this.themeProps.containsKey("PickerButtonTabletNative.derive")) {
                this.themeProps.put("PickerButtonTablet.derive", "PickerButtonTabletNative");
                this.themeProps.put("PickerButtonTablet.sel#derive", "PickerButtonTabletNative.sel");
                this.themeProps.put("PickerButtonTablet.press#derive", "PickerButtonTabletNative.press");
            } else {
                this.themeProps.put("PickerButtonTablet.derive", "Button");
                this.themeProps.put("PickerButtonTablet.sel#derive", "Button");
                this.themeProps.put("PickerButtonTablet.press#derive", "Button");
            }
        }
        this.defaultStyle = new Style();
        this.defaultStyle = this.createStyle("", "", false);
        this.defaultSelectedStyle = new Style(this.defaultStyle);
        this.defaultSelectedStyle = this.createStyle("", "sel#", true);
        String overlayThemes = (String)themeProps.get("@OverlayThemes");
        if (overlayThemes != null) {
            List<String> overlayThemesArr = StringUtil.tokenize(overlayThemes, ',');
            for (String th : overlayThemesArr) {
                if ((th = th.trim()).length() == 0) continue;
                try {
                    Resources res = Resources.openLayered("/" + th);
                    boolean a = accessible;
                    accessible = true;
                    this.addThemeProps(res.getTheme(res.getThemeResourceNames()[0]));
                    accessible = a;
                }
                catch (Exception ex) {
                    System.err.println("Failed to load overlay theme file specified by @overlayThemes theme constant: " + th);
                    Log.e(ex);
                }
            }
        }
    }

    private Map<String, String> parseCache() {
        if (this.parseCache == null) {
            this.parseCache = new HashMap<String, String>();
        }
        return this.parseCache;
    }

    private String fromFloatArray(float[] arr) {
        StringBuilder sb = new StringBuilder();
        int len = arr.length;
        boolean first = true;
        for (int i = 0; i < len; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    private String fromByteArray(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        int len = arr.length;
        boolean first = true;
        for (int i = 0; i < len; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    Style parseStyle(Resources theme, String id, String prefix, String baseStyle, boolean selected, String ... styleString) {
        String cacheKey = selected ? id + ".sel" : id + "." + prefix;
        String originalId = id;
        id = id == null || id.length() == 0 ? "" : id + ".";
        if (Arrays.toString(styleString).equals(this.parseCache().get(cacheKey)) && (selected && this.selectedStyles.containsKey(id) || !selected && this.styles.containsKey(id))) {
            return this.getComponentStyleImpl(originalId, selected, prefix);
        }
        this.parseCache().put(cacheKey, Arrays.toString(styleString));
        Style base = baseStyle != null ? this.getComponentStyleImpl(baseStyle, selected, prefix) : null;
        HashMap<String, String> styles = new HashMap<String, String>();
        for (String str : styleString) {
            StyleParser.parseString(styles, str);
        }
        StyleParser.StyleInfo styleInfo = new StyleParser.StyleInfo(styles);
        if (prefix != null && prefix.length() > 0) {
            id = id + prefix;
        }
        if (this.themeProps == null) {
            this.resetThemeProps(null);
        }
        if (baseStyle != null) {
            this.themeProps.put(id + "derive", baseStyle);
        } else {
            this.themeProps.remove(id + "derive");
        }
        Integer bgColor = styleInfo.getBgColor();
        if (bgColor != null) {
            this.themeProps.put(id + "bgColor", Integer.toHexString(bgColor));
        } else {
            this.themeProps.remove(id + "bgColor");
        }
        Integer fgColor = styleInfo.getFgColor();
        if (fgColor != null) {
            this.themeProps.put(id + "fgColor", Integer.toHexString(fgColor));
        } else {
            this.themeProps.remove(id + "fgColor");
        }
        StyleParser.BorderInfo border = styleInfo.getBorder();
        if (border != null) {
            this.themeProps.put(id + "border", border.createBorder(theme));
        } else {
            this.themeProps.remove(id + "border");
        }
        Integer bgType = styleInfo.getBgType();
        if (bgType != null) {
            this.themeProps.put(id + "bgType", bgType.byteValue());
        } else {
            this.themeProps.remove(id + "bgType");
        }
        StyleParser.ImageInfo bgImage = styleInfo.getBgImage();
        if (bgImage != null) {
            this.themeProps.put(id + "bgImage", bgImage.getImage(theme));
        } else {
            this.themeProps.remove(id + "bgImage");
        }
        StyleParser.MarginInfo margin = styleInfo.getMargin();
        if (margin != null) {
            float[] marginArr = margin.createMargin(base);
            this.themeProps.put(id + "margin", marginArr[0] + "," + marginArr[2] + "," + marginArr[1] + "," + marginArr[3]);
            byte[] unitArr = margin.createMarginUnit(base);
            this.themeProps.put(id + "marUnit", new byte[]{unitArr[0], unitArr[2], unitArr[1], unitArr[3]});
        } else {
            this.themeProps.remove(id + "margin");
            this.themeProps.remove(id + "marUnit");
        }
        StyleParser.PaddingInfo padding = styleInfo.getPadding();
        if (padding != null) {
            float[] paddingArr = padding.createPadding(base);
            this.themeProps.put(id + "padding", paddingArr[0] + "," + paddingArr[2] + "," + paddingArr[1] + "," + paddingArr[3]);
            byte[] unitArr = padding.createPaddingUnit(base);
            this.themeProps.put(id + "padUnit", new byte[]{unitArr[0], unitArr[2], unitArr[1], unitArr[3]});
        } else {
            this.themeProps.remove(id + "padding");
            this.themeProps.remove(id + "padUnit");
        }
        Integer transparency = styleInfo.getTransparency();
        if (transparency != null) {
            this.themeProps.put(id + "transparency", String.valueOf(transparency));
        } else {
            this.themeProps.remove(id + "transparency");
        }
        Integer opacity = styleInfo.getOpacity();
        if (opacity != null) {
            this.themeProps.put(id + "opacity", String.valueOf(opacity));
        } else {
            this.themeProps.remove(id + "opacity");
        }
        Integer alignment = styleInfo.getAlignment();
        if (alignment != null) {
            this.themeProps.put(id + "align", alignment);
        } else {
            this.themeProps.remove(id + "align");
        }
        Integer textDecoration = styleInfo.getTextDecoration();
        if (textDecoration != null) {
            this.themeProps.put(id + "textDecoration", textDecoration);
        } else {
            this.themeProps.remove(id + "textDecoration");
        }
        StyleParser.FontInfo font = styleInfo.getFont();
        if (font != null) {
            this.themeProps.put(id + "font", font.createFont(base));
        } else {
            this.themeProps.remove(id + "font");
        }
        if (selected) {
            this.selectedStyles.remove(id);
        } else {
            this.styles.remove(id);
        }
        return this.getComponentStyleImpl(originalId, selected, prefix);
    }

    Style createStyle(String id, String prefix, boolean selected) {
        Style style;
        String baseStyle;
        String originalId = id;
        if (prefix != null && prefix.length() > 0) {
            id = id + prefix;
        }
        if ((baseStyle = (String)this.themeProps.get(id + "derive")) != null) {
            if (baseStyle.indexOf(46) > -1 && baseStyle.indexOf(35) < 0) {
                baseStyle = baseStyle + "#";
            }
            if (!(baseStyle + ".").equals(id)) {
                int pos = baseStyle.indexOf(46);
                if (pos > -1) {
                    String baseId = baseStyle.substring(0, pos);
                    String basePrefix = baseStyle.substring(pos + 1);
                    style = new Style(this.getComponentStyleImpl(baseId, basePrefix.indexOf("sel") > -1, basePrefix));
                } else {
                    style = new Style(this.getComponentStyle(baseStyle));
                }
            } else {
                baseStyle = null;
                style = selected ? new Style(this.defaultSelectedStyle) : new Style(this.defaultStyle);
            }
        } else {
            style = selected ? new Style(this.defaultSelectedStyle) : new Style(this.defaultStyle);
        }
        if (this.themeProps != null) {
            String bgColor = (String)this.themeProps.get(id + "bgColor");
            String fgColor = (String)this.themeProps.get(id + "fgColor");
            Object border = this.themeProps.get(id + "border");
            Object bgImage = this.themeProps.get(id + "bgImage");
            String transperency = (String)this.themeProps.get(id + "transparency");
            String opacity = (String)this.themeProps.get(id + "opacity");
            String margin = (String)this.themeProps.get(id + "margin");
            String padding = (String)this.themeProps.get(id + "padding");
            Object font = this.themeProps.get(id + "font");
            Integer alignment = (Integer)this.themeProps.get(id + "align");
            Integer textDecoration = (Integer)this.themeProps.get(id + "textDecoration");
            Byte backgroundType = (Byte)this.themeProps.get(id + "bgType");
            Object[] backgroundGradient = (Object[])this.themeProps.get(id + "bgGradient");
            byte[] paddingUnit = (byte[])this.themeProps.get(id + "padUnit");
            byte[] marginUnit = (byte[])this.themeProps.get(id + "marUnit");
            if (this.themeProps.containsKey(id + "elevation")) {
                style.setElevation((Integer)this.themeProps.get(id + "elevation"));
            }
            if (this.themeProps.containsKey(id + "iconGap")) {
                if (this.themeProps.containsKey(id + "iconGapUnit")) {
                    style.setIconGapUnit((Byte)this.themeProps.get(id + "iconGapUnit"));
                } else {
                    style.setIconGapUnit((byte)0);
                }
                style.setIconGap(((Float)this.themeProps.get(id + "iconGap")).floatValue());
            }
            if (this.themeProps.containsKey(id + "fgAlpha")) {
                style.setFgAlpha((Integer)this.themeProps.get(id + "fgAlpha"));
            }
            if (this.themeProps.containsKey(id + "surface")) {
                style.setSurface((Boolean)this.themeProps.get(id + "surface"));
            }
            if (bgColor != null) {
                style.setBgColor(Integer.parseInt(bgColor, 16));
            }
            if (fgColor != null) {
                style.setFgColor(Integer.parseInt(fgColor, 16));
            }
            if (transperency != null) {
                style.setBgTransparency(Integer.parseInt(transperency));
            } else if (selected && (transperency = (String)this.themeProps.get(originalId + "transparency")) != null) {
                style.setBgTransparency(Integer.parseInt(transperency));
            }
            if (opacity != null) {
                style.setOpacity(Integer.parseInt(opacity));
            } else if (selected && (opacity = (String)this.themeProps.get(originalId + "opacity")) != null) {
                style.setBgTransparency(Integer.parseInt(opacity));
            }
            if (margin != null) {
                float[] marginArr = this.toFloatArray(margin.trim());
                style.setMargin(marginArr[0], marginArr[1], marginArr[2], marginArr[3]);
            }
            if (padding != null) {
                float[] paddingArr = this.toFloatArray(padding.trim());
                style.setPadding(paddingArr[0], paddingArr[1], paddingArr[2], paddingArr[3]);
            }
            if (paddingUnit != null) {
                style.setPaddingUnit(paddingUnit);
            } else if (padding != null) {
                style.setPaddingUnit(null);
            }
            if (marginUnit != null) {
                style.setMarginUnit(marginUnit);
            } else if (margin != null) {
                style.setMarginUnit(null);
            }
            if (alignment != null) {
                style.setAlignment(alignment);
            }
            if (textDecoration != null) {
                style.setTextDecoration(textDecoration);
            }
            if (backgroundType != null) {
                style.setBackgroundType(backgroundType);
            }
            if (backgroundGradient != null) {
                if (backgroundGradient.length < 5) {
                    Object[] a = new Object[5];
                    System.arraycopy(backgroundGradient, 0, a, 0, backgroundGradient.length);
                    backgroundGradient = a;
                    backgroundGradient[4] = new Float(1.0f);
                }
                style.setBackgroundGradient(backgroundGradient);
            }
            if (bgImage != null) {
                Image im = null;
                if (bgImage instanceof String) {
                    try {
                        String bgImageStr = (String)bgImage;
                        if (this.imageCache.containsKey(bgImageStr)) {
                            im = this.imageCache.get(bgImageStr);
                        } else {
                            im = bgImageStr.startsWith("/") ? Image.createImage(bgImageStr) : UIManager.parseImage((String)bgImage);
                            this.imageCache.put(bgImageStr, im);
                        }
                        this.themeProps.put(id + "bgImage", im);
                    }
                    catch (IOException ex) {
                        System.out.println("failed to parse image for id = " + id + "bgImage");
                    }
                } else if (bgImage instanceof Image) {
                    im = (Image)bgImage;
                }
                if (id.indexOf("Form") > -1 && (im.getWidth() != Display.getInstance().getDisplayWidth() || im.getHeight() != Display.getInstance().getDisplayHeight()) && style.getBackgroundType() == 1 && accessible) {
                    im.scale(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
                }
                style.setBgImage(im);
            }
            if (font != null) {
                if (font instanceof String) {
                    style.setFont(UIManager.parseFont((String)font));
                } else {
                    style.setFont((Font)font);
                }
            }
            if (border != null) {
                style.setBorder((Border)border);
            }
            style.resetModifiedFlag();
        }
        return style;
    }

    private float[] toFloatArray(String str) {
        float[] retVal = new float[4];
        str = str + ",";
        int rlen = retVal.length;
        for (int i = 0; i < rlen; ++i) {
            retVal[i] = Float.parseFloat(str.substring(0, str.indexOf(",")));
            str = str.substring(str.indexOf(",") + 1);
        }
        return retVal;
    }

    public Hashtable getResourceBundle() {
        if (this.resourceBundle == null && this.bundle != null) {
            this.resourceBundle = new Hashtable<String, String>(this.bundle);
        }
        return this.resourceBundle;
    }

    public void setResourceBundle(Hashtable resourceBundle) {
        if (localeAccessible) {
            this.resourceBundle = resourceBundle;
            if (resourceBundle != null) {
                String v = (String)resourceBundle.get("@rtl");
                if (v != null) {
                    this.getLookAndFeel().setRTL(v.equalsIgnoreCase("true"));
                    this.current.refreshTheme(false);
                }
                this.bundle = new HashMap<String, String>(resourceBundle);
            } else {
                this.bundle = null;
            }
        }
    }

    public Map<String, String> getBundle() {
        return this.bundle;
    }

    public void setBundle(Map<String, String> bundle) {
        if (localeAccessible) {
            this.bundle = bundle;
            if (bundle != null) {
                String textFieldInputMode;
                String v = bundle.get("@rtl");
                if (v != null) {
                    this.getLookAndFeel().setRTL(v.equalsIgnoreCase("true"));
                    this.current.refreshTheme(false);
                }
                if ((textFieldInputMode = bundle.get("@im")) != null && textFieldInputMode.length() > 0) {
                    String[] tokenized = this.toStringArray(StringUtil.tokenizeString(textFieldInputMode, '|'));
                    TextField.setDefaultInputModeOrder(tokenized);
                    for (String val : tokenized) {
                        String actual = bundle.get("@im-" + val);
                        if (actual == null) continue;
                        TextField.addInputMode(val, this.parseTextFieldInputMode(actual), Character.isUpperCase(val.charAt(0)));
                    }
                }
            }
        }
    }

    private Hashtable parseTextFieldInputMode(String s) {
        Vector tokens = StringUtil.tokenizeString(s, '|');
        Hashtable<Integer, String> response = new Hashtable<Integer, String>();
        int count = tokens.size();
        for (int iter = 0; iter < count; ++iter) {
            String t = (String)tokens.elementAt(iter);
            int pos = t.indexOf(61);
            String key = t.substring(0, pos);
            String val = t.substring(pos + 1);
            response.put(Integer.valueOf(key), val);
        }
        return response;
    }

    private String[][] getInputMode(String prefix, String val, Hashtable resourceBundle) {
        if (resourceBundle.containsKey(prefix + val)) {
            return this.tokenizeMultiArray((String)resourceBundle.get(prefix + val), '|', '\n');
        }
        return null;
    }

    private String[] toStringArray(Vector v) {
        String[] arr = new String[v.size()];
        int alen = arr.length;
        for (int iter = 0; iter < alen; ++iter) {
            arr[iter] = (String)v.elementAt(iter);
        }
        return arr;
    }

    private String[][] tokenizeMultiArray(String s, char separator, char lineBreak) {
        Vector lines = StringUtil.tokenizeString(s, lineBreak);
        int lineCount = lines.size();
        String[][] result = new String[lineCount][];
        for (int iter = 0; iter < lineCount; ++iter) {
            String currentString = (String)lines.elementAt(iter);
            result[iter] = this.toStringArray(StringUtil.tokenizeString(currentString, separator));
        }
        return result;
    }

    public String localize(String key, String defaultValue) {
        String o;
        if (this.bundle != null && key != null && (o = this.bundle.get(key)) != null) {
            return o;
        }
        return defaultValue;
    }

    public void addThemeRefreshListener(ActionListener l) {
        if (this.themelisteners == null) {
            this.themelisteners = new EventDispatcher();
        }
        this.themelisteners.addListener(l);
    }

    public void removeThemeRefreshListener(ActionListener l) {
        if (this.themelisteners == null) {
            return;
        }
        this.themelisteners.removeListener(l);
    }

    static {
        accessible = true;
        localeAccessible = true;
    }
}

