/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.scene;

import com.codename1.properties.Property;
import com.codename1.ui.Display;
import com.codename1.ui.Transform;
import com.codename1.ui.scene.Camera;
import com.codename1.ui.scene.Scene;
import java.util.Arrays;

public class PerspectiveCamera
extends Camera {
    public final Property<Double, Camera> verticalFieldOfView;
    private final Scene scene;

    public PerspectiveCamera(Scene scene, double fovY, double zNear, double zFar) {
        super(zNear, zFar);
        this.scene = scene;
        this.verticalFieldOfView = new Property("verticalFieldOfView", 0.25);
    }

    public Transform getTransform() {
        Display d = Display.getInstance();
        float zNear = (float)((Double)this.nearClip.get()).doubleValue();
        double dw = d.getDisplayWidth();
        double dh = d.getDisplayHeight();
        int x = this.scene.getAbsoluteX();
        int y = this.scene.getAbsoluteY();
        int w = this.scene.getWidth();
        int h = this.scene.getHeight();
        Transform perspectiveT = Transform.makePerspective((float)this.verticalFieldOfView.get().doubleValue(), (float)(dw / dh), zNear, (float)((Double)this.farClip.get()).doubleValue());
        float displayH = Display.getInstance().getDisplayHeight();
        float displayW = (float)dw;
        float[] bottomRight = perspectiveT.transformPoint(new float[]{displayW, displayH, zNear});
        Transform currTransform = Transform.makeIdentity();
        float xfactor = -displayW / bottomRight[0];
        float yfactor = -displayH / bottomRight[1];
        currTransform.translate((float)dw / 2.0f, y + h / 2, zNear);
        currTransform.scale(xfactor, yfactor, 1.0f);
        currTransform.concatenate(perspectiveT);
        float zState = 0.0f;
        float cameraZ = -zNear - (float)(w / 2) * zState;
        float cameraX = (float)(-dw) / 2.0f;
        float cameraY = -y - h / 2;
        currTransform.translate(cameraX, cameraY, cameraZ);
        float[] tl = new float[3];
        float[] tr = new float[3];
        float[] bl = new float[3];
        float[] br = new float[3];
        currTransform.transformPoint(new float[]{x, y, 0.0f}, tl);
        currTransform.transformPoint(new float[]{x + w, y, 0.0f}, tr);
        currTransform.transformPoint(new float[]{x + w, y + h, 0.0f}, br);
        currTransform.transformPoint(new float[]{x, y + h, 0.0f}, bl);
        System.out.println("Camera transform " + x + ", " + y + ", " + 0 + "->" + Arrays.toString(tl));
        System.out.println("Camera transform " + (x + w) + ", " + y + ", " + 0 + "->" + Arrays.toString(tr));
        System.out.println("Camera transform " + (x + w) + ", " + (y + h) + ", " + 0 + "->" + Arrays.toString(br));
        System.out.println("Camera transform " + x + ", " + (y + h) + ", " + 0 + "->" + Arrays.toString(bl));
        return currTransform;
    }
}

