/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.l10n.DateFormat;
import com.codename1.l10n.SimpleDateFormat;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Graphics;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.events.ScrollListener;
import com.codename1.ui.events.SelectionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.list.ListModel;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.scene.Bounds;
import com.codename1.ui.scene.PerspectiveCamera;
import com.codename1.ui.scene.Scene;
import com.codename1.ui.spinner.InternalPickerWidget;
import com.codename1.ui.spinner.SpinnerDateModel;
import com.codename1.ui.spinner.SpinnerNode;
import com.codename1.ui.spinner.SpinnerNumberModel;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Spinner3D
extends Container
implements InternalPickerWidget {
    private final SpinnerNode root;
    private final Scene scene;
    private final ScrollingContainer scroller;
    private final boolean gridPosDirty = true;

    public Spinner3D(ListModel<String> listModel) {
        super(BoxLayout.y());
        this.setScrollableY(false);
        this.root = new SpinnerNode();
        this.scene = new Scene(){

            public void setWidth(int width) {
                super.setWidth(width);
                ((Bounds)((Spinner3D)Spinner3D.this).root.boundsInLocal.get()).setWidth(width);
            }

            public void setHeight(int height) {
                super.setHeight(height);
                ((Bounds)((Spinner3D)Spinner3D.this).root.boundsInLocal.get()).setHeight(height);
            }
        };
        this.scene.setName("Scene");
        ((Bounds)this.root.boundsInLocal.get()).setWidth(Display.getInstance().getDisplayWidth());
        ((Bounds)this.root.boundsInLocal.get()).setHeight(1000.0);
        this.setModel(listModel);
        this.scene.setRoot(this.root);
        if (Spinner3D.usePerspective()) {
            this.scene.camera.set(new PerspectiveCamera(this.scene, 0.25, 1600.0, 4600.0));
        }
        this.scroller = new ScrollingContainer(){

            protected Dimension calcPreferredSize() {
                return new Dimension(500, (int)Spinner3D.this.root.calcViewportHeight());
            }

            protected Dimension calcScrollSize() {
                int viewportHeight = (int)Spinner3D.this.root.calcViewportHeight();
                int listHeight = (int)Spinner3D.this.root.calcFlatListHeight();
                int rowHeight = (int)Spinner3D.this.root.calcRowHeight();
                return new Dimension(500, Math.max(viewportHeight, listHeight + 6 * rowHeight));
            }

            protected int getGridPosY() {
                int rowHeight = (int)Spinner3D.this.root.calcRowHeight();
                int scrollY = this.getScrollY();
                int rowOffsetY = scrollY % rowHeight;
                boolean roundUp = rowOffsetY > rowHeight - rowOffsetY;
                return (int)Math.min(Spinner3D.this.root.calcFlatListHeight() - (double)rowHeight, (double)Math.max(0, roundUp ? scrollY + rowHeight - rowOffsetY : scrollY - rowOffsetY));
            }

            protected void onScrollY(int scrollY) {
                super.onScrollY(scrollY);
            }
        };
        this.scroller.setSnapToGrid(true);
        this.scroller.setScrollVisible(false);
        this.scroller.setScrollableY(true);
        this.scroller.setName("Scroller");
        this.scroller.addScrollListener(new ScrollListener(){

            public void scrollChanged(int scrollX, int scrollY, int oldscrollX, int oldscrollY) {
                Spinner3D.this.root.setScrollY(scrollY);
            }
        });
        this.root.addScrollListener(new ScrollListener(){

            public void scrollChanged(int scrollX, int scrollY, int oldscrollX, int oldscrollY) {
                Spinner3D.this.scroller.setScrollY(scrollY);
            }
        });
        ComponentSelector.$(this.scroller, this.scene).setMargin(0).setPadding(0);
        this.scroller.setScrollY((int)this.root.getScrollY());
        Container wrapper = LayeredLayout.encloseIn(this.scene, this.scroller);
        ComponentSelector.$(wrapper).setBorder(Border.createEmpty()).setMargin(0).setPadding(0).setBgTransparency(0);
        wrapper.setName("Wrapper");
        LayeredLayout ll = (LayeredLayout)wrapper.getLayout();
        ll.setInsets(this.scroller, "0 0 auto 0").setInsets(this.scene, "0 0 auto 0");
        this.add(wrapper);
    }

    private static boolean usePerspective() {
        return false;
    }

    public static Spinner3D create(double min, double max, double currentValue, double step) {
        Spinner3D s = new Spinner3D(new SpinnerNumberModel(min, max, currentValue, step));
        return s;
    }

    public static Spinner3D create(int min, int max, int currentValue, int step) {
        Spinner3D s = new Spinner3D(new SpinnerNumberModel(min, max, currentValue, step));
        return s;
    }

    public static Spinner3D createDate(long min, long max, long currentValue) {
        Spinner3D s = new Spinner3D(new SpinnerDateModel(min, max, currentValue));
        return s;
    }

    public int getSelectedIndex() {
        return this.root.getSelectedIndex();
    }

    public void setModel(ListModel model) {
        if (model instanceof SpinnerNumberModel) {
            model = new NumberModelAdapter((SpinnerNumberModel)model);
        }
        if (model instanceof SpinnerDateModel) {
            model = new DateModelAdapter((SpinnerDateModel)model);
        }
        this.root.setListModel(model);
        if (this.scroller != null) {
            this.scroller.setShouldCalcPreferredSize(true);
        }
    }

    @Override
    public Object getValue() {
        ListModel<String> lm = this.root.getListModel();
        if (lm instanceof NumberModelAdapter) {
            NumberModelAdapter adapter = (NumberModelAdapter)lm;
            int selectedIndex = adapter.getSelectedIndex();
            Object out = adapter.inner.getItemAt(selectedIndex);
            return out;
        }
        if (lm instanceof DateModelAdapter) {
            DateModelAdapter adapter = (DateModelAdapter)lm;
            return adapter.inner.getItemAt(adapter.getSelectedIndex());
        }
        return lm.getItemAt(lm.getSelectedIndex());
    }

    @Override
    public void setValue(Object value) {
        ListModel<String> lm = this.root.getListModel();
        if (lm instanceof NumberModelAdapter) {
            NumberModelAdapter adapter = (NumberModelAdapter)lm;
            adapter.inner.setValue(value);
            return;
        }
        if (lm instanceof DateModelAdapter) {
            DateModelAdapter adapter = (DateModelAdapter)lm;
            adapter.inner.setValue((Date)value);
            return;
        }
        int len = lm.getSize();
        for (int i = 0; i < len; ++i) {
            String val = lm.getItemAt(i);
            if (val == null || !val.equals(value)) continue;
            lm.setSelectedIndex(i);
            break;
        }
    }

    public Style getRowStyle() {
        return this.root.getRowStyle();
    }

    public Style getSelectedRowStyle() {
        return this.root.getSelectedRowStyle();
    }

    public Style getSelectedOverlayStyle() {
        return this.root.getSelectedOverlayStyle();
    }

    void setRowFormatter(SpinnerNode.RowFormatter formatter) {
        this.root.setRowFormatter(formatter);
    }

    @Override
    public void paint(Graphics g) {
        int alpha = g.getAlpha();
        g.setColor(this.root.getSelectedOverlayStyle().getBgColor());
        g.setAlpha(255);
        g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        g.setAlpha(alpha);
        super.paint(g);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumberModelAdapter
    implements ListModel<String> {
        private final SpinnerNumberModel inner;

        NumberModelAdapter(SpinnerNumberModel inner) {
            this.inner = inner;
        }

        @Override
        public String getItemAt(int index) {
            return this.inner.getItemAt(index).toString();
        }

        @Override
        public int getSize() {
            return this.inner.getSize();
        }

        @Override
        public int getSelectedIndex() {
            return this.inner.getSelectedIndex();
        }

        @Override
        public void setSelectedIndex(int index) {
            this.inner.setSelectedIndex(index);
        }

        @Override
        public void addDataChangedListener(DataChangedListener l) {
            this.inner.addDataChangedListener(l);
        }

        @Override
        public void removeDataChangedListener(DataChangedListener l) {
            this.inner.removeDataChangedListener(l);
        }

        @Override
        public void addSelectionListener(SelectionListener l) {
            this.inner.addSelectionListener(l);
        }

        @Override
        public void removeSelectionListener(SelectionListener l) {
            this.inner.removeSelectionListener(l);
        }

        @Override
        public void addItem(String item) {
            this.inner.addItem(item);
        }

        @Override
        public void removeItem(int index) {
            this.inner.removeItem(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateModelAdapter
    implements ListModel<String> {
        final SpinnerDateModel inner;
        DateFormat fmt = new SimpleDateFormat("EEE MMM d");

        DateModelAdapter(SpinnerDateModel inner) {
            this.inner = inner;
        }

        @Override
        public String getItemAt(int index) {
            Date dt = (Date)this.inner.getItemAt(index);
            Calendar startToday = Calendar.getInstance();
            startToday.setTime(new Date());
            startToday.set(11, 0);
            startToday.set(12, 0);
            Calendar endToday = Calendar.getInstance();
            endToday.setTime(new Date());
            endToday.set(11, 23);
            endToday.set(12, 59);
            endToday.set(13, 59);
            if (dt.getTime() >= startToday.getTime().getTime() && dt.getTime() < endToday.getTime().getTime()) {
                return "Today";
            }
            return this.fmt.format(dt);
        }

        @Override
        public int getSize() {
            return this.inner.getSize();
        }

        @Override
        public int getSelectedIndex() {
            return this.inner.getSelectedIndex();
        }

        @Override
        public void setSelectedIndex(int index) {
            this.inner.setSelectedIndex(index);
        }

        @Override
        public void addDataChangedListener(DataChangedListener l) {
            this.inner.addDataChangedListener(l);
        }

        @Override
        public void removeDataChangedListener(DataChangedListener l) {
            this.inner.removeDataChangedListener(l);
        }

        @Override
        public void addSelectionListener(SelectionListener l) {
            this.inner.addSelectionListener(l);
        }

        @Override
        public void removeSelectionListener(SelectionListener l) {
            this.inner.removeSelectionListener(l);
        }

        @Override
        public void addItem(String item) {
            this.inner.addItem(item);
        }

        @Override
        public void removeItem(int index) {
            this.inner.removeItem(index);
        }
    }

    private static class ScrollingContainer
    extends Container {
        ScrollingContainer() {
            super(BoxLayout.y());
            this.getUnselectedStyle().setBorder(Border.createEmpty());
        }

        public void setScrollY(int scrollY) {
            super.setScrollY(scrollY);
        }
    }
}

