/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.events.SelectionListener;
import com.codename1.ui.list.ListModel;
import com.codename1.ui.util.EventDispatcher;
import java.util.Calendar;
import java.util.Date;

class SpinnerDateModel
implements ListModel {
    private static final long DAY = 86400000L;
    private final EventDispatcher dataListener = new EventDispatcher();
    private final EventDispatcher selectionListener = new EventDispatcher();
    private final long min;
    private final long max;
    private long currentValue;

    public SpinnerDateModel(long min, long max, long currentValue) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(max));
        cal.set(11, 0);
        cal.add(12, 0);
        cal.add(13, 0);
        cal.add(14, 0);
        this.max = cal.getTime().getTime();
        cal.setTime(new Date(min));
        cal.set(11, 0);
        cal.add(12, 0);
        cal.add(13, 0);
        cal.add(14, 0);
        this.min = cal.getTime().getTime();
        cal.setTime(new Date(currentValue));
        cal.set(11, 0);
        cal.add(12, 0);
        cal.add(13, 0);
        cal.add(14, 0);
        this.currentValue = cal.getTime().getTime();
    }

    Object getValue() {
        return new Date(this.currentValue);
    }

    void setValue(Date value) {
        int oldIndex = this.getSelectedIndex();
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.set(11, 12);
        cal.add(12, 0);
        cal.add(13, 0);
        cal.add(14, 0);
        this.currentValue = cal.getTime().getTime();
        if (oldIndex != this.getSelectedIndex()) {
            this.selectionListener.fireSelectionEvent(oldIndex, this.getSelectedIndex());
        }
    }

    public Object getItemAt(int index) {
        return new Date(this.min + 86400000L * (long)index);
    }

    public int getSize() {
        return (int)((this.max - this.min) / 86400000L) + 1;
    }

    public int getSelectedIndex() {
        int out = (int)((this.currentValue - this.min) / 86400000L);
        return out;
    }

    public void setSelectedIndex(int index) {
        int oldIndex = this.getSelectedIndex();
        this.currentValue = this.min + (long)index * 86400000L;
        int newIndex = this.getSelectedIndex();
        this.selectionListener.fireSelectionEvent(oldIndex, newIndex);
    }

    public void addDataChangedListener(DataChangedListener l) {
        this.dataListener.addListener(l);
    }

    public void removeDataChangedListener(DataChangedListener l) {
        this.dataListener.removeListener(l);
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListener.addListener(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListener.removeListener(l);
    }

    public void addItem(Object item) {
    }

    public void removeItem(int index) {
    }
}

