/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.ui.Graphics;
import com.codename1.ui.Label;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.events.ScrollListener;
import com.codename1.ui.events.SelectionListener;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.geom.Rectangle2D;
import com.codename1.ui.list.ListModel;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.scene.Bounds;
import com.codename1.ui.scene.Node;
import com.codename1.ui.scene.NodePainter;
import com.codename1.ui.scene.Point3D;
import com.codename1.ui.scene.TextPainter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpinnerNode
extends Node {
    ListModel<String> listModel;
    Node selectedRowOverlay = new Node();
    private final Label rowTemplate = new Label("", "Spinner3DRow");
    private final Label overlayTemplate = new Label("", "Spinner3DOverlay");
    private final Style rowStyle;
    private final Style selectedRowStyle;
    private final Style overlayStyle;
    private final Map<Integer, Node> childIndex = new HashMap<Integer, Node>();
    private List<ScrollListener> scrollListeners;
    private boolean setSelectedIndexReentrantLock;
    private boolean setScrollYReentrantLock;
    private RowFormatter rowFormatter;
    private double flatScrollPos;
    private final int numSides = 14;
    private final Label renderer = new Label("Testing", "Spinner3DRow");
    private final DataChangedListener listChangedListener = new DataChangedListener(){

        public void dataChanged(int type, int index) {
            SpinnerNode.this.rebuildChildren();
        }
    };
    private int selectedIndex = -1;
    private List<SelectionListener> selectionListeners;
    private final SelectionListener selectionListener = new SelectionListener(){

        public void selectionChanged(int oldSelected, int newSelected) {
            if (newSelected < 0 && SpinnerNode.this.listModel != null) {
                newSelected = SpinnerNode.this.listModel.getSelectedIndex();
            }
            if (newSelected >= 0 && newSelected < SpinnerNode.this.listModel.getSize() && newSelected != SpinnerNode.this.selectedIndex) {
                SpinnerNode.this.setSelectedIndex(newSelected);
            }
        }
    };

    public SpinnerNode() {
        this.rowStyle = this.rowTemplate.getUnselectedStyle();
        this.selectedRowStyle = this.rowTemplate.getSelectedStyle();
        this.overlayStyle = this.overlayTemplate.getUnselectedStyle();
        this.selectedRowOverlay.setStyle(this.overlayStyle);
        this.selectedRowOverlay.setRenderer(new NodePainter(){

            public void paint(Graphics g, Rectangle bounds, Node node) {
                Style style = node.getStyle();
                g.setColor(style.getBgColor());
                g.fillRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                g.setColor(style.getFgColor());
                int alpha = g.concatenateAlpha(style.getFgAlpha());
                g.drawLine(bounds.getX(), bounds.getY(), bounds.getWidth() + bounds.getX(), bounds.getY());
                g.drawLine(bounds.getX(), bounds.getY() + bounds.getHeight(), bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
                g.setAlpha(alpha);
            }
        });
    }

    private static boolean usePerspective() {
        return false;
    }

    public void addScrollListener(ScrollListener l) {
        if (this.scrollListeners == null) {
            this.scrollListeners = new ArrayList<ScrollListener>();
        }
        this.scrollListeners.add(l);
    }

    public void removeScrollListener(ScrollListener l) {
        if (this.scrollListeners != null) {
            this.scrollListeners.remove(l);
            if (this.scrollListeners.isEmpty()) {
                this.scrollListeners = null;
            }
        }
    }

    private void fireScrollEvent(int scrollPos) {
        if (this.scrollListeners != null) {
            for (ScrollListener l : this.scrollListeners) {
                l.scrollChanged(-1, scrollPos, -1, -1);
            }
        }
    }

    public void setRowFormatter(RowFormatter formatter) {
        if (this.rowFormatter != formatter) {
            this.rowFormatter = formatter;
            this.rebuildChildren();
        }
    }

    public Style getRowStyle() {
        return this.rowStyle;
    }

    public int getNumSides() {
        return 14;
    }

    public Style getSelectedRowStyle() {
        return this.selectedRowStyle;
    }

    public Style getSelectedOverlayStyle() {
        return this.overlayStyle;
    }

    public ListModel<String> getListModel() {
        return this.listModel;
    }

    public void setListModel(ListModel<String> list) {
        if (this.listModel != null) {
            this.listModel.removeSelectionListener(this.selectionListener);
            this.listModel.removeDataChangedListener(this.listChangedListener);
        }
        this.listModel = list;
        if (this.listModel != null) {
            this.listModel.addSelectionListener(this.selectionListener);
            this.listModel.addDataChangedListener(this.listChangedListener);
        }
        this.rebuildChildren();
    }

    private void rebuildChildren() {
        this.childIndex.clear();
        this.removeAll();
        this.setSelectedIndex(this.listModel.getSelectedIndex());
        this.add(this.selectedRowOverlay);
    }

    public Node getSelectedRowOverlay() {
        return this.selectedRowOverlay;
    }

    public double calcRowHeight() {
        return this.renderer.getPreferredH();
    }

    public double calcFlatListHeight() {
        return this.renderer.getPreferredH() * this.listModel.getSize();
    }

    public double calcViewportHeight() {
        double circumference = this.renderer.getPreferredH() * 14;
        double diameter = circumference / Math.PI;
        return diameter;
    }

    private double calculateRotationForChild(int index) {
        double degreeOffset = this.flatScrollPos * 360.0 / (double)(14 * this.renderer.getPreferredH());
        int pos = index % 14;
        return (-25.714285714285715 * (double)pos + degreeOffset) % 360.0;
    }

    private double getRotationRangeForSide() {
        return 25.714285714285715;
    }

    private double getFlatVisibleHeight() {
        return this.renderer.getPreferredH() * 14 / 2;
    }

    public int getSelectedIndex() {
        return (int)(this.flatScrollPos / this.calcFlatListHeight() * (double)this.listModel.getSize());
    }

    public void setSelectedIndex(int index) {
        if (this.setSelectedIndexReentrantLock) {
            return;
        }
        this.setSelectedIndexReentrantLock = true;
        try {
            if (index < 0 || index > this.listModel.getSize() - 1) {
                throw new ArrayIndexOutOfBoundsException("Index out of bounds:" + index + ", must be between 0 and " + (this.listModel.getSize() - 1));
            }
            this.setScrollY((double)index * this.calcFlatListHeight() / (double)this.listModel.getSize());
        }
        finally {
            this.setSelectedIndexReentrantLock = false;
        }
    }

    private void updateSelectedIndex() {
        int newSelectedIndex = this.getSelectedIndex();
        if (newSelectedIndex != this.selectedIndex) {
            int oldSelectedIndex = this.selectedIndex;
            this.selectedIndex = newSelectedIndex;
            this.listModel.setSelectedIndex(newSelectedIndex);
            if (this.selectionListeners != null && !this.selectionListeners.isEmpty()) {
                for (SelectionListener l : this.selectionListeners) {
                    l.selectionChanged(oldSelectedIndex, newSelectedIndex);
                }
            }
        }
    }

    public void addSelectionListener(SelectionListener l) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<SelectionListener>();
        }
        this.selectionListeners.add(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove(l);
        }
        if (this.selectionListeners.isEmpty()) {
            this.selectionListeners = null;
        }
    }

    private int getMinVisibleIndex(int selectedIndex) {
        return selectedIndex - 3;
    }

    private int getMaxVisibleIndex(int selectedIndex) {
        return selectedIndex + 3;
    }

    public double getScrollY() {
        return this.flatScrollPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScrollY(double pos) {
        if (this.setScrollYReentrantLock) {
            return;
        }
        this.setScrollYReentrantLock = true;
        try {
            int prevScrollPos = (int)this.flatScrollPos;
            int posInt = (int)pos;
            if (prevScrollPos != posInt) {
                this.flatScrollPos = posInt;
                this.setNeedsLayout(true);
                if (this.getScene() != null) {
                    this.getScene().repaint();
                }
                this.updateSelectedIndex();
                this.fireScrollEvent((int)pos);
            }
        }
        finally {
            this.setScrollYReentrantLock = false;
        }
    }

    private Node getOrCreateChild(int i) {
        if (this.childIndex.containsKey(i)) {
            return this.childIndex.get(i);
        }
        if (this.listModel != null) {
            ListModel<String> list = this.listModel;
            final Node n = new Node();
            String lbl = list.getItemAt(i);
            if (this.rowFormatter != null) {
                lbl = this.rowFormatter.format(lbl);
            }
            Label renderer = new Label(lbl, "Spinner3DRow"){

                public Style getStyle() {
                    if (n.hasTag("selected")) {
                        return this.getSelectedStyle();
                    }
                    return this.getUnselectedStyle();
                }
            };
            renderer.setSelectedStyle(this.getSelectedRowStyle());
            renderer.setUnselectedStyle(this.getRowStyle());
            n.setRenderer(new TextPainter(lbl, 4));
            this.remove(this.selectedRowOverlay);
            this.add(n);
            this.add(this.selectedRowOverlay);
            this.childIndex.put(i, n);
            return n;
        }
        return null;
    }

    @Override
    protected void layoutChildren() {
        double width = ((Bounds)this.boundsInLocal.get()).getWidth();
        double rendererHeight = this.renderer.getPreferredH();
        double circumference = rendererHeight * 14.0;
        double diameter = circumference / Math.PI;
        int index = 0;
        int selectedIndex = this.getSelectedIndex();
        int minVisibleIndex = this.getMinVisibleIndex(selectedIndex);
        int maxVisibleIndex = this.getMaxVisibleIndex(selectedIndex);
        if (this.hasChildren()) {
            int len = this.listModel.getSize();
            for (int i = 0; i < len; ++i) {
                double angle;
                if (!(minVisibleIndex <= index && maxVisibleIndex >= index || this.childIndex.containsKey(i))) {
                    ++index;
                    continue;
                }
                Node child = this.getOrCreateChild(i);
                if (minVisibleIndex > index || maxVisibleIndex < index) {
                    child.visible.set(false);
                    ++index;
                    continue;
                }
                child.visible.set(true);
                Bounds localBounds = child.boundsInLocal.get();
                localBounds.setWidth(width);
                localBounds.setDepth(0.0);
                localBounds.setHeight(diameter);
                localBounds.setMinX(0.0);
                localBounds.setMinY(0.0);
                child.paintingRect.set(new Rectangle(0, (int)(diameter / 2.0 - rendererHeight / 2.0), (int)width, (int)rendererHeight));
                if (SpinnerNode.usePerspective()) {
                    localBounds.setDepth(diameter);
                    angle = this.calculateRotationForChild(index);
                    if (Math.abs(angle) < 10.0) {
                        child.addTags("selected");
                        child.setStyle(this.getSelectedRowStyle());
                        child.opacity.set(1.0);
                    } else {
                        child.removeTags("selected");
                        double opacity = Math.cos(angle * Math.PI / 180.0);
                        child.setStyle(this.getRowStyle());
                        child.opacity.set(opacity);
                    }
                    child.rotate.set(-angle);
                    child.rotationAxis.set(new Point3D(1.0, 0.0, 0.0));
                    child.layoutX.set(0.0);
                    child.layoutY.set(0.0);
                    child.layoutZ.set(-diameter / 2.0);
                } else {
                    angle = this.calculateRotationForChild(index) * Math.PI / 180.0;
                    double minAngle = angle + this.getRotationRangeForSide() * Math.PI / 180.0 / 2.0;
                    double maxAngle = angle - this.getRotationRangeForSide() * Math.PI / 180.0 / 2.0;
                    if (Math.abs(angle) < 0.17453292519943295) {
                        child.addTags("selected");
                        child.setStyle(this.selectedRowStyle);
                        child.opacity.set(1.0);
                    } else {
                        child.removeTags("selected");
                        child.setStyle(this.rowStyle);
                        double opacity = Math.cos(angle);
                        child.opacity.set(opacity);
                    }
                    double projectedHeight = Math.abs(diameter / 2.0 * (Math.sin(minAngle) - Math.sin(maxAngle)));
                    child.layoutX.set(0.0);
                    child.layoutY.set(-(diameter / 2.0) * Math.sin(angle));
                    child.layoutZ.set(0.0);
                    child.scaleY.set(projectedHeight / rendererHeight);
                }
                ++index;
            }
            Bounds b = this.selectedRowOverlay.boundsInLocal.get();
            b.setWidth(width);
            b.setHeight(rendererHeight);
            b.setMinX(0.0);
            b.setMinY(0.0);
            this.selectedRowOverlay.layoutX.set(0.0);
            this.selectedRowOverlay.layoutY.set(diameter / 2.0 - rendererHeight / 2.0);
        }
    }

    @Override
    public void render(Graphics g) {
        g.setColor(this.overlayStyle.getBgColor());
        int alpha = g.getAlpha();
        g.setAlpha(255);
        g.fillRect(0, 0, (int)((Bounds)this.boundsInLocal.get()).getWidth(), (int)((Bounds)this.boundsInLocal.get()).getHeight());
        g.setAlpha(alpha);
        super.render(g);
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        Rectangle2D overlayRect = this.selectedRowOverlay.getBoundsInScene(new Rectangle2D());
        double magnification = 1.35;
        double oldScaleX = (Double)this.scaleX.get();
        double oldScaleY = (Double)this.scaleY.get();
        double oldTranslateX = (Double)this.translateX.get();
        this.scaleX.set(oldScaleX * magnification);
        this.scaleY.set(oldScaleY * magnification);
        switch (this.getRowStyle().getAlignment()) {
            case 1: {
                this.translateX.set(oldTranslateX + ((Bounds)this.boundsInLocal.get()).getWidth() * (magnification - 1.0) / 2.0 / magnification);
                break;
            }
            case 3: {
                this.translateX.set(oldTranslateX - ((Bounds)this.boundsInLocal.get()).getWidth() * (magnification - 1.0) / 2.0 / magnification);
            }
        }
        this.selectedRowOverlay.visible.set(false);
        g.setClip((int)overlayRect.getX(), (int)overlayRect.getY() + 1, (int)overlayRect.getWidth(), (int)overlayRect.getHeight() - 2);
        super.render(g);
        this.selectedRowOverlay.visible.set(true);
        g.setClip(clipX, clipY, clipW, clipH);
        this.scaleX.set(oldScaleX);
        this.scaleY.set(oldScaleY);
        this.translateX.set(oldTranslateX);
    }

    public static interface RowFormatter {
        public String format(String var1);
    }
}

