/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Label;
import com.codename1.ui.List;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.list.DefaultListCellRenderer;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.spinner.BaseSpinner;
import com.codename1.ui.spinner.Spinner;
import com.codename1.ui.spinner.SpinnerNumberModel;
import com.codename1.ui.spinner.SpinnerRenderer;
import java.util.ArrayList;

public class TimeSpinner
extends BaseSpinner {
    private Spinner hour;
    private Spinner minute;
    private Spinner amPM;
    private final ArrayList<Component> hourComponents = new ArrayList();
    private final ArrayList<Component> minuteComponents = new ArrayList();
    private int startHour = 1;
    private int endHour = 13;
    private int minuteStep = 5;
    private boolean durationMode;
    private boolean showHours = true;
    private boolean showMinutes = true;
    private boolean showMeridiem = true;
    private int currentHour = 8;
    private int currentMinute = 0;
    private boolean currentMeridiem;

    void initSpinner() {
        if (this.hour == null) {
            this.hour = Spinner.create(this.startHour, this.endHour, this.currentHour, 1);
            this.minute = Spinner.create(0, 60, this.currentMinute, this.minuteStep);
            this.amPM = this.currentMeridiem ? Spinner.create(0, 2, 1, 1) : Spinner.create(0, 2, 0, 1);
            ((DefaultListCellRenderer)this.hour.getRenderer()).setRightAlignNumbers(true);
            SpinnerRenderer<Object> twoDigitRender = new SpinnerRenderer<Object>(){

                @Override
                public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
                    int i;
                    if (value != null && value instanceof Integer && (i = ((Integer)value).intValue()) < 10) {
                        value = "0" + i;
                    }
                    return super.getListCellRendererComponent(list, value, index, isSelected);
                }
            };
            this.minute.setRenderer(twoDigitRender);
            SpinnerRenderer<Object> render = new SpinnerRenderer<Object>(){

                @Override
                public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
                    if (value != null && value instanceof Integer) {
                        int d = (Integer)value;
                        value = d == 0 ? "AM" : "PM";
                    }
                    return super.getListCellRendererComponent(list, value, index, isSelected);
                }
            };
            this.amPM.setRenderer(render);
            render.setRTL(false);
            render.setShowNumbers(false);
            twoDigitRender.setUIID("SpinnerRenderer");
            render.setUIID("SpinnerRenderer");
            this.amPM.setRenderingPrototype("WW");
            this.amPM.initSpinnerRenderer();
            this.minute.initSpinnerRenderer();
            this.addComponents();
        }
    }

    void addComponents() {
        this.setLayout(new LayeredLayout());
        LayeredLayout ll = (LayeredLayout)this.getLayout();
        Container content = new Container(BoxLayout.x());
        Style allStyles = content.getAllStyles();
        allStyles.setMargin(0, 0, 0, 0);
        allStyles.setPadding(0, 0, 0, 0);
        allStyles.setBgTransparency(0);
        allStyles.setBorder(Border.createEmpty());
        if (this.amPM != null) {
            Label l;
            content.addComponent(this.hour);
            this.hourComponents.add(this.hour);
            if (this.durationMode) {
                l = new Label(this.getUIManager().localize("hours", "hours"));
                l.setUIID("TimeSpinnerHoursLabel");
                this.hourComponents.add(l);
                content.addComponent(l);
            }
            content.addComponent(this.createSeparator());
            content.addComponent(this.minute);
            this.minuteComponents.add(this.minute);
            if (this.durationMode) {
                l = new Label(this.getUIManager().localize("minutes", "minutes"));
                l.setUIID("TimeSpinnerMinutesLabel");
                this.minuteComponents.add(l);
                content.addComponent(l);
            }
            if (this.showMeridiem) {
                content.addComponent(this.createSeparator());
                content.addComponent(this.amPM);
            }
        }
        this.setHoursVisible(this.showHours);
        this.setMinutesVisible(this.showMinutes);
        this.addComponent(content);
        ll.setInsets(content, "0 auto 0 auto");
    }

    public String[] getPropertyNames() {
        return new String[]{"currentHour", "currentMinute", "minuteStep", "currentMeridiem", "showMeridiem", "durationMode"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class, Boolean.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("durationMode")) {
            if (this.durationMode) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("currentHour")) {
            return this.currentHour;
        }
        if (name.equals("currentMinute")) {
            return this.currentMinute;
        }
        if (name.equals("minuteStep")) {
            return this.minuteStep;
        }
        if (name.equals("currentMeridiem")) {
            if (this.currentMeridiem) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("showMeridiem")) {
            if (this.showMeridiem) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("currentHour")) {
            this.setCurrentHour(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("currentMinute")) {
            this.setCurrentMinute(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("minuteStep")) {
            this.setMinuteStep(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("currentMeridiem")) {
            this.setCurrentMeridiem((Boolean)value);
            return null;
        }
        if (name.equals("showMeridiem")) {
            this.setShowMeridiem((Boolean)value);
            return null;
        }
        if (name.equals("durationMode")) {
            this.setDurationMode((Boolean)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public int getMinuteStep() {
        return this.minuteStep;
    }

    public void setMinuteStep(int minuteStep) {
        if (minuteStep < 1 || minuteStep > 60) {
            throw new IllegalArgumentException("Minute step must be between 1 and 60");
        }
        this.minuteStep = minuteStep;
        if (this.minute != null) {
            this.minute.setModel(new SpinnerNumberModel(0, 60, this.currentMinute, minuteStep));
        }
    }

    public boolean isShowMeridiem() {
        return this.showMeridiem && !this.durationMode;
    }

    public void setShowMeridiem(boolean showMeridiem) {
        if (this.durationMode) {
            return;
        }
        this.showMeridiem = showMeridiem;
        if (showMeridiem) {
            this.startHour = 1;
            this.endHour = 13;
        } else {
            this.startHour = 0;
            this.endHour = 24;
        }
        if (this.hour != null) {
            this.hour.setModel(new SpinnerNumberModel(this.startHour, this.endHour, this.currentHour, 1));
        }
        this.removeAll();
        this.addComponents();
        if (this.isInitialized()) {
            this.getParent().revalidate();
        }
    }

    public int getCurrentHour() {
        if (this.hour != null) {
            return (Integer)this.hour.getValue();
        }
        return this.currentHour;
    }

    public void setCurrentHour(int currentHour) {
        this.currentHour = currentHour;
        if (this.hour != null) {
            this.hour.setValue(currentHour);
        }
    }

    public int getCurrentMinute() {
        if (this.minute != null) {
            return (Integer)this.minute.getValue();
        }
        return this.currentMinute;
    }

    public void setCurrentMinute(int currentMinute) {
        this.currentMinute = currentMinute;
        if (this.minute != null) {
            this.minute.setValue(currentMinute);
        }
    }

    public boolean isCurrentMeridiem() {
        if (this.durationMode) {
            return false;
        }
        if (this.amPM != null) {
            return (Integer)this.amPM.getValue() != 0;
        }
        return this.currentMeridiem;
    }

    public void setCurrentMeridiem(boolean currentMeridiem) {
        if (this.durationMode) {
            return;
        }
        this.currentMeridiem = currentMeridiem;
        if (this.amPM != null) {
            if (currentMeridiem) {
                this.amPM.setValue(1);
            } else {
                this.amPM.setValue(0);
            }
        }
    }

    public boolean isDurationMode() {
        return this.durationMode;
    }

    public void setDurationMode(boolean durationMode) {
        if (durationMode) {
            this.setShowMeridiem(false);
            this.startHour = 0;
            this.endHour = 24;
        } else if (this.showMeridiem) {
            this.startHour = 1;
            this.endHour = 13;
        } else {
            this.startHour = 0;
            this.endHour = 24;
        }
        this.durationMode = durationMode;
    }

    public void setHoursVisible(boolean visible) {
        this.showHours = visible;
        for (Component c : this.hourComponents) {
            c.setVisible(visible);
            c.setHidden(!visible);
        }
    }

    public void setMinutesVisible(boolean visible) {
        this.showMinutes = visible;
        for (Component c : this.minuteComponents) {
            c.setVisible(visible);
            c.setHidden(!visible);
        }
    }
}

