/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.table;

import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.table.AbstractTableModel;
import com.codename1.ui.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableModel
extends AbstractTableModel {
    ArrayList<Object[]> data = new ArrayList();
    String[] columnNames;
    boolean editable;
    private final EventDispatcher dispatcher = new EventDispatcher();

    public DefaultTableModel(String[] columnNames, Object[][] data) {
        this(columnNames, data, false);
    }

    public DefaultTableModel(String[] columnNames, Object[][] data, boolean editable) {
        Collections.addAll(this.data, data);
        this.columnNames = columnNames;
        this.editable = editable;
    }

    DefaultTableModel(String[] columnNames, ArrayList<Object[]> data, boolean editable) {
        this.data = data;
        this.columnNames = columnNames;
        this.editable = editable;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int i) {
        return this.columnNames[i];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.editable;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            return this.data.get(row)[column];
        }
        catch (ArrayIndexOutOfBoundsException err) {
            return "";
        }
    }

    @Override
    public void setValueAt(int row, int column, Object o) {
        this.data.get((int)row)[column] = o;
        this.dispatcher.fireDataChangeEvent(column, row);
    }

    @Override
    public void addDataChangeListener(DataChangedListener d) {
        this.dispatcher.addListener(d);
    }

    @Override
    public void removeDataChangeListener(DataChangedListener d) {
        this.dispatcher.removeListener(d);
    }

    public void addRow(Object ... row) {
        this.data.add(row);
        for (int col = 0; col < row.length; ++col) {
            this.dispatcher.fireDataChangeEvent(col, this.data.size() - 1);
        }
    }

    public void insertRow(int offset, Object ... row) {
        this.data.add(offset, row);
        for (int col = 0; col < row.length; ++col) {
            this.dispatcher.fireDataChangeEvent(col, this.data.size() - 1);
            this.dispatcher.fireDataChangeEvent(col, offset);
        }
    }

    public void removeRow(int offset) {
        this.data.remove(offset);
        this.dispatcher.fireDataChangeEvent(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }
}

