/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.tree;

import com.codename1.compat.java.util.Objects;
import com.codename1.components.SpanButton;
import com.codename1.impl.CodenameOneImplementation;
import com.codename1.ui.Button;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.animations.CommonTransitions;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.tree.TreeModel;
import com.codename1.ui.util.EventDispatcher;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class Tree
extends Container {
    private static final String KEY_OBJECT = "TREE_OBJECT";
    private static final String KEY_PARENT = "TREE_PARENT";
    private static final String KEY_EXPANDED = "TREE_NODE_EXPANDED";
    private static final String KEY_DEPTH = "TREE_DEPTH";
    private static Image folder;
    private static Image openFolder;
    private static Image nodeImage;
    private final EventDispatcher leafListener = new EventDispatcher();
    private final ActionListener expansionListener = new Handler();
    private TreeModel model;
    private final int depthIndent = 2;
    private boolean multilineMode;

    public Tree() {
        this(new StringArrayTreeModel(new String[][]{{"Colors", "Letters", "Numbers"}, {"Red", "Green", "Blue"}, {"A", "B", "C"}, {"1", "2", "3"}}));
    }

    public Tree(TreeModel model) {
        this.model = model;
        this.setLayout(new BoxLayout(2));
        if (folder == null) {
            folder = UIManager.getInstance().getThemeImageConstant("treeFolderImage");
            openFolder = UIManager.getInstance().getThemeImageConstant("treeFolderOpenImage");
            nodeImage = UIManager.getInstance().getThemeImageConstant("treeNodeImage");
        }
        this.buildBranch(null, 0, this);
        this.setScrollableY(true);
        this.setUIID("Tree");
    }

    public static void setFolderIcon(Image folderIcon) {
        folder = folderIcon;
    }

    public static void setFolderOpenIcon(Image folderIcon) {
        openFolder = folderIcon;
    }

    public static void setNodeIcon(Image nodeIcon) {
        nodeImage = nodeIcon;
    }

    public TreeState getTreeState() {
        State out = new State();
        out.extractStateFrom(this);
        return out;
    }

    public void setTreeState(TreeState state) {
        if (state instanceof State) {
            ((State)state).applyStateTo(this);
        }
    }

    public boolean isMultilineMode() {
        return this.multilineMode;
    }

    public void setMultilineMode(boolean multilineMode) {
        this.multilineMode = multilineMode;
    }

    public String[] getPropertyNames() {
        return new String[]{"data"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{CodenameOneImplementation.getStringArray2DClass()};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"String[][]"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("data")) {
            return ((StringArrayTreeModel)this.model).arr;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("data")) {
            this.setModel(new StringArrayTreeModel((String[][])value));
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void setModel(TreeModel model) {
        this.model = model;
        this.removeAll();
        this.buildBranch(null, 0, this);
    }

    private Container expandNode(boolean animate, Component c) {
        return this.expandNode(animate, c, true);
    }

    private Container expandNode(boolean animate, Component c, boolean revalidate) {
        return this.expandNodeImpl(animate, c, revalidate);
    }

    private Container expandNodeImpl(boolean animate, Component c) {
        return this.expandNodeImpl(animate, c, true);
    }

    private Container expandNodeImpl(boolean animate, Component c, boolean revalidate) {
        Container p = c.getParent().getLeadParent();
        if (p != null) {
            c = p;
        }
        c.putClientProperty(KEY_EXPANDED, "true");
        if (openFolder == null) {
            this.setNodeMaterialIcon('\ue2c7', c, 3.0f);
        } else {
            this.setNodeIcon(openFolder, c);
        }
        int depth = (Integer)c.getClientProperty(KEY_DEPTH);
        Container parent = c.getParent();
        Object o = c.getClientProperty(KEY_OBJECT);
        Container dest = new Container(new BoxLayout(2));
        parent.addComponent("Center", (Component)dest);
        this.buildBranch(o, depth, dest);
        if (this.isInitialized() && animate) {
            dest.setHeight(0);
            dest.setVisible(true);
            this.animateLayoutAndWait(300);
            if (this.multilineMode) {
                this.revalidate();
            }
        } else if (revalidate) {
            parent.revalidate();
        }
        return dest;
    }

    protected boolean isExpanded(Component node) {
        Object e = node.getClientProperty(KEY_EXPANDED);
        return e != null && e.equals("true");
    }

    private Container expandPathNode(boolean animate, Container parent, Object node) {
        int cc = parent.getComponentCount();
        for (int iter = 0; iter < cc; ++iter) {
            Component current = parent.getComponentAt(iter);
            Object o = current.getClientProperty(KEY_OBJECT);
            if (this.model.isLeaf(o)) continue;
            BorderLayout bl = (BorderLayout)((Container)current).getLayout();
            current = bl.getNorth();
            if (!Objects.equals(o, node)) continue;
            if (this.isExpanded(current)) {
                return (Container)bl.getCenter();
            }
            return this.expandNodeImpl(animate, current);
        }
        return null;
    }

    private void collapsePathNode(Container parent, Object node) {
        int cc = parent.getComponentCount();
        for (int iter = 0; iter < cc; ++iter) {
            BorderLayout bl;
            Object o;
            Component current = parent.getComponentAt(iter);
            if (!this.isExpanded(current) || (o = (current = (bl = (BorderLayout)((Container)current).getLayout()).getNorth()).getClientProperty(KEY_OBJECT)) == null || !o.equals(node)) continue;
            if (this.isExpanded(current)) {
                this.collapseNode(current, null);
            }
            return;
        }
    }

    public Component findNodeComponent(Object node) {
        return this.findNodeComponent(node, this);
    }

    public Component findNodeComponent(Object node, Component root) {
        if (root == null) {
            return this.findNodeComponent(node, this);
        }
        Object rootNode = root.getClientProperty(KEY_OBJECT);
        if (node.equals(rootNode)) {
            return root;
        }
        if (root instanceof Container) {
            int len = ((Container)root).getComponentCount();
            for (int i = 0; i < len; ++i) {
                Component found = this.findNodeComponent(node, ((Container)root).getComponentAt(i));
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public void expandPath(Object ... path) {
        this.expandPath(this.isInitialized(), path);
    }

    public void expandPath(boolean animate, Object ... path) {
        Container c = this;
        int plen = path.length;
        for (int iter = 0; iter < plen; ++iter) {
            if ((c = this.expandPathNode(animate, c, path[iter])) != null) continue;
            return;
        }
    }

    public void collapsePath(Object ... path) {
        Container c = this;
        int plen = path.length;
        for (int iter = 0; iter < plen - 1; ++iter) {
            c = this.expandPathNode(this.isInitialized(), c, path[iter]);
        }
        this.collapsePathNode(c, path[plen - 1]);
    }

    private void collapseNode(Component c) {
        this.collapseNode(c, CommonTransitions.createSlide(1, false, 300));
    }

    private void collapseNode(Component c, Transition t) {
        Container lead = c.getParent().getLeadParent();
        if (lead != null) {
            c = lead;
        }
        c.putClientProperty(KEY_EXPANDED, null);
        if (folder == null) {
            this.setNodeMaterialIcon('\ue2c7', c, 3.0f);
        } else {
            this.setNodeIcon(folder, c);
        }
        Container p = c.getParent();
        for (int iter = 0; iter < p.getComponentCount(); ++iter) {
            if (p.getComponentAt(iter) == c) continue;
            if (t == null) {
                p.removeComponent(p.getComponentAt(iter));
                break;
            }
            Component dest = p.getComponentAt(iter);
            dest.setHidden(true);
            this.animateLayoutAndWait(300);
            p.removeComponent(dest);
        }
    }

    public Object getSelectedItem() {
        Component c = this.getComponentForm().getFocused();
        if (c != null) {
            return c.getClientProperty(KEY_OBJECT);
        }
        return null;
    }

    public Object getParentNode(Component nodeComponent) {
        if (nodeComponent == null) {
            return null;
        }
        return nodeComponent.getClientProperty(KEY_PARENT);
    }

    public Component getParentComponent(Component nodeComponent) {
        if (nodeComponent == null) {
            return null;
        }
        return this.findNodeComponent(this.getParentNode(nodeComponent));
    }

    public void refreshNode(Component nodeComponent) {
        if (nodeComponent == null) {
            throw new IllegalArgumentException("refreshNode expects a non-null argument");
        }
        Object node = nodeComponent.getClientProperty(KEY_OBJECT);
        if (node == null) {
            return;
        }
        Object nodeParent = nodeComponent.getClientProperty(KEY_PARENT);
        int depth = (Integer)nodeComponent.getClientProperty(KEY_DEPTH);
        Container parentCnt = nodeComponent.getParent();
        if (parentCnt == null) {
            return;
        }
        boolean expanded = this.isExpanded(nodeComponent);
        Component newCmp = this.createNode(node, depth);
        Object current = node;
        newCmp.putClientProperty(KEY_OBJECT, current);
        newCmp.putClientProperty(KEY_PARENT, nodeParent);
        newCmp.putClientProperty(KEY_DEPTH, depth);
        newCmp.getAllStyles().setMarginLeft(nodeComponent.getStyle().getMarginLeft(nodeComponent.isRTL()));
        if (this.model.isLeaf(current)) {
            parentCnt.replace(nodeComponent, newCmp, null);
            this.bindNodeListener(new Handler(current), newCmp);
        } else {
            Container componentArea = new Container(new BorderLayout());
            componentArea.addComponent("North", newCmp);
            parentCnt.getParent().replace((Component)parentCnt, (Component)componentArea, null);
            this.bindNodeListener(this.expansionListener, newCmp);
            if (expanded) {
                this.expandNode(false, newCmp, false);
            }
        }
        this.revalidateLater();
    }

    private void buildBranch(Object parent, int depth, Container destination) {
        Vector children = this.model.getChildren(parent);
        int size = children.size();
        Integer depthVal = depth + 1;
        for (int iter = 0; iter < size; ++iter) {
            Object current = children.elementAt(iter);
            Component nodeComponent = this.createNode(current, depth);
            if (this.model.isLeaf(current)) {
                destination.addComponent(nodeComponent);
                this.bindNodeListener(new Handler(current), nodeComponent);
            } else {
                Container componentArea = new Container(new BorderLayout());
                componentArea.addComponent("North", nodeComponent);
                destination.addComponent(componentArea);
                this.bindNodeListener(this.expansionListener, nodeComponent);
            }
            nodeComponent.putClientProperty(KEY_OBJECT, current);
            nodeComponent.putClientProperty(KEY_PARENT, parent);
            nodeComponent.putClientProperty(KEY_DEPTH, depthVal);
        }
    }

    protected Button createNodeComponent(Object node, int depth) {
        Button cmp = new Button(this.childToDisplayLabel(node));
        cmp.setUIID("TreeNode");
        if (this.model.isLeaf(node)) {
            if (nodeImage == null) {
                FontImage.setMaterialIcon((Label)cmp, '\ue873', 3.0f);
            } else {
                cmp.setIcon(nodeImage);
            }
        } else if (folder == null) {
            FontImage.setMaterialIcon((Label)cmp, '\ue2c7', 3.0f);
        } else {
            cmp.setIcon(folder);
        }
        this.updateNodeComponentStyle(cmp.getAllStyles(), depth);
        return cmp;
    }

    protected void bindNodeListener(ActionListener l, Component node) {
        if (node instanceof Button) {
            ((Button)node).addActionListener(l);
            return;
        }
        ((SpanButton)node).addActionListener(l);
    }

    protected void setNodeIcon(Image icon, Component node) {
        if (node instanceof Button) {
            ((Button)node).setIcon(icon);
            return;
        }
        ((SpanButton)node).setIcon(icon);
    }

    protected void setNodeMaterialIcon(char c, Component node, float size) {
        FontImage.setMaterialIcon(node, '\ue2c7', 3.0f);
    }

    protected Component createNode(Object node, int depth) {
        if (this.multilineMode) {
            SpanButton cmp = new SpanButton(this.childToDisplayLabel(node));
            cmp.setUIID("TreeNode");
            cmp.setTextUIID("TreeNode");
            if (this.model.isLeaf(node)) {
                cmp.setIcon(nodeImage);
            } else {
                cmp.setIcon(folder);
            }
            this.updateNodeComponentStyle(cmp.getAllStyles(), depth);
            return cmp;
        }
        return this.createNodeComponent(node, depth);
    }

    private void updateNodeComponentStyle(Style s, int depth) {
        s.setMarginUnit(2);
        s.setMarginLeft(depth * 2);
    }

    protected String childToDisplayLabel(Object child) {
        return child.toString();
    }

    public void addLeafListener(ActionListener l) {
        this.leafListener.addListener(l);
    }

    public void removeLeafListener(ActionListener l) {
        this.leafListener.removeListener(l);
    }

    protected Object getModel(Component node) {
        return node.getClientProperty(KEY_OBJECT);
    }

    protected Dimension calcPreferredSize() {
        Dimension d = super.calcPreferredSize();
        int count = this.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            if (!(this.getComponentAt(iter) instanceof Container)) continue;
            return d;
        }
        int size = Math.max(1, this.model.getChildren(null).size());
        if (size < 6) {
            return new Dimension(Math.max(d.getWidth(), Display.getInstance().getDisplayWidth() / 4 * 3), d.getHeight() / size * 6);
        }
        return d;
    }

    private class Handler
    implements ActionListener {
        private Object current;

        public Handler() {
        }

        public Handler(Object current) {
            this.current = current;
        }

        public void actionPerformed(ActionEvent evt) {
            Object e;
            if (this.current != null) {
                Tree.this.leafListener.fireActionEvent(new ActionEvent(this.current, ActionEvent.Type.Other));
                return;
            }
            Component c = (Component)evt.getSource();
            Container lead = c.getParent().getLeadParent();
            if (lead != null) {
                c = lead;
            }
            if ((e = c.getClientProperty(Tree.KEY_EXPANDED)) != null && e.equals("true")) {
                Tree.this.collapseNode(c);
            } else {
                Tree.this.expandNode(Tree.this.isInitialized(), c);
            }
        }
    }

    static class StringArrayTreeModel
    implements TreeModel {
        String[][] arr;

        StringArrayTreeModel(String[][] arr) {
            this.arr = arr;
        }

        public Vector getChildren(Object parent) {
            if (parent == null) {
                Vector<String> v = new Vector<String>();
                int a0len = this.arr[0].length;
                for (int iter = 0; iter < a0len; ++iter) {
                    v.addElement(this.arr[0][iter]);
                }
                return v;
            }
            int alen = this.arr.length;
            int aolen = this.arr[0].length;
            Vector<String> v = new Vector<String>();
            for (int iter = 0; iter < aolen; ++iter) {
                if (parent != this.arr[0][iter] || alen <= iter + 1 || this.arr[iter + 1] == null) continue;
                int ailen = this.arr[iter + 1].length;
                for (int i = 0; i < ailen; ++i) {
                    v.addElement(this.arr[iter + 1][i]);
                }
            }
            return v;
        }

        public boolean isLeaf(Object node) {
            Vector v = this.getChildren(node);
            return v == null || v.size() == 0;
        }
    }

    private static class State
    implements TreeState {
        Set<Object> expandedSet = new HashSet<Object>();

        private State() {
        }

        private void extractStateFrom(final Tree tree) {
            this.expandedSet.clear();
            ComponentSelector.select("*", tree).each(new ComponentSelector.ComponentClosure(){

                public void call(Component c) {
                    if (tree.isExpanded(c)) {
                        Object o = c.getClientProperty(Tree.KEY_OBJECT);
                        State.this.expandedSet.add(o);
                    }
                }
            });
        }

        private void applyStateTo(Tree tree) {
            this.applyStateTo(tree, tree);
        }

        private void applyStateTo(final Tree tree, Container parent) {
            ComponentSelector.select("*", parent).each(new ComponentSelector.ComponentClosure(){

                public void call(Component cmp) {
                    Object o = cmp.getClientProperty(Tree.KEY_OBJECT);
                    if (o != null) {
                        if (State.this.expandedSet.contains(o)) {
                            if (!tree.isExpanded(cmp)) {
                                Container dest = tree.expandNode(false, cmp, false);
                                State.this.applyStateTo(tree, dest);
                            }
                        } else if (tree.isExpanded(cmp)) {
                            tree.collapseNode(cmp, null);
                        }
                    }
                }
            });
        }
    }

    public static interface TreeState {
    }
}

