/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.util;

import com.codename1.io.FileSystemStorage;
import com.codename1.io.Util;
import com.codename1.ui.Display;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.geom.Dimension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ImageIO {
    public static final String FORMAT_JPEG = "jpeg";
    public static final String FORMAT_PNG = "png";

    public static ImageIO getImageIO() {
        return Display.getInstance().getImageIO();
    }

    public abstract void save(InputStream var1, OutputStream var2, String var3, int var4, int var5, float var6) throws IOException;

    public void save(Image img, OutputStream response, String format, float quality) throws IOException {
        if (img instanceof EncodedImage) {
            EncodedImage i = (EncodedImage)img;
            this.save(new ByteArrayInputStream(i.getImageData()), response, format, i.getWidth(), i.getHeight(), quality);
        } else if (img.getImage() == null) {
            Image img2 = Image.createImage(img.getWidth(), img.getHeight(), 0);
            Graphics g = img2.getGraphics();
            g.drawImage(img, 0, 0);
            this.saveImage(img2, response, format, quality);
        } else {
            this.saveImage(img, response, format, quality);
        }
    }

    public void save(String imageFilePath, OutputStream response, String format, int width, int height, float quality) throws IOException {
        InputStream in = FileSystemStorage.getInstance().openInputStream(imageFilePath);
        this.save(in, response, format, width, height, quality);
        Util.cleanup(in);
    }

    public Dimension getImageSize(String imageFilePath) throws IOException {
        Image img = Image.createImage(imageFilePath);
        Dimension d = new Dimension(img.getWidth(), img.getHeight());
        img.dispose();
        return d;
    }

    public String saveAndKeepAspect(String imageFilePath, String preferredOutputPath, String format, int width, int height, float quality, boolean onlyDownscale, boolean scaleToFill) throws IOException {
        Dimension d = this.getImageSize(imageFilePath);
        if (onlyDownscale && (scaleToFill ? d.getHeight() <= height || d.getWidth() <= width : d.getHeight() <= height && d.getWidth() <= width)) {
            return imageFilePath;
        }
        float ratio = (float)d.getWidth() / (float)d.getHeight();
        int heightBasedOnWidth = (int)((float)width / ratio);
        int widthBasedOnHeight = (int)((float)height * ratio);
        if (scaleToFill) {
            if (heightBasedOnWidth >= width) {
                height = heightBasedOnWidth;
            } else {
                width = widthBasedOnHeight;
            }
        } else if (heightBasedOnWidth > width) {
            width = widthBasedOnHeight;
        } else {
            height = heightBasedOnWidth;
        }
        OutputStream im = FileSystemStorage.getInstance().openOutputStream(preferredOutputPath);
        this.save(imageFilePath, im, format, width, height, quality);
        return preferredOutputPath;
    }

    protected abstract void saveImage(Image var1, OutputStream var2, String var3, float var4) throws IOException;

    public abstract boolean isFormatSupported(String var1);
}

