/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.validation;

import com.codename1.ui.validation.Constraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistInConstraint
implements Constraint {
    private final List<String> items;
    private final boolean caseSensitive;
    private final String errorMessage;

    public ExistInConstraint(List<String> items, boolean caseSensitive, String errorMessage) {
        this.items = new ArrayList<String>(items);
        this.caseSensitive = caseSensitive;
        this.errorMessage = errorMessage;
    }

    public ExistInConstraint(String[] items, boolean caseSensitive, String errorMessage) {
        this(Arrays.asList(items), caseSensitive, errorMessage);
    }

    public ExistInConstraint(List<String> items, String errorMessage) {
        this(items, false, errorMessage);
    }

    public ExistInConstraint(String[] items, String errorMessage) {
        this(items, false, errorMessage);
    }

    public ExistInConstraint(List<String> items) {
        this(items, false, null);
    }

    public ExistInConstraint(String[] items) {
        this(items, false, null);
    }

    @Override
    public boolean isValid(Object value) {
        if (!this.caseSensitive) {
            return this.containsCaseInsensitive(value.toString(), this.items);
        }
        return this.items.contains(value.toString());
    }

    @Override
    public String getDefaultFailMessage() {
        if (this.errorMessage == null) {
            if (this.items.size() == 1) {
                return "Input value can only be \"" + this.items.get(0) + "\"";
            }
            return "Input value must be one of " + this.items;
        }
        return this.errorMessage;
    }

    boolean containsCaseInsensitive(String s, List<String> items) {
        for (String item : items) {
            if (!item.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }
}

