/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.validation;

import com.codename1.ui.validation.Constraint;

public class LengthConstraint
implements Constraint {
    private final int length;
    private final String errorMessage;

    public LengthConstraint(int length, String errorMessage) {
        this.length = length;
        this.errorMessage = errorMessage;
    }

    public LengthConstraint(int length) {
        this(length, null);
    }

    public boolean isValid(Object value) {
        return value != null && value.toString().length() >= this.length;
    }

    public String getDefaultFailMessage() {
        if (this.errorMessage == null) {
            if (this.length == 1) {
                return "A value is required";
            }
            return "Input must be at least " + this.length + " characters";
        }
        return this.errorMessage;
    }
}

