/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.validation;

import com.codename1.components.InteractionDialog;
import com.codename1.ui.Button;
import com.codename1.ui.CheckBox;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.InputComponent;
import com.codename1.ui.Label;
import com.codename1.ui.List;
import com.codename1.ui.Painter;
import com.codename1.ui.PickerComponent;
import com.codename1.ui.RadioButton;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextComponent;
import com.codename1.ui.TextField;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.events.FocusListener;
import com.codename1.ui.events.ScrollListener;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.spinner.Picker;
import com.codename1.ui.util.UITimer;
import com.codename1.ui.validation.Constraint;
import com.codename1.ui.validation.GroupConstraint;
import java.util.ArrayList;
import java.util.HashMap;

public class Validator {
    private static final String VALID_MARKER = "cn1$$VALID_MARKER";
    private static HighlightMode defaultValidationFailureHighlightMode = HighlightMode.EMBLEM;
    private static Image defaultValidationFailedEmblem = null;
    private static float defaultValidationEmblemPositionX = 1.0f;
    private static float defaultValidationEmblemPositionY = 0.5f;
    private static boolean validateOnEveryKey = false;
    private InteractionDialog message = new InteractionDialog();
    private String errorMessageUIID = "DialogBody";
    private HighlightMode validationFailureHighlightMode = defaultValidationFailureHighlightMode;
    private Image validationFailedEmblem = defaultValidationFailedEmblem;
    private float validationEmblemPositionX = defaultValidationEmblemPositionX;
    private float validationEmblemPositionY = defaultValidationEmblemPositionY;
    private final HashMap<Component, Constraint> constraintList = new HashMap();
    private final ArrayList<Component> submitButtons = new ArrayList();
    private boolean showErrorMessageForFocusedComponent;

    public Validator() {
        if (defaultValidationFailedEmblem == null) {
            this.validationFailedEmblem = defaultValidationFailedEmblem = FontImage.createMaterial('\ue5c9', "InvalidEmblem", 3.0f);
        }
    }

    public static HighlightMode getDefaultValidationFailureHighlightMode() {
        return defaultValidationFailureHighlightMode;
    }

    public static void setDefaultValidationFailureHighlightMode(HighlightMode aDefaultValidationFailureHighlightMode) {
        defaultValidationFailureHighlightMode = aDefaultValidationFailureHighlightMode;
    }

    public static Image getDefaultValidationFailedEmblem() {
        return defaultValidationFailedEmblem;
    }

    public static void setDefaultValidationFailedEmblem(Image aDefaultValidationFailedEmblem) {
        defaultValidationFailedEmblem = aDefaultValidationFailedEmblem;
    }

    public static float getDefaultValidationEmblemPositionX() {
        return defaultValidationEmblemPositionX;
    }

    public static void setDefaultValidationEmblemPositionX(float aDefaultValidationEmblemPositionX) {
        defaultValidationEmblemPositionX = aDefaultValidationEmblemPositionX;
    }

    public static float getDefaultValidationEmblemPositionY() {
        return defaultValidationEmblemPositionY;
    }

    public static void setDefaultValidationEmblemPositionY(float aDefaultValidationEmblemPositionY) {
        defaultValidationEmblemPositionY = aDefaultValidationEmblemPositionY;
    }

    public static boolean isValidateOnEveryKey() {
        return validateOnEveryKey;
    }

    public static void setValidateOnEveryKey(boolean aValidateOnEveryKey) {
        validateOnEveryKey = aValidateOnEveryKey;
    }

    public HighlightMode getValidationFailureHighlightMode() {
        return this.validationFailureHighlightMode;
    }

    public void setValidationFailureHighlightMode(HighlightMode validationFailureHighlightMode) {
        this.validationFailureHighlightMode = validationFailureHighlightMode;
    }

    public Image getValidationFailedEmblem() {
        return this.validationFailedEmblem;
    }

    public void setValidationFailedEmblem(Image validationFailedEmblem) {
        this.validationFailedEmblem = validationFailedEmblem;
    }

    public float getValidationEmblemPositionX() {
        return this.validationEmblemPositionX;
    }

    public void setValidationEmblemPositionX(float validationEmblemPositionX) {
        this.validationEmblemPositionX = validationEmblemPositionX;
    }

    public float getValidationEmblemPositionY() {
        return this.validationEmblemPositionY;
    }

    public void setValidationEmblemPositionY(float validationEmblemPositionY) {
        this.validationEmblemPositionY = validationEmblemPositionY;
    }

    public boolean isShowErrorMessageForFocusedComponent() {
        return this.showErrorMessageForFocusedComponent;
    }

    public void setShowErrorMessageForFocusedComponent(boolean showErrorMessageForFocusedComponent) {
        this.showErrorMessageForFocusedComponent = showErrorMessageForFocusedComponent;
    }

    public String getErrorMessageUIID() {
        return this.errorMessageUIID;
    }

    public void setErrorMessageUIID(String errorMessageUIID) {
        this.errorMessageUIID = errorMessageUIID;
    }

    public Validator addConstraint(Component cmp, Constraint ... c) {
        InputComponent inputComponent;
        Constraint constraint = null;
        if (c.length == 1) {
            constraint = c[0];
            this.constraintList.put(cmp, constraint);
        } else if (c.length > 1) {
            constraint = new GroupConstraint(c);
            this.constraintList.put(cmp, constraint);
        }
        if (constraint == null) {
            throw new IllegalArgumentException("addConstraint needs at least a Constraint, but the Constraint array in empty");
        }
        this.bindDataListener(cmp);
        boolean isV = this.isValid();
        for (Component btn : this.submitButtons) {
            btn.setEnabled(isV);
        }
        if (UIManager.getInstance().isThemeConstant("showValidationErrorsIfNotOnTopMode", true) && cmp instanceof InputComponent && !(inputComponent = (InputComponent)cmp).isOnTopMode()) {
            Label labelForComponent = null;
            if (inputComponent instanceof TextComponent) {
                labelForComponent = ((TextComponent)inputComponent).getField().getLabelForComponent();
            } else if (inputComponent instanceof PickerComponent) {
                labelForComponent = ((PickerComponent)inputComponent).getPicker().getLabelForComponent();
            }
            if (labelForComponent != null) {
                final Label myLabel = labelForComponent;
                final String originalText = myLabel.getText();
                final String originalUIID = myLabel.getUIID();
                final Constraint myConstraint = constraint;
                final Runnable showError = new Runnable(){

                    public void run() {
                        boolean isValid = false;
                        if (inputComponent instanceof TextComponent) {
                            isValid = myConstraint.isValid(((TextComponent)inputComponent).getField().getText());
                        } else if (inputComponent instanceof PickerComponent) {
                            isValid = myConstraint.isValid(((PickerComponent)inputComponent).getPicker().getValue());
                        }
                        String errorMessage = Validator.this.trimLongString(UIManager.getInstance().localize(myConstraint.getDefaultFailMessage(), myConstraint.getDefaultFailMessage()), "ErrorLabel", myLabel.getWidth());
                        if (errorMessage != null && errorMessage.length() > 0 && !isValid) {
                            myLabel.setUIID("ErrorLabel");
                            myLabel.setText(errorMessage);
                            UITimer.timer(2000, false, Display.getInstance().getCurrent(), new Runnable(){

                                public void run() {
                                    myLabel.setUIID(originalUIID);
                                    myLabel.setText(originalText);
                                }
                            });
                        } else {
                            myLabel.setUIID(originalUIID);
                            myLabel.setText(originalText);
                        }
                    }
                };
                FocusListener myFocusListener = new FocusListener(){

                    public void focusLost(Component cmp) {
                        showError.run();
                    }

                    public void focusGained(Component cmp) {
                    }
                };
                if (inputComponent instanceof TextComponent) {
                    ((TextComponent)inputComponent).getField().addFocusListener(myFocusListener);
                } else if (inputComponent instanceof PickerComponent) {
                    ((PickerComponent)inputComponent).getPicker().addFocusListener(myFocusListener);
                }
            }
        }
        return this;
    }

    private String trimLongString(String errorMessage, String uiid, int width) {
        Label errorLabel = new Label(errorMessage, uiid);
        while (errorLabel.getPreferredW() > width && errorMessage.length() > 1) {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 1);
            errorLabel.setText(errorMessage);
        }
        return errorMessage;
    }

    public Validator addSubmitButtons(Component ... cmp) {
        boolean isV = this.isValid();
        for (Component c : cmp) {
            this.submitButtons.add(c);
            c.setEnabled(isV);
        }
        return this;
    }

    protected Object getComponentValue(Component cmp) {
        if (cmp instanceof InputComponent) {
            cmp = ((InputComponent)cmp).getEditor();
        }
        if (cmp instanceof TextArea) {
            return ((TextArea)cmp).getText();
        }
        if (cmp instanceof Picker) {
            return ((Picker)cmp).getValue();
        }
        if (cmp instanceof RadioButton || cmp instanceof CheckBox) {
            if (((Button)cmp).isSelected()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (cmp instanceof Label) {
            return ((Label)cmp).getText();
        }
        if (cmp instanceof List) {
            return ((List)cmp).getSelectedItem();
        }
        return null;
    }

    public void bindDataListener(Component cmp) {
        if (!(!this.showErrorMessageForFocusedComponent || cmp instanceof InputComponent && ((InputComponent)cmp).isOnTopMode())) {
            cmp.addFocusListener(new FocusListener(){

                public void focusGained(Component cmp) {
                    String err;
                    Form p = cmp.getComponentForm();
                    if (p != Display.getInstance().getCurrent()) {
                        return;
                    }
                    if (Validator.this.message != null) {
                        Validator.this.message.dispose();
                    }
                    if (!Validator.this.isValid(cmp) && (err = Validator.this.getErrorMessage(cmp)) != null && err.length() > 0) {
                        Validator.this.message = new InteractionDialog(err);
                        Validator.this.message.getTitleComponent().setUIID(Validator.this.errorMessageUIID);
                        Validator.this.message.setAnimateShow(false);
                        if (Validator.this.validationFailureHighlightMode == HighlightMode.EMBLEM || Validator.this.validationFailureHighlightMode == HighlightMode.UIID_AND_EMBLEM) {
                            int xpos = cmp.getAbsoluteX();
                            int ypos = cmp.getAbsoluteY();
                            Component scr = cmp.getScrollable();
                            if (scr != null) {
                                xpos -= scr.getScrollX();
                                ypos -= scr.getScrollY();
                                scr.addScrollListener(new ScrollListener(){

                                    public void scrollChanged(int scrollX, int scrollY, int oldscrollX, int oldscrollY) {
                                        if (Validator.this.message != null) {
                                            Validator.this.message.dispose();
                                        }
                                        Validator.this.message = null;
                                    }
                                });
                            }
                            float width = cmp.getWidth();
                            float height = cmp.getHeight();
                            xpos += Math.round(width * Validator.this.validationEmblemPositionX);
                            ypos += Math.round(height * Validator.this.validationEmblemPositionY);
                            if (Validator.this.message != null) {
                                Validator.this.message.showPopupDialog(new Rectangle(xpos, ypos, Validator.this.validationFailedEmblem.getWidth(), Validator.this.validationFailedEmblem.getHeight()));
                            }
                        } else {
                            Validator.this.message.showPopupDialog(cmp);
                        }
                    }
                }

                public void focusLost(Component cmp) {
                }
            });
        }
        if (validateOnEveryKey) {
            if (cmp instanceof TextComponent) {
                ((TextComponent)cmp).getField().addDataChangedListener(new ComponentListener(cmp));
                return;
            }
            if (cmp instanceof TextField) {
                ((TextField)cmp).addDataChangedListener(new ComponentListener(cmp));
                return;
            }
        }
        if (cmp instanceof TextComponent) {
            ((TextComponent)cmp).getField().addActionListener((ActionListener)new ComponentListener(cmp));
            return;
        }
        if (cmp instanceof TextArea) {
            ((TextArea)cmp).addActionListener((ActionListener)new ComponentListener(cmp));
            return;
        }
        if (cmp instanceof List) {
            ((List)cmp).addActionListener((ActionListener)new ComponentListener(cmp));
            return;
        }
        if (cmp instanceof CheckBox || cmp instanceof RadioButton) {
            ((Button)cmp).addActionListener((ActionListener)new ComponentListener(cmp));
            return;
        }
        if (cmp instanceof Picker) {
            ((Picker)cmp).addActionListener((ActionListener)new ComponentListener(cmp));
            return;
        }
        if (cmp instanceof PickerComponent) {
            ((PickerComponent)cmp).getPicker().addActionListener((ActionListener)new ComponentListener(cmp));
        }
    }

    public boolean isValid() {
        for (Component c : this.constraintList.keySet()) {
            if (this.isValid(c)) continue;
            return false;
        }
        return true;
    }

    protected void validate(Component cmp) {
        Object val = this.getComponentValue(cmp);
        Constraint c = this.constraintList.get(cmp);
        if (c != null) {
            this.setValid(cmp, c.isValid(val));
        }
    }

    boolean isValid(Component cmp) {
        Boolean b = (Boolean)cmp.getClientProperty(VALID_MARKER);
        if (b != null) {
            return b;
        }
        Object val = this.getComponentValue(cmp);
        Constraint c = this.constraintList.get(cmp);
        if (c != null) {
            return c.isValid(val);
        }
        return true;
    }

    public String getErrorMessage(Component cmp) {
        return this.constraintList.get(cmp).getDefaultFailMessage();
    }

    void setValid(Component cmp, boolean v) {
        String uiid;
        Boolean b = (Boolean)cmp.getClientProperty(VALID_MARKER);
        if (b != null && b == v) {
            return;
        }
        cmp.putClientProperty(VALID_MARKER, v);
        if (!v) {
            for (Component c : this.submitButtons) {
                c.setEnabled(false);
            }
        } else {
            boolean isV = this.isValid();
            for (Component c : this.submitButtons) {
                c.setEnabled(isV);
            }
            if (this.message != null && cmp.hasFocus()) {
                this.message.dispose();
            }
        }
        if (cmp instanceof InputComponent && ((InputComponent)cmp).isOnTopMode()) {
            InputComponent tc = (InputComponent)cmp;
            if (v) {
                tc.errorMessage(null);
            } else {
                tc.errorMessage(this.getErrorMessage(cmp));
            }
        }
        if (!(cmp.getComponentForm() == null || this.validationFailureHighlightMode != HighlightMode.EMBLEM && this.validationFailureHighlightMode != HighlightMode.UIID_AND_EMBLEM || cmp.getComponentForm().getGlassPane() instanceof ComponentListener)) {
            cmp.getComponentForm().setGlassPane(new ComponentListener(null));
        }
        if (v) {
            if (this.validationFailureHighlightMode == HighlightMode.UIID || this.validationFailureHighlightMode == HighlightMode.UIID_AND_EMBLEM) {
                uiid = cmp.getUIID();
                if (uiid.endsWith("Invalid")) {
                    uiid = uiid.substring(0, uiid.length() - 7);
                    cmp.setUIID(uiid);
                }
                return;
            }
            if (this.validationFailureHighlightMode == HighlightMode.EMBLEM && this.validationFailedEmblem != null) {
                // empty if block
            }
        } else if (!(this.validationFailureHighlightMode != HighlightMode.UIID && this.validationFailureHighlightMode != HighlightMode.UIID_AND_EMBLEM || (uiid = cmp.getUIID()).endsWith("Invalid"))) {
            cmp.setUIID(uiid + "Invalid");
        }
    }

    class ComponentListener
    implements ActionListener,
    DataChangedListener,
    Painter {
        private final Component cmp;
        private Rectangle visibleRect = new Rectangle();

        public ComponentListener(Component cmp) {
            this.cmp = cmp;
        }

        public void actionPerformed(ActionEvent evt) {
            Validator.this.validate(this.cmp);
        }

        public void dataChanged(int type, int index) {
            Validator.this.validate(this.cmp);
        }

        public void paint(Graphics g, Rectangle rect) {
            for (Component c : Validator.this.constraintList.keySet()) {
                if (Validator.this.isValid(c) || c instanceof InputComponent && ((InputComponent)c).isOnTopMode()) continue;
                int xpos = c.getAbsoluteX();
                int ypos = c.getAbsoluteY();
                float width = c.getWidth();
                float height = c.getHeight();
                xpos += Math.round(width * Validator.this.validationEmblemPositionX);
                ypos += Math.round(height * Validator.this.validationEmblemPositionY);
                Container parent = c.getParent();
                this.visibleRect = parent.getVisibleBounds(this.visibleRect);
                Container grandParent = parent.getParent();
                if (grandParent != null) {
                    this.visibleRect.setX(this.visibleRect.getX() + grandParent.getAbsoluteX());
                    this.visibleRect.setY(this.visibleRect.getY() + grandParent.getAbsoluteY());
                }
                int[] originalClip = g.getClip();
                g.setClip(this.visibleRect);
                if (xpos + Validator.this.validationFailedEmblem.getWidth() > Display.getInstance().getDisplayWidth()) {
                    g.drawImage(Validator.this.validationFailedEmblem, xpos - Validator.this.validationFailedEmblem.getWidth(), ypos - Validator.this.validationFailedEmblem.getHeight() / 2);
                } else {
                    g.drawImage(Validator.this.validationFailedEmblem, xpos - Validator.this.validationFailedEmblem.getWidth() / 2, ypos - Validator.this.validationFailedEmblem.getHeight() / 2);
                }
                g.setClip(originalClip);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HighlightMode {
        UIID,
        EMBLEM,
        UIID_AND_EMBLEM,
        NONE;

    }
}

