/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util;

import com.codename1.util.TBigInteger;
import java.util.Random;

public class BigInteger {
    public static final BigInteger ZERO = new BigInteger(0, new int[0]);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTES_PER_INT = 4;
    private static final byte[] rndMask = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};
    private static final byte[] bitCounts = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    TBigInteger peer;

    private BigInteger() {
        this.peer = new TBigInteger(0, new int[0]);
    }

    private BigInteger(int signum, int[] mag) {
        this.peer = new TBigInteger(signum, mag);
    }

    public BigInteger(String sval) throws NumberFormatException {
        this(sval, 10);
    }

    public BigInteger(String sval, int rdx) throws NumberFormatException {
        this.peer = new TBigInteger(sval, rdx);
    }

    public BigInteger(byte[] bval) throws NumberFormatException {
        this.peer = new TBigInteger(bval);
    }

    BigInteger(TBigInteger peer) {
        this.peer = peer;
    }

    public BigInteger(int sign, byte[] mag) throws NumberFormatException {
        this.peer = new TBigInteger(sign, mag);
    }

    public BigInteger(int numBits, Random rnd) throws IllegalArgumentException {
        this.peer = new TBigInteger(numBits, rnd);
    }

    public BigInteger(int bitLength, int certainty, Random rnd) throws ArithmeticException {
        this.peer = new TBigInteger(bitLength, certainty, rnd);
    }

    static int bitLen(int w) {
        return w < 32768 ? (w < 128 ? (w < 8 ? (w < 2 ? (w < 1 ? (w < 0 ? 32 : 0) : 1) : (w < 4 ? 2 : 3)) : (w < 32 ? (w < 16 ? 4 : 5) : (w < 64 ? 6 : 7))) : (w < 2048 ? (w < 512 ? (w < 256 ? 8 : 9) : (w < 1024 ? 10 : 11)) : (w < 8192 ? (w < 4096 ? 12 : 13) : (w < 16384 ? 14 : 15)))) : (w < 0x800000 ? (w < 524288 ? (w < 131072 ? (w < 65536 ? 16 : 17) : (w < 262144 ? 18 : 19)) : (w < 0x200000 ? (w < 0x100000 ? 20 : 21) : (w < 0x400000 ? 22 : 23))) : (w < 0x8000000 ? (w < 0x2000000 ? (w < 0x1000000 ? 24 : 25) : (w < 0x4000000 ? 26 : 27)) : (w < 0x20000000 ? (w < 0x10000000 ? 28 : 29) : (w < 0x40000000 ? 30 : 31))));
    }

    public static BigInteger probablePrime(int bitLength, Random random) {
        return new BigInteger(TBigInteger.probablePrime(bitLength, random));
    }

    public static BigInteger valueOf(long val) {
        return new BigInteger(TBigInteger.valueOf(val));
    }

    public BigInteger abs() {
        return this.peer.sign >= 0 ? this : this.negate();
    }

    public BigInteger add(BigInteger val) throws ArithmeticException {
        return new BigInteger(this.peer.add(val.peer));
    }

    public BigInteger and(BigInteger value) {
        return new BigInteger(this.peer.and(value.peer));
    }

    public BigInteger andNot(BigInteger value) {
        return this.and(value.not());
    }

    public int bitCount() {
        return this.peer.bitCount();
    }

    public int bitLength() {
        return this.peer.bitLength();
    }

    public int compareTo(Object o) {
        if (o instanceof BigInteger) {
            return this.compareTo((BigInteger)o);
        }
        throw new IllegalArgumentException("BigInteger can only be compared to other BigIntegers");
    }

    public int compareTo(BigInteger val) {
        return this.peer.compareTo(val.peer);
    }

    public BigInteger divide(BigInteger val) throws ArithmeticException {
        return new BigInteger(this.peer.divide(val.peer));
    }

    public BigInteger[] divideAndRemainder(BigInteger val) throws ArithmeticException {
        TBigInteger[] presults = this.peer.divideAndRemainder(val.peer);
        BigInteger[] out = new BigInteger[presults.length];
        int plen = presults.length;
        for (int i = 0; i < plen; ++i) {
            out[i] = new BigInteger(presults[i]);
        }
        return out;
    }

    public boolean equals(Object val) {
        if (val == this) {
            return true;
        }
        if (!(val instanceof BigInteger)) {
            return false;
        }
        BigInteger biggie = (BigInteger)val;
        return this.peer.equals(biggie.peer);
    }

    public BigInteger gcd(BigInteger val) {
        return new BigInteger(this.peer.gcd(val.peer));
    }

    public int hashCode() {
        return this.peer.hashCode();
    }

    public int intValue() {
        return this.peer.intValue();
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public boolean isProbablePrime(int certainty) {
        return this.peer.isProbablePrime(certainty);
    }

    public long longValue() {
        return this.peer.longValue();
    }

    public BigInteger max(BigInteger val) {
        return this.compareTo(val) > 0 ? this : val;
    }

    public BigInteger min(BigInteger val) {
        return this.compareTo(val) < 0 ? this : val;
    }

    public BigInteger mod(BigInteger m) throws ArithmeticException {
        return new BigInteger(this.peer.mod(m.peer));
    }

    public BigInteger modInverse(BigInteger m) throws ArithmeticException {
        return new BigInteger(this.peer.modInverse(m.peer));
    }

    public BigInteger modPow(BigInteger exponent, BigInteger m) throws ArithmeticException {
        return new BigInteger(this.peer.modPow(exponent.peer, m.peer));
    }

    public BigInteger multiply(BigInteger val) {
        return new BigInteger(this.peer.multiply(val.peer));
    }

    public BigInteger negate() {
        return new BigInteger(this.peer.negate());
    }

    public BigInteger not() {
        return this.add(ONE).negate();
    }

    public BigInteger pow(int exp) throws ArithmeticException {
        return new BigInteger(this.peer.pow(exp));
    }

    public BigInteger remainder(BigInteger n) throws ArithmeticException {
        return new BigInteger(this.peer.remainder(n.peer));
    }

    public BigInteger shiftLeft(int n) {
        return new BigInteger(this.peer.shiftLeft(n));
    }

    public BigInteger shiftRight(int n) {
        return new BigInteger(this.peer.shiftRight(n));
    }

    public int signum() {
        return this.peer.signum();
    }

    public BigInteger subtract(BigInteger val) {
        return new BigInteger(this.peer.subtract(val.peer));
    }

    public byte[] toByteArray() {
        return this.peer.toByteArray();
    }

    public BigInteger xor(BigInteger val) {
        return new BigInteger(this.peer.xor(val.peer));
    }

    public BigInteger or(BigInteger value) {
        return new BigInteger(this.peer.or(value.peer));
    }

    public BigInteger setBit(int n) throws ArithmeticException {
        return new BigInteger(this.peer.setBit(n));
    }

    public BigInteger clearBit(int n) throws ArithmeticException {
        return new BigInteger(this.peer.clearBit(n));
    }

    public BigInteger flipBit(int n) throws ArithmeticException {
        return new BigInteger(this.peer.flipBit(n));
    }

    public String toString() {
        return this.peer.toString();
    }

    public String toString(int rdx) {
        return this.peer.toString(rdx);
    }

    public int getLowestSetBit() {
        return this.peer.getLowestSetBit();
    }

    public boolean testBit(int n) throws ArithmeticException {
        return this.peer.testBit(n);
    }
}

