/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util;

import com.codename1.io.Util;
import com.codename1.ui.Display;
import com.codename1.util.RunnableWithResult;
import com.codename1.util.RunnableWithResultSync;
import com.codename1.util.SuccessCallback;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyThread {
    private static List<ErrorListener> globalErrorListenenrs;
    private final Object LOCK = new Object();
    private List<ErrorListener> errorListenenrs;
    private final Thread t;
    private boolean running = true;
    private final ArrayList<Object> queue = new ArrayList();

    private EasyThread(String name) {
        this.t = Display.getInstance().startThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object current = null;
                Object resultCallback = null;
                while (EasyThread.this.running) {
                    try {
                        Object object = EasyThread.this.LOCK;
                        synchronized (object) {
                            if (EasyThread.this.queue.size() > 0) {
                                current = EasyThread.this.queue.get(0);
                                if (current instanceof RunnableWithResult) {
                                    resultCallback = EasyThread.this.queue.get(1);
                                    EasyThread.this.queue.remove(0);
                                }
                                EasyThread.this.queue.remove(0);
                            } else {
                                Util.wait(EasyThread.this.LOCK);
                            }
                        }
                        if (current != null) {
                            if (current instanceof Runnable) {
                                ((Runnable)current).run();
                            } else {
                                ((RunnableWithResult)current).run(resultCallback);
                            }
                        }
                    }
                    catch (Throwable t) {
                        EasyThread.this.fireEvent(EasyThread.this.errorListenenrs, current, t);
                        EasyThread.this.fireEvent(globalErrorListenenrs, current, t);
                    }
                    current = null;
                    resultCallback = null;
                }
            }
        }, name);
        this.t.start();
    }

    public static EasyThread start(String name) {
        return new EasyThread(name);
    }

    public static void addGlobalErrorListener(ErrorListener err) {
        if (globalErrorListenenrs == null) {
            globalErrorListenenrs = new ArrayList<ErrorListener>();
        }
        globalErrorListenenrs.add(err);
    }

    public static void removeGlobalErrorListener(ErrorListener err) {
        if (globalErrorListenenrs == null) {
            return;
        }
        ArrayList<ErrorListener> l = new ArrayList<ErrorListener>();
        l.addAll(globalErrorListenenrs);
        l.remove(err);
        globalErrorListenenrs = l;
    }

    private void fireEvent(List<ErrorListener> lst, Object current, Throwable t) {
        if (lst != null) {
            for (ErrorListener e : lst) {
                e.onError(this, current, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void run(RunnableWithResult<T> r, SuccessCallback<T> t) {
        Object object = this.LOCK;
        synchronized (object) {
            this.queue.add(r);
            this.queue.add(t);
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r) {
        Object object = this.LOCK;
        synchronized (object) {
            this.queue.add(r);
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(final RunnableWithResultSync<T> r) {
        final boolean[] flag = new boolean[1];
        final Object[] result = new Object[1];
        final SuccessCallback sc = new SuccessCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSucess(T value) {
                boolean[] blArray = flag;
                synchronized (flag) {
                    result[0] = value;
                    flag[0] = true;
                    flag.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        RunnableWithResult rr = new RunnableWithResult<T>(){

            @Override
            public void run(SuccessCallback<T> onSuccess) {
                sc.onSucess(r.run());
            }
        };
        Object object = this.LOCK;
        synchronized (object) {
            this.queue.add(rr);
            this.queue.add(sc);
            this.LOCK.notify();
        }
        Display.getInstance().invokeAndBlock(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean[] blArray = flag;
                synchronized (flag) {
                    if (!flag[0]) {
                        Util.wait(flag);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        return (T)result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAndWait(final Runnable r) {
        final boolean[] flag = new boolean[1];
        Object object = this.LOCK;
        synchronized (object) {
            this.queue.add(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        boolean[] blArray = flag;
                        synchronized (flag) {
                            flag[0] = true;
                            flag.notify();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                        }
                    }
                }
            });
            this.LOCK.notify();
        }
        Display.getInstance().invokeAndBlock(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean[] blArray = flag;
                synchronized (flag) {
                    if (!flag[0]) {
                        Util.wait(flag);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        Object object = this.LOCK;
        synchronized (object) {
            this.running = false;
            this.LOCK.notify();
        }
    }

    public boolean isThisIt() {
        return this.t == Thread.currentThread();
    }

    public void addErrorListener(ErrorListener err) {
        if (this.errorListenenrs == null) {
            this.errorListenenrs = new ArrayList<ErrorListener>();
        }
        this.errorListenenrs.add(err);
    }

    public void removeErrorListener(ErrorListener err) {
        if (this.errorListenenrs == null) {
            return;
        }
        ArrayList<ErrorListener> l = new ArrayList<ErrorListener>();
        l.addAll(this.errorListenenrs);
        l.remove(err);
        this.errorListenenrs = l;
    }

    public final void setPriority(int newPriority) {
        this.t.setPriority(newPriority);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ErrorListener<T> {
        public void onError(EasyThread var1, T var2, Throwable var3);
    }
}

