/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util.promise;

import com.codename1.annotations.Async;
import com.codename1.io.Util;
import com.codename1.ui.CN;
import com.codename1.util.AsyncResource;
import com.codename1.util.AsyncResult;
import com.codename1.util.SuccessCallback;
import com.codename1.util.promise.ExecutorFunction;
import com.codename1.util.promise.Functor;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Promise<T> {
    private final LinkedList<PromiseHandler> then = new LinkedList();
    private final Functor<T, ?> resolve;
    private final Functor<Throwable, ?> reject;
    private State state = State.Pending;
    private Throwable error;
    private T value;

    @Async.Schedule
    public Promise(ExecutorFunction executor) {
        this.resolve = new Functor<T, Object>(){

            @Override
            public Object call(final T o) {
                if (!CN.isEdt()) {
                    CN.callSerially(new Runnable(){

                        public void run() {
                            Promise.this.resolve.call(o);
                        }
                    });
                    return null;
                }
                Promise.this.state = State.Fulfilled;
                Promise.this.value = o;
                Promise.this.processThens(o, true);
                return Promise.this.value;
            }
        };
        this.reject = new Functor<Throwable, Object>(){

            @Override
            public Object call(final Throwable o) {
                if (!CN.isEdt()) {
                    CN.callSerially(new Runnable(){

                        public void run() {
                            Promise.this.reject.call(o);
                        }
                    });
                    return null;
                }
                Promise.this.state = State.Rejected;
                Promise.this.error = o;
                Promise.this.processThens(o, false);
                return Promise.this.error;
            }
        };
        if (executor != null) {
            executor.call(this.resolve, this.reject);
        }
    }

    public static Promise all(final Promise ... promises) {
        return new Promise(new ExecutorFunction(){

            public void call(final Functor resolve, final Functor reject) {
                final int[] complete = new int[1];
                final int len = promises.length;
                final Object[] results = new Object[len];
                if (len > 0) {
                    for (int i = 0; i < len; ++i) {
                        final int index = i;
                        Promise p = promises[i];
                        p.then(new Functor(){

                            public Object call(Object res) {
                                results[index] = res;
                                complete[0] = complete[0] + 1;
                                if (complete[0] == len) {
                                    resolve.call(results);
                                }
                                return null;
                            }
                        }).except(new Functor(){

                            public Object call(Object error) {
                                reject.call(error);
                                return null;
                            }
                        });
                    }
                } else {
                    resolve.call(results);
                }
            }
        });
    }

    public static Promise allSettled(final Promise ... promises) {
        return new Promise(new ExecutorFunction(){

            public void call(final Functor resolve, Functor reject) {
                final int[] complete = new int[1];
                final int len = promises.length;
                if (len > 0) {
                    for (int i = 0; i < len; ++i) {
                        Promise p = promises[i];
                        p.always(new Functor(){

                            public Object call(Object res) {
                                complete[0] = complete[0] + 1;
                                if (complete[0] == len) {
                                    resolve.call(promises);
                                }
                                return null;
                            }
                        });
                    }
                } else {
                    resolve.call(promises);
                }
            }
        });
    }

    public static <V> Promise<V> resolve(final V value) {
        return new Promise(new ExecutorFunction(){

            public void call(Functor resolutionFunc, Functor rejectionFunc) {
                resolutionFunc.call(value);
            }
        });
    }

    public static Promise reject(final Throwable err) {
        return new Promise(new ExecutorFunction(){

            public void call(Functor resolve, Functor reject) {
                Promise.reject(err);
            }
        });
    }

    public static <V> Promise<V> promisify(final AsyncResource<V> res) {
        return new Promise(new ExecutorFunction(){

            public void call(final Functor resolutionFunc, final Functor rejectionFunc) {
                res.onResult(new AsyncResult<V>(){

                    @Override
                    public void onReady(V r, Throwable err) {
                        if (err != null) {
                            rejectionFunc.call(err);
                        } else {
                            resolutionFunc.call(r);
                        }
                    }
                });
            }
        });
    }

    @Async.Execute
    private void processThens(final Object o, final boolean resolved) {
        if (!CN.isEdt()) {
            CN.callSerially(new Runnable(){

                public void run() {
                    Promise.this.processThens(o, resolved);
                }
            });
            return;
        }
        while (!this.then.isEmpty()) {
            PromiseHandler p = this.then.remove(0);
            try {
                Object result;
                Object v = result = resolved ? p.resolve.call(o) : p.reject.call(o);
                if (result instanceof Promise) {
                    Promise promiseResult = (Promise)result;
                    switch (promiseResult.state) {
                        case Fulfilled: {
                            ((PromiseHandler)p).promise.resolve.call(promiseResult.value);
                            break;
                        }
                        case Rejected: {
                            ((PromiseHandler)p).promise.reject.call(promiseResult.error);
                            break;
                        }
                        case Pending: {
                            promiseResult.then(((PromiseHandler)p).promise.resolve, ((PromiseHandler)p).promise.reject);
                        }
                    }
                    continue;
                }
                ((PromiseHandler)p).promise.resolve.call(result);
            }
            catch (Throwable ex) {
                ((PromiseHandler)p).promise.reject.call(ex);
            }
        }
    }

    public Promise ready(final SuccessCallback<T> resolutionFunc, final SuccessCallback<Throwable> rejectionFunc) {
        return this.then(resolutionFunc == null ? null : new Functor<T, Object>(){

            @Override
            public Object call(T o) {
                resolutionFunc.onSucess(o);
                return null;
            }
        }, rejectionFunc == null ? null : new Functor<Throwable, Object>(){

            @Override
            public Object call(Throwable o) {
                rejectionFunc.onSucess(o);
                return null;
            }
        });
    }

    public Promise onSuccess(SuccessCallback<T> resolutionFunc) {
        return this.ready(resolutionFunc, null);
    }

    public Promise onFail(SuccessCallback<Throwable> rejectionFunc) {
        return this.ready(null, rejectionFunc);
    }

    public Promise onComplete(SuccessCallback handlerFunc) {
        return this.ready(handlerFunc, handlerFunc);
    }

    public Promise then(Functor<T, ?> resolutionFunc) {
        return this.then(resolutionFunc, null);
    }

    public Promise then(Functor<T, ?> resolutionFunc, Functor<Throwable, ?> rejectionFunc) {
        if (resolutionFunc == null) {
            resolutionFunc = new Functor<T, Object>(){

                @Override
                public Object call(T o) {
                    return o;
                }
            };
        }
        if (rejectionFunc == null) {
            rejectionFunc = new Functor<Throwable, Object>(){

                @Override
                public Object call(Throwable o) {
                    throw (RuntimeException)o;
                }
            };
        }
        PromiseHandler handler = new PromiseHandler();
        handler.promise = new Promise<T>(null);
        handler.resolve = resolutionFunc;
        handler.reject = rejectionFunc;
        this.then.add(handler);
        switch (this.state) {
            case Fulfilled: {
                this.processThens(this.value, true);
                break;
            }
            case Rejected: {
                this.processThens(this.error, false);
            }
        }
        return handler.promise;
    }

    public Promise except(Functor<Throwable, ?> rejectionFunc) {
        return this.then(null, rejectionFunc);
    }

    public Promise always(Functor handlerFunc) {
        return this.then(handlerFunc, handlerFunc);
    }

    public T getValue() {
        return this.value;
    }

    public State getState() {
        return this.state;
    }

    public T await() {
        final boolean[] complete = new boolean[1];
        final Object[] out = new Object[1];
        final Throwable[] ex = new Throwable[1];
        this.onSuccess(new SuccessCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSucess(T res) {
                boolean[] blArray = complete;
                synchronized (complete) {
                    out[0] = res;
                    complete[0] = true;
                    complete.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        }).onFail(new SuccessCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSucess(Object res) {
                boolean[] blArray = complete;
                synchronized (complete) {
                    ex[0] = (Throwable)res;
                    complete[0] = true;
                    complete.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        while (!complete[0]) {
            CN.invokeAndBlock(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean[] blArray = complete;
                    synchronized (complete) {
                        Util.wait(complete, 500);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        if (ex[0] != null) {
            throw new AsyncResource.AsyncExecutionException(ex[0]);
        }
        return (T)out[0];
    }

    public AsyncResource<T> asAsyncResource() {
        final AsyncResource out = new AsyncResource();
        this.onSuccess(new SuccessCallback<T>(){

            @Override
            public void onSucess(T res) {
                out.complete(res);
            }
        });
        this.onFail(new SuccessCallback<Throwable>(){

            @Override
            public void onSucess(Throwable err) {
                out.error(err);
            }
        });
        return out;
    }

    private static class PromiseHandler {
        private Promise promise;
        private Functor resolve;
        private Functor reject;

        private PromiseHandler() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        Pending,
        Fulfilled,
        Rejected;

    }
}

