/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util.regex;

import com.codename1.util.regex.RECompiler;
import java.io.PrintStream;
import java.util.HashMap;

public class REDebugCompiler
extends RECompiler {
    static HashMap hashOpcode = new HashMap();

    String opcodeToString(char opcode) {
        String ret = (String)hashOpcode.get(opcode);
        if (ret == null) {
            ret = "OP_????";
        }
        return ret;
    }

    String charToString(char c) {
        if (c < ' ' || c > '\u007f') {
            return "\\" + c;
        }
        return String.valueOf(c);
    }

    String nodeToString(int node) {
        char opcode = this.instruction[node];
        char opdata = this.instruction[node + 1];
        return this.opcodeToString(opcode) + ", opdata = " + opdata;
    }

    public void dumpProgram(PrintStream p) {
        int i = 0;
        while (i < this.lenInstruction) {
            char opcode = this.instruction[i];
            int opdata = this.instruction[i + 1];
            short next = (short)this.instruction[i + 2];
            p.print(i + ". " + this.nodeToString(i) + ", next = ");
            if (next == 0) {
                p.print("none");
            } else {
                p.print(i + next);
            }
            i += 3;
            if (opcode == '[') {
                p.print(", [");
                for (int r = 0; r < opdata; ++r) {
                    char charLast;
                    char charFirst;
                    if ((charFirst = this.instruction[i++]) == (charLast = this.instruction[i++])) {
                        p.print(this.charToString(charFirst));
                        continue;
                    }
                    p.print(this.charToString(charFirst) + "-" + this.charToString(charLast));
                }
                p.print("]");
            }
            if (opcode == 'A') {
                p.print(", \"");
                int len = opdata;
                while (len-- != 0) {
                    p.print(this.charToString(this.instruction[i++]));
                }
                p.print("\"");
            }
            p.println();
        }
    }

    public void dumpProgram() {
        PrintStream w = new PrintStream(System.out);
        this.dumpProgram(w);
        w.flush();
    }

    static {
        hashOpcode.put(56, "OP_RELUCTANTSTAR");
        hashOpcode.put(61, "OP_RELUCTANTPLUS");
        hashOpcode.put(47, "OP_RELUCTANTMAYBE");
        hashOpcode.put(69, "OP_END");
        hashOpcode.put(94, "OP_BOL");
        hashOpcode.put(36, "OP_EOL");
        hashOpcode.put(46, "OP_ANY");
        hashOpcode.put(91, "OP_ANYOF");
        hashOpcode.put(124, "OP_BRANCH");
        hashOpcode.put(65, "OP_ATOM");
        hashOpcode.put(42, "OP_STAR");
        hashOpcode.put(43, "OP_PLUS");
        hashOpcode.put(63, "OP_MAYBE");
        hashOpcode.put(78, "OP_NOTHING");
        hashOpcode.put(71, "OP_GOTO");
        hashOpcode.put(67, "OP_CONTINUE");
        hashOpcode.put(92, "OP_ESCAPE");
        hashOpcode.put(40, "OP_OPEN");
        hashOpcode.put(41, "OP_CLOSE");
        hashOpcode.put(35, "OP_BACKREF");
        hashOpcode.put(80, "OP_POSIXCLASS");
        hashOpcode.put(60, "OP_OPEN_CLUSTER");
        hashOpcode.put(62, "OP_CLOSE_CLUSTER");
    }
}

