/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.xml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
implements Iterable<Element> {
    public static final int DEPTH_INFINITE = Integer.MAX_VALUE;
    boolean isComment;
    boolean caseSensitive;
    private boolean textElement;
    private String name;
    private ArrayList<Element> children;
    private Element parent;
    private Hashtable attributes;

    protected Element() {
    }

    public Element(String tagName) {
        this.name = tagName;
    }

    public Element(String tagName, boolean isTextElement) {
        this(tagName);
        this.textElement = isTextElement;
    }

    private static boolean cmpTagName(String tagName, Element tag) {
        if ("*".equals(tagName)) {
            return true;
        }
        return tagName.equalsIgnoreCase(tag.getTagName());
    }

    public boolean isTextElement() {
        return this.textElement;
    }

    protected void setTextElement(boolean textElement) {
        this.textElement = textElement;
    }

    public String getTagName() {
        if (this.textElement) {
            throw new IllegalStateException("Text elements do not have a tag name");
        }
        return this.name;
    }

    protected void setTagName(String name) {
        this.name = name;
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    protected void setAttribute(Object id, String value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(id, value);
    }

    public void addChild(Element childElement) {
        this.setChildParent(childElement);
        this.children.add(childElement);
    }

    public Element getParent() {
        return this.parent;
    }

    protected void setParent(Element parent) {
        this.parent = parent;
    }

    public int getNumChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    protected Vector getChildren() {
        if (this.children == null) {
            return null;
        }
        return new Vector<Element>(this.children);
    }

    protected void setChildren(Vector children) {
        this.children = children == null ? null : new ArrayList(children);
    }

    public Element getChildAt(int index) {
        if (index < 0 || this.children == null || index >= this.children.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.children.get(index);
    }

    public Element getFirstChildByTagName(String name) {
        if (this.children == null) {
            return null;
        }
        int i = 0;
        Element found = null;
        while (found == null && i < this.children.size()) {
            Element child = this.children.get(i);
            if (!child.textElement && Element.cmpTagName(name, child)) {
                found = child;
                continue;
            }
            ++i;
        }
        return found;
    }

    public Element getElementById(String id) {
        String thisId = this.getAttribute("id");
        if (thisId != null && thisId.equals(id)) {
            return this;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element child = this.children.get(i);
                Element match = child.getElementById(id);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    private void getDescendantsByTagNameInternal(Vector v, String name, int depth) {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element child = this.children.get(i);
                if (depth > 1) {
                    child.getDescendantsByTagNameInternal(v, name, depth - 1);
                }
                if (child.textElement || !Element.cmpTagName(name, child)) continue;
                v.addElement(child);
            }
        }
    }

    private void getDescendantsByTagNameAndAttributeInternal(Vector v, String name, String attribute, int depth) {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                String a;
                Element child = this.children.get(i);
                if (depth > 1) {
                    child.getDescendantsByTagNameAndAttributeInternal(v, name, attribute, depth - 1);
                }
                if (child.textElement || !Element.cmpTagName(name, child) || (a = child.getAttribute(attribute)) == null || a.length() <= 0) continue;
                v.addElement(child);
            }
        }
    }

    public Vector getDescendantsByTagNameAndAttribute(String name, String attributeName, int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException("Depth must be 1 or higher");
        }
        if (this.children == null) {
            return new Vector();
        }
        Vector v = new Vector();
        this.getDescendantsByTagNameAndAttributeInternal(v, name, attributeName, depth);
        return v;
    }

    public Vector getDescendantsByTagName(String name, int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException("Depth must be 1 or higher");
        }
        Vector v = new Vector();
        if (this.children != null) {
            this.getDescendantsByTagNameInternal(v, name, depth);
        }
        return v;
    }

    public Vector getDescendantsByTagName(String name) {
        return this.getDescendantsByTagName(name, Integer.MAX_VALUE);
    }

    public Vector getChildrenByTagName(String name) {
        return this.getDescendantsByTagName(name, 1);
    }

    private void getTextDescendantsInternal(Vector v, String text, boolean caseSensitive, int depth) {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Element child = this.children.get(i);
            if (depth > 0) {
                child.getTextDescendantsInternal(v, text, caseSensitive, depth - 1);
            }
            if (!child.textElement) continue;
            if (text != null) {
                int index;
                String childText = child.getText();
                if (!caseSensitive) {
                    childText = childText.toLowerCase();
                }
                if ((index = childText.indexOf(text)) == -1) continue;
                v.addElement(child);
                continue;
            }
            v.addElement(child);
        }
    }

    public Vector getTextDescendants(String text, boolean caseSensitive, int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException("Depth must be 1 or higher");
        }
        if (this.children == null) {
            return new Vector();
        }
        if (!caseSensitive && text != null) {
            text = text.toLowerCase();
        }
        Vector v = new Vector();
        this.getTextDescendantsInternal(v, text, caseSensitive, depth);
        return v;
    }

    public Vector getTextDescendants(String text, boolean caseSensitive) {
        return this.getTextDescendants(text, caseSensitive, Integer.MAX_VALUE);
    }

    public Vector getTextChildren(String text, boolean caseSensitive) {
        return this.getTextDescendants(text, caseSensitive, 1);
    }

    public boolean contains(Element element) {
        if (this == element) {
            return true;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element child = this.children.get(i);
                if (!child.contains(element)) continue;
                return true;
            }
        }
        return false;
    }

    public int setAttribute(String attribute, String value) {
        if (this.textElement) {
            throw new IllegalStateException("Text elements cannot have attributes");
        }
        this.setAttribute((Object)attribute, value);
        return -1;
    }

    public void removeAttribute(String attribute) {
        this.removeAttribute((Object)attribute);
    }

    protected void removeAttribute(Object id) {
        if (this.attributes != null) {
            this.attributes.remove(id);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
    }

    public int getAttributeAsInt(String name, int def) {
        String s = this.getAttribute(name);
        if (s == null) {
            return def;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public String getAttribute(String name) {
        String val;
        if (this.attributes == null) {
            return null;
        }
        if (!this.caseSensitive && (val = (String)this.attributes.get(name.toLowerCase())) != null) {
            return val;
        }
        return (String)this.attributes.get(name);
    }

    private void setChildParent(Element child) {
        if (this.textElement) {
            throw new IllegalStateException("Text elements cannot have children");
        }
        if (child.getParent() != null) {
            throw new IllegalStateException("An Element can't have two parents.");
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        child.setParent(this);
    }

    public void removeChildAt(int index) {
        if (index < 0 || this.children == null || index >= this.children.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Element child = this.children.get(index);
        child.setParent(null);
        this.children.remove(index);
    }

    public int getChildIndex(Element child) {
        int result = -1;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (child != this.children.get(i)) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public void insertChildAt(Element child, int index) {
        this.setChildParent(child);
        this.children.add(index, child);
    }

    public void replaceChild(Element oldChild, Element newChild) {
        if (this.children != null) {
            this.setChildParent(newChild);
            int index = this.children.indexOf(oldChild);
            if (index != -1) {
                this.children.add(index, newChild);
                this.removeChildAt(index + 1);
                return;
            }
        }
        throw new IllegalArgumentException("The oldChild element specified must be this element's child");
    }

    public String getText() {
        if (!this.textElement) {
            throw new IllegalStateException("Only text elements can get text");
        }
        return this.name;
    }

    public void setText(String str) {
        if (!this.textElement) {
            throw new IllegalStateException("Only text elements can set text");
        }
        this.name = str;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String spacing) {
        String str = spacing;
        if (!this.textElement) {
            str = str + "<" + this.getTagName();
            if (this.attributes != null) {
                Enumeration e = this.attributes.keys();
                while (e.hasMoreElements()) {
                    String attrStr = (String)e.nextElement();
                    String val = (String)this.attributes.get(attrStr);
                    str = str + " " + attrStr + "='" + val + "'";
                }
            }
            str = str + ">\n";
            if (this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    str = str + this.children.get(i).toString(spacing + ' ');
                }
            }
            str = str + spacing + "</" + this.getTagName() + ">\n";
        } else {
            str = str + "'" + this.name + "'\n";
        }
        return str;
    }

    public boolean hasTextChild() {
        if (this.children != null) {
            for (int iter = 0; iter < this.children.size(); ++iter) {
                Element child = this.children.get(iter);
                if (!(child instanceof Element) || !child.isTextElement()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    @Override
    public Iterator<Element> iterator() {
        return this.children.iterator();
    }
}

