/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.xml;

import com.codename1.util.StringUtil;
import com.codename1.xml.Element;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public class XMLWriter {
    private static final String[][] escapes = new String[][]{{"&", "&amp;"}, {"\"", "&quot;"}, {"<", "&lt;"}, {">", "&gt;"}, {"'", "&apos;"}};
    private final boolean encodeText;

    public XMLWriter(boolean encodeText) {
        this.encodeText = encodeText;
    }

    public void writeXML(Writer writer, Element element) throws IOException {
        this.writeXML(writer, element, new StringBuilder(), false);
    }

    public String toXML(Element element) {
        StringBuilder writer = new StringBuilder();
        this.toXML(writer, element, new StringBuilder(), false);
        return writer.toString();
    }

    private void toXML(StringBuilder writer, Element element, StringBuilder indentation, boolean isInline) {
        if (!isInline) {
            writer.append((CharSequence)indentation);
        }
        if (element.isTextElement()) {
            writer.append(this.encodeIfRequired(element.getText()));
        } else {
            writer.append('<');
            String elementName = this.encodeIfRequired(element.getTagName());
            writer.append(elementName);
            Hashtable attributes = element.getAttributes();
            if (attributes != null) {
                Enumeration keys = attributes.keys();
                while (keys.hasMoreElements()) {
                    String attributeKey = (String)keys.nextElement();
                    String attributeValue = (String)attributes.get(attributeKey);
                    writer.append(' ');
                    writer.append(this.encodeIfRequired(attributeKey));
                    writer.append("=\"");
                    writer.append(this.encodeIfRequired(attributeValue));
                    writer.append('\"');
                }
            }
            if (element.isEmpty()) {
                writer.append(" />");
            } else {
                writer.append('>');
                if (!isInline && !element.hasTextChild()) {
                    writer.append('\n');
                    indentation.append('\t');
                    for (Element child : element) {
                        if (!(child instanceof Element)) {
                            throw new IllegalStateException("Element contained child of invalid type");
                        }
                        this.toXML(writer, child, indentation, isInline);
                        writer.append('\n');
                    }
                } else {
                    isInline = true;
                    for (Element child : element) {
                        if (child instanceof Element) {
                            this.toXML(writer, child, null, isInline);
                            continue;
                        }
                        throw new IllegalStateException("Element contained child of invalid type");
                    }
                }
                if (!isInline) {
                    indentation.deleteCharAt(indentation.length() - 1);
                    writer.append((CharSequence)indentation);
                }
                writer.append("</");
                writer.append(elementName);
                writer.append('>');
            }
        }
    }

    private void writeXML(Writer writer, Element element, StringBuilder indentation, boolean isInline) throws IOException {
        if (!isInline) {
            writer.write(indentation.toString());
        }
        if (element.isTextElement()) {
            writer.write(this.encodeIfRequired(element.getText()));
        } else {
            writer.write(60);
            String elementName = this.encodeIfRequired(element.getTagName());
            writer.write(elementName);
            Hashtable attributes = element.getAttributes();
            if (attributes != null) {
                Enumeration keys = attributes.keys();
                while (keys.hasMoreElements()) {
                    String attributeKey = (String)keys.nextElement();
                    String attributeValue = (String)attributes.get(attributeKey);
                    writer.write(32);
                    writer.write(this.encodeIfRequired(attributeKey));
                    writer.write("=\"");
                    writer.write(this.encodeIfRequired(attributeValue));
                    writer.write(34);
                }
            }
            if (element.isEmpty()) {
                writer.write(" />");
            } else {
                writer.write(62);
                if (!isInline && !element.hasTextChild()) {
                    writer.write(10);
                    indentation.append('\t');
                    for (Element child : element) {
                        if (!(child instanceof Element)) {
                            throw new IllegalStateException("Element contained child of invalid type");
                        }
                        this.writeXML(writer, child, indentation, isInline);
                        writer.write(10);
                    }
                } else {
                    isInline = true;
                    for (Element child : element) {
                        if (child instanceof Element) {
                            this.writeXML(writer, child, null, isInline);
                            continue;
                        }
                        throw new IllegalStateException("Element contained child of invalid type");
                    }
                }
                if (!isInline) {
                    indentation.deleteCharAt(indentation.length() - 1);
                    writer.write(indentation.toString());
                }
                writer.write("</");
                writer.write(elementName);
                writer.write(62);
            }
        }
    }

    private String encodeIfRequired(String text) {
        if (this.encodeText) {
            int elen = escapes.length;
            for (int i = 0; i < elen; ++i) {
                text = StringUtil.replaceAll(text, escapes[i][0], escapes[i][1]);
            }
        }
        return text;
    }
}

