/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.components.InfiniteProgress;
import com.codename1.components.WebBrowser;
import com.codename1.io.AccessToken;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.JSONParser;
import com.codename1.io.NetworkManager;
import com.codename1.io.Storage;
import com.codename1.io.Util;
import com.codename1.ui.BrowserWindow;
import com.codename1.ui.CN;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.animations.CommonTransitions;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.html.DocumentInfo;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.util.AsyncResource;
import com.codename1.util.regex.StringReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class Oauth2 {
    private boolean useRedirectForWeb = false;
    private boolean useBrowserWindow = "true".equals(CN.getProperty("oauth2.useBrowserWindow", "true"));
    public static final String TOKEN = "access_token";
    private String token;
    private static String expires;
    private String refreshToken;
    private String identityToken;
    private String clientId;
    private String redirectURI;
    private String scope;
    private String clientSecret;
    private String oauth2URL;
    private String tokenRequestURL;
    private Hashtable additionalParams;
    private Dialog login;
    private static boolean backToParent;

    public static boolean isBackToParent() {
        return backToParent;
    }

    public static void setBackToParent(boolean aBackToParent) {
        backToParent = aBackToParent;
    }

    private void serializeAuth() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("token", this.token);
        params.put("refreshToken", this.refreshToken);
        params.put("identityToken", this.identityToken);
        params.put("clientId", this.clientId);
        params.put("redirectURI", this.redirectURI);
        params.put("scope", this.scope);
        params.put("clientSecret", this.clientSecret);
        params.put("oauth2URL", this.oauth2URL);
        params.put("tokenRequestURL", this.tokenRequestURL);
        params.put("additionalParams", this.additionalParams);
        params.put("backToParent", backToParent);
        Storage s = Storage.getInstance();
        s.writeObject("__oauth2Params", params);
    }

    public static Oauth2 fetchSerializedOauth2Request() {
        Storage s = Storage.getInstance();
        Map m = (Map)s.readObject("__oauth2Params");
        if (m == null) {
            return null;
        }
        Oauth2 out = new Oauth2((String)m.get("oauth2URL"), (String)m.get("clientId"), (String)m.get("redirectURI"));
        out.token = (String)m.get("token");
        out.refreshToken = (String)m.get("refreshToken");
        out.identityToken = (String)m.get("identityToken");
        out.scope = (String)m.get("scope");
        out.clientSecret = (String)m.get("clientSecrete");
        out.tokenRequestURL = (String)m.get("tokenRequestURL");
        if (m.get("additionalParams") != null) {
            out.additionalParams = new Hashtable();
            out.additionalParams.putAll((Map)m.get("additionalParams"));
        }
        backToParent = (Boolean)m.get("backToParent");
        s.deleteStorageFile("__oauth2Params");
        return out;
    }

    public Oauth2(String oauth2URL, String clientId, String redirectURI) {
        this(oauth2URL, clientId, redirectURI, null, null, null);
    }

    public Oauth2(String oauth2URL, String clientId, String redirectURI, String scope) {
        this(oauth2URL, clientId, redirectURI, scope, null, null);
    }

    public Oauth2(String oauth2URL, String clientId, String redirectURI, String scope, String tokenRequestURL, String clientSecret) {
        this(oauth2URL, clientId, redirectURI, scope, tokenRequestURL, clientSecret, null);
    }

    public static String getExpires() {
        return expires;
    }

    public Oauth2(String oauth2URL, String clientId, String redirectURI, String scope, String tokenRequestURL, String clientSecret, Hashtable additionalParams) {
        this.oauth2URL = oauth2URL;
        this.redirectURI = redirectURI;
        this.clientId = clientId;
        this.scope = scope;
        this.clientSecret = clientSecret;
        this.tokenRequestURL = tokenRequestURL;
        this.additionalParams = additionalParams;
    }

    public String authenticate() {
        if (this.token == null) {
            this.login = new Dialog();
            boolean i = Dialog.isAutoAdjustDialogSize();
            Dialog.setAutoAdjustDialogSize(false);
            this.login.setLayout(new BorderLayout());
            this.login.setScrollable(false);
            Component html = this.createLoginComponent(null, null, null, null);
            this.login.addComponent("Center", html);
            this.login.setScrollable(false);
            this.login.setDialogUIID("Container");
            this.login.setTransitionInAnimator(CommonTransitions.createSlide(1, true, 300));
            this.login.setTransitionOutAnimator(CommonTransitions.createSlide(1, false, 300));
            this.login.show(0, 0, 0, 0, false, true);
            Dialog.setAutoAdjustDialogSize(i);
        }
        return this.token;
    }

    public void setUseBrowserWindow(boolean useBrowserWindow) {
        this.useBrowserWindow = useBrowserWindow;
    }

    public boolean isUseBrowserWindow() {
        return this.useBrowserWindow;
    }

    public void setUseRedirectForWeb(boolean redirect) {
        this.useRedirectForWeb = redirect;
    }

    public boolean isUseRedirectForWeb() {
        return this.useRedirectForWeb;
    }

    public Component createAuthComponent(ActionListener al) {
        return this.createLoginComponent(al, null, null, null);
    }

    public static boolean handleRedirect(ActionListener callback) {
        Oauth2 request = Oauth2.fetchSerializedOauth2Request();
        if (request == null) {
            return false;
        }
        String href = CN.getProperty("browser.window.location.href", null);
        request.handleURL(href, null, callback, null, null, null);
        return true;
    }

    public void showAuthentication(final ActionListener al) {
        if ("HTML5".equals(CN.getPlatformName()) && this.useRedirectForWeb) {
            String href;
            this.redirectURI = href = CN.getProperty("browser.window.location.href", null);
            this.serializeAuth();
            CN.execute("javascript:(function(){window.onbeforeunload=function(){}; window.location.href='" + this.buildURL() + "';})();");
            return;
        }
        if (this.useBrowserWindow) {
            final BrowserWindow win = new BrowserWindow(this.buildURL());
            win.setTitle("Login");
            win.addLoadListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String url = (String)evt.getSource();
                    if (url.startsWith(Oauth2.this.redirectURI)) {
                        win.close();
                        Oauth2.this.handleURL((String)evt.getSource(), null, al, null, null, null);
                    }
                }
            });
            win.show();
            return;
        }
        final Form old = Display.getInstance().getCurrent();
        InfiniteProgress inf = new InfiniteProgress();
        final Dialog progress = inf.showInifiniteBlocking();
        Form authenticationForm = new Form("Login");
        authenticationForm.setScrollable(false);
        if (old != null) {
            Command cancel = new Command("Cancel"){

                public void actionPerformed(ActionEvent ev) {
                    if (Display.getInstance().getCurrent() == progress) {
                        progress.dispose();
                    }
                    old.showBack();
                }
            };
            if (authenticationForm.getToolbar() != null) {
                authenticationForm.getToolbar().addCommandToLeftBar(cancel);
            } else {
                authenticationForm.addCommand(cancel);
            }
            authenticationForm.setBackCommand(cancel);
        }
        authenticationForm.setLayout(new BorderLayout());
        authenticationForm.addComponent("Center", this.createLoginComponent(al, authenticationForm, old, progress));
        authenticationForm.show();
    }

    private String buildURL() {
        String URL2 = this.oauth2URL + "?client_id=" + Util.encodeUrl(this.clientId) + "&redirect_uri=" + Util.encodeUrl(this.redirectURI);
        if (this.scope != null) {
            URL2 = URL2 + "&scope=" + Util.encodeUrl(this.scope);
        }
        URL2 = this.clientSecret != null ? URL2 + "&response_type=code" : URL2 + "&response_type=token";
        if (this.additionalParams != null) {
            Enumeration e = this.additionalParams.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = this.additionalParams.get(key).toString();
                URL2 = URL2 + "&" + Util.encodeUrl(key) + "=" + Util.encodeUrl(val);
            }
        }
        return URL2;
    }

    private Component createLoginComponent(final ActionListener al, final Form frm, final Form backToForm, final Dialog progress) {
        String URL2 = this.buildURL();
        DocumentInfo.setDefaultEncoding("UTF-8");
        WebBrowser[] web = new WebBrowser[]{new WebBrowser(){

            public void onLoad(String url) {
                Oauth2.this.handleURL(url, this, al, frm, backToForm, progress);
            }

            public void onStart(String url) {
            }
        }};
        web[0].setURL(URL2);
        return web[0];
    }

    protected void handleTokenRequestResponse(Map map) {
        this.token = (String)map.get(TOKEN);
        Object ex = map.get("expires_in");
        if (ex == null) {
            ex = map.get("expires");
        }
        if (ex != null) {
            expires = ex.toString();
        }
        this.refreshToken = (String)map.get("refresh_token");
        this.identityToken = (String)map.get("id_token");
    }

    protected void handleTokenRequestResponse(String t) {
        int end;
        this.token = t.substring(t.indexOf("=") + 1, t.indexOf("&"));
        int off = t.indexOf("expires=");
        int start = 8;
        if (off == -1) {
            off = t.indexOf("expires_in=");
            start = 11;
        }
        if (off > -1) {
            end = t.indexOf(38, off);
            if (end < 0 || end < off) {
                end = t.length();
            }
            expires = t.substring(off + start, end);
        }
        off = t.indexOf("refresh_token=");
        this.refreshToken = null;
        start = "refresh_token=".length();
        if (off > -1) {
            end = t.indexOf(38, off);
            if (end < 0 || end < off) {
                end = t.length();
            }
            this.refreshToken = t.substring(off + start, end);
        }
    }

    protected void handleRedirectURLParams(Map params) {
    }

    public RefreshTokenRequest refreshToken(String refreshToken) {
        final RefreshTokenRequest out = new RefreshTokenRequest();
        this.refreshToken(refreshToken, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (out.isDone()) {
                    return;
                }
                if (evt.getSource() instanceof Throwable) {
                    out.error(new AsyncResource.AsyncExecutionException((Throwable)evt.getSource()));
                } else {
                    out.complete((AccessToken)evt.getSource());
                }
            }
        });
        return out;
    }

    private void refreshToken(String refreshToken, ActionListener al) {
        this.handleURL(this.redirectURI + "?code=" + Util.encodeUrl(refreshToken) + "&cn1_refresh_token=1", null, al, null, null, null);
    }

    private void handleURL(String url, WebBrowser web, final ActionListener al, Form frm, final Form backToForm, Dialog progress) {
        if (url.startsWith(this.redirectURI)) {
            if (progress != null && Display.getInstance().getCurrent() == progress) {
                progress.dispose();
            }
            if (web != null) {
                web.stop();
            }
            if (this.login != null) {
                this.login.removeAll();
                this.login.revalidate();
            }
            if (url.indexOf("code=") > -1) {
                Hashtable params = this.getParamsFromURL(url);
                this.handleRedirectURLParams(params);
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class TokenRequest
                extends ConnectionRequest {
                    boolean callbackCalled;

                    TokenRequest() {
                    }

                    @Override
                    protected void readResponse(InputStream input) throws IOException {
                        byte[] tok = Util.readInputStream(input);
                        String t = new String(tok);
                        boolean expiresRelative = true;
                        if (t.startsWith("{")) {
                            JSONParser p = new JSONParser();
                            Map<String, Object> map = p.parseJSON(new StringReader(t));
                            Oauth2.this.handleTokenRequestResponse(map);
                        } else {
                            Oauth2.this.handleTokenRequestResponse(t);
                        }
                        if (Oauth2.this.login != null) {
                            Oauth2.this.login.dispose();
                        }
                    }

                    @Override
                    protected void handleException(Exception err) {
                        if (backToForm != null && !this.callbackCalled) {
                            backToForm.showBack();
                        }
                        if (al != null && !this.callbackCalled) {
                            this.callbackCalled = true;
                            al.actionPerformed(new ActionEvent((Object)err, ActionEvent.Type.Exception));
                        }
                    }

                    @Override
                    protected void postResponse() {
                        if (backToParent && backToForm != null && !this.callbackCalled) {
                            backToForm.showBack();
                        }
                        if (al != null && !this.callbackCalled) {
                            this.callbackCalled = true;
                            if (this.getResponseCode() >= 200 && this.getResponseCode() < 300) {
                                al.actionPerformed(new ActionEvent((Object)new AccessToken(Oauth2.this.token, expires, Oauth2.this.refreshToken, Oauth2.this.identityToken), ActionEvent.Type.Response));
                            } else {
                                al.actionPerformed(new ActionEvent((Object)new IOException(this.getResponseErrorMessage()), ActionEvent.Type.Exception));
                            }
                        }
                    }
                }
                TokenRequest req = new TokenRequest();
                req.setReadResponseForErrors(true);
                req.setUrl(this.tokenRequestURL);
                req.setPost(true);
                req.addRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                req.addArgument("client_id", this.clientId);
                req.addArgument("redirect_uri", this.redirectURI);
                req.addArgument("client_secret", this.clientSecret);
                if (params.containsKey("cn1_refresh_token")) {
                    req.addArgument("grant_type", "refresh_token");
                    req.addArgument("refresh_token", (String)params.get("code"));
                } else {
                    req.addArgument("code", (String)params.get("code"));
                    req.addArgument("grant_type", "authorization_code");
                }
                NetworkManager.getInstance().addToQueue(req);
            } else if (url.indexOf("error_reason=") > -1) {
                Hashtable table = this.getParamsFromURL(url);
                String error = (String)table.get("error_reason");
                if (this.login != null) {
                    this.login.dispose();
                }
                if (backToForm != null) {
                    backToForm.showBack();
                }
                if (al != null) {
                    al.actionPerformed(new ActionEvent((Object)new IOException(error), ActionEvent.Type.Exception));
                }
            } else {
                boolean success;
                boolean bl = success = url.indexOf("#") > -1;
                if (success) {
                    String accessToken = url.substring(url.indexOf("#") + 1);
                    this.token = accessToken.indexOf("&") > 0 ? accessToken.substring(accessToken.indexOf("=") + 1, accessToken.indexOf("&")) : accessToken.substring(accessToken.indexOf("=") + 1);
                    if (this.login != null) {
                        this.login.dispose();
                    }
                    if (backToParent && backToForm != null) {
                        backToForm.showBack();
                    }
                    if (al != null) {
                        al.actionPerformed(new ActionEvent((Object)new AccessToken(this.token, expires), ActionEvent.Type.Response));
                    }
                }
            }
        } else if (frm != null && Display.getInstance().getCurrent() != frm) {
            progress.dispose();
            frm.show();
        }
    }

    private Hashtable getParamsFromURL(String url) {
        int paramsStarts = url.indexOf(63);
        if (paramsStarts > -1) {
            url = url.substring(paramsStarts + 1);
        }
        Hashtable<String, String> retVal = new Hashtable<String, String>();
        String[] params = Util.split(url, "&");
        int plen = params.length;
        for (int i = 0; i < plen; ++i) {
            if (params[i].indexOf("=") <= 0) continue;
            String[] keyVal = Util.split(params[i], "=");
            retVal.put(keyVal[0], keyVal[1]);
        }
        return retVal;
    }

    static {
        backToParent = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RefreshTokenRequest
    extends AsyncResource<AccessToken> {
    }
}

